{ XFCN zur Kommunikation mit MacIbterface.  C. Meyer & ct 10/95 }
{ Think Pascal 4.0, Teile  1990 Symantec Corporation }
{ Libs und Interfaces: RSRCRuntime.Lib, Interface.lib, HyperXLib.lib, }
{ HyperXCmd.p, DeskBus.p  - Als XFCN Code Resource "HyperFace" }
{ kompilieren und mit ResEdit in gewnschten Stack kopieren }

unit HyperFace_Driver;
interface
	uses  { include the HyperCard interfaces in the XFCN/CMD }
		HyperXCmd, DeskBus;

	procedure main (paramPtr: XCmdPtr);		{ entry point }

implementation

	procedure main;
		label
			55;

{***** fr ADB-Routinen *****}
		const
{ Applikationsspezifische Konstanten }
			kADBDeviceInitial = $7;
			kADBListen = $8;			{ ADB-Befehlskonstanten }
			kADBTalk = $C;
			kADBFlush = $1;
			kADBReset = 0;
			kADBcmdmsk = $FC;		{ Maske fr ADB-Befehl, filtert Register aus }
			kADBregmsk = $03;		{ Maske fr ADB-Register, filtert Befehl aus }
 { ID wird eigentlich von Apple zugeteilt, hier vorlufig: }
			kADBhdlID = $09;
 { Flags fr Host- und Device-Service-Flagregister }
			kP0fc = $1;         			{ PortSelectBits/PortServFlags-Konstanten }
			kP1fc = $2;
			kDispfc = $10;

		var
{ globale Variablen fr MacInterface }
			gADBDevice: byte;			{ enthlt nach InitADB Device-Nummer von MacInterface }
			gADBopBuf: packed array[0..7] of byte;
			aLong: LongInt;
			Error: OSErr;

		function sendADB (cmdbyte: byte; byte1: byte; byte2: byte): osErr;
{ Senden eines ADB-Kommandos ohne Completion-Routine }
		begin
			gADBopBuf[0] := 2;
			gADBopBuf[1] := byte1;
			gADBopBuf[2] := byte2;
			sendADB := ADBOp(nil, nil, @gADBopBuf, cmdbyte);
			delay(1, aLong);
{ Bei Talk finden sich nun in ADBopBuf die Device-Registerwerte, }
{ wenn ADB nicht berlastet war }
		end;


{******Ende ADB-Routinen*****}


		procedure Fail (errMsg: Str255);
		begin	{ Fehlermeldung an Parameterblock bergeben }
			paramPtr^.returnValue := PasToZero(paramPtr, errMsg);
			goto 55;		{ exit the routine }
		end;

		procedure HyperFace (paramPtr: XCmdPtr);
			var
				aStr, RetStr: Str255;
				aInt, Count: Integer;
				IntFData2, IntFData3: Byte;
				IntFPort, IntFCmd: char;
				IntFStr: string[32];
		begin
{ Anzahl der Parameter berprfen }
			if (paramPtr^.paramCount <> 3) then
				Fail('error - parameter count');
{ Erster Parameter: Command, zweiter: ggf. Port-Nummer,  }
{ dritter: Datenbyte als/oder String 0...255 }
			ZeroToPas(paramPtr, paramPtr^.params[1]^, aStr);
			IntFCmd := aStr[1];
			ZeroToPas(paramPtr, paramPtr^.params[2]^, aStr);
			IntFData2 := StrToNum(paramPtr, aStr);
			ZeroToPas(paramPtr, paramPtr^.params[3]^, aStr);
			IntFData3 := StrToNum(paramPtr, aStr);
			IntFStr := aStr;
			RetStr := 'ok';
			Error := NoErr;
{ nicht ganz sauber: Device-ID als Konstante annehmen }
			gADBDevice := kADBDeviceInitial;
			case IntFCmd of
				'l', 'L': 	{ generic ADB Command Listen, 2 Bytes Data }
					Error := sendADB(gADBDevice * 16 + kADBListen, IntFData2, IntFData3);
				't', 'T': 	{ generic ADB Command Talk, 2 Bytes Data }
					Error := sendADB(gADBDevice * 16 + kADBTalk + 1, IntFData2, IntFData3);
				'o', 'O': 	{ InitADB }
					ADBReInit;
				'f', 'F': 	{ generic ADB Command Flush }
					Error := sendADB(gADBDevice * 16 + kADBFlush, 0, 0);
				'd', 'D':	{ an Display senden }
					begin
						Error := sendADB(gADBDevice * 16 + kADBListen, kDispfc, 12);	{ FF/CLS }
						for count := 1 to length(IntFStr) do
							Error := sendADB(gADBDevice * 16 + kADBListen, kDispfc, byte(IntFStr[count]));
					end;
				'w', 'W': 	{ Port beschreiben }
					begin
						if IntFData2 = 0 then
							Error := sendADB(gADBDevice * 16 + kADBListen, kP0fc, IntFData3)
						else
							Error := sendADB(gADBDevice * 16 + kADBListen, kP1fc, IntFData3)
					end;
				'r', 'R':  	{ Port einlesen }
					begin
{ Talk Register 1 }
						Error := sendADB(gADBDevice * 16 + kADBTalk + 1, 0, 0);
						delay(1, aLong);
						if IntFData2 = 0 then
							aLong := gADBopBuf[2]
						else
							aLong := gADBopBuf[1];
						NumToString(aLong, RetStr);
					end;
				otherwise
					Fail('error - unknown command');
			end;
			if Error <> noErr then
				Fail('error - ADBop failed');
			paramPtr^.PassFlag := FALSE;
			paramPtr^.ReturnValue := PasToZero(paramPtr, RetStr);
		end;		{ HyperFace }

	begin 		{ main }
		HyperFace(paramPtr);  {entry point }
55:			{ exit label for failure routine }
	end; 		{ main }
end.