/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     edit.cpp                                                         *
*  Aufgabe:   Hauptprogramm (Initialisierung, etc.)                            *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include "toolbar.h"
#include "debug.h"
#include "edit.h"
#include "aclient.h"
#include "enhframe.h"
#include "statbar.h"
#include "ctedit.h"
#include "editor.h"
#include "api.h"

/* Name     : main
** Task     : Hauptfunktion
** Input    : Mehr als ein Parameter wird erst spter untersttzt
*/

void main(int argc, char *argv[])
  {
  int i;
#ifdef __EMX__
  _wildcard(&argc, &argv);
#endif

  // Suche nach allen Editormodulen
  loadAllDll();
  // Initialisiere alle DLL
  CallDllInit();

  // Das wird der Editor
  Editor *edit;

  if (argc<=2)
     {
     // neues editorobjekt
     edit=new Editor;
     if (argc>1)
        edit->setInitFile(argv[1]);

     // Fenster erzeugen
     edit->process(edit);
     delete edit;
     }
  else
     {
     for (int i=1; i<argc; i++)
        {
        edit=new Editor;
        edit->setInitFile(argv[i]);
        edit->run();
        DosSleep(0);
        }
    int count=0;
    while (1)
       {
       TID id=0;
       DosWaitThread(&id, DCWW_WAIT);
       if (threadsRunning==0)
          break;
       DosSleep(0);
       }
    }
  } /* main */
