#ifndef _DLIST_H_
#define _DLIST_H_

#ifndef OS2_INCLUDED
 #define INCL_DOS
 #include <os2.h>
#endif

class DLockInit {
  HMTX sema4;
public:
  DLockInit(int init=0, char *name=0) {
    DosCreateMutexSem((PSZ)name, &sema4, 0, init);
    }
  ~DLockInit()      { DosCloseMutexSem(sema4); }
  APIRET request(ULONG timeout=(ULONG)SEM_INDEFINITE_WAIT)
                    {
                    return DosRequestMutexSem(sema4, timeout); }
  APIRET release()  {
                    return DosReleaseMutexSem(sema4);
                    }
};

struct Dlink {
  Dlink *next;
  Dlink *prev;
  Dlink() { next=prev=0; }
  Dlink(Dlink *p, Dlink *n) { next=n; prev=p; }
};

extern DLockInit ilock;

class Blist {
protected:
  Dlink *list;
  Dlink *cursor;
  int elem;
  int curpos;
public:
  Blist()              { list=0; cursor=0; elem=0; curpos=0; }
#ifndef __EMX__
  ~Blist()             { clear(); }
#endif
  void lock()          { ilock.request(); }
  void unlock()        { ilock.release(); }
  void  push(Dlink *p);
  Dlink *pop()         { return get(); }
  Dlink *lookup()      { return list; }
  Dlink *_get();
  Dlink *get()         { return _get(); }
  int isEmpty()        { return list==0; }
  int elements()       { return elem; }

  Dlink *first()       { return lookup(); }
  Dlink *last();

  void append(Dlink *p);
  Dlink* insert(Dlink *p, int no=0);
  void remove(int no);
  void remove(Dlink *p) { _remove(p); }
  void _remove(Dlink *p);
  Dlink *operator[](int i) { return _nelem(i); }
  Dlink *_nelem(int i);
  void forAll(void (*)(Dlink*));
#ifndef __EMX__
  void clear();
#endif
};

template <class T>struct Tlink : public Dlink
  {
  T    info;
  Tlink(const T& x) : info(x) {}
  };

template<class T> class Dlist : protected Blist
  {
protected:
  void  qsort  (int (*)(T&,T&), int l, int r);
public:
#ifndef __EMX__
  ~Dlist() { clear(); }
#endif
  void  lock()                          { Blist::lock(); }
  void  unlock()                        { Blist::unlock(); }

  // Stack like funcktions
  void  push(T& p);                     // push element like stack (fastest)
  void  qpush(T& p)                     // push element like queue
                                        { append(p); }
  T     pop();                          // pop element (look and remove)
  T&    lookup();                       // first (top) element
  T&    top()                           { return lookup(); }

  // general information
  int   isEmpty();                      // is list empty?
  int   elements();                     // no. elements in list
  int   entries()                       { return elements(); }
  T&    first();                        // first element
  T&    last();                         // last element
  T&    operator[](int i);              // usage like arrays
  T&    operator ()(int i)              { return operator[](i); }

  // manipulation of list
  T     get();                          // get and remove first(top) element
  void  append(T& p);                   // append (queue like) to list
                                        // slower than push
  void  vappend(T p);                   // append, but call-by-value
  Dlink* insert(T& p,int no=0);          // insert behind no
/*  Dlink* insert(T& p, int (*)(T&,T&)); */  // insert by unsing compare-function
  void  sort  (int (*)(T&,T&));         // sort (slow)
  void  qsort  (int (*f)(T&,T&));       // quicksort (faster, but not ideal)
  void  remove(int no);                 // remove element no
#ifndef __EMX__
  void  clear();                        // clear whole list, free memory
#endif
  void  forAll(void (*)(T&));           // iterate through all

  // iterators, not object-oriented at all <g>
  // but VERY fast
  // example: for (void *p=list; p; p=list.next(p))
  //             sum+=list(p);

  operator void *();                    // pointer to first element
  void *setToN(int x=0);                // set poiter to specific element
  T&    operator ()(void *p);           // get info through this pointer
  void *next(void *p);                  // iterate to next
  void *prev(void *p);                  // iterate to prev
  };

template<class T> inline void Dlist<T>::push(T& p)
  {
  Blist::push(new Tlink<T>(p));
  }

template<class T> inline T Dlist<T>::pop()
  {
  return get();
  }

template<class T> inline T& Dlist<T>::lookup()
  {
  return ((Tlink<T>*)Blist::lookup())->info;
  }

template<class T> inline int Dlist<T>::isEmpty()
  {
  return Blist::isEmpty();
  }

template<class T> inline int Dlist<T>::elements()
  {
  return Blist::elements();
  }

template<class T> inline T& Dlist<T>::first()
  {
  return ((Tlink<T>*)Blist::first())->info;
  }

template<class T> inline T& Dlist<T>::last()
  {
  return ((Tlink<T>*)Blist::last())->info;
  }

template<class T> inline void Dlist<T>::append(T& p)
  {
  Blist::append(new Tlink<T>(p));
  }

template<class T> inline void Dlist<T>::vappend(T p)
  {
  Blist::append(new Tlink<T>(p));
  }

template<class T> inline Dlink* Dlist<T>::insert(T& p,int no)
  {
  return Blist::insert(new Tlink<T>(p), no);
  }

template<class T> inline void Dlist<T>::qsort  (int (*f)(T&,T&))
  {
  qsort(f, 0, elements()-1);
  }

template<class T> inline void Dlist<T>::remove(int no)
  {
  Blist::remove(no);
  }

template<class T> inline T& Dlist<T>::operator[](int i)
  {
  return ((Tlink<T>*)Blist::operator[](i))->info;
  }

template<class T> inline Dlist<T>:: operator void *()
  {
  return (void *)list;
  }

template<class T> inline void* Dlist<T>::setToN(int x)
  {
  int i=0;
  for (Dlink *p=list; i<x; i++, p=p->next)
     ;
  return p;
  }

template<class T> inline T& Dlist<T>::operator ()(void *p)
  {
  return ((Tlink<T>*)p)->info;
  }

template<class T> inline void* Dlist<T>::next(void *p)
  {
  return ((Tlink<T>*)p)->next;
  }

template<class T> inline void* Dlist<T>::prev(void *p)
  {
  return ((Tlink<T>*)p)->prev;
  }

#if !defined(__TEMPINC__)||!defined(__IBMCPP)
  #define INLINE inline
  #include "dlist.c"
#endif

#endif
