/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     dlist.cpp                                                        *
*  Aufgabe:   allgemeine verkettete Liste auf Basis von Templates              *
*             (ist an verschiedenen Stellen ntzlich)                          *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include "dlist.h"
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

DLockInit ilock;

/* Name     : Blist::push
** Task     : Listenelement in Liste aufnehmen
** Input    : Dlink *p                  - Listenelement
*/
void Blist::push(Dlink *p)
  {
  p->next=list;
  p->prev=0;

  if (list)
     list->prev=p;
  list=p;
  ++elem;
  if (!cursor)
     {
     cursor=list;
     curpos=0;
     } /* endif: !cursor */
  else
     ++curpos;
  } /* Blist::push */

/* Name     : *Blist::_get
** Task     : Listenelement zurckgeben (und lschen)
** Remarks  : intern
*/
Dlink *Blist::_get()
  {
  if (cursor==list)
     cursor=cursor->next;
  else
     {
     --curpos;
     if (curpos<0)
        {
        curpos=0;
        cursor=list;
        } /* endif: curpos<0 */
     } /* endelse */
  Dlink *first=list;
  list=list->next;
  --elem;
  return first;
  } /* *Blist::_get */


/* Name     : *Blist::last
** Task     : Das letzte Listenelement zurckgeben
*/
Dlink *Blist::last()
  {
  Dlink *p, *n;
  for (p=cursor; p; p=n)
     if (!(n=p->next))
        {
        return p;
        } /* endif: !(n=p->next) */
  return 0;
  } /* endfor: p */

/* Name     : Blist::append
** Task     : Listenlement in die Liste aufnehmen (hinten anfgen)
** Input    : Dlink *p                  - Listenelement
*/
void Blist::append(Dlink *p)
  {
  if (list)
     {
     Dlink *l=last();
     cursor=l->next=p;
     p->prev=l;
     curpos=elem;
     elem++;
     } /* endif: list */
  else
     {
     cursor=list=p;
     elem=1;
     curpos=0;
     } /* endelse */
  } /* Blist::append */



/* Name     : Blist::insert
** Task     : Listenlement an bestimmter Position einfgen
** Input    : Dlink *p                  - Listenelement
              int no                    - Position
*/
Dlink* Blist::insert(Dlink *p, int no)
  {
  if (!list)
     {
     push(p);
     } /* endif: !list */
  else
     {
     int i=0;
     for (Dlink *l=list; i<no && l && l->next; l=l->next, i++)
        ;
     p->next=l->next;
     if (l->next)
        l->next->prev=p;
     l->next=p;
     p->prev=l;
     elem++;
     curpos=0;
     cursor=list;
     } /* endelse */
  return p;
  } /* Blist::insert */



/* Name     : Blist::remove
** Task     : ein Listenelement bestimmter Position entfernen
** Input    : int no                    - Position
** State    : under construction
*/
void Blist::remove(int no)
  {
  _remove(_nelem(no));
  curpos=0;
  cursor=list;
  } /* Blist::remove */

/* Name     : Blist::_remove
** Task     : Listenelement entfernen
** Input    : Dlink *p                  - Position
** Remarks  : intern
*/
void Blist::_remove(Dlink *p)
  {
  if (p==list)
     list=list->next;
  else
     {
     if (p->prev)
        p->prev->next=p->next;
     if (p->next)
        p->next->prev=p->prev;
     } /* endelse */
  --elem;
  if (p==cursor)
     {
     cursor=list;
     curpos=0;
     } /* endif: p==cursor */
  delete p;
  } /* Blist::_remove */

/* Name     : *Blist::_nelem
** Task     : n-tes Element liefern
** Input    : int i                     - Postition
** State    : under construction
*/
Dlink *Blist::_nelem(int i)
  {
  if (i>curpos)
     {
     do {
        cursor=cursor->next;
        curpos++;
     } while (i>curpos);
     return cursor;
     } /* endif: i>curpos */
  while (i<curpos)
     {
     cursor=cursor->prev;
     curpos--;
     } /* endwhile: i<curpos */
  return cursor;
  } /* *Blist::_nelem */



/* Name     : Blist::forAll
** Task     : Fr alle Element eine Funktion ausfhren
** Input    : void (*f)(Dlink*)         - Funktion
*/
void Blist::forAll(void (*f)(Dlink*))
  {
  for (Dlink *p=list; p; p=p->next)
     (*f)(p);
  } /* Blist::forAll */

/* Name     : Blist::clear
** Task     : Liste lschen <g>
*/
#ifndef __EMX__
void Blist::clear()
  {
  // :-)
  } /* Blist::clear */
#endif
