/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     debug.c                                                          *
*  Aufgabe:   Debugging-Funktionen, auch fr andere Programme ntzlich         *
*                                                                              *
\******************************************************************************/
#define INCL_PM
#define INCL_DOS
#define INCL_BASE
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#ifndef WC_CIRCULARSLIDER
 #define WC_CIRCULARSLIDER    ((PSZ)0xffff0041L)
#endif
#ifndef PMERR_OK
 #define PMERR_OK             0
#endif
#include "errcodes.h"
/*#include "debug.h"*/

#define DOUT_UNINITIALIZED -2

/* Handle auf die Ausgabe */
static HFILE doutput=DOUT_UNINITIALIZED;

/* Name     : queryThreadInfo
** Task     : Informationen ber einen Thread
** Output   : PID *pid                  - Process id
              TID *tid                  - Thread id
              HMODULE *hmod             - Module handle
              ULONG *type               - typ des Prozesses
*/
static void queryThreadInfo(PID *pid, TID *tid, HMODULE *hmod, ULONG *type)
  {
  PTIB t;
  PPIB p;

  /* die entscheidene Funktion ... */
  DosGetInfoBlocks(&t, &p);
  *pid  = p->pib_ulpid;
  *tid  = t->tib_ptib2->tib2_ultid;
  *hmod = p->pib_hmte;
  *type = p->pib_ultype;
  } /* queryThreadInfo */


/* Name     : queryPID
** Task     : ermittle die Process ID
*/
static PID queryPID(void)
  {
  PID pid;
  TID tid;
  HMODULE hmod;
  ULONG type;

  queryThreadInfo(&pid, &tid, &hmod, &type);
  return pid;
  } /* queryPID */

/* Name     : queryTID
** Task     : Erfrage die Thread ID
*/
static TID queryTID(void)
  {
  PID pid;
  TID tid;
  HMODULE hmod;
  ULONG type;

  queryThreadInfo(&pid, &tid, &hmod, &type);
  return tid;
  } /* queryTID */


/* Name     : *lower
** Task     : einen String in Kleinbuchstaben konvertieren
** I/O      : char *s                   - der String
** Output   : Zeiger auf s
*/
static char *lower(char *s)
  {
  for (;*s;s++) *s=(*s>='A'&& *s<='Z') ? *s+('a'-'A') : *s;
     return s;
  } /* *lower */


/* Name     : debug_initialize
** Task     : initilisieren der Debugging Funktionen
*/
void debug_initialize(void)
  {
  char *output;

  /* Durchscanne alle Environment Variablen */
  /* Setze Ausgabe Handle entsprechend */
  if (DosScanEnv((PSZ)"DEBUG", (PSZ*)&output)==0 && *output!=0)
     {
     ULONG action;

     lower(output);

     if (!strcmp(output, "stdout"))
        doutput=1;
     if (!strcmp(output, "stderr"))
        doutput=2;
     if (!strcmp(output, "msgbox"))
        doutput=-1;
     if (!strcmp(output, "watchcat"))
        {
        if (DosOpen("\\PIPE\\WATCHCAT",
                &doutput, &action,
                0, FILE_NORMAL, FILE_OPEN,
                OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE, 0))
           doutput=0;
        } /* endif: !strcmp(output, "watchcat") */
     if (!strcmp(output, "pipe"))
        {
        if (DosOpen("\\PIPE\\DEBUG",
                &doutput, &action,
                0, FILE_NORMAL, FILE_OPEN,
                OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE, 0))
           doutput=0;
        } /* endif: !strcmp(output, "pipe") */
     if (!strcmp(output, "ignore"))
        doutput=0;
     } /* endif: DosScanEnv((PSZ)"DEBUG", (PSZ*)&output)==0 && *output!=0 */
  else
     {
     /* Finde selbst heraus, welche Ausgabeart die beste ist */
     PID pid;
     TID tid;
     HMODULE hmod;
     ULONG type, action;

     queryThreadInfo(&pid, &tid, &hmod, &type);
     switch(type)
        {
        case 0: /* Fullscreen -> stderr*/
        case 2: /* windowed -> stderr */
                doutput=2;
                break;
        case 3: /* PM -> msgBox */
                doutput=-1;
                break;
        case 4: /* detached -> pipe */
                if (DosOpen("\\PIPE\\DEBUG",
                        &doutput, &action,
                        0, FILE_NORMAL, FILE_OPEN,
                        OPEN_ACCESS_READWRITE|OPEN_SHARE_DENYNONE, 0))
                   doutput=0;
        default: /* ???? */
                doutput=0;
        } /* endswitch: type */
     } /* endelse */
  } /* debug_initialize */



/* Name     : debug_output
** Task     : Ausgabe eines Strings
** Input    : char *msg                 - Debugging Text
*/
void debug_output(char *msg)
  {
  if (doutput==DOUT_UNINITIALIZED)              /* nicht init? */
     {
     debug_initialize();
     printf("init: %i\r\n", doutput);
     } /* endif: doutput==DOUT_UNINITIALIZED */

  if (doutput==0)                               /* ignorieren? */
     return;

  else if (doutput==-1)                         /* MsgBox? */
     WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, msg, "Debug", 100, MB_OK|MB_MOVEABLE);
  else
     {
     ULONG written;
     DosWrite(doutput, msg, strlen(msg), &written);
     } /* endelse */
  } /* debug_output */



/* Name     : dprintf
** Task     : Debugging-Ausgabe wie printf
** Input    : char *format              - Format wie printf
              ...                       - Parameter wie printf
** Output   : -
*/
void dprintf(char *format, ...)
  {
  va_list arglist;
  char buffer[1024];                    /* ok, beschrnkte Gre */

  va_start(arglist, format);
  vsprintf(buffer, format, arglist);
  debug_output(buffer);
  va_end(arglist);
  } /* dprintf */



/* Name     : _debug_ensure
** Task     : Sicherstellen einer Bedingung
** Input    : int x                     - Bedingung (BOOL)
              char *expr                - Ausdruck (textuell)
              char *f                   - Funktion
              char *file                - Datei
              int line                  - Zeile
*/
void _debug_ensure(int x, char *expr, char *f, char *file, int line)
  {
  if (!x)
     dprintf("failed: %s in %s, (%s,%i)\n", expr, f, file, line);
  } /* _debug_ensure */


/* Name     : _debug_valid_ptr
** Task     : Ist der Zeiger gltig?
** Input    : void *p                   - der Zeiger
              char *ptr                 - Name des Zeigers (textuell)
              char *f                   - Funktion
              char *file                - Datei
              int line                  - Zeile
*/
void _debug_valid_ptr(void *p, char *ptr, char *f, char *file, int line)
  {
  APIRET rc;
  ULONG size, flags;

  /* NULL - Pointer? */
  if (p==0)
     {
     dprintf("null-pointer : %s in %s, (%s, %i)\r\n",
                              ptr, f, file, line);
     return;
     } /* endif: p==0 */

  /* Versuche Infos ber den Zeiger zu bekommen */
  rc=DosQueryMem(p, &size, &flags);
  if (rc==487)  /* Fehler ? */
     {
     /* Ungltige Adresse */
     dprintf("inv. address : %s, %s==%p in %s (%s,%i)\r\n",
                              ptr, ptr, p, f, file, line);
     return;
     } /* endif: rc==487 */


  if (  (flags&(0x1|0x2|0x10)) != (0x1|0x2|0x10))
     {
     /* Mehr Infos */
     char msg[80];
     sprintf(msg, "ptr invalid  : %s, %s==%p, in %s (%s, %i); \r\n",
                              ptr, ptr, p, f, file, line);
     if (flags&0x1)     strcat(msg, "read ");
     if (flags&0x2)     strcat(msg, "write ");
     if (flags&0x8)     strcat(msg, "guard ");
     if (flags&0x10)    strcat(msg, "commit ");
     if (flags&0x4000)  strcat(msg, "free ");
     if (flags&0x2000)  strcat(msg, "shared ");
     if (flags&0x10000) strcat(msg, "base ");
     debug_output(msg);
     } /* endif: (flags&(0x1|0x2|0x10)) != (0x1|0x2|0x10) */
  } /* _debug_valid_ptr */;


/* Name     : checkPM
** Task     : berprfe die Gltigkeit einer PM-Funktion
** Input    : HWND hwnd                 - Window Handle
              char *fun                 - Funktion
              char *file                - Datei
              int line                  - Zeile
** Output   : TRUE: Alles ok, FALSE Fehler
*/
int checkPM(HWND hwnd, char *fun, char *file, int line)
  {
  HAB hab;
  ERRORID errid;
  char msg_buffer[1024], hwnd_buffer[80], cls[32];


  /* Ermittle den Handle Anchor Block  (per Thread) */
  hab=WinQueryAnchorBlock(HWND_DESKTOP);

  /* Erfrage den letzten Fehler (bezgl. HAB) */
  errid=WinGetLastError(hab);

  /* Alles OK? -> TRUE, sonst FALSE */
  if (ERRORIDERROR(errid)!=PMERR_OK)
     {
     char *msg="n/a";

     /* Weitere Informationen */
     PERRINFO perrinfo=WinGetErrorInfo(hab);

     if (perrinfo)
        {
        USHORT *offset=(USHORT *)((char *)perrinfo+perrinfo->offaoffszMsg);
        msg=(char *)perrinfo+*offset;
        } /* endif: perrinfo */
     if (hwnd==0)
        strcpy(hwnd_buffer, "");
     else
        {
        /* Infos ebr den window handle */
        if (!WinQueryClassName(hwnd, 20, cls))
           strcpy(cls, "???");
        cls[31]=0;
        sprintf(hwnd_buffer, "Handle:     %x (%s) ", hwnd, cls);
        strcat(hwnd_buffer, WinIsWindow(hab, hwnd) ? "valid " : "invalid ");
        if (WinIsWindow(hab, hwnd))
           strcat(hwnd_buffer, WinIsWindowVisible(hwnd) ? "visible " : "invisible ");
        strcat(hwnd_buffer, "\r\n");
        } /* endelse */

     /* Alle Infos anzeigen */
     sprintf(msg_buffer,
            "[%s(%s,%i)] - PID:%x TID:%i\r\n"
            "PM-Error  : %s (%x)\r\n"
            "Error sev : %s (%x)\r\n"
            "%s"
            "Message   : %s\r\n",
                fun, file, line, queryPID(), queryTID(),
                pmerror(ERRORIDERROR(errid)),
                (int)ERRORIDERROR(errid),
                pmsev(ERRORIDSEV(errid)),
                (int)pmsev(ERRORIDSEV(errid)),
                hwnd_buffer,
                msg);
     debug_output(msg_buffer);
     return FALSE;
     } /* endif: ERRORIDERROR(errid)!=PMERR_OK */
  else
     return TRUE;
  } /* checkPM */



/* Name     : _debug_winhandle
** Task     : Infos ber window handle
** Input    : HWND hwnd                 - window handle
              char *fun                 - Funktion
              char *file                - Datei
              char *line                - Zeile
*/
void _debug_winhandle(HWND hwnd, char *fun, char *file, char *line)
  {
  HAB hab;
  char hwnd_buffer[80], cls[32];

  /* Erfrage window handle anchor block (per Thread) */
  hab=WinQueryAnchorBlock(HWND_DESKTOP);
  if (!WinQueryClassName(hwnd, 20, cls))
     strcpy(cls, "???");
  cls[31]=0;
  dprintf("[%s(%s,%i)] - PID:%x TID:%i\r\n"
           "Handle:     %x (%s) %s%s\r\n\r\n",
           fun, file, line, queryPID(), queryTID(),
           hwnd, cls,
           WinIsWindow(hab, hwnd) ? "valid " : "invalid "),
           (WinIsWindow(hab, hwnd) && WinIsWindowVisible(hwnd)
                                  ? "visible " : "invisible ");
  } /* _debug_winhandle */



/* Name     : _debug_winmsg
** Task     : Tracen von window procedure messages
** Input    : HWND hwnd                 - window handle
              ULONG msg                 - Message
              MPARAM mp1                - Parameter 1
              MPARAM mp2                - Parameter 2
              char *fun                 - Funktion
              char *file                - Datei
              int line                  - Zeile
*/
void _debug_winmsg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2, char *fun, char *file, int line)
  {
  HAB hab;
  char hwnd_buffer[80], cls[32], msg_buffer[40];
  char buffer[1024];

  hab=WinQueryAnchorBlock(HWND_DESKTOP);
  if (!WinQueryClassName(hwnd, 20, cls))
     strcpy(cls, "???");
  cls[31]=0;

  if (msg>WM_USER)
     sprintf(msg_buffer, "WM_USER+%i", msg-WM_USER);
  else
     strcpy(msg_buffer, querywmessage(msg));

  sprintf(buffer, "[%s(%s,%i)] - PID:%x TID:%i\r\n"
           "Handle:     %x (%s) %s%s\r\n"
           "Message:    %s (%x)\r\n"
           "mp1:        %x (dec. %i)\r\n"
           "mp2:        %x (dec. %i)\r\n\r\n",
           fun, file, line, queryPID(), queryTID(),
           hwnd, cls,
           WinIsWindow(hab, hwnd) ? "valid " : "invalid ",
           (WinIsWindow(hab, hwnd) && WinIsWindowVisible(hwnd))
                                  ? "visible " : "invisible ",
           msg_buffer, msg,
           mp1, mp1, mp2, mp2);
  debug_output(buffer);
  } /* _debug_winmsg */



/* Name     : checkDOS
** Task     : Basis API Funktion berprfen
** Input    : APIRET rc                 - Rckgabe der API Funktion
              char *fun                 - Funktion
              char *file                - Datei
              int line                  - Zeile
*/
int checkDOS(APIRET rc, char *fun, char *file, int line)
  {
  ULONG cl, action, locus;
  char msg_buffer[1024];

  /* Erfrage die Fehlerklasse */
  if (DosErrClass(rc,&cl, &action, &locus))
     printf("error in error");
  else
     {
     ULONG len;
     char buffer[160];
     APIRET rcm;

     /* Textuelle Fehlerinformation */
     rcm=DosGetMessage(0,0, (UCHAR *)buffer, 158, rc, "OSO001.MSG", &len);
     if (rcm==0 || rcm==316)
        buffer[len]=0;
     else
        strcpy(buffer, "n/a");

     /* Ausgabe */
     sprintf(msg_buffer,
            "[%s(%s,%i)] - PID:%x TID:%i\r\n"
            "Base-Error: %s (%i)\r\n"
            "Class:      %s\r\n"
            "Action:     %s\r\n"
            "Msg:        %s\r\n",
              fun, file, line, queryPID(), queryTID(),
              doserror(rc), rc,
              queryClass(rc),
              queryAction(rc),
              buffer);
     debug_output(msg_buffer);
     } /* endelse */
  return rc;
  } /* checkDOS */
