/******************************************************************************\
*                                                                              *
*  c't OS/2 Editor v0.7                                                        *
*                                                                              *
*  Modul:     api.cpp                                                          *
*  Aufgabe:   fr eine der nchsten Folgen                                     *
*                                                                              *
\******************************************************************************/
#include "common.h"
#pragma hdrstop
#include <string.h>
#include "debug.h"
#include "generic.h"
#include "dlist.h"
#include "api.h"
#include "editor.h"

/* #define NO_API */

/*
** Hier sind alle API Funktionen als C-Funktionen aufgefhrt. Dies
** ist der einzig _portable_ Weg, das C++-Interface als prozedurales
** Interface zu exportieren.
** Das hat natrlich einen gewissen Overhead, so da man die API-
** Fhigkeit dieses Editors mit #define NO_API aussachlten kann
**/

#ifndef NO_API
Dlist<Api *> DllList;

extern HMODULE module;  // definiert in editor.cpp, 0 falls .exe
                        // module-handle, falls DLL


/* Name     : EdSetColor
** Aufgabe  : Setzen der Farbe
** Parameter: Editor *e                 - Editorobjekt
              int color                 - Farb
*/
void APIENTRY EdSetColor(Editor *e, int color)
  {
  e->setColor(color);
  } /* EdSetColor */



/* Name     : EdAddToolbarButton
** Aufgabe  : Hinzufgen eines Knopfes zum Toolbar
** Parameter: Editor *e                 - Editorobjekt
              ActionFnPtr p             - Fkt., falls Knopf gedrckt
              char *s1                  - Meneintrag
              char *s2                  - Hilfetext, Copyright, ...
              int *id                   - id, 0=Ordne ID zu
              HMODULE h                 - module handle (nicht benutzt)
              unsigned r                - Resource id
** Rckgabe :
*/
void APIENTRY EdAddToolbarButton(Editor *e, ActionFnPtr p, char *s1, char *s2,
           int flag, HMODULE h, unsigned r, int *ret_id)
  {
  e->addToolbarButton(p, s1, s2, flag, h, r, ret_id);
  } /* EdAddToolbarButton */



/* Name     : EdAddMenuItem
** Aufgabe  : Einen neuen meneintrag schaffen
** Parameter: Editor *e                 - Editorobjekt
              int mainmenu              - Men, unter dem Mnpkt erscheinen soll
              ActionFnPtr p             - Fkt., falls Men bettigt
              char *s1                  - Meneintrag
              char *s2                  - Hilfetext, Copyright, ...
              int *id                   - id, 0=Ordne ID zu
              HMODULE h                 - module handle (nicht benutzt)
              unsigned r                - Resource id
*/
void APIENTRY EdAddMenuItem(Editor *e, int mainmenu, ActionFnPtr p, char *s1, char *s2,
           int flag, HMODULE h, unsigned r, int *ret_id)
  {
  e->addMenuItem(p, mainmenu, s1, s2, flag, h, r, ret_id);
  } /* EdAddToolbarButton */



/* Name     : EdAddContextMenu
** Aufgabe  : Eintrag ins Kontextmen
** Parameter: Editor *e                 - Editorobjekt
              int id                    - ID des Eintrags
              ActionFnPtr p             - Aktionsfunktion
              char *s1                  - Meneintrag
              char *s2                  - Helptext
** Rckgabe:  dummy-int
*/
int APIENTRY EdAddContextMenu(Editor *e, int id, ActionFnPtr p, char *s1, char *s2, int *ret_id)
  {
  return e->addContextMenu(p, id, s1, s2, ret_id);
  } /* EdAddToolbarButton */



/* Name     : EdLoadFile
** Aufgabe  : Lade eine datei
** Parameter: Editor *e                 - Editorobjekt
              char *file                - Dateiname
*/
void APIENTRY EdLoadFile(Editor *e, char *file)
  {
  e->load(file);
  } /* EdLoadFile */



/* Name     : EdSaveFile
** Aufgabe  : Speichere Datei
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdSaveFile(Editor *e)
  {
  e->save();
  } /* EdSaveFile */



/* Name     : EdSaveFileAs
** Aufgabe  : Speichere die Datei unter einem bestimmten Namen
** Parameter: Editor *e                 - Editorobjekt
              char *name                - Name der Datei
*/
void APIENTRY EdSaveFileAs(Editor *e, char *name)
  {
  e->save(name);
  } /* EdSaveFileAs */



/* Name     : EdGetText
** Aufgabe  : Exportiere Text in einen Puffer
** Parameter: Editor *e                 - Editorobjekt
              char *buffer              - Pufferbereich
              int length                - Lnge des Puffers
** Rckgabe : Dummy int
*/
int APIENTRY EdGetText(Editor *e, char *buffer, int length)
  {
  ensure(validptr(buffer) && validptr(buffer+length-1));
  return e->getText(buffer, length);
  } /* EdGetText */



/* Name     : EdGetTextOffset
** Aufgabe  : Importiere Text in Puffer ab einem Offset
** Parameter: Editor *e                 - Editorobjekt
              char *buffer              - Puffer
              int length                - Lnge des Puffers
              int offset                - Offset
** Rckgabe : Dummy-int
*/
int APIENTRY EdGetTextOffset(Editor *e, char *buffer, int length, int offset)
  {
  ensure(validptr(buffer) && validptr(buffer+length-1));
  return e->getText(buffer, length, offset);
  } /* EdGetTextOffset */



/* Name     : EdGetTextLine
** Aufgabe  : Exportiere eine Zeile in den Puffer
** Parameter: Editor *e                 - Editorobjekt
              char *buffer              - Puffer
              int length                - Lnge des Puffers
              int line                  - Zeile (ab 1)
** Rckgabe : Dummy int
*/
int APIENTRY EdGetTextLine(Editor *e, char *buffer, int length, int line)
  {
  ensure(validptr(buffer) && validptr(buffer+length-1) && line>0);
  return e->getTextLine(buffer, length, line);
  } /* EdGetTextLine */



/* Name     : EdSaveIni
** Aufgabe  : Speichere die aktuellen Benutzereinstellungen in os2.ini
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdSaveIni(Editor *e)
  {
  e->saveini();
  } /* EdSaveIni */



/* Name     : EdAddText
** Aufgabe  : Fge Text in den Editor (hinten) ein
** Parameter: Editor *e                 - Editorobjekt
              char *text                - Text
*/
void APIENTRY EdAddText(Editor *e, char *text)
  {
  ensure(validread(text));
  e->add(text);
  } /* EdAddText */



/* Name     : EdAddTextOffset
** Aufgabe  : Fge text bei einem Offset ein
** Parameter: Editor *e                 - Editorobjekt
              char *text                - Text
              int offset                - Offset
*/
void APIENTRY EdAddTextOffset(Editor *e, char *text, int offset)
  {
  ensure(validread(text) && offset>0);
  e->add(text, FALSE, offset);
  } /* EdAddTextOffset */



/* Name     : EdAddLine
** Aufgabe  : Fge eine Zeile am Ende ein
** Parameter: Editor *e                 - Editorobjekt
              char *text                - text (Zeile)
              int line                  - Zeile
*/
void APIENTRY EdAddLine(Editor *e, char *text, int line)
  {
  ensure(validread(text) && line>0);
  e->addLine(text, TRUE, line);
  } /* EdAddLine */



/* Name     : EdIsChanged
** Aufgabe  : Hat sich der Inhalt des Editors gendert?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : TRUE/FALSE
*/
BOOL APIENTRY EdIsChanged(Editor *e)
  {
  return e->isChanged();
  } /* EdIsChanged */



/* Name     : EdClear
** Aufgabe  : Lsche den Inhalt des markierten Bereichs
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdClear(Editor *e)
  {
  e->clear();
  } /* EdClear */



/* Name     : EdClearAll
** Aufgabe  : Lsche den gesamten Editortext
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdClearAll(Editor *e)
  {
  e->clearAll();
  } /* EdClearAll */



/* Name     : EdCopy
** Aufgabe  : Kopiere markierten Text in das Clipboard
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe :
*/
void APIENTRY EdCopy(Editor *e)
  {
  e->copy();
  } /* EdCopy */



/* Name     : EdCut
** Aufgabe  : Ausschneiden des markierten Textes
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdCut(Editor *e)
  {
  e->cut();
  } /* EdCut */



/* Name     : EdPaste
** Aufgabe  : kopieren des Clipboards in den Editor
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdPaste(Editor *e)
  {
  e->paste();
  } /* EdPaste */



/* Name     : EdInsert
** Aufgabe  : Einfgen eines Textes (statt markierten Text)
** Parameter: Editor *e                 - Editorobjekt
              char *text                - tex
*/
void APIENTRY EdInsert(Editor *e, char *text)
  {
  e->insert(text);
  } /* EdInsert */



/* Name     : EdDelete
** Aufgabe  : Lschen des gesamten Editortextes (Vorsicht!)
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe :
*/
void APIENTRY EdDelete(Editor *e)
  {
  e->discard();
  } /* EdDelete */



/* Name     : EdUndo
** Aufgabe  : Undo der letzten nderung
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdUndo(Editor *e)
  {
  e->undo();
  } /* EdUndo */



/* Name     : EdMarkall
** Aufgabe  : Alles markieren
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdMarkall(Editor *e)
  {
  e->markall();
  } /* EdMarkall */



/* Name     : EdDisableUpdate
** Aufgabe  : Updaten ausstellen
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdDisableUpdate(Editor *e)
  {
  e->disableUpdate();
  } /* EdDisableUpdate */



/* Name     : EdEnableUpdate
** Aufgabe  : Updaten einstellen
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdEnableUpdate(Editor *e)
  {
  e->enableUpdate();
  } /* EdEnableUpdate */



/* Name     : EdSetWordWrap
** Aufgabe  : Wortumbruch einstellen/ausstellen
** Parameter: Editor *e                 - Editorobjekt
              BOOL b                    - an/aus
*/
void APIENTRY EdSetWordWrap(Editor *e, BOOL b)
  {
  e->setWordWrap(b);
  } /* EdSetWordWrap */



/* Name     : EdQueryWordWrap
** Aufgabe  : Status des Wortumbruchs ermitteln
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : TRUE: Wordumbruch angestellt
*/
BOOL APIENTRY EdQueryWordWrap(Editor *e)
  {
  return e->queryWordWrap();
  } /* EdQueryWordWrap */



/* Name     : EdSetReadOnly
** Aufgabe  : Setze Editorfeld auf Readonly (nicht readonly)
** Parameter: Editor *e                 - Editorobjekt
              BOOL b                    - TRUE: readonly
*/
void APIENTRY EdSetReadOnly(Editor *e, BOOL b)
  {
  e->setReadOnly(b);
  } /* EdSetReadOnly */



/* Name     : EdQueryReadOnly
** Aufgabe  : Frage nach dem aktuellen readonly Status
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : TRUE: readonly
*/
BOOL APIENTRY EdQueryReadOnly(Editor *e)
  {
  return e->queryReadOnly();
  } /* EdQueryReadOnly */



/* Name     : EdSetChangedFlag
** Aufgabe  : Setze das Flag, das signalisiert, ob sich der Text gendert hat
** Parameter: Editor *e                 - Editorobjekt
              BOOL b                    - TRUE: Jawoll, hat sich gendert
*/
void APIENTRY EdSetChangedFlag(Editor *e, BOOL b)
  {
  e->setChangedFlag(b);
  } /* EdSetChangedFlag */



/* Name     : EdResetChangedFlag
** Aufgabe  : Text hat sich nicht gendert
** Parameter: Editor *e                 - Editorobjekt
*/
void APIENTRY EdResetChangedFlag(Editor *e)
  {
  e->resetChangedFlag();
  } /* EdResetChangedFlag */



/* Name     : EdRemoveLine
** Aufgabe  : Lsche eine Zeile
** Parameter: Editor *e                 - Editorobjekt
              int line                  - Zeile
*/
void APIENTRY EdRemoveLine(Editor *e, int line)
  {
  e->removeLine(line);
  } /* EdRemoveLine */



/* Name     : EdQueryNrOfLines
** Aufgabe  : Wieviel Zeilen hat der Text?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : Anzahl der Zeilen
*/
int APIENTRY EdQueryNrOfLines(Editor *e)
  {
  return e->queryNrOfLines();
  } /* EdQueryNrOfLines */



/* Name     : EdSetText
** Aufgabe  : Setze den Inhalt des Editors (Vorsicht!)
** Parameter: Editor *e                 - Editorobjekt
              char *text                - Dieser Text ist neuer Inhalt
*/
void APIENTRY EdSetText(Editor *e, char *text)
  {
  e->setText(text);
  } /* EdSetText */



/* Name     : EdQueryTextLength
** Aufgabe  : Wie lang ist der Text?
** Parameter: Editor *e                 - Editorobjek
** Rckgabe : Lnge des Textes
*/
int APIENTRY EdQueryTextLength(Editor *e)
  {
  return e->queryTextLength();
  } /* EdQueryTextLength */



/* Name     : EdQueryCurrentLine
** Aufgabe  : In welcher Zeile steht der Cursor?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : aktuelle Zeile
*/
int APIENTRY EdQueryCurrentLine(Editor *e)
  {
  return e->queryCurrentLine();
  } /* EdQueryCurrentLine */



/* Name     : EdQueryCurrentCol
** Aufgabe  : In welcher Spalte steht der Cursor?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : aktuelle Spalte
*/
int APIENTRY EdQueryCurrentCol(Editor *e)
  {
  return e->queryCurrentCol();
  } /* EdQueryCurrentCol */



/* Name     : EdQueryCurrentCurPos
** Aufgabe  : In welcher Position steht der Cursor?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : Position (0-basiert)
*/
int APIENTRY EdQueryCurrentCurPos(Editor *e)
  {
  return e->queryCurrentCurPos();
  } /* EdQueryCurrentCurPos */



/* Name     : EdSetCurrentLine
** Aufgabe  : Setze die aktuelle Spalte
** Parameter: Editor *e                 - Editorobjekt
              int line                  - Zeile
*/
void APIENTRY EdSetCurrentLine(Editor *e, int line)
  {
  ensure(line>=1);
  e->setCurrentLine(line);
  } /* EdSetCurrentLine */



/* Name     : EdSetCurrentCol
** Aufgabe  : Setze die aktuelle Spalte
** Parameter: Editor *e                 - Editorobjekt
              int col                   - Spalte
*/
void APIENTRY EdSetCurrentCol(Editor *e, int col)
  {
  ensure(col>=1);
  e->setCurrentCol(col);
  } /* EdSetCurrentCol */



/* Name     : EdSetCurrentColPos
** Aufgabe  : Setze die Cursorposition
** Parameter: Editor *e                 - Editorobjekt
              int pos                   - Position
*/
void APIENTRY EdSetCurrentColPos(Editor *e, int pos)
  {
  ensure(pos>=0);
  e->setCurrentCurPos(pos);
  } /* EdSetCurrentColPos */



/* Name     : EdSetStatusText
** Aufgabe  : Setze den Text in der Statuszeile
** Parameter: Editor *e                 - Editorobjekt
              char *text                - Text
*/
void APIENTRY EdSetStatusText(Editor *e, char *text)
  {
  ensure(validread(text));
  e->setStatusText(text);
  } /* EdSetStatusText */



/* Name     : EdQueryIndent
** Aufgabe  : Wie ist der Autoindentstatus?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : TRUE: an
*/
BOOL APIENTRY EdQueryIndent(Editor *e)
  {
  return e->queryIndent();
  } /* EdQueryIndent */



/* Name     : EdSetIndent
** Aufgabe  : Setze den Autoindentstatus
** Parameter: Editor *e                 - Editorobjekt
              BOOL b                    - TRUE: an
** Rckgabe :
*/
void APIENTRY EdSetIndent(Editor *e, BOOL b)
  {
  e->setIndent(b);
  } /* EdSetIndent */



/* Name     : EdQueryQuickmark
** Aufgabe  : Wie ist der Quickmarkingstatus?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : TRUE: an
*/
BOOL APIENTRY EdQueryQuickmark(Editor *e)
  {
  return e->queryQuickmark();
  } /* EdQueryQuickmark */



/* Name     : EdSetQuickmark
** Aufgabe  : Setze den Quickmarkstatus
** Parameter: Editor *e                 - Editorobjekt
              BOOL b                    - TRUE: an
*/
void APIENTRY EdSetQuickmark(Editor *e, BOOL b)
  {
  e->setQuickmark(b);
  } /* EdSetQuickmark */



/* Name     : EdQueryToolbar
** Aufgabe  : Ist der Toolbar sichtbar?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : TRUE: sichtbar
*/
BOOL APIENTRY EdQueryToolbar(Editor *e)
  {
  return !e->queryHideToolbar();
  } /* EdQueryToolbar */



/* Name     : EdSetToolbar
** Aufgabe  : Zeige den Toolbar an/nicht an
** Parameter: Editor *e                 - Editorobjekt
              BOOL b                    - TRUE: sichtbar
*/
void APIENTRY EdSetToolbar(Editor *e, BOOL b)
  {
  e->hideToolbar(!b);
  } /* EdSetToolbar */



/* Name     : EdDoAction
** Aufgabe  : Lse eine Aktion aus der Liste aus (Menpunkt, Toolbar)
** Parameter: Editor *e                 - Editorobjekt
              int i                     - Eintrag
** Rckgabe : Ergebnis der Aktion
*/
BOOL APIENTRY EdDoAction(Editor *e, int i)
  {
  ensure(i>=0);
  return e->doAction(i);
  } /* EdDoAction */



/* Name     : EdSearch
** Aufgabe  : Suchen, Cursor Posiotionieren
** Parameter: Editor *e                 - Editorobjekt
              char *s                   - Suchstring
** Rckgabe : gefunden ja/nein
*/
BOOL APIENTRY EdSearch(Editor *e, char *s)
  {
  ensure(validread(s));
  return e->search(s);
  } /* EdSearch */



/* Name     : EdSetConditionalMenu
** Aufgabe  : Setze ein Menpkt. als conditional
** Parameter: Editor *e                 - Editorobjekt
              int submenuid             - Obermen-ID
              int defaultid             - ID des Standardeintrags
*/
void APIENTRY EdSetConditionalMenu(Editor *e, int submenuid, int defaultid)
  {
  ensure(1);
  e->setConditionalMenu(submenuid, defaultid);
  } /* EdSetConditionalMenu */



/* Name     : EdSetMenuChecked
** Aufgabe  : Kreuze einen Menpunkt an/nicht an
** Parameter: Editor *e                 - Editorobjekt
              int id                    - ID des Menpunktes
              BOOL b                    - TRUE: ankreuzen
*/
void APIENTRY EdSetMenuChecked(Editor *e, int id, BOOL b)
  {
  ensure(id>=0);
  e->setMenuChecked(id, b);
  } /* EdSetMenuChecked */



/* Name     : EdQueryBkColor
** Aufgabe  : Hintergrundfarbe?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : Farbe des Hintergrundes
*/
int APIENTRY EdQueryBkColor(Editor *e)
  {
  return e->queryBkColor();
  } /* EdQueryBkColor */



/* Name     : EdSetBkColor
** Aufgabe  : Setze die hintergrundfarbe
** Parameter: Editor *e                 - Editorobjekt
              int color                 - Farbe
*/
void APIENTRY EdSetBkColor(Editor *e, int color)
  {
  e->setBkColor(color);
  } /* EdSetBkColor */



/* Name     : EdQueryFgColor
** Aufgabe  : Vordergrundfarbe?
** Parameter: Editor *e                 - Editorobjekt
** Rckgabe : Farbe des Vordergrundes
*/
int APIENTRY EdQueryFgColor(Editor *e)
  {
  return e->queryFgColor();
  } /* EdQueryFgColor */



/* Name     : EdSetFgColor
** Aufgabe  : Setze die Vordergrundfarbe
** Parameter: Editor *e                 - Editorobjekt
              int color                 - Farbe
*/
void APIENTRY EdSetFgColor(Editor *e, int color)
  {
  e->setFgColor(color);
  } /* EdSetFgColor */



/* Name     : EdSetFontName
** Aufgabe  : Setze den Namen der Schrift
** Parameter: Editor *e                 - Editorobjekt
              char *name                - Schriftname (z.B. "Courier")
*/
void APIENTRY EdSetFontName(Editor *e, char *name)
  {
  e->setFont(name, 0, -1);
  } /* EdSetFontName */



/* Name     : EdSetFontSize
** Aufgabe  : Setze die Gre der Schrift
** Parameter: Editor *e                 - Editorobjekt
              int size                  - Gre (z.B. 8)
*/
void APIENTRY EdSetFontSize(Editor *e, int size)
  {
  ensure(size>0 && size<100);
  e->setFont(0, size, -1);
  } /* EdSetFontSize */



/* Name     : EdSetFontType
** Aufgabe  : Setze den Schrifttyp
** Parameter: Editor *e                 - Editorobjekt
              int type                  - 1: Monospaced 0: Proportional
*/
void APIENTRY EdSetFontType(Editor *e, int type)
  {
  ensure(type==0 || type==1);
  e->setFont(0, 0, type);
  } /* EdSetFontType */

/*
** Es folgt eine Tabelle mit allen API-Funktionen. Neue Funktionen werden
** stets _hinten_ angefgt! Die Nummern mssen mit den Werten in editapi.c
** bereinstimmen.
*/

PFN vtable[]={
  (PFN)EdSetColor,                              //  0
  (PFN)EdAddToolbarButton,                      //  1
  (PFN)EdAddContextMenu,                        //  2
  (PFN)EdAddMenuItem,                           //  3
  (PFN)EdLoadFile,                              //  4
  (PFN)EdLoadFile,                              //  5
  (PFN)EdSaveFile,                              //  6
  (PFN)EdSaveFileAs,                            //  7
  (PFN)EdGetText,                               //  8
  (PFN)EdGetTextOffset,                         //  9
  (PFN)EdGetTextLine,                           // 10
  (PFN)EdSaveIni,                               // 11
  (PFN)EdAddText,                               // 12
  (PFN)EdAddText,                               // 13
  (PFN)EdAddLine,                               // 14
  (PFN)EdIsChanged,                             // 15
  (PFN)EdClear,                                 // 16
  (PFN)EdClearAll,                              // 17
  (PFN)EdCopy,                                  // 18
  (PFN)EdCut,                                   // 19
  (PFN)EdPaste,                                 // 20
  (PFN)EdInsert,                                // 21
  (PFN)EdDelete,                                // 22
  (PFN)EdUndo,                                  // 23
  (PFN)EdMarkall,                               // 24
  (PFN)EdDisableUpdate,                         // 25
  (PFN)EdEnableUpdate,                          // 26
  (PFN)EdSetWordWrap,                           // 27
  (PFN)EdQueryWordWrap,                         // 28
  (PFN)EdSetReadOnly,                           // 29
  (PFN)EdQueryReadOnly,                         // 30
  (PFN)EdSetChangedFlag,                        // 31
  (PFN)EdResetChangedFlag,                      // 32
  (PFN)EdRemoveLine,                            // 33
  (PFN)EdQueryNrOfLines,                        // 34
  (PFN)EdSetText,                               // 35
  (PFN)EdQueryTextLength,                       // 36
  (PFN)EdQueryCurrentLine,                      // 37
  (PFN)EdQueryCurrentCol,                       // 38
  (PFN)EdQueryCurrentCurPos,                    // 39
  (PFN)EdSetCurrentLine,                        // 40
  (PFN)EdSetCurrentCol,                         // 41
  (PFN)EdSetCurrentColPos,                      // 42
  (PFN)EdSetStatusText,                         // 43
  (PFN)EdQueryIndent,                           // 44
  (PFN)EdSetIndent,                             // 45
  (PFN)EdQueryQuickmark,                        // 46
  (PFN)EdSetQuickmark,                          // 47
  (PFN)EdQueryToolbar,                          // 48
  (PFN)EdSetToolbar,                            // 49
  (PFN)EdDoAction,                              // 50
  (PFN)EdSearch,                                // 51
  (PFN)EdSetConditionalMenu,                    // 52
  (PFN)EdSetMenuChecked,                        // 53
  (PFN)EdQueryBkColor,                          // 54
  (PFN)EdSetBkColor,                            // 55
  (PFN)EdQueryFgColor,                          // 56
  (PFN)EdSetFgColor,                            // 57
  (PFN)EdSetFontName,                           // 58
  (PFN)EdSetFontSize,                           // 59
  (PFN)EdSetFontType                            // 60
} /* EdAddContextMenu */;
#endif

/* Name       : loadDll
** Aufgabe    : Lade eine DLL, ermittle die Editorfunktionen
** Parameteter: char *name                - Dateiname der DLL (fully qualified)
*/
#ifndef NO_API
void loadDll(char *name)
  {
  APIRET rc;
  char loadError[100];
  PFN fn1=0, fn2=0, fn3=0, fn4=0, fn5=0;
  HMODULE mod;

  // Lade die DLL
  rc=DosLoadModule((PSZ)loadError, 100, (PSZ)name, &mod);

  // Ermittle wichtige Einsprungpunkte
  rc=DosQueryProcAddr(mod, 0, (PSZ)"ctEditInit", (PFN*)&fn1);
  DosQueryProcAddr(mod, 0, (PSZ)"ctNewName", (PFN*)&fn2);
  DosQueryProcAddr(mod, 0, (PSZ)"ctContextMenu", (PFN*)&fn3);
  DosQueryProcAddr(mod, 0, (PSZ)"ctInitEditorWindow", (PFN*)&fn4);
  DosQueryProcAddr(mod, 0, (PSZ)"ctDeInitEditorWindow", (PFN*)&fn5);

  // Falls kein Editormodul: Freigabe der DLL
  if (!fn1 /*&& !fn2 && !fn3*/)
     {
     DosFreeModule(mod);
     return;
     } /* endif: !fn1 && !fn2 && !fn3 */

  // DLL in eine Liste aufnehmen (per Proze)
  Api *api=new Api(mod, name, (ApiInitFnPtr)fn1, (ApiFnPtr)fn2, (ApiContextMenuFnPtr)fn3, (ApiInitWindowFnPtr)fn4, (ApiInitWindowFnPtr)fn5);
  if (!api)
     return;

  // Ok!
  DllList.append(api);
  } /* loadDll */


/* Name     : forAllModulesDo
** Aufgabe  : Eine Funktion fr alle DLL in Verzeichnis ausfhren
** Parameter: HMODULE hmod              - module handle
              char *env                 - EnvString. Hier suchen, falls gesetzt
              char *subdir              - oder im Unterverzeichnis
              void (*fn)(char *fullname) - Funktion
*/
void forAllModulesDo(HMODULE hmod, char *env, char *subdir, void (*fn)(char *fullname))
  {
  HDIR fh=HDIR_CREATE;
  FILEFINDBUF3 buf;
  ULONG fc=1,count;
  APIRET rc;
  char path[CCHMAXPATH], fullname[CCHMAXPATH], basepath[CCHMAXPATH];
  char *pPath;

  // Environmentvariable gestzt?
#ifndef __WATCOMC__
  if (DosScanEnv(env, (PCSZ*)&pPath))
#else
  if (DosScanEnv(env, (char const **)&basepath))
#endif
     {
     // Ermittle den Pfad des Programms/DLL
     if (hmod==0)
        {
        // Handle ist 0 (also EXE, nun "richtigen" Wert ermitteln
        PTIB t; PPIB p;

        basepath[0]=0;
        DosGetInfoBlocks(&t, &p);
        // Prima, nun haben wir den Handle
        hmod=p->pib_hmte;
        } /* endif: hmod==0 */
     // Aus dem Handle bekommen wir den Pfadnamen
     rc=DosQueryModuleName(hmod, CCHMAXPATH, basepath);
     if (rc) return;

     // Dateinamen abstreichen: " c:\edit\edit.exe -> c:\edit\ "
     for (char *s=basepath+strlen(basepath)-1; s>basepath; s--)
        if (*s=='\\') { *(s+1)=0; break; } /* endif: *s=='\\' */
     strcat(basepath, subdir);
     } /* endif: DosScanEnv(env, (PCSZ*)&basepath) */
  else
     strcpy(basepath, pPath);

  if (basepath[0]=='\0') return;
  if (basepath[strlen(basepath)-1]!='\\') strcat(basepath, "\\");

  // In Path den Suchsring bringen: c:\edit\*.dll
  strcpy(path, basepath);
  strcat(path, "*.DLL");

  // Starte die Suche
  rc=DosFindFirst((PSZ)path,&fh,0x37,(PFILEFINDBUF)&buf,(USHORT)sizeof(buf),&fc,1);

  // Alle DLL durchgehen
  for(;rc==0;rc=DosFindNext(fh,&buf,sizeof(buf),&fc))
     {
     char *name=buf.achName;
     strcpy(fullname, basepath);
     strcat(fullname, name);
     // In fullname steht der volle Dateiname. Jetzt die Funktion aufrufen
     if (stricmp(name, "editapi"))
        (*fn)(fullname);
     }
  }
#endif

/* Name       : loadAllDll
** Aufgabe    : Lade alle DLL
*/
void loadAllDll()
  {
#ifndef NO_API
  // Falls API zur Verfgung gestellt werden soll: Alle DLL laden!
  forAllModulesDo(module, "EDITMODPATH", "Module", loadDll);
#endif
  }


/* Name       : CallDllInit
** Aufgabe    : Alle DLL initialisieren (ctEditInit aufrufen)
*/
void CallDllInit()
  {
#ifndef NO_API
  // Liste durchgehen
  for (void *p=DllList; p; p=DllList.next(p))
     {
     ApiInitFnPtr fnptr=DllList(p)->Init;
     // Falls ctEditinit da ->aufrufen
     if (fnptr)
        (*fnptr)(vtable);
     }
#endif
  rand();
  }


/* Name       : CallChangeName
** Aufgabe    : Der Name der Datei hat sich gendert
** Parameter  : Editorobjekt
*/
void CallChangeName(Editor *e)
  {
  e->ctNewName(e->queryName());
#ifndef NO_API
  // Liste durchgehen
  for (void *p=DllList; p; p=DllList.next(p))
     {
     ApiFnPtr fnptr=DllList(p)->newName;
     // Funktion ctChangeName vorhanden -> aufrufen
     if (fnptr)
        (*fnptr)(e, (char *)e->queryName());
     }
#endif
  }

/* Name       : CallContextMenu
** Aufgabe    : Kontextmen!
** Parameter  : Editorobjekt
*/
void CallContextMenu(Editor *e, char *name, char *selection)
  {
  e->ctContextMenu(name, selection);
#ifndef NO_API
  // Liste durchgehen
  for (void *p=DllList; p; p=DllList.next(p))
     {
     ApiContextMenuFnPtr fnptr=DllList(p)->contextMenu;
     // Funktion ctContextMenu vorhanden? -> aufrufen
     if (fnptr)
        (*fnptr)(e, name, selection);
     }
#endif
  }

/* Name       : CallInitWindow
** Aufgabe    : Einmal zu Beginn der Fensterinitialisierung aufrufen
** Parameter  : Editorobjekt
*/
void CallInitWindow(Editor *e)
  {
  e->ctInitEditorWindow();
#ifndef NO_API
  // Liste durchgehen
  for (void *p=DllList; p; p=DllList.next(p))
     {
     ApiInitWindowFnPtr fnptr=DllList(p)->newWindow;
     // Funktion ctContextMenu vorhanden? -> aufrufen
     if (fnptr)
        (*fnptr)(e);
     }
#endif
  }

/* Name       : CallDeInitWindow
** Aufgabe    : Einmal zu Beginn der Fensterinitialisierung aufrufen
** Parameter  : Editorobjekt
*/
void CallDeInitWindow(Editor *e)
  {
  e->ctDeInitEditorWindow();
#ifndef NO_API
  // Liste durchgehen
  for (void *p=DllList; p; p=DllList.next(p))
     {
     ApiInitWindowFnPtr fnptr=DllList(p)->endWindow;
     // Funktion ctContextMenu vorhanden? -> aufrufen
     if (fnptr)
        (*fnptr)(e);
     }
#endif
  }
