// Applikator-Klasse

#include <iostream.h>

// -------- gemeinsamer Teil fr alle Manipulatoren ---------------
class OMI {
public:
  typedef int Arg;
  typedef ostream& (*Fkt)(ostream&, Arg);
  OMI(Fkt ff, Arg aa) : f(ff), a(aa) {}
  friend ostream& operator<<(ostream& os, const OMI& omi) {
    return omi.f(os, omi.a);
  }
private:
  const Fkt f;
  const Arg a;
};

class AppI {
public:
  AppI(OMI::Fkt ff) : f(ff) {}
  OMI operator()(OMI::Arg n) const { return OMI(f, n); }
private:
  const OMI::Fkt f;
};

// -------- Definition des space-Manipulators ---------------------
ostream& spaces(ostream& os, int n) {
  for (int i=0; i<n; i++)
    os << ' ';
  return os;
}

const AppI space(spaces);

int main() {
  cout << "0123456\n";
  cout << '#' << space(5) << '#' << endl;
  return 0;
}
