// Qbistdoc.cpp : implementation of the CQbistDoc class
//

#include "stdafx.h"
//neu
#include "resource.h"
#include "tiffdlg.h"
#include "mydefs.h"
#include "progdlg.h"
//Ende neu
#include "Qbistdoc.h"
#include "Qbist.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQbistDoc

IMPLEMENT_DYNCREATE(CQbistDoc, CDocument)

BEGIN_MESSAGE_MAP(CQbistDoc, CDocument)
	//{{AFX_MSG_MAP(CQbistDoc)
	ON_COMMAND(ID_VARIATIONEN_FEIN, OnVariationenFein)
	ON_COMMAND(ID_VARIATIONEN_GROB, OnVariationenGrob)
	ON_COMMAND(ID_VARIATIONEN_MITTEL, OnVariationenMittel)
	ON_COMMAND(ID_VARIATIONEN_1, OnVariationen1)
	ON_COMMAND(ID_VARIATIONEN_2, OnVariationen2)
	ON_COMMAND(ID_VARIATIONEN_3, OnVariationen3)
	ON_COMMAND(ID_VARIATIONEN_4, OnVariationen4)
	ON_COMMAND(ID_VARIATIONEN_5, OnVariationen5)
	ON_COMMAND(ID_VARIATIONEN_6, OnVariationen6)
	ON_COMMAND(ID_VARIATIONEN_7, OnVariationen7)
	ON_COMMAND(ID_VARIATIONEN_8, OnVariationen8)
	ON_COMMAND(ID_VARIATIONEN_ZENTRALBILD, OnVariationenZentralbild)
	ON_COMMAND(ID_DATEI_TIFFEXPORTIEREN, OnDateiTiffexportieren)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQbistDoc construction/destruction

CQbistDoc::CQbistDoc()
{
	// TODO: add one-time construction code here
}

CQbistDoc::~CQbistDoc()
{
}

BOOL CQbistDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	
	//neu
	
	for(int i=0;i<NUM_TRANSFORMS;i++)
	{
		transformSequence[0][i] = myRand()%TOTAL_TRANSFORMS;
		source[0][i] = myRand()%NUM_REGISTERS;
		control[0][i] = myRand()%NUM_REGISTERS;
		dest[0][i] = myRand()%NUM_REGISTERS;
	}

	SwitchCoarseness(1);

	MakeVariations();

	//Ende neu


	return TRUE;
}

////neu:

void CQbistDoc::MakeVariations(void)
{
	short variation, i;
	for(variation = 1; variation <=8; variation++)
		for(i=0; i<NUM_TRANSFORMS;i++)
		{
			transformSequence[variation][i]=transformSequence[0][i];
			source[variation][i]=source[0][i];
			control[variation][i]=control[0][i];
			dest[variation][i]=dest[0][i];
		}

	for(variation = 1; variation <=8; variation++)
	{
		switch(coarseness)
		{
			case 2:
				transformSequence[variation][myRand()%NUM_TRANSFORMS]=myRand()%TOTAL_TRANSFORMS;
				source[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;
				control[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;
				dest[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;
			 	//Kein break!
			case 1:
				transformSequence[variation][myRand()%NUM_TRANSFORMS]=myRand()%TOTAL_TRANSFORMS;
				source[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;
				control[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;
				dest[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;   			
		 		break;
			case 0:
				switch(myRand()%4)
				{
					case 0:
						transformSequence[variation][myRand()%NUM_TRANSFORMS]=myRand()%TOTAL_TRANSFORMS;
						break;
					case 1:
						source[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;
						break;
					case 2:
						control[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;
						break;
					case 3:
						dest[variation][myRand()%NUM_TRANSFORMS]=myRand()%NUM_REGISTERS;
						break;
				}
				break;
		}
	}  	  
}

void CQbistDoc::SwitchCoarseness(short newCoarseness)
{
	coarseness = newCoarseness;

	POSITION myPos = GetFirstViewPosition();
	if(NULL == myPos) //Doc hat keinen View
		return;	
	CMenu* pMenu = GetNextView(myPos)->GetParent()->GetMenu();

	pMenu->CheckMenuItem(ID_VARIATIONEN_FEIN, MF_UNCHECKED);
	pMenu->CheckMenuItem(ID_VARIATIONEN_MITTEL, MF_UNCHECKED);
	pMenu->CheckMenuItem(ID_VARIATIONEN_GROB, MF_UNCHECKED);

	switch(coarseness)
	{
		case 0:
			pMenu->CheckMenuItem(ID_VARIATIONEN_FEIN, MF_CHECKED);
			break;
		case 1:
			pMenu->CheckMenuItem(ID_VARIATIONEN_MITTEL, MF_CHECKED);
			break;
		case 2:
			pMenu->CheckMenuItem(ID_VARIATIONEN_GROB, MF_CHECKED);
			break;
	}
}

void CQbistDoc::variationAsMain (short variation)
{	
	for(int i=0;i<NUM_TRANSFORMS;i++)
	{
		transformSequence[0][i] = transformSequence[variation][i];
		source[0][i] = source[variation][i];
		control[0][i] = control[variation][i];
		dest[0][i] = dest[variation][i];
	}
	MakeVariations();
	UpdateAllViews(NULL, 0L, NULL);
}

//Ende neu

/////////////////////////////////////////////////////////////////////////////
// CQbistDoc serialization

#define SWAPBYTES(myShort) (HIBYTE(myShort)+(LOBYTE(myShort)<<8))

void CQbistDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
		//neu://ACHTUNG: MOTOROLA-BYTEFOLGE
		for(int i = 0; i<NUM_TRANSFORMS; i++)
	    	ar<< (unsigned short) SWAPBYTES(transformSequence[0][i]);
		for(i = 0; i<NUM_TRANSFORMS; i++)
	    	ar<<(unsigned short) SWAPBYTES(source[0][i]);
		for(i = 0; i<NUM_TRANSFORMS; i++)
	    	ar<<(unsigned short) SWAPBYTES(control[0][i]);
		for(i = 0; i<NUM_TRANSFORMS; i++)
	    	ar<<(unsigned short) SWAPBYTES(dest[0][i]);
		//Ende neu
	}
	else
	{
		// TODO: add loading code here
		//neu:
		unsigned short myValue;
		for(int i = 0; i<NUM_TRANSFORMS; i++)
		{
	    	ar>>myValue;
	    	transformSequence[0][i] = SWAPBYTES(myValue);
		}
		for(i = 0; i<NUM_TRANSFORMS; i++)
		{
	    	ar>>myValue;
	    	source[0][i] = SWAPBYTES(myValue);
		}
		for(i = 0; i<NUM_TRANSFORMS; i++)
		{
	    	ar>>myValue;
	    	control[0][i] = SWAPBYTES(myValue);
		}
		for(i = 0; i<NUM_TRANSFORMS; i++)
		{
	    	ar>>myValue;
	    	dest[0][i] = SWAPBYTES(myValue);
		}
		MakeVariations();
		//Ende neu
	}
}

/////////////////////////////////////////////////////////////////////////////
// CQbistDoc diagnostics

#ifdef _DEBUG
void CQbistDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CQbistDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CQbistDoc commands

void CQbistDoc::OnVariationenFein() 
{
	// TODO: Add your command handler code here
	//neu:
	SwitchCoarseness(0);
	//Ende neu
}

void CQbistDoc::OnVariationenGrob() 
{
	// TODO: Add your command handler code here
	//neu:
	SwitchCoarseness(2);
	//Ende neu
}

void CQbistDoc::OnVariationenMittel() 
{
	// TODO: Add your command handler code here
	//neu:
	SwitchCoarseness(1);
	//Ende neu
}

void CQbistDoc::OnVariationen1() 
{
	// TODO: Add your command handler code here
	//neu
	variationAsMain(1);
	//Ende neu
}

void CQbistDoc::OnVariationen2() 
{
	// TODO: Add your command handler code here
	//neu
	variationAsMain(2);
	//Ende neu
}

void CQbistDoc::OnVariationen3() 
{
	// TODO: Add your command handler code here
	//neu
	variationAsMain(3);
	//Ende neu
}

void CQbistDoc::OnVariationen4() 
{
	// TODO: Add your command handler code here
	//neu
	variationAsMain(4);
	//Ende neu
}

void CQbistDoc::OnVariationen5() 
{
	// TODO: Add your command handler code here
	//neu
	variationAsMain(5);
	//Ende neu
}

void CQbistDoc::OnVariationen6() 
{
	// TODO: Add your command handler code here
	//neu
	variationAsMain(6);
	//Ende neu
}

void CQbistDoc::OnVariationen7() 
{
	// TODO: Add your command handler code here
	//neu
	variationAsMain(7);
	//Ende neu
}

void CQbistDoc::OnVariationen8() 
{
	// TODO: Add your command handler code here
	//neu
	variationAsMain(8);
	//Ende neu
}

void CQbistDoc::OnVariationenZentralbild() 
{
	// TODO: Add your command handler code here
	//neu:
	MakeVariations();
	UpdateAllViews(NULL, 0L, NULL);
	//Ende neu
}

void CQbistDoc::writeByte(unsigned char data, CFile* pFile)
{
	pFile->Write(&data, 1);
}

void CQbistDoc::writeShort(short data, CFile* pFile)
{
	pFile->Write(&data, 2);
}

void CQbistDoc::writeLong(long data, CFile* pFile)
{
	pFile->Write(&data, 4);
}

void CQbistDoc::OnDateiTiffexportieren() 
{
	// TODO: Add your command handler code here
	//neu:

	myTiffDlg.DoModal();
	
	CFileDialog myFileDlg(FALSE,"tif","Kunst.tif",OFN_PATHMUSTEXIST);
	if (IDOK != myFileDlg.DoModal())
		return; //"Abbruch" gedrckt
	
	POSITION pos = GetFirstViewPosition();
	if(NULL != pos)
	{
		CRect myClRect;
		CView* myView = GetNextView(pos);
		myView->GetClientRect(myClRect);
		CBrush myBrush(RGB(192,192,192));
		myView->GetDC()->FillRect(myClRect,&myBrush);
		myView->Invalidate(FALSE); //sonst werden die Bildchen nachher nicht refresht
	}
		
	BeginWaitCursor();

	if (myProgDlg.GetSafeHwnd() == 0) myProgDlg.Create();

	char text[100];

	CFile theFile;
	theFile.Open(myFileDlg.GetPathName().GetBuffer(0),CFile::modeCreate|CFile::modeWrite);
	
	writeShort('II', &theFile); //Intel-Bytefolge
	writeShort(42,&theFile); //TIFF-Version
	writeLong(8L, &theFile); //Offset zu IFD
	
	writeShort(13, &theFile); //Anzahl Eintrge//8
	
	writeShort(255, &theFile); //Subfile Type//10
	writeShort(3, &theFile); //SHORT
	writeLong(1L, &theFile); //count
	writeShort(1, &theFile);
	writeShort(0, &theFile);
	
	writeShort(256, &theFile); //Width//22
	writeShort(3, &theFile); //SHORT
	writeLong(1L, &theFile); //count
	writeShort((unsigned short)(myTiffDlg.m_width), &theFile);
	writeShort(0, &theFile);

	writeShort(257, &theFile); //Height//34
	writeShort(3, &theFile); //SHORT
	writeLong(1L, &theFile); //count
	writeShort((unsigned short)(myTiffDlg.m_height), &theFile);
	writeShort(0, &theFile);

	writeShort(258, &theFile); //BitsPerSamp//46
	writeShort(3, &theFile); //SHORT
	writeLong(3L, &theFile); //count
	writeLong(186L, &theFile);	  //zu 3

	writeShort(259, &theFile); //Comp//58
	writeShort(3, &theFile); //SHORT
	writeLong(1L, &theFile); //count
	writeShort(1, &theFile);
	writeShort(0, &theFile);

	writeShort(262, &theFile); //PhotmInterpr//70
	writeShort(3, &theFile); //SHORT
	writeLong(1L, &theFile); //count
	writeShort(2, &theFile);
	writeShort(0, &theFile);

	writeShort(273, &theFile); //StripOffsets//82
	writeShort(4, &theFile); //LONG
	writeLong(1L, &theFile); //count
	writeLong(192L, &theFile); //zu Bilddaten

	writeShort(277, &theFile); //SampPerPix//94
	writeShort(3, &theFile); //SHORT
	writeLong(1L, &theFile); //count
	writeShort(3, &theFile);
	writeShort(0, &theFile);

	writeShort(279, &theFile); //StripByteCnts//106
	writeShort(4, &theFile); //LONG
	writeLong(1L, &theFile); //count
	writeLong(((long)(myTiffDlg.m_width))*((long)(myTiffDlg.m_height))*3L, &theFile);

	writeShort(282, &theFile); //xRes//118
	writeShort(5, &theFile); //RATIONAL
	writeLong(1L, &theFile); //count
	writeLong(170L, &theFile); //zu 1

	writeShort(283, &theFile); //yRes//130
	writeShort(5, &theFile); //RATIONAL
	writeLong(1L, &theFile); //count
	writeLong(178L, &theFile); //zu 2

	writeShort(284, &theFile); //PlanarConf//142
	writeShort(3, &theFile); //SHORT
	writeLong(1L, &theFile); //count
	writeShort(1, &theFile);
	writeShort(0, &theFile);

	writeShort(296, &theFile); //ResUnit//154
	writeShort(3, &theFile); //SHORT
	writeLong(1L, &theFile); //count
	writeShort(2, &theFile);
	writeShort(0, &theFile);

	writeLong(0L, &theFile); //Kennung fr Directory-Ende//166

	writeLong(72L, &theFile);//1//170
	writeLong(1L, &theFile);//1//174
	writeLong(72L, &theFile);//2//178
	writeLong(1L, &theFile);//2//182
	
	writeShort(8, &theFile);//3//186
	writeShort(8, &theFile);//3//188
	writeShort(8, &theFile);//3//190	 
		
	//Bild ab 192

	myVector reg[NUM_REGISTERS];
	
	long lStartTime,lNowTime,mySeconds;
	time(&lStartTime);
	
	int x,y,i,j;
	long timeCount=0;

	for(y=0;y<myTiffDlg.m_height;y++)
	{
		for(x=0;x<myTiffDlg.m_width;x++)
		{
			for(j=0;j<NUM_REGISTERS;j++) //regs werden bei jedem Pixel zerstrt!
			{
				reg[j].x=((float)x)/(float)myTiffDlg.m_width;
				reg[j].y=((float)y)/(float)myTiffDlg.m_height;
				reg[j].z=((float)j)/(float)NUM_REGISTERS;
			}
			
			for(i=0;i<NUM_TRANSFORMS;i++)
			{
				transformList[transformSequence[0][i]]
					(&(reg[source[0][i]]),&(reg[control[0][i]]),&(reg[dest[0][i]]));
			}
			
			writeByte((unsigned char)(0xFEU * reg[0].x), &theFile);
			writeByte((unsigned char)(0xFEU * reg[0].y), &theFile);
			writeByte((unsigned char)(0xFEU * reg[0].z), &theFile);

			timeCount++;
			if(0 == timeCount % PROGRESS_UPDT_TIME)
			{
				time(&lNowTime);

				mySeconds = (long)(((float)(lNowTime-lStartTime))/(float)(timeCount)*(float)(myTiffDlg.m_height*myTiffDlg.m_width-timeCount));
				
				if(0 == mySeconds) //D.h. noch zu kurz gemessen!
				{
					wsprintf(text, "");
				}
				else
				{
					if(mySeconds > 129L)
					{
						wsprintf(text, "TIFF-Datei fertig in ca. %d Minuten",mySeconds/60);
					}											  
					else
					{
						if(mySeconds > 59L)
							wsprintf(text, "TIFF-Datei fertig in ca. einer Minute");
						else
							wsprintf(text, "TIFF-Datei fertig in ca. %d Sekunden",mySeconds);
					}
				}
				myProgDlg.SetDlgItemText(IDC_PROG_TEXT,text);
			}
		}
	}
	
	theFile.Close(); 

	myProgDlg.DestroyWindow();

	EndWaitCursor();
}
