#ifndef _DEBUG_H_
#define _DEBUG_H_

#ifndef __cplusplus
  #define inline _Inline
#endif

#ifdef __cplusplus
  extern "C" {
#endif

/* This file defines a few macros for debugging, iff DEBUG #define'd          */
/*                                                                            */
/* dprintf              - used just like printf                               */
/* dputs                - print out a string                                  */
/* ENSURE(x)            - prints a message if x evaluates to FALSE            */
/* VALIDPTR(x)          - prints a message if x is null ptr or invalid        */
/* BREAKPOINT           - set a breakpoint                                    */
/* PT                   - just print a message with function, file, line      */
/* IF_DEBUG(x)          - evaluate x iff DEBUG is #defined'd                  */

#ifdef DEBUG
 extern void dprintf(char *format, ...);
 extern void _debug_ensure(int x, char *expr, char *f, char *file, int line);
 extern int checkDOS(APIRET rc, char *fun, char *file, int line);
 extern int checkPM(HWND dummy, char *fun, char *file, int line);
 extern void _debug_winhandle(HWND hwnd, char *fun, char *file, char *line);

 #define dputs(x) dprintf("%s [%s (%s,%i)]\r\n", x, __FUNCTION__, __FILE__, __LINE);
 #define BREAKPOINT   { EXCEPTIONREPORTRECORD r; r.ExceptionNum=0xe004abcd; r.fHandlerFlags=0;         \
                        r.NestedExceptionReportRecord=0; \
                        r.ExceptionAddress=0; \
                        r.cParameters=0; DosRaiseException(&r); debug_output("breakpoint\r\n");}
 #define ENSURE(x)    _debug_ensure((x), #x, __FUNCTION__,__FILE__,__LINE__)
 #define VALIDPTR(p)  _debug_valid_ptr((p), #p, __FUNCTION__, __FILE__, __LINE__)
 #define PT           dprintf("CHECKPOINT %i: %s in (%s,%i)\n", __LINE__, __FUNCTION__, __FILE__, __LINE__);
 #define IF_DEBUG(x) (x)
 #define CHECKDOS(x) checkDOS(x, __FUNCTION__, __FILE__, __LINE__)
 #define CHECKPM(x)  checkPM(x, __FUNCTION__, __FILE__, __LINE__)
 #define CHECKHANDLE(x) _debug_winhandle(x, __FUNCTION__, __FILE__, __LINE__)
 #define CHECKMSG(h, m, mp1, mp2) _debug_winmsg(h,m, mp1, mp2, __FUNCTION__, __FILE__, __LINE__)
#else
 inline  void dprintf(char *s, ...) {}

 #define BREAKPOINT
 #define ENSURE(x)
 #define VALIDPTR(x)
 #define PT
 #define IF_DEBUG(x)
 #define CHECKDOS(x)
 #define CHECKPM(x)
 #define CHECKHANDLE(x)
 #define CHECKMSG(h, m, mp1, mp2)
#endif

#ifdef __cplusplus
  }
#endif

#endif
