#define INCL_DOS
#define INCL_WIN
#include <os2.h>
#include "toolbar.h"
#include "statbar.h"
#include "ctedit.h"
#include "debug.h"

MRESULT EXPENTRY clientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

#define ID_TOOLBAR   100
#define ID_STATUSBAR 101
#define ID_MLE       102

extern HAB hab;

HWND EnhClientWinCreateStdWindow(HWND    hwndParent,
                           ULONG   flStyle,
                           PULONG  flags,
                           PSZ     clientClass,
                           PSZ     title,
                           ULONG   styleClient,
                           HMODULE hmod,
                           ULONG   id,
                           PHWND   hwndClient)
  {
  HWND hwndFrame;
  static BOOL registered=FALSE;
  static char classname[]="ctEnhClient";

  if (!registered)
      {
      WinRegisterClass(hab, classname, clientWndProc, CS_SIZEREDRAW, 0);
      registered=TRUE;
      }

  hwndFrame=WinCreateStdWindow(hwndParent, flStyle, flags, classname,
                             title, styleClient, hmod, id, hwndClient);

  WinShowWindow(hwndFrame, TRUE);
  return hwndFrame;
  }

MRESULT EXPENTRY clientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
  {
  HWND hwndToolbar  =WinWindowFromID(hwnd, ID_TOOLBAR);
  HWND hwndStatusbar=WinWindowFromID(hwnd, ID_STATUSBAR);
  HWND hwndMLE      =WinWindowFromID(hwnd, ID_MLE);

  if (msg==WM_COMMAND || msg==WM_CONTROL)
     {
     return ctEditorProc(hwnd, msg, mp1, mp2);
     }

  switch(msg)
     {
    case WM_SIZE:
         {
         int cx=SHORT1FROMMP(mp2);
         int cy=SHORT2FROMMP(mp2);

         WinSetWindowPos(hwndToolbar,   HWND_TOP, 0,cy-TOOLBAR_HEIGHT,cx,TOOLBAR_HEIGHT,SWP_MOVE|SWP_SIZE|SWP_ZORDER);
         WinSetWindowPos(hwndMLE,       HWND_TOP, 0,   20,cx, cy-(TOOLBAR_HEIGHT+20), SWP_MOVE|SWP_SIZE|SWP_ZORDER);
         WinSetWindowPos(hwndStatusbar, HWND_TOP, 0,    0,cx,    20, SWP_MOVE|SWP_SIZE|SWP_ZORDER);
         }
       break;
    case WM_CREATE:
        WinCreateWindow(hwnd, WC_MLE, (PSZ)"",
                        WS_VISIBLE | MLS_HSCROLL | MLS_VSCROLL,
                        10, 0, 455, 101,
                        hwnd, HWND_TOP, ID_MLE, 0L, NULL);
        WinCreateWindow(hwnd, "ctToolbar", (PSZ)"",
                        WS_VISIBLE,
                        0, 0, 0, 0,
                        hwnd, HWND_TOP, ID_TOOLBAR, 0L, NULL);
        WinCreateWindow(hwnd, "ctStatusbar", (PSZ)"ctStatusbar",
                        WS_VISIBLE,
                        0, 0, 0, 0,
                        hwnd, HWND_TOP, ID_STATUSBAR, 0L, NULL);
        break;
     case WM_USER:
        return (MRESULT)hwndToolbar;
     default:
       return WinDefWindowProc(hwnd,msg,mp1,mp2);
     }
  return FALSE;
  }
