/* patchfmt.cmd  by Harald Bgeholz / c't            */
/* patcht einen neuen Bootsektor in OS/2s FORMAT.COM */

parse arg bootfile fmtfile rest
parse source . . where
fname=filespec("Name", where)
say fname"   by Harald Bgeholz / c't"

if (rest \== "") | (fmtfile == "") then do
  say "Aufruf: "fname" <bootsektor> <format.com>"
  say "  <bootsektor> = Filename des Bootsektors"
  say "  <format.com> = Filename des zu patchenden FORMAT.COM"
  say "ACHTUNG: Machen Sie vorher ein Backup von FORMAT.COM!!!"
  exit
end

bootsector=charin(bootfile, 1, 513)
if (length(bootsector) \= 512) | (right(bootsector,2) \== "55AA"X) |,
   (left(bootsector,1) == "EB"X & c2d(substr(bootsector,2,1)) < 60) |,
   (left(bootsector,1) == "E9"X & c2d(substr(bootsector,2,1)) < 59) |,
   (left(bootsector,1) \== "E9"X & left(bootsector,1) \== "EB"X) then do
  say "Ungltiger oder ungeeigneter Bootsektor!"
  exit
end

formatcom=charin(fmtfile, 1, 100000)
if (length(formatcom) >= 100000) then do
  say "FORMAT.COM zu lang!"
  exit
end
if (left(formatcom,2) \== "MZ") then do
  say "FORMAT.COM ungltig"
  exit
end

bootpos=pos("IBM 20.0", formatcom)-3
if (bootpos<0) | (substr(formatcom,bootpos+510,2) \== "55AA"X) then do
  say "Original-Bootsektor nicht gefunden. Kann FORMAT.COM nicht patchen."
  exit
end
say "Bootsektor gefunden bei Offset" bootpos-1

call charout fmtfile, bootsector, bootpos
say "FORMAT.COM erfolgreich gepatcht."
