/* ffnen einer Datei mittels StandardFile */

/* Globale Variablen */

Handle				gTextHandle;

/*FSSpecOpen*/
#pragma segment Files
Boolean FSSpecOpen()
{
	StandardFileReply		mySFR;
	SFTypeList				docTypes;
	short					fileRef;
	long					docLength;
	OSErr					err;
	
	sndTypes[0] = 'TEXT';
	sndTypes[1] = 'ttro';
/* In der StandardFile-Box werden nur Dokumente der 
obigen Datei-Typen angezeigt */
	StandardGetFile(nil, 2, docTypes, &mySFR);
	if (mySFR.sfGood)
	{			
/* Das ausgewhlte Dokument wird mittels eines FSSpecs geffnet */			
		err = FSpOpenDF(&mySFR.sfFile, fsCurPerm, &fileRef);
		if (err != noErr) { ReportError(kOpenErrStrID, true, err); }
		err = GetEOF(fileRef, &docLength);
		if (error != noErr) { ReportError(kOpenErrStrID, true, err); }
		gTextHandle = NewHandle(docLength+16);
		if (gTextHandle == nil) { ReportError(kMemFullErrStrID, true, KMemFullErr); }
/* gTextHandle ist global definiert, deshalb kann der 
Aufruf von HUnlock an anderer Stelle erfolgen */
		HLock(gTextHandle);
/* Der Schreib-/Lesezeiger wird auf den Anfang des 
Dokumentes gesetzt */
		err = SetFPos(fileRef,fsFromStart,0);
		if (err != noErr) { ReportError(kOpenErrStrID, true, err); }
/* Es werden docLength Bytes in gTextHandle eingelesen */
		err = FSRead(fileRef, &docLength, *gTextHandle);
		if (err != noErr) { ReportError(kReadErrStrID, true, err); }
		err = FSClose(fileRef);
		if (err != noErr) { ReportError(kCloseErrStrID, true, err); }
	}
	return mySFR.sfGood;
}


/* Wie findet man einen Ordner? */

/* Typdefinitionen */

typedef struct {
	Boolean				isASCII;
	long				teFlushWhichWay;
	long				teLanguage;
	long				teFlags;
	} TextPrefs, *TextPrefsPtr, **TextPrefsHandle;
	
/* Globale Variablen */

TextPrefs				gTextPrefs;

/* Preferences lesen */
void ChangePrefs()
{

	short				prefVRefNum;
	long				prefDirID;
	FSSpec				prefFSSpec;
	short				fileRef;
	OSErr				err;
	
	
/* Nachschauen, ob ein Preferences-Ordner existiert, 
wenn nicht, anlegen */
	err = FindFolder(kOnSystemDisk, kTemporaryFolderType, kCreateFolder,
&prefVRefNum, &prefDirID);
	count = sizeof(gPrefs);
/* Existiert schon ein Prefences-Dokument dieses Programmes
auf dem angegebenen Volume im angegebenen Verzeichnis? */
/* Wenn nicht, dann gibt FSMakeFSSpec "file not found" 
(fnfErr) als Fehlermeldung zurck */
	if (FSMakeFSSpec(prefVRefNum, prefDirID, kTempName, &prefFSSpec) == fnfErr)
	{
	FSpCreate(&prefFSSpec, 'BRAP', 'pref', -1));
	err = FSpOpenDF(&prefFSSpec, fsCurPerm, fileRef);
	if (err != noErr) { ReportError(kOpenErrStrID, true, err); }
	err = SetFPos(fileRef,fsFromStart,0);
	if (err != noErr) { ReportError(kOpenErrStrID, true, err); }
	gTextPrefs.isASCII = true;
	gTextPrefs.teFlushWhichWay = teFlushRight;
	gTextPrefs.teLanguage = kGermanLanguage;
	gTextPrefs.teFlags = 0x00000000;
	err = FSWrite(fileRef, sizeof(gTextPrefs), &gTextPrefs);
	if (err != noErr) { ReportError(kWritedErrStrID, true, err); }
	err = FSClose(fileRef);
	if (err != noErr) { ReportError(kCloseErrStrID, true, err); }
	}
/* Preferences-Dokument existiert bereits */
	else
	if (FSMakeFSSpec(prefVRefNum, prefDirID, kTempName, &prefFSSpec) == noErr)
	{
	
	err = FSpOpenDF(&prefFSSpec, fsCurPerm, fileRef);
	if (err != noErr) { ReportError(kOpenErrStrID, true, err); }
	err = SetFPos(fileRef,fsFromStart,0);
	if (err != noErr) { ReportError(kOpenErrStrID, true, err); }
/* Preferences in gTextPrefs einlesen */
	err = FSRead(fileRef, sizeof(gTextPrefs), &gTextPrefs);
	if (err != noErr) { ReportError(kReadErrStrID, true, err); }
	err = FSClose(fileRef);
	if (err != noErr) { ReportError(kCloseErrStrID, true, err); }
	}
}

/* working directory in vRefNum und DirID umwandeln, 
um einen FSSpec anzulegen */

/* working directory umwandeln */
void ChangeWDtoVandDir()
{
	Str63					volName;
	short					wdRefNum;
	short					vRefNum;
	long					dirID;
	FSSpec					tempFSSpec;
	
	
/* HGetVol kann ein WD zurckgeben, wenn das 
default-Volume auf diese Weise zuvor gesetzt wurde */
	err = HGetVol((StringPtr) &volName, &vRefNum, &dirID);
	if (err != noErr) { ReportError(kVolumeErrStrID, true, err); }
/* Das WD steht nach Aufruf von HGetVol in vRefNum */
	wdRefNum = vRefNum;
/* GetWDInfo wandelt das WD in vRefNum und dirID um */
	err = GetWDInfo(wdRefNum, &vRefNum, &dirID, nil);
	if (err != noErr) { ReportError(kWDErrStrID, true, err); }
	if (FSMakeFSSpec(vRefNum, dirID, kTempName, &tempFSSpec) == fnfErr)
	{
	
/* Das Dokument existiert noch nicht auf dem 
default-Volume und mu erst angelegt werden */
	
	}
	else
	if (FSMakeFSSpec(vRefNum, dirID, kTempName, &tempFSSpec) == fnfErr)
	{
	
/* Das Dokument existiert schon auf dem default-Volume 
und kann benutzt werden */
	}
}
