/* Drucken unter Windows: Beispiel prt2.cpp */
/* Thomas Hornschuh, c't 8/95, MS VC++ 1.51 */
#include <windows.h>
#include <string.h>
#include <commdlg.h>
#include "printlib.h" // allgemeine
#include "printdlg.h"
#include "resid.h"

HWND hWndEdit, hWndMain;
BOOL fNoName=TRUE;
HGLOBAL hDevNames=NULL, hDevMode=NULL;
HINSTANCE hInstance;

/* Seitenraender, Default 1 Zoll */
int TopBorder=720;
int BottomBorder=720;
int LeftBorder=720;
int RightBorder=720;

void LoadFile()
{
OPENFILENAME ofn;
char szDirName[128];
char szFile[128]="\0";
HFILE hf;
HGLOBAL hMem;
LPSTR lpText;
UINT nBytes;
HFONT OldFont;

  /* Hole Namen des Windows Directories */
  GetWindowsDirectory(szDirName, sizeof(szDirName));
  /* temporr */
  strcpy(szDirName,"G:\\WFW311"); 
  
  /* Initalisiere Struktur mit Nullen */
  memset(&ofn, 0, sizeof(OPENFILENAME));
  
  /* OpenFile-Dialog vorbereiten */
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hWndMain;
  ofn.lpstrFilter = "Ini-Dateien (*.ini)\0*.ini\0Textdateien (*.txt)\0*.txt\0\0";
  ofn.nFilterIndex = 1;
  ofn.lpstrFile= szFile;
  ofn.nMaxFile = sizeof(szFile);
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

  if (GetOpenFileName(&ofn)) {
    hMem=GlobalAlloc(GMEM_MOVEABLE,65535);
    if (!hMem) return;
    lpText=(LPSTR)GlobalLock(hMem);

    hf = _lopen(szFile, OF_READ);
    nBytes=_lread(hf,lpText,65535);
    _lclose(hf);
    if (nBytes>0) {
      lpText[nBytes]='\0';
      SetWindowText(hWndEdit,lpText);
      SetWindowText(hWndMain,szFile);
      fNoName=FALSE;
    }
    GlobalFree(hMem);
  }
}

void SaveFile(BOOL fDialog)
{
OPENFILENAME ofn;
char szDirName[128];
char szFile[128]="\0";
HFILE hf;
HGLOBAL hMem;
LPSTR lpText;
int nBytes;
OFSTRUCT of;
BOOL fDoSave;

  if (fDialog || fNoName) {
    /* Hole Namen des Windows Directories */
    GetWindowsDirectory(szDirName, sizeof(szDirName));

    /* Initalisiere Struktur mit Nullen */
    memset(&ofn, 0, sizeof(OPENFILENAME));

    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hWndMain;
    ofn.lpstrFilter = "Alle Dateien\0*.*\0\0";
    ofn.nFilterIndex = 1;
    ofn.lpstrFile= szFile;
    ofn.nMaxFile = sizeof(szFile);
    ofn.lpstrInitialDir = szDirName;
    ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
    fDoSave=GetSaveFileName(&ofn);
  } else {
    fDoSave=TRUE;
    GetWindowText(hWndMain,szFile,sizeof(szFile));
  }

  if (fDoSave) {
    hMem=GlobalAlloc(GMEM_MOVEABLE,65535);
    if (!hMem) return;
    lpText=(LPSTR)GlobalLock(hMem);
    nBytes=GetWindowText(hWndEdit,lpText,65535);

    hf=OpenFile(szFile,&of,OF_CREATE|OF_WRITE);
    if (!hf) {
      GlobalFree(hMem);
      return;
    }
    _lwrite(hf,lpText,nBytes);
    _lclose(hf);

    GlobalFree(hMem);
  }

}

#ifdef PROTOKOLL
void DebugOutputLineInfo(RECT &rcRect,LPSTR lpText,int nTextLength)
{
char Buffer[1024];
char Text [512];
MSG msg;

  strncpy(Text,lpText,nTextLength);
  Text[nTextLength]='\0';
  wsprintf(Buffer,
    "\n***\nRect: left %d top %d right %d bottom %d\nTextHeight: %d\nText: %s\n",
    rcRect.left,rcRect.top,rcRect.right,rcRect.bottom,
    rcRect.bottom-rcRect.top,Text);
  OutputDebugString(Buffer);
}
#endif PROTOKOLL      
  
// DoTextPrint druckt den Text im Edit-Control hWndEdit aus
// Thomas Hornschuh / c't 8/95 / MSVC++ 1,51
BOOL DoTextPrint( HDC hDC,BOOL fDoPrint,
                  int nMinPage,int nMaxPage, int &nPages) {
LPSTR lpszBuffer, pStart,pEnd,pOut;
UINT nLength;
HGLOBAL hBuffer;
POINT Extent;
RECT rcText;
int AktY;
BOOL fInPrint; // Drucken oder nur Berechnen ?

  nPages=1; // Seitenzaehler
  SetTypoMapping(hDC); // Mapping Mode setzen, Seite initialisieren
  nLength=GetWindowTextLength(hWndEdit)+1;
  hBuffer=GlobalAlloc(GMEM_MOVEABLE,nLength);
  lpszBuffer=(LPSTR)GlobalLock(hBuffer);
  GetWindowText(hWndEdit,lpszBuffer,nLength);
  pStart=lpszBuffer;
  // physikalische Seitengroesse ermitteln, umrechnen
  Escape(hDC,GETPHYSPAGESIZE,NULL,NULL,&Extent);
  Extent.x=MulDiv(Extent.x,720,GetDeviceCaps(hDC, LOGPIXELSX));
  Extent.y=MulDiv(Extent.y,720,GetDeviceCaps(hDC, LOGPIXELSY)); 

  AktY=TopBorder;
  fInPrint=fDoPrint && nPages>=nMinPage && nPages<=nMaxPage;
  if (fInPrint) {
    SetTypoMapping(hDC);
    StartPage(hDC);
  }   

  while (*pStart!='\0') {
    pEnd=strchr(pStart,13); // return suchen
    if (!pEnd)
      pEnd=strchr(pStart,'\0');
    rcText.left=LeftBorder;  rcText.right=Extent.x-RightBorder;
    rcText.top=AktY;         rcText.bottom=rcText.top;
    /* Abmessungen der Zeile errechnen, aber nicht ausgeben */
    nLength=pEnd-pStart;
    if (nLength==0) {
      nLength=1; pOut=" ";
    } else
      pOut=pStart;
    SelectObject(hDC, GetStockObject(ANSI_FIXED_FONT));
    DrawText(hDC,pOut,nLength, // DT_CALCRECT ist der "Trick"
         &rcText,DT_LEFT | DT_TOP|DT_WORDBREAK | DT_CALCRECT | 
         DT_NOPREFIX|DT_EXPANDTABS);
    if (rcText.bottom>Extent.y-BottomBorder) { 
      // Neue Seite anfangen
      if (fInPrint) {
        if (EndPage(hDC)<0) { // Abbruch pruefen
          AbortDoc(hDC);
          return TRUE;
        }
      }
      nPages++;
      fInPrint=fDoPrint && nPages>=nMinPage && nPages<=nMaxPage;
      if (fInPrint) {
        SetTypoMapping(hDC);
        StartPage(hDC);
      }   

      if (fDoPrint) DlgNextPage();
      AktY=TopBorder;
      rcText.left=LeftBorder; rcText.right=Extent.x-RightBorder;
      rcText.top=AktY;        rcText.bottom=rcText.top;
      SelectObject(hDC, GetStockObject(ANSI_FIXED_FONT));
      DrawText(hDC,pOut,nLength,
      &rcText,DT_LEFT | DT_TOP | DT_WORDBREAK | DT_CALCRECT | 
      DT_NOPREFIX | DT_EXPANDTABS);
   }
   /* Nun Text auch wirklich ausgeben */
   if (fInPrint) {
         SelectObject(hDC, GetStockObject(ANSI_FIXED_FONT));
         DrawText(hDC, pOut, nLength, &rcText, DT_LEFT | 
                 DT_TOP | DT_WORDBREAK|DT_NOPREFIX|DT_EXPANDTABS); }
   AktY=rcText.bottom;
   /* Naechste Zeile bearbeiten */
   if (*pEnd!='\0') { // noch kein Textende
     pStart=pEnd+1;
     if (*pStart=='\n') pStart++; // ggf. Linefeed ueberspringen
   } else // Textende erreicht 
     pStart=pEnd;
  }
  if (fInPrint) // bei "echtem" Drucklauf Abbruch pruefen
    if (EndPage(hDC)<0) {
      AbortDoc(hDC);
      return TRUE;
    }
  return FALSE;
}
  
void PrintText()
{
HDC hDC;
DOCINFO doc;
// RECT rcBand;
char DocName[128];
DWORD Flags;
int nFromPage,nToPage,nPages;
BOOL fAbort;

  // Seitenanzahl berechnen
  if (!hDevNames || !hDevMode)
    GetPrinterSettings(hWndMain,FALSE,hDevMode,hDevNames);
  hDC=OpenPrinter(hDevNames,hDevMode);
  if (!hDC) return;
  DoTextPrint(hDC,FALSE,1,999,nPages);
  DeleteDC(hDC);
  Flags=PD_DISABLEPRINTTOFILE;
  hDC=OpenPrinterInteractiveEx(hWndMain,hDevMode,hDevNames,1,nPages,
                   nFromPage,nToPage,Flags);
  if (hDC) {
    GetWindowText(hWndMain,DocName,sizeof(DocName));
    doc.cbSize=sizeof(doc);
    doc.lpszDocName=DocName;
    doc.lpszOutput=NULL;
    StartDoc(hDC,&doc);
    ShowPrintDlg(99,1,hWndMain,hInstance);
    DoSetAbortProc(hDC,hInstance);

    fAbort=DoTextPrint(hDC,TRUE,nFromPage,nToPage,nPages);

    if (!fAbort) EndDoc(hDC);
    DeleteDC(hDC);
    ClosePrintDlg();
  }
}

void HandleCommand(HWND hWnd,UINT id)
{
  switch(id) {
    case IDM_EXIT:
      SendMessage(hWnd,WM_CLOSE,0,0L);
      break;
    case IDM_CUT:
      SendMessage(hWndEdit,WM_CUT,0,0L);
      break;
    case IDM_COPY:
      SendMessage(hWndEdit,WM_COPY,0,0L);
      break;
    case IDM_PASTE:
      SendMessage(hWndEdit,WM_PASTE,0,0L);
      break;
    case IDM_OPEN:
      LoadFile();
      break;
    case IDM_SAVE:
      SaveFile(FALSE);
      break;
    case IDM_SAVEAS:
      SaveFile(TRUE);
      break;
    case IDM_NEW:
      SetWindowText(hWndEdit,"");
      fNoName=TRUE;
      break;
    case IDM_PRINT:
      PrintText();
      break;
    case IDM_SETUP:
      GetPrinterSettings(hWndMain,TRUE,hDevMode,hDevNames);
      break;
  }
}    



LRESULT FAR PASCAL _export WinProc(HWND hWnd, UINT msg, WPARAM wParam,LPARAM lParam)
{
// HDC hDC;
RECT rcClient;

  switch(msg) {
    case WM_CREATE:
      GetClientRect(hWnd,&rcClient);
      hWndEdit=CreateWindow("EDIT","",
      WS_CHILD|WS_VISIBLE|WS_HSCROLL|WS_VSCROLL|ES_MULTILINE,
      0,0,rcClient.right,rcClient.bottom,hWnd,NULL,
      GetWindowWord(hWnd,GWW_HINSTANCE),NULL);
      SendMessage(hWndEdit, WM_SETFONT, GetStockObject(ANSI_FIXED_FONT), 1L);
      return 0L;

    case WM_COMMAND:
      HandleCommand(hWnd,wParam);
      return 0L;
    case WM_SIZE:
      GetClientRect(hWnd,&rcClient);
      SetWindowPos(hWndEdit,NULL,0,0,rcClient.right,
           rcClient.bottom,SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
      break;
    case WM_DESTROY:
      PostQuitMessage(0);
      break;
    case WM_ACTIVATE:
      if (wParam)
    SetFocus(hWndEdit);
      return 0L;

  }
  return DefWindowProc(hWnd,msg,wParam,lParam);
}


void DoRegister(HINSTANCE hInst)
{
WNDCLASS c;

  c.style=NULL;
  c.lpfnWndProc=WinProc;
  c.cbClsExtra=0;
  c.cbWndExtra=0;
  c.hInstance=hInst;
  c.hIcon=LoadIcon(NULL,IDI_APPLICATION);
  c.hCursor=LoadCursor(NULL,IDC_ARROW);
  c.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);
  c.lpszMenuName="TheMenu";
  c.lpszClassName="GDIPrintExample";
  RegisterClass(&c);
};



int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInstance,
            LPSTR lpCmdLine, int nCmdShow)

{
// HWND hWnd;
MSG msg;

  lpCmdLine;
  
  if (!hPrevInstance)
    DoRegister(hInst);

  hInstance=hInst;

  hWndMain=CreateWindow("GDIPrintExample","PrintPad",
          WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,
          CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
          NULL,NULL,hInst,NULL);


  ShowWindow(hWndMain,nCmdShow);
  while (GetMessage(&msg,0,0,0)) {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
  return msg.wParam;

}