// Fortschrittsdialog und Abbruch-Callback fuer Druckprogramm
// Thomas Hornschuh / c't 8/95 / MSVC++ 1.51
#include <windows.h>
#include "resid.h"

char TextTemplate[64];
int nStartPage;
int nMaxPage;

HWND hWndDialog;
BOOL fAborted;
DLGPROC DlgProcInstance=NULL;
ABORTPROC AbortProcInstance=NULL;

// Abbruchcallback
BOOL CALLBACK _export AbortProc(HDC hDC, int error) {
MSG msg;
  if (PeekMessage(&msg,NULL,NULL,NULL,PM_REMOVE))
    if (!IsDialogMessage(hWndDialog,&msg)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  return !fAborted;
}

// Fortschrittsdialogprozedur
BOOL CALLBACK _export PrintDlgProc( HWND hwndDlg, UINT msg, 
                                    WPARAM wParam,LPARAM lParam) {
char NewText[64];
  switch (msg) {
    case WM_INITDIALOG:
      GetDlgItemText( hwndDlg, IDT_TEXT, TextTemplate, 
                      sizeof(TextTemplate));
      wsprintf(NewText, TextTemplate, nStartPage, nMaxPage);
      SetDlgItemText(hwndDlg, IDT_TEXT, NewText);
      return TRUE;
    case WM_COMMAND:
      fAborted= wParam==IDOK;
      return TRUE;
  }
  return FALSE;
}
  
// Fortschrittsdialog anzeigen
void ShowPrintDlg(int nMax,int nStart,HWND hParent,HINSTANCE hInst) {
  if (!DlgProcInstance)
    DlgProcInstance= (DLGPROC)MakeProcInstance(FARPROC(PrintDlgProc),
                    hInst);
  nMaxPage=nMax;
  nStartPage=nStart;
  fAborted=FALSE;
  hWndDialog=CreateDialog(hInst,"PrintDlg",hParent,DlgProcInstance);
  EnableWindow(hParent,FALSE);
}

// eine Seite weiter
void DlgNextPage()
{
char NewText[64];
 wsprintf(NewText,TextTemplate,++nStartPage,nMaxPage);
 SetDlgItemText(hWndDialog,IDT_TEXT,NewText);
}

// Abbruchcallback setzen
void DoSetAbortProc(HDC hDC,HINSTANCE hInst) {
  if (!AbortProcInstance)
    AbortProcInstance= (ABORTPROC)MakeProcInstance(FARPROC(AbortProc),
                        hInst);
  SetAbortProc(hDC,AbortProcInstance);
}

// Forschrittsdailog entfernen
void ClosePrintDlg() {
  EnableWindow(GetParent(hWndDialog),TRUE);
  DestroyWindow(hWndDialog);
}
