//68K-Code. Mit MacHeaders kompilieren
#include <QuickdrawText.h>
#include <fp.h>
#include "globals.h"

#define kOn  2
#define kOff  3
#define kShowInfo  1
#define kButtonLeft  4
#define kButtonRight  8
#define kDemoArea  14
#define kDemoFont 15
#define mDemoFont -4048

typedef struct
{
  Boolean isOn;
  char radioButtonState;
  MenuHandle demoFontMenu;
  short font;
  GWorldPtr gWorld1, gWorld2;
  unsigned char gammaCurve[17];
  unsigned char *smoothedBits, *numberOfSetBits;
} CPStruct;

void drawDemoArea(DialogPtr CPDialog, int numItems,
      CPStruct** myHandle);

pascal long main(int message, int item, int numItems, int CPanelID,
      EventRecord *theEvent, long cdevStorageValue,
      DialogPtr CPDialog )
{
  CPStruct** myHandle;
  ControlHandle myControlHandle;
  short itemType, j;
  Rect itemRect, worldBounds;
  QDErr errorCode1 = noErr, errorCode2 = noErr;
  int i, choice;
  Point pt;
  Str255 tempStr;
  DialogPtr myDialog;
  float gamma;
  Handle resHandle = NIL;
  
  if ((message != macDev) && (message != initDev))
    myHandle = (CPStruct**)cdevStorageValue;
  switch(message)
  {
     case macDev:
      return 1L;
    case initDev:
      if((NIL != (myHandle=(CPStruct**)NewHandle(sizeof(CPStruct))))
        //"&&" bricht nach false ab, das erspart lange if-Kette!
        &&((**myHandle).smoothedBits=(**myHandle).smoothedBits=NIL,
           HLock((Handle)myHandle),
           GetDItem(CPDialog,kDemoArea,&itemType,
                                (Handle*)&myControlHandle,&itemRect),
           SetRect(&worldBounds,0,0,(itemRect.right-itemRect.left)*4,
                                   (itemRect.bottom-itemRect.top)*4),
           noErr == (errorCode1 = NewGWorld(&((**myHandle).gWorld1),
                                         1,&worldBounds,NIL,NIL,0L)))
        &&(SetRect(&worldBounds,0,0,itemRect.right-itemRect.left,
                                       itemRect.bottom-itemRect.top),
           noErr == (errorCode2 = NewGWorld(&((**myHandle).gWorld2),
                                         1,&worldBounds,NIL,NIL,0L)))
        &&(NIL != (resHandle = GetResource('DATA', rData)))
        &&(GetDItem(CPDialog,kDemoArea,&itemType,
                                (Handle*)&myControlHandle,&itemRect),
           NIL != ((**myHandle).smoothedBits =
             (unsigned char*)NewPtr((itemRect.right-itemRect.left+1)*
                     (itemRect.bottom-itemRect.top+1)*sizeof(char))))
        &&(NIL != ((**myHandle).numberOfSetBits =
                           (unsigned char*)NewPtr(16*sizeof(char)))))
      {}
      else //Initialisierungsfehler; Speicher freigeben
      {
        if (myHandle != NIL) //Allokation hier erfolgreich
        {
          if (noErr == errorCode1)
            DisposeGWorld((**myHandle).gWorld1);
          if (noErr == errorCode2)
            DisposeGWorld((**myHandle).gWorld2);
          if (NIL != resHandle)
            ReleaseResource (resHandle);
          if (NIL != (**myHandle).smoothedBits)
            DisposePtr((Ptr)(**myHandle).smoothedBits);
          if (NIL != (**myHandle).numberOfSetBits)
            DisposePtr((Ptr)(**myHandle).numberOfSetBits);
          DisposeHandle((Handle)myHandle);
        }
        return cdevMemErr; //Abbruch. Fehlermeldung an Finder
      }
      
      for(i=0; i<16; i++)
        (**myHandle).numberOfSetBits[i] = ((i & 0x8) != 0) 
            + ((i & 0x4) != 0) + ((i & 0x2) != 0) + ((i & 0x1) != 0);
      
      (**myHandle).isOn = ((**(resourceStruct**)resHandle).isOn!=0) ?
                                                        true : false;
      GetDItem(CPDialog,kOn+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
      SetCtlValue(myControlHandle,(**myHandle).isOn?1:0);
      GetDItem(CPDialog,kOff+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
      SetCtlValue(myControlHandle,(**myHandle).isOn?0:1);
      
      if( ((**(resourceStruct**)resHandle).radioButtonState
                                                    < kButtonLeft) ||
          ((**(resourceStruct**)resHandle).radioButtonState
                                  > kButtonRight) ) //falls Datenmll
        (**myHandle).radioButtonState = kButtonLeft+2;
      else
        (**myHandle).radioButtonState =
                    (**(resourceStruct**)resHandle).radioButtonState;
      ReleaseResource(resHandle);
      for(i=kButtonLeft; i<=kButtonRight; i++)
      {
        GetDItem(CPDialog,i+numItems,&itemType,   
                                (Handle*)&myControlHandle,&itemRect);
        SetCtlValue(myControlHandle,
                           (i==(**myHandle).radioButtonState) ? 1:0);
      }
      gamma = 0.06-0.12*((**myHandle).radioButtonState-kButtonLeft) /
                                 (float)(kButtonRight-kButtonLeft+1);
        for(i=0; i<=16; i++) //nicht ganz "Gamma"
          (**myHandle).gammaCurve[i] =
                      (unsigned char)(255.0*(i+gamma*i*(16-i))/16.0);
      
      (**myHandle).demoFontMenu = GetMenu(mDemoFont);
      InsertMenu((**myHandle).demoFontMenu, hierMenu);
      AddResMenu((**myHandle).demoFontMenu,'FONT');
      GetDItem(CPDialog,kDemoArea+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
      i=itemRect.right;
      GetDItem(CPDialog,kDemoFont+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
      itemRect.right=i;
      itemRect.bottom=itemRect.top+19;
      SetDItem(CPDialog,kDemoFont+numItems,itemType,
                                  (Handle)myControlHandle,&itemRect);
      (**myHandle).font=0;
      HUnlock((Handle)myHandle);
      break;
    case hitDev:
      HLock((Handle)myHandle);
      if( ((item == kOn + numItems) && (!(**myHandle).isOn))  || 
          ((item == kOff + numItems) && (**myHandle).isOn) )
      {
        (**myHandle).isOn = !(**myHandle).isOn;
        GetDItem(CPDialog,kOn+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
        SetCtlValue(myControlHandle,(**myHandle).isOn?1:0);
        GetDItem(CPDialog,kOff+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
        SetCtlValue(myControlHandle,(**myHandle).isOn?0:1);
        drawDemoArea(CPDialog,numItems,myHandle);
      }
      else if ((item >= kButtonLeft + numItems) &&
                                 (item <= kButtonRight + numItems) &&
                               (item!=(**myHandle).radioButtonState))
      {
        (**myHandle).radioButtonState=item;
        for(i=kButtonLeft; i<=kButtonRight; i++)
        {
          GetDItem(CPDialog,i+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
          SetCtlValue(myControlHandle,
                             (i==(**myHandle).radioButtonState)?1:0);
        }
        gamma = 0.06-0.12*((**myHandle).radioButtonState-kButtonLeft)
                                /(float)(kButtonRight-kButtonLeft+1);
        for(i=0; i<=16; i++) //nicht ganz "Gamma"
          (**myHandle).gammaCurve[i] =
                      (unsigned char)(255.0*(i+gamma*i*(16-i))/16.0);
        
        if( (**myHandle).isOn )
          drawDemoArea(CPDialog,numItems,myHandle);
      }
      else if (item == kShowInfo + numItems)
      {
        if(NIL != (myDialog=GetNewDialog(-4048,NIL,(WindowPtr)-1L)))
        {
          SetDialogDefaultItem(myDialog,1);
          do
            ModalDialog(NIL, &j);
          while (j != 1);
          DisposDialog(myDialog);
        }
        TextFont(applFont); //sonst erfolgt Update mit Chicago
        TextSize(9);
      }
      else if (item == kDemoFont + numItems)
      {
        GetDItem(CPDialog,kDemoFont+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
        choice = GetCtlValue(myControlHandle);
        if(choice != (**myHandle).font)
        {
          (**myHandle).font = choice;
          drawDemoArea(CPDialog,numItems,myHandle);
        }
      }
      HUnlock((Handle)myHandle);
      break;
    case activDev:
      HLock((Handle)myHandle);
      GetDItem(CPDialog,kOn+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
      HiliteControl(myControlHandle,0);
      GetDItem(CPDialog,kOff+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      HiliteControl(myControlHandle,0);
      GetDItem(CPDialog,kShowInfo+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      HiliteControl(myControlHandle,0);
      GetDItem(CPDialog,kDemoFont+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      HiliteControl(myControlHandle,0);
      GetDItem(CPDialog,kDemoFont+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      MoveTo(itemRect.left+96,itemRect.top+13);
      GetFontName((**myHandle).font,tempStr);
      TextFont(systemFont);
      TextSize(12);
      DrawString(tempStr);
      TextFont(applFont);
      TextSize(9);
      HUnlock((Handle)myHandle);
      break;
    case deactivDev:
      HLock((Handle)myHandle);
      GetDItem(CPDialog,kOn+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      HiliteControl(myControlHandle,255);
      GetDItem(CPDialog,kOff+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      HiliteControl(myControlHandle,255);
      GetDItem(CPDialog,kShowInfo+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      HiliteControl(myControlHandle,255);
      GetDItem(CPDialog,kDemoFont+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      HiliteControl(myControlHandle,255);
      HUnlock((Handle)myHandle);
      break;
    case updateDev:
      HLock((Handle)myHandle);
      GetDItem(CPDialog,kDemoFont+numItems,
                      &itemType,(Handle*)&myControlHandle,&itemRect);
      MoveTo(itemRect.left+96,itemRect.top+13);
      GetFontName((**myHandle).font,tempStr);
      TextFont(systemFont);
      TextSize(12);
      DrawString(tempStr);
      TextFont(applFont);
      TextSize(9);
      drawDemoArea(CPDialog,numItems,myHandle);
      HUnlock((Handle)myHandle);
      break;
    case closeDev:
      HLock((Handle)myHandle);
      if( NIL == (resHandle = GetResource('DATA', rData)) )
        return cdevResErr;
      (**(resourceStruct**)resHandle).isOn=((**myHandle).isOn)?255:0;
      (**(resourceStruct**)resHandle).radioButtonState =
                                       (**myHandle).radioButtonState;
      for(i=0;i<17;i++)
        (**(resourceStruct**)resHandle).gammaCurve[i] =
                                          (**myHandle).gammaCurve[i];
      ChangedResource(resHandle);
      if(ResError() == noErr)
        WriteResource(resHandle);
      ReleaseResource(resHandle);
    
      DeleteMenu(mDemoFont);
      ReleaseResource((Handle)(**myHandle).demoFontMenu);
      DisposeGWorld((**myHandle).gWorld1);
      DisposeGWorld((**myHandle).gWorld2);
      DisposePtr((Ptr)(**myHandle).smoothedBits);
      DisposePtr((Ptr)(**myHandle).numberOfSetBits);
      DisposeHandle((Handle)myHandle);
      myHandle = NIL;
      break;
  }
  return (long) myHandle;
}

void drawDemoArea(DialogPtr CPDialog, int numItems,
                                                 CPStruct **myHandle)
{
  short i, j, fNum;
  unsigned int myRowBytes;
  int x, y, zoom;
  char k;
  Str255 tempStr;
  GrafPort oldPort;
  GrafPtr  oldPtr;
  short itemType;
  Rect itemRect;
  FontInfo fi;
  ControlHandle myControlHandle;
  RgnHandle oldClipRgn;
  RGBColor myColor;
  unsigned char *bitmapStart, *cellStart;
  GWorldPtr oldWorld,myWorld;
  GDHandle oldGDHandle;
  PixMapHandle myPixMap, oldPixMap;
  
  GetItem((**myHandle).demoFontMenu,(**myHandle).font,tempStr);
  GetFNum(tempStr, &fNum);
  
  tempStr[0]=30;
  for(i=0; i<15; i++)
  {
    tempStr[i+1]='A'+i; //Keine Aggregatzuweisung!
    tempStr[i+16]='a'+i;
  }
  
  GetDItem(CPDialog,kDemoArea+numItems,&itemType,
                                (Handle*)&myControlHandle,&itemRect);
  GetPort(&oldPtr);
  oldPort = *oldPtr; //Struktur kopieren!
  oldClipRgn=NewRgn();
  GetClip(oldClipRgn);
  SetPort(CPDialog);
  EraseRect(&itemRect);
  FrameRect(&itemRect);
  itemRect.left++;
  itemRect.right--;
  itemRect.top++;
  itemRect.bottom--;
  ClipRect(&itemRect);

  myWorld = (**myHandle).isOn ?
                         (**myHandle).gWorld1 : (**myHandle).gWorld2;
  zoom = (**myHandle).isOn ? 4 : 1;
  
  GetGWorld((CGrafPtr*) &oldWorld,&oldGDHandle);
  oldPixMap = GetGWorldPixMap(oldWorld);
  
  LockPixels(myWorld->portPixMap);
  SetGWorld(myWorld,NIL);
  EraseRect(&(myWorld->portRect));
  
  TextFont(fNum);
  TextSize(zoom*3);
  GetFontInfo(&fi);
  j=fi.ascent;
  for(i=5*zoom; (i<=50*zoom) &&
                (j < zoom*(itemRect.bottom-itemRect.top)); i+=2*zoom)
  {
    MoveTo(0,j);
    DrawString(tempStr);
    TextSize(i);
    GetFontInfo(&fi);
    j+=fi.ascent+fi.descent+zoom;
  }
  
  myPixMap = GetGWorldPixMap(myWorld);
  
  myRowBytes = (0x3FFF) & (**myPixMap).rowBytes;
  bitmapStart = (unsigned char*) GetPixBaseAddr(myPixMap);

  for(x=0;x<=itemRect.right-itemRect.left;x++)
  {
    for(y=0; y<=itemRect.bottom-itemRect.top; y++)
    {
      if((**myHandle).isOn)
      {
        cellStart = bitmapStart + 4*y*myRowBytes + x/2;
        j = 16;
        for(i=0;i<4;i++)
        {
          j -= (**myHandle).numberOfSetBits[0xF &
              ( ((x&1) == 0) ?
               *(cellStart+i*myRowBytes)>>4:*(cellStart+i*myRowBytes)
              )
              ];
        } //j = 0 -> schwarz, = 16 -> wei
        (**myHandle).smoothedBits
                             [x+y*(itemRect.right-itemRect.left+1)] =
                                          (**myHandle).gammaCurve[j];
      }
      else
      {
        cellStart = bitmapStart + y*myRowBytes + x/8;
        (**myHandle).smoothedBits
                             [x+y*(itemRect.right-itemRect.left+1)] =
                      ((0 != 1 & (*cellStart >> (7-x&7))) ? 0: 0xFF);
      }
    }    
  }
  
  SetGWorld((CGrafPtr)oldWorld,oldGDHandle);
  UnlockPixels(myWorld->portPixMap);
  
  for(x=0;x<=itemRect.right-itemRect.left;x++)
    for(y=0; y<=itemRect.bottom-itemRect.top; y++)
      if((**myHandle).smoothedBits
                      [x+y*(itemRect.right-itemRect.left+1)] != 0xFF)
      {
        myColor.red = myColor.green = myColor.blue =
                          ((unsigned short) (**myHandle).smoothedBits
                          [x+y*(itemRect.right-itemRect.left+1)])<<8;
        SetCPixel(itemRect.left+x,itemRect.top+y,&myColor);
      }
  
  *oldPtr = oldPort;
  SetPort(oldPtr);
  SetClip(oldClipRgn);
  DisposeRgn(oldClipRgn);
}