;USEINT14.SYS
;Device-Treiber zur INT14-Benutzung

ver  equ '1.00' ;Version
etx  equ 3      ;ETX=Sendepuffer leer
dle  equ 16     ;DLE fr Escaping
eof  equ 26     ;EOF (wird escaped)

jms  equ <jmp short>
ofs  equ <offset>
wp   equ <word ptr>
by   equ <byte ptr>

;Offset-Werte im Device-Header
cmd     = 2     ;Kommandocode
status  = 3     ;Status
media   = 13    ;Media-Deskriptor
trans   = 14    ;Transfer-Adresse
count   = 18    ;Zeichen-/Blockzahl

code segment
assume cs:code,ds:code,es:code

;Character-Device-Header
        dw -1,-1,8800h
        dw strateg,entry
devnam  db 'INT14_C1'   ;Name

;Sprungtabelle fr Funktionen
dev dw init
    dw exit
    dw exit
    dw exit     ;IOCTL input
    dw input    ;Inp/wait
    dw inpnw    ;Inp/no wait
    dw inpnw    ;Status:EOF?
    dw flush    ;Flush
    dw write    ;Write
    dw write    ;Write+verify
    dw exit     ;Outp.Status=OK
    dw exit     ;Outp.Flush
    dw exit     ;IOCTL out
    dw open     ;Open
    dw close    ;Close

;Variablen (Even!)
ptrsav  dd ?    ;Fr ES+BX
com     dw 0    ;Int14-COM-Port
mstat   db -1   ;Modemstatus
opfl    db 0    ;Open/Close-Zhler
dlefl   db 0    ;Flag fr Tx-DLE
escfl   db -1   ;Flag fr Rx-Escaping
datf    db 3    ;Datenformat

;--- Gertetreiber-Routinen ---

;Strategy-Routine
strateg proc far
    mov wp cs:[ptrsav],bx
    mov wp cs:[ptrsav+2],es
    ret
strateg endp

;Entry-Punkt
entry:sti
    cld
    push si     ;Verwendete
    push ax     ;Register
    push cx     ;retten
    push dx
    push di
    push ds
    push es
    push bx
    lds bx,cs:[ptrsav]
    mov cx,ds:[bx].count
    mov al,ds:[bx].cmd
    cbw
    mov si,ofs dev
    add si,ax
    add si,ax   ;Zeiger auf
    cmp al,14   ;Routine
    ja cmderr
    les di,ds:[bx].trans
    push cs     ;DS=CS,CX=Count,
    pop ds      ;ES:BX=Transf.-Adr.
    jmp [si]
cmderr:mov ax,8103h ;CMD-Fehler
    jms err1

exitp proc far
exit:mov ah,1
err1:lds bx,cs:[ptrsav]
    mov [bx].status,ax
    pop bx
    pop es
    pop ds
    pop di
    pop dx
    pop cx
    pop ax
    pop si
    ret
exitp endp

;Open-Routine
open:cmp opfl,0
    jnz op1
    mov al,-1   ;Modemstatus
    mov mstat,al;usw.rcksetzen
    mov escfl,al
    inc opfl
op1:jmp exit

;Close-Routine
close:dec opfl
    jnz cl1     ;Nix mehr offen:
    call disc   ;Sicherheits-
cl1:jmp exit    ;halber auflegen

;Puffer lschen
flush:jmp exit

;Non-destructive read/no wait
inpnw:mov al,etx;Dummy!
    lds bx,[ptrsav]
    mov [bx].media,al
    jmp exit    ;Zchn=Media-Deskr.

;CX Zeichen empfangen
input:jcxz inp2 ;0 Zeichen?!
    mov ah,0    ;Bit0=more data
inp1:mov al,escfl
    cmp al,-1   ;Noch was brig?
    jne inp2    ;Ja (hinter DLE)
    test ah,1   ;Von INT14-Fkt.2:
    jnz inp7    ;Mehr Daten?
    cmp cx,1
    je inp8     ;Statusabfrage
    test cl,7   ;beim n*8ten Zch.
    jnz inp5    ;und beim letzten
inp8:mov ah,3
    mov dx,com
    int 14h
    test ah,1   ;RxD hat Vorrang
    jnz inp7    ;vor Modemstatus
    and al,0f0h
    cmp al,mstat;Modemstatus
    je inp5     ;gendert?
    mov mstat,al
    shr al,1
    shr al,1    ;Ja->Bits 0-3
    shr al,1
    shr al,1
    jms inp6    ;DLE+Status
inp5:mov al,etx
    test ah,1
    jz inp2     ;Nix da: ETX
inp7:mov ah,2
    int 14h     ;Zch.empfangen
    cmp al,etx  ;ETX,EOF,DLE
    je inp3     ;escapen
    cmp al,eof
    je inp3
    cmp al,dle
    jne inp4
inp3:add al,32
inp6:mov escfl,al
    mov al,dle
    jms inp4
inp2:mov escfl,-1
inp4:stosb      ;ES:DI=Transfer-
    loop inp1   ;Adresse
    jmp exit

;CX Zeichen senden
write:jcxz wr3  ;CX=Zeichenzahl
wr1:mov al,es:[di]
    inc di      ;ES:DI=DTA
    cmp dlefl,0 ;DLE vorher?
    jz wr4
    mov dlefl,0
    cmp al,31   ;Ja, Escaping?
    ja wr7
    jb wr5
    call disc   ;31=Auflegen
    jms wr2
wr5:cmp al,8    ;8-30=Datenformat
    jb wr8
    sub al,8
    mov datf,al
    jms wr2
wr8:call ini    ;Init.
    jms wr2
wr7:sub al,32   ;Escaping
    jms wr6
wr4:cmp al,dle  ;DLE?
    jne wr6
    mov dlefl,-1
    jms wr2
wr6:mov dx,com  ;Senden
    mov ah,1
    int 14h
wr2:loop wr1
wr3:jmp exit

;Port initialisieren
ini:push cx
    mov cl,5    ;Baudrate=
    shl al,cl   ;Bit 5...7
    or al,datf  ;+Datenformat
    mov ah,0
    mov dx,com
    int 14h
    mov cx,2000 ;Ini-Timeout
in1:mov ah,3    ;fr CTS->1
    int 14h
    test ah,1   ;RxD?
    jz in2
    mov ah,2    ;Ja, Puffer
    int 14h     ;leerlesen
    jms in3
in2:test al,16  ;Auf CTS=1
    jnz in4     ;warten
in3:loop in1
in4:mov bl,3
    mov ax,501h
    int 14h     ;DTR+RTS=1
    pop cx
    ret

;Auflegen
disc:mov dx,com
    mov ax,501h
    mov bl,0    ;DTR+RTS=0
    int 14h
    ret

endad equ this byte ;Resident bis hier

;--- Transienter Initialisierungs-Teil ---

;Initialisierung
init:push cs    ;ES=CS
    pop es
    lds bx,ptrsav
    lds si,[bx].count
ini2:lodsb      ;1. Space vor
    cmp al,' '  ;Parametern suchen
    jb ini3
    jne ini2
    call do     ;Optionen auswerten
    jnc ini3
    push cs     ;Error
    pop ds
    mov errbu,al
    mov si,ofs errtx
    jms ini4
ini3:push cs    ;DS=CS
    pop ds
    mov si,ofs hello
ini4:call prtstr
    lds bx,[ptrsav]
    mov [bx].trans,ofs endad
    mov [bx].trans+2,cs
    jmp exit

;String ab SI bis 0 anzeigen
prtstr:lodsb
    cmp al,0
    jz prtstr1
    mov bl,7
    mov ah,0eh
    int 10h
    jmp prtstr
prtstr1:ret

;Kommandozeile ab DS:[SI]
;bis CR decodieren
do: lodsb
    cmp al,'/'  ;"/" optional
    je do
    cmp al,' '  ;Spaces ignorieren
    je do
    jb do2      ;Fertig, ok
    call caps
    mov di,ofs optio
    mov cx,ofs optad-optio
    repne scasb ;ES=CS!
    jne do1
    sub di,ofs optio+1
    shl di,1
    push ax     ;Buchst.merken
    call cs:optad[di]
    pop ax
    jnc do
do1:stc
    ret
do2:clc
    ret

;Klein- zu Grobuchstabe
caps:cmp al,'a'
    jb caps1
    cmp al,'z'
    ja caps1
    sub al,32
caps1:ret

;Unterprogramme fr Optionen:
;DS:SI->Kommandozeile, ES=CS,
;liefern C=1 bei Error
opti:lodsb
    cmp al,'1'  ;In=COMn
    jb opti1
    cmp al,'9'
    ja opti1
    mov cs:devnam[7],al
    mov cs:comnr,al
    sub al,'1'
    xor ah,ah
    mov cs:com,ax
    ret
opti1:stc
    ret

optio db 'I'  ;Optionen
optad dw opti
hello db "USEINT14 ",ver,"  COM"
comnr db "1  (c) c't 1995",13,10,0
errtx db 'USEINT14.SYS: Fehlerhafter Parameter "'
errbu db '?"',13,10,0
code  ends
      end
