{ ISOMON - ISO-9660-Monitor fr CD-ROMs, TP 6.0, (bb) c't 4/95      }
Program ISOMon;

Uses DOS, Crt, Graph;

CONST
  ok = True ;  fehler = False ;
  esc = #27 ;  null = #0      ;
  fst_sekt     = 16           ;  { Start-Sektor, hier der des PVD   }
  stdid        = 'CD001'      ;  { Standard-ID fr VD               }
  xa_id        = 'CD-XA001'   ;  { Standard-ID XA-Erw. bei Dir-Rec  }
  hsfs         = 'CDROM'      ;  { High-Sierra-Id                   }
  boot_rec     = 0            ;  { Boot Record                      }
  prim_dtyp    = 1            ;  { Primary Volume Descriptor        }
  suppl_dtyp   = 2            ;  { Supplentary Volume Descriptor    }
  part_dtyp    = 3            ;  { Volume Partition Descriptor      }
  vd_term      = 255          ;  { Volume Descriptor Set Terminator }
  d_char = [ 'A'..'Z','0'..'9','_']; { in D+F-Namen laut Level 1 zugelassen }

TYPE
  ptr_sector = ^sector;  sector  = Array[1..2048] of Byte;   { Raw-Sektor }
  ptr_drec  = ^raw_rec;  raw_rec = Array[1..256] of Byte;    { Dir-Record  }
  isoidtyp  = Array[1..128] of Char;  isoidptr = ^isoidtyp;  { Char-Pointer}
  ptr_prim_vd = ^iso_p_descriptor;
  vd_datime = Record
    datime : Array[1..16] of Char;                    { Ziffern   }
    gmt    : ShortInt                     { numerisch: -48 bis +52}
  End;
  iso_p_descriptor = Record     { Struktur des Primary Volume Descriptor }
    VD_typ         : Byte                ; {   1      VD Type        }
    std_id         : Array[1..5] of Char ; {   2-6    Standard Id    }
    vd_vers        : Byte                ; {   7      VD Version     }
    unused1        : Byte                ; {   8                     }
    sys_id         : Array[1..32] of Char; {   9-40   System Id      }
    vol_id         : Array[1..32] of Char; {  41-72   Volume Id      }
    unused8        : Array[1..8]  of Byte; {  73-80                  }
    vol_spc_sizeL  : LongInt             ; {  81-88   Vol Spc Size LE}
    vol_spc_sizeM  : LongInt             ; {          Variante BE    }
    unused32       : Array[1..32] of Byte; {  89-120                 }
    vol_set_sizeL  : Word                ; { 121-124  Vol Set Size LE}
    vol_set_sizeM  : Word                ; {          Variante BE    }
    vol_seq_nrL    : Word                ; { 125-128  Vol Sequence Nr}
    vol_seq_nrM    : Word                ; {          Variante BE    }
    log_blc_sizeL  : Word                ; { 129-132  Log Blc Size LE}
    log_blc_sizeM  : Word                ; {          Variante BE    }
    pth_tb_sizeL   : LongInt             ; { 133-140  Path Tb Size LE}
    pth_tb_sizeM   : LongInt             ; {          Variante BE    }
    typ_L_path_tb  : LongInt             ; { 141-144  Type L Path Tb }
    opt_L_path_tb  : LongInt             ; { 145-148  Opt. L Path Tb }
    typ_M_path_tb  : LongInt             ; { 149-152  Type M Path Tb }
    opt_M_path_tb  : LongInt             ; { 153-156  Opt. M Path Tb }
    root_dir_rec   : Array[1..34] of Byte; { 157-190  Dir Record Root}
    vol_set_id,                            { 191-318  Volume Set Id  }
    publ_id,                               { 319-446  Publisher Id   }
    data_prep_id,                          { 447-574  Data Prepare Id}
    appl_id        : Array[1..128]of Char; { 575-702  Application Id }
    c_file_id      : Array[1..37] of Char; { 703-739  (C) File Id    }
    abstr_file_id  : Array[1..37] of Char; { 740-776  Abstrct File Id}
    bibl_file_id   : Array[1..37] of Char; { 777-813  Bibliog File Id}
    vol_creat_datime,                      { 814-830  Vol Creatn D/T }
    vol_mod_datime,                        { 831-847  Vol Modifi D/T }
    vol_expi_datime,                       { 848-864  Vol Expirat D/T}
    vol_eff_datime : vd_datime           ; { 865-881  Vol Effectv D/T}
    file_struct_ver: Byte                ; { 882      File Struct Ver}
    reserved1      : Byte                ; { 883      Reserved       }
    app_use        : Array[1..141] of Byte;{ 884-1024 Application Use}
    {----------                            -------- XA-Erweiterung:  }
    xa_sign        : Array[1..8] of Char ; {1025-1032  1-8  Id Signat}
    xa_flags       : Word                ; {1033-1034  9-10 XA Flags }
    startup_dir    : Array[1..8] of Char ; {1035-1042 11-18 Strtp Dir}
    reserved8      : Array[1..8] of Byte ; {1043-1050 19-26 Reserved }
    {----------                           ---------------------------}
    reserved1000   : Array[1051..2048] of Byte;
  End;{isopdescriptor}               { LE = Little,  BE = Big Endian }

  boot_record = Record
    vd_typ         : Byte                ; {   1      Volume Descriptor Type }
    std_id         : Array[1..5] of Char ; {   2-6    CD001                  }
    vd_vers        : Byte                ; {   7      Volume Descriptor Version}
    sys_id         : Array[1..32] of Char; {   8-39   Boot System Identifier}
    boot_id        : Array[1..32] of Char; {  40-71   Boot Identifier}
    sys_use        : Array[1..1977]of Byte;{  72-2048 not specified, for System use}
  End;{bootrecord}

  vol_partition_descriptor = Record
    vd_typ         : Byte                ; {   1      Volume Descriptor Type}
    std_id         : Array[1..5] of Char ; {   2-6    CD001                 }
    vd_vers        : Byte                ; {   7      Volume Descriptor Version}
    dummy          : Byte                ; {   8      unused                }
    sys_id         : Array[1..32] of Char; {   9-40   System Identifier     }
    part_id        : Array[1..32] of Char; {  41-72   Volume Partition Identifier}
    part_locL      : LongInt             ; {  73-80   Volume Partition Location}
    part_locM      : LongInt             ; {          BE-Variante           }
    sizeL          : LongInt             ; {  81-88   Volume Partition Size }
    sizeM          : LongInt             ; {          Variante fr BE       }
    reserved       : Array[1..1960]of Byte;{  89-2048 not specified         }
  End;{volpartdescrpt}

  ptr_dir_rec = ^directory_record;
  dr_datime = Record
    datime : Array[1..6] of Byte;                       { numerisch   }
    gmt    : ShortInt                         { numerisch: -48 bis +52}
  End;
  directory_record = Record                {-Struktur eines Directory-Record-}
    len_dr         : Byte                ; {   1      Len of Dir Record      }
    len_ar         : Byte                ; {   2      Extended Attr Rec Len  }
    loc_extentL    : LongInt             ; {   3-10   Location of Extent LE  }
    loc_extentM    : LongInt             ; {          Variante BE            }
    len_dataL      : LongInt             ; {  11-18   Data Length LE         }
    len_dataM      : LongInt             ; {          Variante BE            }
    rec_datime     : dr_datime           ; {  19-25   Recording Date and Time}
    file_flags     : Byte                ; {  26      File Flags (8 Bits)    }
    unit_size      : Byte                ; {  27      File Unit Size         }
    interl_gap_size: Byte                ; {  28      Interleave Gap Size    }
    vol_sequ_numL  : Integer             ; {  29-32   Volume Sequence Num LE }
    vol_sequ_numM  : Integer             ; {          Variane BE             }
    len_fi         : Byte                ; {  33      Length of File Id      }
    file_name      : Array[1..223] of Char;{  34-...  File Identifier        }
    { ... weitere Felder dynamisch, von len_fi abhngig ...                  }
  End;{directoryRecord}

  ptr_xa_dir = ^xa_dir_extens;
  xa_dir_extens = Record            {-Struktur der XA-Erweiterung im Dir Rec-}
    ow_id          : Integer             ; {???   1-2    Owner Identifier       }
    grp_id         : Integer             ; {???   3-4    Group Identifier       }
    attr           : Word                ; {   5-6    Attributes Bits        }
    sign           : Array[1..2] of Char ; {   7-8    Signature Bytes 'XA'   }
    file_num       : Byte                ; {   9      File Number            }
    reserved       : Array[1..5] of Byte ; {  10-14   Reserved               }
  End;{xa-Extension}

  ptr_pt_rec = ^path_table_record;
  path_table_record = Record
    len_di         : Byte                ; {   1      Len of Directory Id     }
    len_ar         : Byte                ; {   2      Len of Ext Attribut Rec }
    loc_ext        : LongInt             ; {   3-6    Location of Extent      }
    parent_dir_num : Integer             ; {   7-8    Parent Directory Number }
    dir_name       : Array[1..32] of Char; {   9-...  Directory Identifier    }
  End;{pathtable}

VAR cd_lw : Char;               { CD-ROM-Laufwerks-Buchstabe       }

{==================== Prozeduren/Funktionen ========================}

{-------------------- Hilfs-Funktionen --------------------}
PROCEDURE wait;
VAR k : char;
Begin
  GotoXY(1,25); Write('>>>Taste');
  k := ReadKey;
  GotoXY(1,25); ClrEol;
END;
PROCEDURE beep;
Begin
  Sound(220);        { Beep }
  Delay(400);        { For 400 ms }
  NoSound;           { Relief! }
END;

{                wandelt die Char-Arrays der ISO-Records in Strings }
FUNCTION pstr( pvd : isoidptr; strlen : Byte ) : String;
VAR sammel : String; i : Integer;
Begin
  sammel[0] := Char( strlen);
  i := 1;
  While (pvd^[i]<>null) and (i <= strlen) DO Begin
    sammel[i] := pvd^[i] ;            { pvd = Zeiger auf Char       }
    Inc(i);
  End;{While}                         { Id's sind mit ' ' aufgefllt}
  IF i < strlen Then sammel[0] := Char(i-1);
  i := length(sammel);
  While sammel[i] = ' ' Do Begin
    Dec(i);
    sammel[0] := Chr(i);
  End;
  pstr := sammel;
END;{pstr}

FUNCTION btst(by, bi : Byte) : Boolean;
Begin
  IF Odd( by Shr bi) Then btst := True
                     Else btst := False;
End;
FUNCTION bin(wert : LongInt; bits : Byte ) : String;
VAR i : Integer; c : String[32];
Begin
  c := '';
  For i := 1 to bits DO Begin
    IF odd(wert) Then c := '1' + c
                 Else c := '0' + c;
    wert := wert shr 1;
  End;{For}
  bin := c;
END;

{--------------------- Haupt-Funktionen/Prozeduren -----------------}

{  Absolute Disc Read - ruft die MSCDEX-Funktion ber Interrupt auf }
FUNCTION lies_sekt(beginn : LongInt; s_anzahl : Integer ;
                            VAR puffer : sector) : Boolean;
VAR  regs : Registers;
Begin
  regs.ax := $1508;                  { MSCDEX-Command Absolute Disc Read}
  regs.CX := Ord(cd_lw)-65;          { Drive-Number                     }
  regs.SI := beginn Shr 16;          { Erster Sektor Hi-Word            }
  regs.DI := beginn Mod 65536;       { Erster Sektor Lo-Word            }
  regs.DX := s_anzahl;               { Anzahl zu lesender Sektoren      }
  regs.ES := Seg(puffer);            { Adresse Sektorpuffer/Struktur Hi }
  regs.BX := Ofs(puffer);            { Adresse Sektorpuffer/Struktur Lo }
  Intr($2F, regs);                   { Call MSCDEX                      }
  IF Odd(regs.Flags)=true Then Begin { wenn ungerade (Carry-Flg) Lesef. }
      lies_sekt := fehler;
    Writeln(' ! Fehler beim lesen von Sektor ', beginn, ' ! ');
    wait;
  End
  Else
    lies_sekt := ok;
END;


FUNCTION cd_iso_test(VAR prim_vd : ptr_prim_vd) : Boolean ;
Begin
  cd_iso_test := False;
  IF lies_sekt(fst_sekt, 1, sector(prim_vd^)) = ok Then Begin
    IF pstr(@prim_vd^.std_id, 5) = stdid Then Begin
      Write('CD "', pstr(@prim_vd^.vol_id,32),'" ist eine ISO-9660-CD-ROM ');
      IF prim_vd^.xa_sign = xa_id Then Write('XA');
      Writeln;
      Write('ISO-9660-Version: ', pstr(@prim_vd^.std_id,5));
      IF prim_vd^.xa_sign = xa_id Then
        Write(', XA-Version: ', pstr(@prim_vd^.xa_sign,8) );
      Writeln;
      (* (' ??? ... Mode x ... !!! ');  *)
      cd_iso_test := True;
    End{If stid}
    Else IF copy(pstr( @prim_vd^.sys_id, 6),2,5) = hsfs Then Begin
           Writeln('CD ist High-Sierra-Format');
           (* cd_iso_test := True // bei Erweiterung mit HS-Format-Strukturen *)
         End
         Else
           Writeln('kein Volume-Descriptor in Sektor 16');
  End;{IFok}
 (* wait; *)
END;{cd-iso-test}

PROCEDURE descrpt_list(anseh, sys : Boolean);
VAR num  : LongInt;
    ende : Byte;
    sekt : sector;    
Begin  
  ClrScr;
  num := fst_sekt;  ende := 0;
  Repeat
    Write('Sektor ', num,' = ');
    IF lies_sekt(num, 1, sekt) = ok Then Begin
      IF pstr( @sekt[2], 5) = stdid Then
        Case sekt[1] Of
          boot_rec   : Begin
                         TextBackground(Blue); beep;
                         Writeln('Boot Record');
                         TextBackground(Black);
                       End;
          prim_dtyp  : Writeln('Primary Volume Descriptor');
          suppl_dtyp : Begin
                         TextBackground(Blue);
                         Writeln('Suplementary Volume Descriptor');
                         TextBackground(Black);
                       End;
          part_dtyp  : Begin
                         TextBackground(Blue);
                         Writeln('Volume Partition Descriptor');
                         TextBackground(Black);
                       End;
          vd_term    : Begin
                         Writeln('Volume Descriptor Set Terminator');
                         ende := 1;
                       End;
        Else{Case}
          Writeln('!!! unbekannter Descriptor-Typ ???')
        End {Case}
      Else{not stdid}
        IF pstr( @sekt[9], 5) = hsfs Then
          Writeln('ein High-Sierra-Descriptor')
        Else Begin
          If ende = 0 Then
            Writeln('kein ISO 9660-Descriptor');
          ende := 2;
        End;{IfpstrElse // EndIF stdid}
      Inc(num);
    End;{IFok}
  Until ende > 1;
END;{descrpt_list}


PROCEDURE view_prim(pvd : ptr_prim_vd );

  FUNCTION prt_datime(datime : vd_datime) : String;
  VAR  back  : String;
  Begin
    back := '';
    IF Length(datime.datime) > 0 Then Begin
      With datime Do Begin
        back[0]:=Chr(6);
        back[1]:=datime[7]; back[2]:=datime[8]; back[3]:='.';        { Tag   }
        back[4]:=datime[5]; back[5]:=datime[6]; back[6]:='.';        { Monat }
        back := back + Copy(datime, 1, 4) + ',  ';                   { Jahr  }
        back[14]:=datime[9];  back[15]:=datime[10]; back[16]:=':';   { Stunde}
        back[17]:=datime[11]; back[18]:=datime[12]; back[19]:=':';   { Minute}
        back[20]:=datime[13]; back[21]:=datime[14]; back[22]:='.';   { Sekunde }
        back[23]:=datime[15]; back[24]:=datime[16];                  { Hundstl }
        back[0]:=Chr(24); back := back + ' - '
      End;{With}
    End;{IfLengt}
    prt_datime := back;
  END;{prtdatime}

Begin{view-prim}
  ClrScr;
  With pvd^ Do Begin
    Writeln('Standard ID        : ', std_id );
    Writeln('Vol Descriptor Vers: ', vd_vers );
    Writeln('System ID          : ', pstr(@sys_id,32) );
    Writeln('Volume ID          : ', pstr(@vol_id,32) );
    Writeln('Volume Space Size  : ', vol_spc_sizeL, '  blocks');
    Writeln('Volume Set Size    : ', vol_set_sizeL );
    Writeln('Volume Seq Number  : ', vol_seq_nrL );
    Writeln('Logical Block Size : ', log_blc_sizeL );
    Writeln('Path Table Size    : ', pth_tb_sizeL );
    Writeln('Type L Path Table  : ', typ_l_path_tb );
    Writeln('Opt. L Path Table  : ', opt_L_path_tb );
  { Writeln('Type M Path Table  : ', wandle(typ_M_path_tb) );
    Writeln('Opt. M Path Table  : ', wandle(opt_L_path_tb) ); }
    IF xa_sign = 'CD-XA001' Then Begin
      Writeln('-------------XA-ID : ', xa_sign );
      Writeln('XA-Flags           : ', bin(xa_flags,16) );
      Writeln('Startup Directory  : ', pstr(@startup_dir, 8) );
      Writeln('------------------');
    End;{IFxa}
    Writeln('Volume Set ID      : ', pstr(@vol_set_id, 128) );
    Writeln('Publisher ID       : ', pstr(@publ_id, 128) );
    Writeln('Data Preparer ID   : ', pstr(@data_prep_id, 128) );
    Writeln('Applikation ID     : ', pstr(@appl_id, 128) );
    Writeln('Copyrght File ID   : ', pstr(@c_file_id, 37) );
    Writeln('Abstract File ID   : ', pstr(@abstr_file_id, 37) );
    Writeln('Bibliogr File ID   : ', pstr(@bibl_file_id, 37) );
    Write(  'Vol Creat Datime   : ', prt_datime(vol_creat_datime) );
    Writeln(' GMT ',vol_creat_datime.gmt Div 4 );
    Write(  'Vol Mod Datime     : ', prt_datime(vol_mod_datime) );
    Writeln(' GMT ',vol_mod_datime.gmt Div 4 );
    Write(  'Vol Expirat''n DT   : ', prt_datime(vol_expi_datime) );
    Writeln(' GMT ',vol_expi_datime.gmt Div 4 );
    Write(  'Vol Effective DT   : ', prt_datime(vol_eff_datime) );
    Writeln(' GMT ',vol_eff_datime.gmt Div 4 );
  End;{With}
  wait;
END;{viewprim}


FUNCTION nxt_record( VAR len_ext : Integer; VAR rec_start, sekt_nr : LongInt;
                     VAR sekt : ptr_sector; rec : ptr_drec;
                     len_rec, sektlen : Integer )     : Boolean;
VAR len_rec_tl : Integer;
Begin
  nxt_record := True;
  len_rec_tl := len_rec;
  IF sekt^[rec_start] = 0 Then                     { kein Record mehr in Sektor}
    IF (rec_start = sektlen) Or (len_ext <=1) Then    { dann Ende }
      nxt_record := False
    Else Begin {moreRecords}
      Inc(sekt_nr); Dec(len_ext);
      IF lies_sekt( sekt_nr, 1, sekt^ ) = Not ok Then nxt_record := fehler;
      Move( sekt^[1], rec^, SizeOf(rec^) );
      rec_start := 0;
    End{IFElse}
  Else Begin {nchster Record}
    IF (rec_start + len_rec) > sektlen Then len_rec_tl := (sektlen+1)-rec_start;
    Move( sekt^[rec_start], rec^, len_rec_tl);      { normaler Move des Records }
    rec_start := rec_start + len_rec;
    IF len_rec_tl < len_rec Then Begin             { wenn nur ein Teil  }
      Inc(sekt_nr);  Dec(len_ext);
      IF lies_sekt(sekt_nr, 1, sekt^) = ok Then Begin
        len_rec_tl := len_rec-len_rec_tl;            { der Rest }
        Move( sekt^[1], rec^[len_rec_tl+1], len_rec_tl);
        rec_start := len_rec_tl+1;             { hier gehts nachher weiter }
      End{IFok}
      Else Begin
        rec_start := 2048;                     { Lesefehler -> Stop bzw nchster }
        len_ext := 0;
      End;{IFokElse}
    End;{IFlenrec}
  End;{IF0Else}
END;{nxtrecord}

PROCEDURE view_dir(sekt_num : LongInt );
VAR testkey      : Char;
    reclen, len_extent    : Integer;
    next_rec, su_adr  : LongInt;
    sektor       : ptr_sector;
    drecord             : ptr_dir_rec;
    xarecord            : ptr_xa_dir;

  PROCEDURE view_xa(xarec : ptr_xa_dir);
  Begin
    With xarec^ Do Begin
      Writeln('----------------- XA-Erweiterung:');
      Writeln('Owner Id        : ', ow_id   );
      Writeln('Group Id        : ', grp_id  );
      Writeln('16 Attribut-Bits: ', bin(attr, 16) );
      Writeln('File Number     : ', file_num);
    End;{With}
  END;

Begin{view-dir}
  next_rec := 1;  su_adr := 0; len_extent := 1 {proforma};
  New(drecord);  New(xarecord);  New(sektor);
  testkey:=' ';
    IF lies_sekt(sekt_num, 1, sektor^) = ok Then Begin   { den ersten lesen }
      reclen := sektor^[1];
      While nxt_record( len_extent, next_rec, sekt_num, sektor, @drecord^, reclen, 2048 ) Do Begin
        ClrScr;
        With drecord^ DO Begin
          IF next_rec = 0 Then next_rec := len_dr+1;
          IF file_name[1] = null Then
            len_extent := (len_dataL+2047) DIV 2048;      { Anzahl Sektoren }
          Writeln('Length Dir Rec  : ', len_dr );
          Writeln('Len Ext Attr Rec: ', len_ar );
          Writeln('Loc of Extend   : ', loc_extentL);
          Writeln('Data length     : ', len_dataL);
          Writeln('Recording Datime: nicht impl.') ;
          Writeln('File Flags 8 Bit: ', bin(file_flags, 8) );
          Writeln('File Unit Size  : ', unit_size );
          Writeln('Interlv Gap Size: ', interl_gap_size );
          Writeln('Volume Sequ Num : ', vol_sequ_numL );
          Writeln('Length File-ID  : ', len_fi );
          IF btst(file_flags ,1)=True Then
            Write('Directory ID    : ')
          Else
            Write('File ID         : ');
          IF Byte(file_name[1]) = 0 Then
            Writeln('=  Nullbyte = Root' )
          Else IF Byte(file_name[1]) = 1 Then
                 Writeln('=  1-Byte = Parent/Root' )
               Else
                 Writeln( pstr(@file_name, len_fi) );
          IF (file_flags <> 0) And (file_flags <> 2) Then Begin (*////!!!!!*)
            beep; Writeln('!!! siehe Flags' ); End;             (*////!!!!*)
          IF len_ar > 0 Then Begin                              (*////!!!!!*)
            beep; Writeln('!!! siehe Attribute' ); End;         (*////!!!!*)
          IF len_dr > ((33+len_fi+1) AND $FE) Then Begin  { System Use Area }
            su_adr := (next_rec-len_dr) + 33 + len_fi;
            IF Odd(len_fi)=False Then Inc(su_adr);      { +1 Padding-Byte }
            Move( sektor^[su_adr], xarecord^, 14);
            IF xarecord^.sign = 'XA' Then
              view_xa(xarecord)
            Else
              Write(''); { anderes System, z.B. RRIP }
            su_adr := 0;
          End;{IFsu}
          IF testkey <> esc Then
            testkey := Readkey;
          reclen := sektor^[next_rec];
        End;{With}
      End;{While}
    End;{Ifok}
  Dispose(drecord);  Dispose(xarecord);  Dispose(sektor);
END;{viewdir}

PROCEDURE browse_dir(pvd : ptr_prim_vd);
VAR root_sekt : LongInt;
    root      : ptr_dir_rec;
Begin
  ClrScr;
  New(root);
  Move (pvd^.root_dir_rec, root^, 34);
  root_sekt := root^.loc_extentL;       { Log. Blocknummer des Dir-Extent }
  view_dir( root_sekt );
  Dispose(root);
END;{browsedir}

PROCEDURE testname(name : String; dtyp : Boolean; VAR iso : Boolean);
VAR testkey : char;  fehler : Boolean;
    zlr, list, i : Byte;
Begin
  list := 0;
  IF dtyp = True Then Begin
    IF (Pos( '.', name )>0) Or (Pos( ';', name)>0) Then list := 1
    Else IF Length(name) > 8 Then list := 2
  End
  Else{ftyp} Begin
    i := Pos(';', name);
    IF i > 0 Then name[0] := chr(i-1);
    i := Pos('.', name); IF i=0 Then i := Length(name);
    IF (i > 9) Or (Length(name)-i > 3) Then list := 2+4
  End;{Ifdtyp}
  For i := 1 to Byte(name[0]) Do Begin
    IF (name[i]<>'.') And Not (name[i] In d_char) Then list := list Or 8;
  End;{For}
  IF list>0 Then Begin
    write(name);
    Case list Of
      1     : Writeln(' - Separator in Dir-Name nicht erlaubt');
      2,4,6 : Writeln(' - ISO-9660-konform, aber nur Level 3');
      8     : Writeln(' - unerlaubte Zeichen ');
      9     : Writeln(' - Separator(en) und Zeichen nicht erlaubt ');
     14     : Writeln(' - ISO/ Level 3, aber unerlaubte Zeichen');
    End;{Case}
(*  testkey := Readkey;  *)
  iso := False;
  End;{IFlist}
END;{testname}

PROCEDURE test_iso_names(pvd : ptr_prim_vd);
CONST dir = True; datei = False;
VAR iso9660                   : Boolean;
    testkey                   : Char;
    len_di, len_dr            : Byte;
    ptsekt_num, next_ptrec    : LongInt;
    dsekt_num, next_drec      : LongInt;
    ptlen_ext, ptreclen, zlr  : Integer;
    dlen_ext, dreclen         : Integer;
    ptsektor, dsektor         : ptr_sector;
    ptrecord   : ptr_pt_rec;
    drecord    : ptr_dir_rec;
    hilfrec    : ptr_drec;
Begin
  zlr := 0;  testkey:=' ';  iso9660 := True;
  next_ptrec := 1; ptlen_ext := 1; dlen_ext := 1;
  New(ptsektor);  New(dsektor);  New(ptrecord);  New(drecord);
  ptsekt_num := pvd^.typ_L_path_tb;
  ptlen_ext := (pvd^.pth_tb_sizeL+2047) DIV 2048;
  IF lies_sekt(ptsekt_num, 1, ptsektor^) = ok Then Begin
    ptreclen := (8+ptsektor^[1]+1) And $FE;
    While nxt_record( ptlen_ext, next_ptrec, ptsekt_num, ptsektor, @ptrecord^, ptreclen, 2048) Do Begin
      IF next_ptrec = 0 Then next_ptrec := (9+ptrecord^.len_di) And $FE;
      IF ptrecord^.dir_name[1] <> null Then
        testname(pstr(@ptrecord^.dir_name, ptrecord^.len_di), dir, iso9660 ); { nur Dir-Namen }
        Inc(zlr);
      dsekt_num := ptrecord^.loc_ext;
      IF lies_sekt( dsekt_num, 1, dsektor^) = ok Then Begin
        next_drec := 1;
        dreclen := dsektor^[1];
        While nxt_record( dlen_ext, next_drec, dsekt_num, dsektor, @drecord^, dreclen, 2048) Do Begin
          IF next_drec = 0 Then next_drec := drecord^.len_dr+1;
          IF drecord^.file_name[1] = null Then
            dlen_ext := (drecord^.len_dataL+2047) Div 2048
          Else IF btst(drecord^.file_flags, 1) = False Then { nur Filenamen }
            testname(pstr(@drecord^.file_name, drecord^.len_fi), Datei, iso9660 );
          dreclen := dsektor^[next_drec];
        End;{WhileD}
      End;{IFokD}
      ptreclen := (9+ptsektor^[next_ptrec]) And $FE;
    End;{WhilePT}
    IF iso9660 Then Writeln('CD ist bezglich der Dir-/Filenamen ISO9660-konform');  wait;
  End;{IFokPT}
  Dispose(drecord); Dispose(ptrecord); Dispose(dsektor); Dispose(ptsektor);
END;{testisonames}


PROCEDURE brause_path_tb(pvd : ptr_prim_vd );
VAR testkey                    : Char;
    len_di                     : Byte;
    sekt_num, next_rec: LongInt;
    len_extent, zlr, reclen    : Integer;
    sektor     : ptr_sector;
    ptrecord   : ptr_pt_rec;
    hilfrec    : ptr_drec;
Begin
  next_rec := 1;  len_extent := 1;  zlr := 0;  testkey:=' ';
  New(sektor);  New(ptrecord);
  sekt_num := pvd^.typ_L_path_tb;
  len_extent := (pvd^.pth_tb_sizeL+2047) DIV 2048;
  (* hier evtl. einbauen die ganze Path Table dauerhaft einlesen... *)
  IF lies_sekt(sekt_num, 1, sektor^) = ok Then Begin
    reclen := (8+sektor^[1]+1) And $FE;
    While nxt_record( len_extent, next_rec, sekt_num, sektor, @ptrecord^, reclen, 2048) Do Begin
      Inc( zlr );
      ClrScr;
      With ptrecord^ Do Begin
        Writeln('---------  Path Table ---------');
        Writeln('Record-Nummer : ', zlr );
        Writeln('Len Dir Id    : ', len_di,'  Record gesamt: ', (9+len_di) And $FE );
        Writeln('Ext Attr Len  : ', len_ar );
        Writeln('Loc of Extent : ', loc_ext );
        Writeln('Parent DirNr  : ', parent_dir_num );
        Write(  'Dir Identif.  : ');
        IF dir_name[1] = null Then
          Writeln('Null = Root-Directory')
        Else
          Writeln( pstr(@dir_name, len_di) );
        GotoXY(1,25);
        Write('"V" to view this Directory, any key to next ');
        IF testkey <> esc Then testkey := Readkey;
        IF testkey In ['v','V'] Then
          view_dir(loc_ext);                 { Dir-Records anzeigen }
        reclen := (9+sektor^[next_rec]) And $FE;
      End;{With}
    End;{While}
  End;{IFok}
  Dispose(sektor);  Dispose(ptrecord);
END;{brausepathTb}


      { ------------- Main -------------------- }
VAR
  wahl : char; hilf : String;
  prim_vd : ptr_prim_vd;                   { Global vorrtiger PVD }
  sektnr, sekt2nr  : LongInt;              { kann z.Zt. bis 325000 werden}

Begin
  IF ParamCount < 1 Then Begin
    Writeln('Aufrufparameter: <CD-ROM-Drive>');
    Halt
  End
  Else Begin
    hilf := ParamStr(1);
    cd_lw := UpCase( hilf[1] );
  End;{IFParamElse}
  New(prim_vd);
  TextMode(CO80);
  IF cd_iso_test(prim_vd) = ok Then Begin
    Repeat
      window(15,9, 65,20);
      TextBackground(Blue); ClrScr;
      Writeln(' ********** ISOMON 1.0, c''t 4/95 - (bb) **********');
      Writeln('  I       - ISO-9660-Integritt testen');
      Writeln('  L       - Liste der Descriptoren');
      Writeln('  P       - Primary Descriptor ansehen');
(*      Writeln('  A       - Andere Descriptoren ansehen ???'); *)
      Writeln('  B       - Browse Path Table');
      Writeln('  R       - Root Dir ');
      Writeln('  N       - Neue CD-ROM einloggen');
(*      Writeln('  V       - Vergleich auf doppelte Descriptoren');  *)
      Writeln('  E,Q,Esc - Ende');
      Writeln('---------------------------------------------');
      Write  ('          - Auswahl'); GotoXY(3, WhereY);
      wahl := Readkey ;
(*      Read( wahl );        !alternativ *)
      Window(1,1, 80,25);
      TextBackground(Black); ClrScr;
      Case wahl Of
        'I','i' :              { ISO-9660-Integritt testen }
                  test_iso_names(prim_vd);
        'L','l' : Begin        { Liste von Descriptoren anzeigen bisTerminator}
                    descrpt_list(FALSE,FALSE);
                    wait;
                  End;
        'P','p' :              { Primary Descriptor anzeigen }
                  view_prim(prim_vd);
        'A','a' :              { Andere Descriptoren anzeigen }
                  Writeln('nicht implementiert');
        'B','b' : Begin        { Browse - Die Path Table-Records anzeigen }
                    IF prim_vd^.typ_L_path_tb > 16 Then Begin
                      brause_path_tb(prim_vd)
                    End;
                  End;
        'R','r' : browse_dir(prim_vd); { Directory-Records anzeigen, ber Root-Dir in PVD }
        'N','n' : IF cd_iso_test(prim_vd) = Not ok Then wahl := 'Q';
        'Q','q','E','e',esc :  wahl := 'Q';
      End;{Case}
    Until wahl = 'Q' ;
  End;{IFiso-ok}
  Dispose(prim_vd);
End.

