(* Basis-Unit fr Bildschirmschoner - c't '94 - Ingo T. Storm*)
(* groe Teile: Robert J. Warren, Borland Pascal 7.0 *)
Unit uSaver;
interface
uses  WinProcs, WinTypes, oWindows, oDialogs, Win31;

const (* Nachricht an das Hauptfenster, wenn Zeit zum Malen ist *)
  WM_Animate = WM_User;

type  PScrnSaverApp = ^TScrnSaverApp;
      TScrnSaverApp = object(TApplication)
        Configure: Boolean;
        procedure InitMainWindow; virtual;
        function IdleAction:boolean; virtual;
      end;

      PScrnSaverWin = ^TScrnSaverWin;
      TScrnSaverWin = Object(TWindow)
        FirstMouseMove:Boolean;
        prevPt:TPoint;
        trWinRect : TRect;
        constructor Init(aParent:PWindowsObject; aTitle:PChar);
        destructor  Done; virtual;
        function  GetClassName: PChar; virtual;
        procedure SetupWindow; virtual;
        procedure DefWndProc(var Msg: TMessage); virtual;
        procedure WMSyscommand(var Msg: TMessage);
                  virtual WM_First + WM_SysCommand;
        procedure WMAnimate(var Msg: TMessage);
                  virtual WM_First + WM_Animate;
        procedure ClearRect(DC : hDC; tr : Trect);
        procedure ClearScreen; virtual;
      end;

implementation

procedure TScrnSaverApp.InitMainWindow;
begin MainWindow:=new(PScrnSaverWin,Init(nil,name)); end;

function TScrnSaverApp.IdleAction;
begin
  if not Configure and (MainWindow <> nil) then
    PostMessage(MainWindow^.hWindow,WM_Animate,0,0);
  IdleAction:=not Configure;
end;

constructor TScrnSaverWin.Init(aParent: PWindowsObject; aTitle: PChar);
begin
  TWindow.Init(aParent, aTitle);
  FirstMouseMove := True;
  Attr.Style     := WS_POPUP;
  GetWindowRect(GetDesktopWindow,trWinRect);
end;

destructor TScrnSaverWin.Done;
begin
  ShowCursor(true);
  inherited Done;
end;

procedure TScrnSaverWin.SetupWindow;
begin
  inherited SetupWindow;
  ShowCursor(false);
  GetCursorPos(PrevPt);
  GetWindowRect(GetDesktopWindow, trWinRect);
  with trWinRect do
    SetWindowPos(hWindow, HWND_TOPMOST, Left, Top, Right, Bottom, 0);
end;

function TScrnSaverWin.GetClassName: PChar;
begin
  GetClassName := 'ScreenSaverClass';
end;

procedure TScrnSaverWin.DefWndProc(Var Msg:TMessage);
begin (* Aufwachen bei Tastendruck oder Mausbewegung *)
  case msg.Message  of
    WM_MOUSEMOVE:
      if (MAKEPOINT(msg.LParam).x <> prevPt.x) or
         (MAKEPOINT(msg.LParam).y <> prevPt.y) then
        if Not FirstMouseMove
          then PostMessage(HWindow, WM_CLOSE, 0, 0)
        else FirstMouseMove := False;
    WM_ACTIVATE, WM_ACTIVATEAPP, (*
      if ( msg.WParam = 0 ) then begin
        TWindow.DefWndProc(Msg);
        exit;
      end;*)
    WM_KEYDOWN, WM_SYSKEYDOWN, WM_LBUTTONDOWN, WM_MBUTTONDOWN,
    WM_RBUTTONDOWN: PostMessage(HWindow, WM_CLOSE, 0, 0);
  end;
  TWindow.DefWndProc(Msg);
end;

procedure TScrnSaverWin.WMSyscommand(var Msg: TMessage);
begin
  if ((Msg.WParam and $FFF0) = SC_ScreenSave) then Msg.Result := 1
  else DefWndProc(Msg);
end;

procedure TScrnSaverWin.WMAnimate; (* hier wird ggf. gemalt *)
begin if FirstMouseMove then ClearScreen; end;

procedure TScrnSaverWin.ClearRect;
begin
  with tr do BitBlt(DC, left, top, right, bottom, 0,0,0, BLACKNESS);
end;

procedure TScrnSaverWin.ClearScreen;
var hWinDC : hDC;
begin
  hWinDC:=GetWindowDC(hWindow); ClearRect(hWinDC,trWinRect);
  ReleaseDC(hWindow, hWinDC);
end;

end.