//  MailSlot-Demo / Thomas Hornschuh / c't 4/95 / Borland C++

#include <windows.h>

#define INCL_NETMAILSLOT
#define INCL_NETERRORS

extern "C" {
#include <lan.h>
}

struct DemoMessage {   // diese Dummy-Nachricht wird verschickt
  DWORD dwTime;        // und empfangen
  long nCounter;
  int x, y;
};

unsigned int hMailSlot;
long nCounter;

LRESULT FAR PASCAL _export WinProc( HWND hWnd, UINT msg,
                                    WPARAM wParam,LPARAM lParam)
{  switch (msg) {
     case WM_CREATE:
       DosMakeMailslot( "\\mailslot\\DemoSlot",sizeof(DemoMessage),0,
                        &hMailSlot);
       SetTimer(hWnd,1,100,NULL);
       nCounter=0;
       return 0;
     case WM_TIMER: {   // MailSlot lesen
	   DemoMessage Msg;
	   unsigned short sz,next,p;
	   HDC hDC;
	   char Buffer[64];

	   DosReadMailslot(hMailSlot,(char far*)&Msg,&sz,&next,&p,0);
	   if (sz==sizeof(Msg)) {
	     wsprintf( Buffer,"Message id: %ld, Time: %ld",
                       Msg.nCounter,Msg.dwTime);
	     hDC=GetDC(hWnd);
	     TextOut(hDC,Msg.x,Msg.y,Buffer,lstrlen(Buffer));
	     ReleaseDC(hWnd,hDC);
	   }
	 }
         break;
     case WM_LBUTTONDOWN: {    // Demo-Nachricht verschicken
         DemoMessage Msg;
         Msg.nCounter=nCounter++;
         Msg.dwTime=GetTickCount();
         Msg.x=LOWORD(lParam);
         Msg.y=HIWORD(lParam);
         DosWriteMailslot("\\\\*\\mailslot\\DemoSlot",
           (char far*)&Msg,sizeof(Msg),0,2,MAILSLOT_NO_TIMEOUT);
       }
       break;
     case WM_CLOSE:
       KillTimer(hWnd,NULL);
       DosDeleteMailslot(hMailSlot);
       PostQuitMessage(0);
       break;
   }
   return DefWindowProc(hWnd,msg,wParam,lParam);
}

void DoRegister(HINSTANCE hInst)
{
WNDCLASS c;
  c.style=NULL;           c.lpfnWndProc=WinProc;
  c.cbClsExtra=0;         c.cbWndExtra=0;
  c.hInstance=hInst;
  c.hIcon=LoadIcon(hInst,IDI_APPLICATION);
  c.hCursor=LoadCursor(NULL,IDC_ARROW);
  c.hbrBackground=(HBRUSH)COLOR_WINDOW+1;
  c.lpszMenuName=NULL;
  c.lpszClassName="IPCDemoWndClass";
  RegisterClass(&c);
};

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpCmdLine, int nCmdShow)
{
MSG msg;
HWND hWnd;
   if (!hPrevInstance) DoRegister(hInstance);
   hWnd=CreateWindow("IPCDemoWndClass","Mailslot Demo",
		WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,
		CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
		NULL,NULL,hInstance,NULL);
   ShowWindow(hWnd,nCmdShow);
   while (GetMessage(&msg,0,0,0)) {
     TranslateMessage(&msg);
     DispatchMessage(&msg);
   }
   return msg.wParam;
}

