
#include <notebook.h>
#include <applicat.h>
#include <dialog.h>
#include <framewin.h>
#include <gdiobjec.h>

#include <string.h>

// MENU & COMMANDS
#define IDM_PROBE              1
#define IDCM_DEMONOTEBOOK     101
#define IDCM_HELPABOUT        999

// MAIN DIALOGS
#define IDDLG_HELPABOUT        1
#define IDDLG_NOTEBOOK         2

// NOTEBOOK MEMBERS
#define IDDLG_PAGE1          210
#define IDDLG_PAGE2          220
#define IDDLG_PAGE2SUB1      221
#define IDBMP_PAGE2SUB1      221
#define IDNB_NOTEBOOK        101

class TDlgPage1 : public TDialog
     {
        public:        TDlgPage1 (TWindow* parent, TResId resID, TModule* module = 0)
                      :TDialog (parent, resID, module) {}
        protected:     void SetupWindow();
     };

void TDlgPage1::SetupWindow()
{
  TDialog::SetupWindow();
  SendDlgItemMessage (101,LB_ADDSTRING,0,(LPARAM)"Diese Liste sollte man fllen");
}

class TDlgPage2 : public TDialog
     {
        public:        TDlgPage2 (TWindow* parent, TResId resID, TModule* module = 0)
                      :TDialog (parent, resID, module) {}
        protected:     void SetupWindow();
     };

void TDlgPage2::SetupWindow()
{
  TDialog::SetupWindow();
  SendDlgItemMessage (101,LB_ADDSTRING,0,(LPARAM)"Die blichen 0815-Sysinfos");
  WinCheckButton (HWindow,102,BM_SETCHECK);
}

class TDlgPage2Sub1 : public TDialog
     {
        public:        TDlgPage2Sub1 (TWindow* parent, TResId resID, TModule* module = 0)
                      :TDialog (parent, resID, module) {}
        protected:     void SetupWindow();
     };

void TDlgPage2Sub1::SetupWindow()
{
  TDialog::SetupWindow();
  SendDlgItemMessage (101,LB_ADDSTRING,0,(LPARAM)"No True Type Fonts, please");
}

class TDlgNotebook : public TDialog
     {
        public:        TNotebook     *pNotebook;
                       ULONG          ulIDPage1;
                       ULONG          ulIDPage2;
                       ULONG          ulIDPage2Sub1;
                       TDlgPage1     *pIDlgPage1;
                       TDlgPage2     *pIDlgPage2;
                       TDlgPage2Sub1 *pIDlgPage2Sub1;
                       HBITMAP        hbm;
                       TBitmap*       pIBitmap;

        public:        TDlgNotebook (TWindow* parent, TResId resID, TModule* module = 0)
                      :TDialog (parent, resID, module) {}
        protected:     BOOL CanClose();
                       void SetupWindow();
     };

BOOL TDlgNotebook::CanClose()
{
  delete pIDlgPage1;
  delete pIDlgPage2;
  delete pIDlgPage2Sub1;
  pNotebook->DeletePage (ulIDPage1,BKA_SINGLE);
  pNotebook->DeletePage (ulIDPage2,BKA_SINGLE);
  pNotebook->DeletePage (ulIDPage2Sub1,BKA_SINGLE);
  delete pNotebook;
  delete pIBitmap;
 // CLOSE
  return (TRUE);
}

void TDlgNotebook::SetupWindow()
{
  TDialog::SetupWindow();
 // NOTEBOOK
  pNotebook = new TNotebook (this,IDNB_NOTEBOOK);
  pNotebook->Create();
 // INSERT & SETUP FIRST PAGE
  ulIDPage1 = pNotebook->InsertPage (0,BKA_STATUSTEXTON | BKA_MAJOR,BKA_FIRST);
  pNotebook->SetTabText (ulIDPage1,"~Gerte");
  pNotebook->SetStatuslineText (ulIDPage1,"Liste der verfgbaren Gerte");
 // LINK DIALOG
  pIDlgPage1 = new TDlgPage1(pNotebook,IDDLG_PAGE1);
  pIDlgPage1->Create();
  pNotebook->SetPageWindow (ulIDPage1,pIDlgPage1);
 // INSERT & SETUP SECOND PAGE
  ulIDPage2 = pNotebook->InsertPage (ulIDPage1,BKA_STATUSTEXTON | BKA_MAJOR,BKA_NEXT);
  pNotebook->SetTabText (ulIDPage2,"~System");
  pNotebook->SetStatuslineText (ulIDPage2,"Einige Systeminformationen");
 // LINK DIALOG
  pIDlgPage2 = new TDlgPage2(pNotebook,IDDLG_PAGE2);
  pIDlgPage2->Create();
  pNotebook->SetPageWindow (ulIDPage2,pIDlgPage2);
 // CREATE BITMAP FOR MINOR TAB
  pIBitmap = new TBitmap (GetModule()->GetInstance(),IDBMP_PAGE2SUB1);
  hbm = HBITMAP(*pIBitmap);
 // INSERT & SETUP THIRD PAGE (MINOR TAB)
  ulIDPage2Sub1 = pNotebook->InsertPage (ulIDPage2,BKA_STATUSTEXTON | BKA_MINOR,BKA_NEXT);
  pNotebook->SetTabBitmap (ulIDPage2Sub1,hbm);
  pNotebook->SetStatuslineText (ulIDPage2Sub1,"Installierte Fonts");
 // LINK DIALOG
  pIDlgPage2Sub1 = new TDlgPage2Sub1(pNotebook,IDDLG_PAGE2SUB1);
  pIDlgPage2Sub1->Create();
  pNotebook->SetPageWindow (ulIDPage2Sub1,pIDlgPage2Sub1);
 // SETUP TAB DIMENSIONS
  pNotebook->SetDimensions (48,20,BKA_MAJORTAB);
  pNotebook->SetDimensions (41,32,BKA_MINORTAB);
  pNotebook->SetDimensions (20,20,BKA_PAGEBUTTON);
 // RECOLOR
  pNotebook->SetColor (RGB(255,255,255),BKA_BACKGROUNDPAGECOLOR);
  pNotebook->SetColor (RGB(192,0,192),BKA_BACKGROUNDMAJORCOLOR);
  pNotebook->SetColor (RGB(0,0,0),BKA_FOREGROUNDMAJORCOLOR);
}

class TWinProbe : public TFrameWindow
     {
        public:     TDialog      *pIDlgAbout;
                    TDlgNotebook *pIDlgNotebook;

        public:          TWinProbe (TWindow* parent, const char far *title = 0);
        protected:  void CmDemoNotebook ();
                    void CmHelpAbout ();
                    DECLARE_RESPONSE_TABLE(TWinProbe);
     };

DEFINE_RESPONSE_TABLE1(TWinProbe,TFrameWindow)
  EV_COMMAND (IDCM_DEMONOTEBOOK,CmDemoNotebook),
  EV_COMMAND (IDCM_HELPABOUT,CmHelpAbout),
END_RESPONSE_TABLE;

void TWinProbe::CmDemoNotebook()
{
  pIDlgNotebook = new TDlgNotebook (this,IDDLG_NOTEBOOK);
  pIDlgNotebook->Execute();
  delete pIDlgNotebook;
}

void TWinProbe::CmHelpAbout()
{
  pIDlgAbout = new TDialog(this,IDDLG_HELPABOUT);
  pIDlgAbout->Execute();
  delete pIDlgAbout;
}

TWinProbe::TWinProbe (TWindow *parent, const char far *title)
          :TFrameWindow (parent, title, 0, FALSE, 0)
{
  Init (parent,FALSE);
}

class TAppProbe : public TApplication
     {
        public:          TAppProbe() : TApplication() {}
                    void InitMainWindow();
     };

void TAppProbe::InitMainWindow()
{
  SetMainWindow (new TWinProbe(0, "c't - The Lost Notebook Object"));
  GetMainWindow()->AssignMenu (IDM_PROBE);
}

int OwlMain(int /*argc*/, char* /*argv*/ [])
{
  return TAppProbe().Run();
}

