#include <notebook.h>

void TNotebook::SetStyle (ULONG ulStyle)
{
  SetWindowLong (QWL_STYLE,ulStyle);
  Invalidate ();
}

ULONG TNotebook::ClearStyle (ULONG ulStyle)
{
  return (GetWindowLong(GWL_STYLE) & (0xFFFFFFFF - ulStyle));
}

void TNotebook::SetBinding (USHORT usFlags)
{
  SetStyle (ClearStyle(BKS_SOLIDBIND | BKS_SPIRALBIND) | usFlags);
}

void TNotebook::SetIntersection (USHORT usFlags)
{
  SetStyle (ClearStyle(BKS_BACKPAGESBR | BKS_BACKPAGESBL |
                       BKS_BACKPAGESTR | BKS_BACKPAGESTL) | usFlags);
}

void TNotebook::SetMajorTabLocation (USHORT usFlags)
{
  SetStyle (ClearStyle(BKS_MAJORTABRIGHT | BKS_MAJORTABLEFT |
                       BKS_MAJORTABTOP | BKS_MAJORTABBOTTOM) | usFlags);
}

ULONG TNotebook::SetColor (TColor color, USHORT usFlags)
{
 // FLAGS: BKA_BACKGROUNDPAGECOLOR, BKA_BACKGROUNDMAJORCOLOR,
 //        BKA_BACKGROUNDMINORCOLOR, BKA_FOREGROUNDMAJORCOLOR,
 //        BKA_FOREGROUNDMINORCOLOR,
  return (ULONG)WinSendMsg(HWindow,BKM_SETNOTEBOOKCOLORS,
                MPFROMLONG(color.Rgb()),MPFROMSHORT(usFlags));
}

ULONG TNotebook::SetTabText (ULONG ulPageID, const char far* text)
{
  return (ULONG)WinSendMsg(HWindow,BKM_SETTABTEXT,
                MPFROMLONG(ulPageID),MPFROMP(text));
}

ULONG TNotebook::SetTabBitmap (ULONG ulPageID, HBITMAP hbm)
{
  return (ULONG)WinSendMsg(HWindow,BKM_SETTABBITMAP,
		MPFROMLONG(ulPageID),MPFROMLONG(hbm));
}

void TNotebook::SetTabShape (USHORT usFlags)
{
  SetStyle (ClearStyle(BKS_SQUARETABS | BKS_ROUNDEDTABS | 
                       BKS_POLYGONTABS) | usFlags);
}

void TNotebook::SetTabTextAlignment (USHORT usFlags)
{
  SetStyle (ClearStyle(BKS_TABTEXTCENTER | BKS_TABTEXTLEFT | 
                       BKS_TABTEXTRIGHT) | usFlags);
}

void TNotebook::SetStatuslineTextAlignment (USHORT usFlags)
{
  SetStyle (ClearStyle(BKS_STATUSTEXTLEFT | BKS_STATUSTEXTRIGHT | 
                       BKS_STATUSTEXTCENTER) | usFlags);
}

ULONG TNotebook::TurnToPage (ULONG ulPageID)
{
  return (ULONG)WinSendMsg(HWindow,BKM_TURNTOPAGE,
                           MPFROMLONG(ulPageID),MPFROMLONG(0L));
}

ULONG TNotebook::InsertPage (ULONG ulPageID, USHORT usStyle, 
                             USHORT usOrder)
{
 // STYLE: BKA_AUTOPAGESIZE, BKA_STATUSTEXTON, BKA_MAJOR, BKA_MINOR
 // ORDER: BKA_FIRST, BKA_LAST, BKA_NEXT, BKA_PREV
  return (ULONG)WinSendMsg(HWindow,BKM_INSERTPAGE,
                           MPFROMLONG(ulPageID),
                           MPFROM2SHORT(usStyle,usOrder));
}

ULONG TNotebook::SetPageWindow (ULONG ulPageID, TWindow* window)
{
  return (ULONG)WinSendMsg(HWindow,BKM_SETPAGEWINDOWHWND,
                MPFROMLONG(ulPageID),MPFROMHWND(window->HWindow));
}

ULONG TNotebook::SetStatuslineText (ULONG ulPageID,const char far* text)
{
  return (ULONG)WinSendMsg(HWindow,BKM_SETSTATUSLINETEXT,
                MPFROMLONG(ulPageID),MPFROMP(text));
}

ULONG TNotebook::SetDimensions (TSize size, USHORT usFlags)
{
 // FLAGS: BKA_MAJORTAB, BKA_MINORTAB, BKA_PAGEBUTTON
  return (ULONG)WinSendMsg(HWindow,BKM_SETDIMENSIONS,
                MPFROM2SHORT(size.cx,size.cy),MPFROMSHORT(usFlags));
}

ULONG TNotebook::DeletePage (ULONG ulPageID, USHORT usFlags)
{
 // FLAGS: BKA_SINGLE, BKA_TAB, BKA_ALL
  return (ULONG)WinSendMsg(HWindow,BKM_DELETEPAGE,
                MPFROMLONG(ulPageID),MPFROMSHORT(usFlags));
}

char far* TNotebook::GetClassName()
{
  return (WC_NOTEBOOK);
}

