#include <AppleEvents.h>
#include "globals.h"
#include "util.h"
#include "io.h"
#include "win.h"

short gNumDocuments; /* Anzahl der offenen Fenster */
short gLastNumber; /* zum Durchnumerieren der neuen Fenster */
ControlActionUPP vActionProc, hActionProc;

void winInit(void) { /* initialisiere dieses Modul */
    gNumDocuments = 0;
    gLastNumber = 0;
    vActionProc = NewControlActionProc (scrollVAction);
    hActionProc = NewControlActionProc (scrollHAction);
} /* winInit */

void winDoNew(void) { /* erzeuge ein neues Dokumentenfenster */
    Ptr          newWin;
    WindowPtr    theWindow; /* Zeiger auf WindowRecord */
    documentPeek doc; /* Zeiger auf documentRecord */
    Rect         viewRect, destRect;
    TEHandle     newTE;
    TEPtr        te;
    Str255       winName, winNumber;
    short        numLen, i, nameLen;
    Str255       emptyString = "\p";

	newWin = NewPtr(sizeof(documentRecord));
	if (newWin == NIL) {
		errorHandler(kNotEnoughMemory, false);
		return;
	}
	theWindow = GetNewWindow(kDocumentWindow,newWin,(WindowPtr)-1L);
	if (theWindow == NIL)
		errorHandler(kResourceError,true);
	gNumDocuments++;
	doc = (documentPeek) theWindow;
	SetPort (theWindow);
	winGetTextRect (theWindow, &viewRect);
	destRect = viewRect;
	destRect.right = destRect.left + kMaxTextWidth;
	newTE = TENew (&destRect, &viewRect); /* neues TextEdit-Feld */
	if (newTE != NIL) {
		te = *newTE;
		winRoundViewRect (newTE); /* Textbereich runden */
		doc->docTE = newTE;
		doc->docVScroll = GetNewControl (kVScroll, theWindow);
		doc->docHScroll = GetNewControl (kHScroll, theWindow);
		TEAutoView (true, doc->docTE);
		if (doc->docVScroll != NIL && doc->docHScroll != NIL) {
			/* Scrollbalken an Fenstergre anpassen */
			winResizeScrolls (theWindow);
			winUpdateScrolls (theWindow);
			gLastNumber++;
			NumToString (gLastNumber, winNumber);
			GetWTitle (theWindow, winName); /* Name des Fensters */
			numLen = winNumber [0]; /* Lnge des Strings */
			nameLen = winName [0];
			winName [0] = nameLen + numLen;	/* Zielstring lnger */
			for (i = nameLen; i < nameLen + numLen; i++)
				winName [i + 1] = winNumber [i - nameLen + 1];
			SetWTitle (theWindow, winName);	/* "Ohne Titel - 1" */
			ShowWindow (theWindow);
			doc->needSave = false;
			doc->isSaved = false;
		}
		else { /* Fehler beim Laden der Scrollbalken */
			winDoClose (theWindow); /* dann auch kein Fenster */
			errorHandler (kResourceError, false);
		} /* else */
	} /* if */
	else
		DisposePtr (newWin);
} /* winDoNew */

void winDoClose (WindowPtr theWindow) { /* Fenster zu, sichern? */
	TEHandle te;
	short    i;
	Str255   winName;
		
	if (winIsOurs (theWindow)) {
		te = ((documentPeek) theWindow) -> docTE;
		if (((documentPeek) theWindow) -> needSave) {
			GetWTitle (theWindow, winName);
			ParamText (winName,"\p","\p","\p");
			i = Alert (kAskSaveAlert, NIL);	/* Wirklich? */
			if (i==1) /* Sichern */
				ioSaveTextFile (theWindow);
			if (i==2) /* Abbrechen */
				return; 
		} /* if needSave */
		TEDispose(te);
		CloseWindow (theWindow);
		DisposePtr ((Ptr) theWindow);
		gNumDocuments--;
	} /* if */	
} /* winDoClose */

Boolean winIsOurs (WindowPtr theWindow) { /* Dokumentfenster? */
	short myKind;
	
	if (theWindow != NIL) {
		myKind = ((WindowPeek) theWindow)->windowKind;
		return (myKind == userKind);
	} /* if */
	else	
		return false;
} /* winIsOurs */

void winCloseAll (void) { /* alle Dokumentfenster zu */
	WindowPtr theWindow;
	
	theWindow = FrontWindow (); /* Adressenfenster schon zu! */
	while (theWindow != NIL) {
		winDoClose (theWindow);
		theWindow = FrontWindow ();
	}
} /* winCloseAll */

void doIdle(void) { /* Freizeitaktivitt: Cursor blinken lassen */
	WindowPtr currentWindow;
	
	currentWindow = FrontWindow ();
	if (winIsOurs (currentWindow))
		TEIdle (((documentPeek) currentWindow)->docTE);
} /* doIdle */

/* Fenster aktivieren oder deaktivieren */
void winDoActivate (WindowPtr theWindow, Boolean doActive) {
	documentPeek docWin;
	
	if (winIsOurs (theWindow)) { /* Ist es ein Dokumentfenster? */
		docWin = (documentPeek) theWindow;
		if (doActive) { /* hier wird aktiviert */
			TEActivate (docWin->docTE);
			(*docWin->docVScroll)->contrlVis = kShowControl;
			(*docWin->docHScroll)->contrlVis = kShowControl;
			DrawControls (theWindow); /* Scrollbalken zeichnen */
		} /* if */
		else { /* hier wird deaktiviert */
			TEDeactivate (docWin->docTE);
			HideControl (docWin->docVScroll); /* Scrollb. deakt. */
			HideControl (docWin->docHScroll);
		} /* else */
		DrawGrowIcon (theWindow); /* Toolbox zeichnet Grenfeld */
	} /* if */
} /* winDoActivate */

void winDrawAll (WindowPtr theWindow) { /* Fensterinhalt komplett */
	SetPort (theWindow);
	BeginUpdate(theWindow);
	DrawControls (theWindow); /* Scrollbalken zeichnen */
	DrawGrowIcon (theWindow); /* Grenfeld zeichnen */
	TEUpdate(&theWindow->portRect,((documentPeek)theWindow)->docTE);
	EndUpdate(theWindow);
} /* winDrawAll */

void winDoZoom (WindowPtr theWindow, short partCode) {
	EraseRect (&theWindow->portRect); /* Fensterinhalt lschen */
	ZoomWindow (theWindow, partCode, theWindow == FrontWindow());
	winIsResized (theWindow);
} /* winDoZoom */

/* Benutzer zieht Fenster mit Grenfeld */
void winDoGrow (WindowPtr theWindow, EventRecord *theEvent) {
	Rect         tempRect;
	long         growResult;
	RgnHandle    tempRgn;
	documentPeek docWin;

	tempRect = qd.screenBits.bounds; /* Bildschirmflche */
	tempRect.left = 128; /* Kleiner darf es nicht sein! */
	tempRect.top = 64; 
	growResult = GrowWindow (theWindow, theEvent->where, &tempRect);
	if (growResult != 0) { /* Wurde die Gre wirklich verndert? */
		docWin = (documentPeek) theWindow;
		tempRect = (*docWin->docTE)->viewRect;
		SizeWindow (theWindow, LoWord(growResult),
							   HiWord(growResult), true);
		winIsResized (theWindow); /* Scrollbalken etc. */
		tempRgn = NewRgn();
		CopyRgn (((WindowPeek) theWindow)->contRgn, tempRgn);
		/* contRgn ist in globalen Koordinaten; in lokale umwand. */
		OffsetRgn (tempRgn, theWindow->portBits.bounds.left,
							theWindow->portBits.bounds.top);
		InvalRgn (tempRgn); /* Gebiet zum Neuzeichnen */
		SectRect(&tempRect, &(*docWin->docTE)->viewRect, &tempRect);
		ValidRect(&tempRect); /* Dieses Viereck nicht neuzeichnen */
		DisposeRgn (tempRgn);
	} /* if */
} /* winDoGrow */

void winAdjustMenus (void) { /* Mens gem aktuellem Zustand */
	Boolean    isOurs, needToBeSaved;
	WindowPtr  theWindow;
	MenuHandle fileMenu, editMenu;
	TEHandle   te;
	long       size;
	
	theWindow = FrontWindow ();
	isOurs = (winIsOurs (theWindow));
	fileMenu = GetMHandle (kFileMenu);
	editMenu = GetMHandle (kEditMenu);
	if (isOurs) { /* eines unserer Fenster ist vorne */
		EnableItem (fileMenu, kFMClose);
		EnableItem (fileMenu, kFMSaveAs);
		EnableItem (fileMenu, kFMPageSetup);
		EnableItem (fileMenu, kFMPrint);
		needToBeSaved = ((documentPeek) theWindow)->needSave;
		if (needToBeSaved) /* es mu noch gesichert werden */
			EnableItem (fileMenu, kFMSave);
		else
			DisableItem (fileMenu, kFMSave);
		te = ((documentPeek) theWindow)->docTE;
		if ((*te)->selStart < (*te)->selEnd) { /* Text markiert */
			EnableItem (editMenu, kEMCut);
			EnableItem (editMenu, kEMCopy);
			EnableItem (editMenu, kEMClear);
		} /* if */
		else { /* nichts markiert, also keine Edit-Befehle */
			DisableItem (editMenu, kEMCut);
			DisableItem (editMenu, kEMCopy);
			DisableItem (editMenu, kEMClear);
		}  /*  else  */
		if (GetScrap (NIL, 'TEXT', &size) > 0) /* Clipboard? */
			EnableItem (editMenu, kEMPaste);
		else
			DisableItem (editMenu, kEMPaste);
	}
	else { /* keins unserer Fenster */
		DisableItem (fileMenu, kFMClose);
		DisableItem (fileMenu, kFMSave);
		DisableItem (fileMenu, kFMSaveAs);
		DisableItem (fileMenu, kFMPageSetup);
		DisableItem (fileMenu, kFMPrint);
		DisableItem (editMenu, kEMCut);
		DisableItem (editMenu, kEMCopy);
		DisableItem (editMenu, kEMPaste);
		DisableItem (editMenu, kEMClear);
	}	
} /* winAdjustMenus */

void winDoMenu (short theItem) /* fr Bearbeiten-Men */
{
	TEHandle  te;
	WindowPtr theWindow;
	long      total, contig;
	
	theWindow = FrontWindow ();
	if (winIsOurs (theWindow)) {
		te = ((documentPeek) theWindow)->docTE;
		switch (theItem) {
			case kEMCut:
				if (ZeroScrap () == noErr) { /* Clipboard lschen */
					PurgeSpace (&total, &contig); /* Noch Platz? */
					if ((*te)->selEnd - (*te)->selStart +5 > contig)
						errorHandler (kNotEnoughMemory, false);
					else {
						TECut (te);
						((documentPeek) theWindow)->needSave = true;
						if (TEToScrap () != noErr)
							ZeroScrap (); /* hat nicht geklappt */
					}  /* else */
				} /* if */
				break;
			case kEMCopy:
				if (ZeroScrap () == noErr) { /* Clipboard lschen */
					TECopy (te);
					if (TEToScrap () != noErr)
						ZeroScrap (); /* hat nicht geklappt */
				} /* if */
				break;
			case kEMPaste:
				if (TEFromScrap () == noErr) {
					if (TEGetScrapLen()+((*te)->teLength
					 -((*te)->selEnd-(*te)->selStart))>kMaxTELength)
						errorHandler (kNotEnoughMemory, false);
					else {	
						TEPaste (te);
						((documentPeek) theWindow)->needSave = true;
					} /* else */
				} /* if */
				break;
			case kEMClear:
				TEDelete (te);
				((documentPeek) theWindow)->needSave = true;
				break;
			default:
				break;
		} /* switch */
		winUpdateScrolls (theWindow); /* Scrollbalken anpassen */
		winAdjustTE (theWindow);
	} /* if */
} /* winDoMenu */

void winDoKey (EventRecord *myEvent) { /* Taste gedrckt */
	WindowPtr theWindow;
	TEHandle  te;
	char      key;
	
	theWindow = FrontWindow (); /* Tasten zum vorderen Fenster  */
	if (winIsOurs (theWindow)) { /* eines unserer Dokumente? */
		te = ((documentPeek) theWindow)->docTE;
		key = myEvent->message & charCodeMask; /* Welche Taste? */
		if (key == kDelChar || (*te)->teLength - ((*te)->selEnd
						- (*te)->selStart) + 1 < kMaxTELength) {
			TEKey (key, te); /* gib TextEdit die Taste */
			winUpdateScrolls (theWindow); /* Scrollbalken akt. */
			winAdjustTE (theWindow);
			((documentPeek) theWindow)->needSave = true;
		} /* if */
		else  /* 32-KByte-Grenze von TextEdit berschritten */
			errorHandler (kDocumentTooLarge, false);
	} /* if */	
} /* winDoKey */

void winDoClick (WindowPtr theWindow, EventRecord *theEvent) {
	Point         mouse;
	ControlHandle theControl;
	short         thePart, val;
	Boolean       shiftDown;
	documentPeek  docWin;
	Rect          teRect;
	
	if (winIsOurs (theWindow)) {
		SetPort (theWindow);
		mouse = theEvent->where; /* Wo wurde hingeklickt? */
		GlobalToLocal (&mouse); /* in lokalen Koordinaten */
		docWin = (documentPeek) theWindow;
		winGetTextRect (theWindow, &teRect);
		if (PtInRect (mouse, &teRect)) { /* War es im Textfeld? */
			shiftDown = (theEvent->modifiers & shiftKey) != 0;
				/* Shift-Taste gedrckt? */
			TEClick (mouse, shiftDown, docWin->docTE);
				/* TextEdit verarbeitet den Klick! */
		} /* if */
		else { /* sonst war es wohl ein Scrollbalken */
			thePart = FindControl (mouse, theWindow, &theControl);
			switch (thePart) { /* In welchen Bereich des Balkens? */
				case 0: /* Control (also Balken) ist deaktiviert */
					break;
				case inThumb:
					val = GetCtlValue (theControl);
					thePart = TrackControl (theControl, mouse, NIL);
					if (thePart != 0) {
						val -= GetCtlValue (theControl);
						if (val != 0) { /* bewegt */
							if  (theControl == docWin->docVScroll)
								TEScroll (0,
								   val*(*docWin->docTE)->lineHeight,
								   					 docWin->docTE);
							else
								TEScroll (val, 0, docWin->docTE);
						} /* if  */
					} /* if */
					break;
				default: /* es war nicht der Griff */
					if (theControl == docWin->docVScroll)
						val = TrackControl (theControl,
												mouse, vActionProc);
					else
						val = TrackControl (theControl,
												mouse, hActionProc);
			} /* switch */
		} /* else */
	} /* if */
} /* winDoClick */

/* wird von TrackControl stndig aufgerufen  */
pascal void scrollVAction (ControlHandle theControl, short thePart) {
	short     amount;
	WindowPtr theWindow;
	TEPtr     te;
	
	if (thePart != 0) { /* berhaupt Control angeklickt? */
		theWindow = (*theControl)->contrlOwner; /* Fenster? */
		te = *((documentPeek) theWindow)->docTE;
		switch (thePart) {/* Welcher Teil? */
			case inUpButton:
			case inDownButton:
				amount =1;
				break;
			case inPageUp:
			case inPageDown:
				amount = (te->viewRect.bottom - te->viewRect.top) /
						  te->lineHeight;
				break;
		} /* switch */
		if ((thePart == inDownButton) || (thePart == inPageDown))
			amount = -amount; /* Richtung ist abwrts */
		checkScrollValues (theControl, &amount);
		if (amount != 0) /* Hat sich etwas gendert? */
			TEScroll (0, amount * te->lineHeight,
				((documentPeek) theWindow)->docTE);
	} /* if */
} /* scrollVAction */

pascal void scrollHAction (ControlHandle theControl, short thePart) {
	short     amount;
	WindowPtr theWindow;
	TEPtr     te;
	
	if (thePart != 0) {	/* berhaupt Control angeklickt? */
		theWindow = (*theControl)->contrlOwner;
		te = *((documentPeek) theWindow)->docTE;
		switch (thePart) { /* Welcher Bereich? */
			case inUpButton:
			case inDownButton:
				amount = 4;
				break;
			case inPageUp:
			case inPageDown:
				amount = te->viewRect.right - te->viewRect.left;
				break;
		}  /*  switch  */
		if ((thePart == inDownButton) || (thePart == inPageDown))
			amount = -amount; /* Richtung ist nach rechts */
		checkScrollValues (theControl, &amount);
		if (amount != 0) /* Hat sich etwas gendert? */
			TEScroll (amount, 0,
						         ((documentPeek) theWindow)->docTE);
	} /* if */
} /* scrollHAction */

/*  Ist der neue Wert des Controls im zulssigen Bereich? */
void checkScrollValues (ControlHandle theControl, short *newAmount) {
	short val, max;
	
	val = GetCtlValue (theControl);
	max = GetCtlMax (theControl);
	*newAmount = val - *newAmount;
	if (*newAmount < 0)
		*newAmount = 0;
	if (*newAmount > max)
		*newAmount = max;
	SetCtlValue (theControl, *newAmount);
	*newAmount = val - *newAmount;
} /* checkScrollValues  */

void winIsResized (WindowPtr theWindow) {
	winResizeScrolls (theWindow); /* Scrollbalken: Gre, Lage */
	winUpdateScrolls (theWindow); /* Scrollbalken: Werte  */
	winAdjustTE (theWindow);
	InvalRect (&theWindow->portRect); /* Update anfordern */
} /* winIsResized */

/* Scrollbalken an Ort und Stelle bringen */
void winResizeScrolls (WindowPtr theWindow) {
	Rect         teRect;
	documentPeek docWin;
	short        winHeight, winWidth;
	
	docWin = (documentPeek) theWindow;
	winGetTextRect (theWindow, &teRect);
	(*docWin->docTE)->viewRect = teRect;
	winRoundViewRect (docWin->docTE);
	winHeight = theWindow->portRect.bottom-theWindow->portRect.top;
	winWidth = theWindow->portRect.right-theWindow->portRect.left;
	MoveControl (docWin->docVScroll,
					   theWindow->portRect.right - kScrollSize, -1);
	SizeControl (docWin->docVScroll,
					kScrollSize + 1, winHeight - (kScrollSize - 2));
	MoveControl (docWin->docHScroll,
					  -1, theWindow->portRect.bottom - kScrollSize);
	SizeControl (docWin->docHScroll,
					 winWidth - (kScrollSize - 2), kScrollSize + 1);
} /* winResizeScrolls */

void winUpdateScrolls (WindowPtr theWindow) { /* neuer Wert */
	documentPeek docWin;
	
	docWin = (documentPeek) theWindow;
	winAdjustScroll (true, docWin->docVScroll, docWin->docTE);
	winAdjustScroll (false, docWin->docHScroll, docWin->docTE);
} /* winUpdateScrolls */

void winAdjustScroll (Boolean vertical, ControlHandle theScroll,
												   TEHandle theTE) {
	short value, lines, max;
	short oldVal, oldMax;
	TEPtr te;
	
	oldVal = GetCtlValue (theScroll);
	oldMax = GetCtlMax (theScroll);
	te = *theTE;
	if (vertical)
	{
		lines = te->nLines;	/* Anzahl der Zeilen insgesamt */
	  /* Wenn der letzte Buchstabe ein <cr> ist, stimmt es nicht. */
	if (*(*te->hText + te->teLength - 1) == kCrChar)
			lines += 1; /* eine Zeile dazurechnen */
		max = lines - ((te->viewRect.bottom - te->viewRect.top) /
													te->lineHeight);
	}
	else
		max = kMaxTextWidth-(te->viewRect.right-te->viewRect.left);
	if (max < 0) max = 0;
	SetCtlMax (theScroll, max); /* am Anschlag */
	
	te = *theTE; /* Handle! Ggf. schon verschoben! */
	if (vertical) /* neuen Wert ermitteln */
		value = (te->viewRect.top-te->destRect.top)/te->lineHeight;
	else
		value = te->viewRect.left-te->destRect.left;	
	if (value < 0) value = 0; /* gltiger Bereich */
	if (value > max) value = max;
	SetCtlValue (theScroll, value);
	if ((max != oldMax) || (value != oldVal))
		ShowControl (theScroll); /* neu zeichnen */
}  /*  winAdjustScroll  */

/* Gre des Textfeldes (Fenstergre abzgl. Scrollbalken) */
void winGetTextRect (WindowPtr theWindow, Rect *teRect) {
	*teRect = theWindow->portRect;	/* das ganze Fenster  */
	InsetRect (teRect, kTextMargin, kTextMargin);
	teRect->bottom = teRect->bottom - kScrollSize;
	teRect->right = teRect->right - kScrollSize;
} /* winGetTextRect */

/* ViewRect auf ganzzahliges Vielfaches der Zeilenhhe runden */
void winRoundViewRect (TEHandle docTE) {
	TEPtr te;
	
	te = *docTE;
	te->viewRect.bottom = (((te->viewRect.bottom - te->viewRect.top) / te->lineHeight) * te->lineHeight) + te->viewRect.top;
} /* winRoundViewRect */

/*  neue Abmessungen an TextEdit */
void winAdjustTE (WindowPtr theWindow) {
	TEPtr te;
	short hVal, vVal;
	short diffWidth, diffHeight;
	
	hVal = GetCtlValue (((documentPeek) theWindow)->docHScroll);
	vVal = GetCtlValue (((documentPeek) theWindow)->docVScroll);
	te = *((documentPeek) theWindow)->docTE;
	diffHeight = te->viewRect.top - te->destRect.top;
	diffWidth = te->viewRect.left - te->destRect.left;
	TEScroll (diffWidth - hVal,
							   diffHeight - (vVal * te->lineHeight),
								 ((documentPeek) theWindow)->docTE);
} /* winAdjustTE */