#include <Printing.h>
#include "globals.h"
#include "util.h"
#include "win.h"
#include "print.h"

THPrint  gPrintRecord;
TPPrPort gPrintPort;

#define printMargin 20 /* Rand beim Drucken */

void prInit(void) {
	gPrintRecord = (THPrint) NewHandleClear (sizeof (TPrint));
	if (gPrintRecord == NIL)
		errorHandler (kNotEnoughMemory,true);
	PrOpen ();
	PrintDefault (gPrintRecord);
	PrClose ();
} /* prInit */

/* Hier stellt der Benutzer das Papierformat ein */
void prPageSetup(void) {
	PrOpen ();
	PrStlDialog (gPrintRecord);
	PrClose ();
}  /* prPageSetup */

/* das aktive Fenster drucken */
void prPrintWin(void)
{
	WindowPtr myWindow;
	GrafPtr   oldPort;
	TEHandle  te;
	Rect      oldTEView, oldTEDest; /* alte TE-Werte */
	Rect      zeroRect;
	TPrStatus printStatus; /* aktueller Druckstatus */
	Rect      pageRect; /* Gre einer Seite */
	Boolean   pCancel; /* Hat der Benutzer abgebrochen? */
	short     pCopies, copyCount; /* Anzahl der Kopien */
	short     pLines, pageHeight;
	short     page, pLineHeight, pFullHeight, pNumPages;
	Str255    docName, strSeite, strSeitenNr;
	
	myWindow = FrontWindow (); /* dieses Fenster drucken */
	if (!winIsOurs (myWindow)) /* Ist es kein Textfenster? */
		return; /* also nicht drucken */
	GetWTitle (myWindow, docName); /* der Name des Dokuments */
	GetIndString (strSeite, kIOStrings, kPageNumber); 
	SetRect (&zeroRect, 0, 0, 0, 0);
	PrOpen ();
	if (PrJobDialog (gPrintRecord)) {
		GetPort (&oldPort); /* alten GrafPort zwischenspeichern */
		pCopies = (*gPrintRecord)->prJob.iCopies; /* Wie oft? */
		te = ((documentPeek) myWindow)->docTE;
		oldTEView = (*te)->viewRect;
		oldTEDest = (*te)->destRect;
		TEDeactivate (te); /* Textcursor nicht drucken */
		gPrintPort = PrOpenDoc (gPrintRecord, NIL, NIL);
		SetPort ((GrafPtr) gPrintPort);
		pageRect = (*gPrintRecord)->prInfo.rPage; /* Seitengre */
		InsetRect (&pageRect, printMargin, printMargin); /* Rand */
		pageRect.top = pageRect.top + printMargin; /* oben Titel */
		pageHeight = pageRect.bottom - pageRect.top;
		(*te)->inPort = (GrafPtr) gPrintPort;
		(*te)->viewRect = pageRect; /* auf Druckseite formatieren */
		(*te)->destRect = pageRect;
		TECalText (te); /* neues Format, andere Zeilenzahl */
		pCancel = false;
		pLines = (*te)->nLines; /* Anzahl der Zeilen */
		pLineHeight = TEGetHeight (1, 1, te); /* Hhe einer Zeile */
		pFullHeight = TEGetHeight (pLines, 1, te); /* Gesamthhe */
		(*te)->destRect.bottom = (*te)->destRect.top + pFullHeight;
		if (pageHeight % pLineHeight != 0)
			pageHeight = pageHeight - (pageHeight % pLineHeight);
		pNumPages = (pFullHeight / pageHeight) + 1;
		(*te)->viewRect.bottom = (*te)->viewRect.top + pageHeight;
		/* die Seiten einzeln aufbauen */
		for (copyCount = 1; copyCount <= pCopies; copyCount++) 
			for (page = 1; (page<=pNumPages)&&(!pCancel); page++) {
				PrOpenPage (gPrintPort, NIL); /* Seite beginnen */
				ClipRect (&(*gPrintRecord)->prInfo.rPage);
				TEUpdate (&(*te)->viewRect, te); /* TE zeichnet */
				MoveTo (pageRect.left, pageRect.top - printMargin);
				DrawString (docName); /* als Titel den Namen */
				DrawString (strSeite); /* Text: "  Seite  " */
				NumToString (page, strSeitenNr);
				DrawString (strSeitenNr);
				PrClosePage (gPrintPort); /* Seite beenden */
				ClipRect (&zeroRect); /* nicht mehr zeichnen */
				TEScroll (0, -pageHeight, te);
				if (PrError () == iPrAbort) /* Abbrechen? */
					pCancel = true;			
			}  /* for */
		PrCloseDoc (gPrintPort); /* Druckjob beendet */
		if (((*gPrintRecord)->prJob.bJDocLoop==bSpoolLoop) &&
											  (PrError () == noErr))
			PrPicFile (gPrintRecord, NIL, NIL, NIL, &printStatus);
		SetPort (oldPort);
		(*te)->inPort = oldPort;
		(*te)->viewRect = oldTEView;
		(*te)->destRect = oldTEDest;
		TEUpdate (&(*te)->viewRect, te);
	} /* if */
	PrClose ();
} /* prPrintWin */