Program BubbleHelp; (*$C PRELOAD *) (*$R BUBBLE.RES *)
(* Bubble-Help fr Borland Pascal fr Windows *)
(*$D Bubble Help, Detlef Rattunde - c't 2/95  *)
Uses WinTypes,WinProcs,Win31,Strings,Objects,OWindows,ODialogs;

Type TCharArray = Array[0..255] Of Char;

Type TBubbleBag = Record (* Bubble-Help Record *)
       DCMasks,        (* Kontext fr Masken-Bitmaps *)
       DCBkGnd,        (* Puffer fr Hintergrund *)
       DC:HDC;         (* DC fr das Desktop  *)
       hPrevMasks,     (* letztes Bitmap-Handle in DCMasks *)
       hPrevBkGnd,     (* letztes Bitmap-Handle in DCBkGnd *)
       hAndMask,       (* AND-Masken-Bitmap *)
       hXorMask,       (* XOR-Masken-Bitmap *)
       hBkGnd:HBITMAP; (* Hintergrund-Bitmap *)
       iX, iY:Integer; (* x-, y-Position *)
       hPrevCtrl:HWND; (* letztes aktives Control *)
     End;

Type pDlgBubble = ^TDlgBubble;       (* BUBBLE-HELP RECORD *)
     TDlgBubble = Object(TDlgWindow)
       fBubbling   :Boolean;
       Bubble      :TBubbleBag;
       Constructor Init (AParent:pWindowsObject; AName:pChar);
       Destructor  Done; Virtual;
       Function    GetClassName:pChar; Virtual;
       Procedure   WMNCActivate (Var Msg:TMessage);
                   Virtual WM_FIRST+WM_NCACTIVATE;
       Procedure   WMSetCursor (Var Msg:TMessage);
                   Virtual WM_FIRST+WM_SETCURSOR;
       Procedure   WMCommand (Var Msg:TMessage);
                   Virtual WM_FIRST+WM_COMMAND;
       Procedure   WMTimer (Var Msg:TMessage);
                   Virtual WM_FIRST+WM_TIMER;
       Procedure   BubbleOn (hCtrl:HWND);
       Procedure   BubbleOff;
       Procedure   BubbleStart;
     End;

Type TAppBubble = Object(TApplication) (* APPLICATION OBJECT *)
       Procedure   InitMainWindow; Virtual;
     End;

Var  AppBubble   :TAppBubble;

Constructor TDlgBubble.Init (AParent:pWindowsObject; AName:pChar);
Begin
  TDlgWindow.Init (AParent,AName);
  fBubbling:=FALSE;
  With Bubble Do Begin (* Bubble-Help initialisieren *)
    DC:=CreateDC ('DISPLAY',Nil,Nil,Nil);
    hBkGnd:=CreateCompatibleBitmap(DC,178,74);
    DeleteDC (DC);
    hAndMask:=LoadBitmap(hInstance,'BUBBLEHELP_AND');
    hXorMask:=LoadBitmap(hInstance,'BUBBLEHELP_XOR');
    hPrevCtrl:=0
  End
End;

Destructor TDlgBubble.Done;
Begin
  BubbleOff;
  With Bubble Do Begin
    DeleteObject (hBkGnd);      DeleteObject (hAndMask);
    DeleteObject (hXorMask)
  End;
  TDlgWindow.Done
End;

Procedure TDlgBubble.BubbleOff;
Begin (* Hintergrund restaurieren *)
  KillTimer(hWindow,10); fBubbling:=FALSE;
  With Bubble Do If (hPrevCtrl <> 0) Then Begin
    BitBlt (DC, iX, iY, 178, 74, DCBkGnd, 0, 0, SRCCOPY);
    SelectObject (DCBkGnd,hPrevBkGnd);
    SelectObject (DCMasks,hPrevMasks);
    DeleteDC (DCBkGnd);  DeleteDC (DCMasks);  DeleteDC (DC);
    hPrevCtrl:=0;        ShowCaret(0)
  End
End;

Procedure TDlgBubble.BubbleStart;
Begin (* ggf. Bubble entfernen, Timer zurcksetzen *)
  If fBubbling Then BubbleOff;
  KillTimer (hWindow,10);
  SetTimer (hWindow,10,800,Nil);
End;

Procedure TDlgBubble.BubbleOn (hCtrl:HWND);
Var  iCharCount, iID :Integer;  szHelp          :TCharArray;
     hfOrg, hfFat    :HFont;    clr             :TColorRef;
     R               :TRect;    P               :TPoint;
Begin
  If (GetActiveWindow <> hWindow) Then EXIT; (* kein Fokus *)
  GetCursorPos(P);
  GetWindowRect(hWindow,R);
  if not PtInRect(R,P) then EXIT; (* Maus nicht im Dialog-Fenster *)
 (* Hilfetext aus Ressource laden *)
  iID:=GetDlgCtrlID(hCtrl);
  iCharCount:=LoadString (hInstance,iID,szHelp,SizeOf(szHelp)-1);
  If iCharCount = 0 Then StrPCopy(@szHelp,'kein Hilfetext');
  With (Bubble) Do Begin
   (* Bubble ber dem Control zentieren *)
    GetWindowRect (hCtrl,R);
    iX:=R.LEFT+((R.RIGHT-R.LEFT) DIV 2)-23;  iY:=R.TOP-74;
   (* Hintergrund sichern *)
    HideCaret(0);
    DC:=CreateDC ('DISPLAY',Nil,Nil,Nil);
    DCBkGnd:=CreateCompatibleDC(DC);
    hPrevBkGnd:=SelectObject (DCBkGnd,hBkGnd);
    BitBlt (DCBkGnd,0,0,178,74,DC,iX,iY,SRCCOPY);
    DCMasks:=CreateCompatibleDC(DC);
    hPrevMasks:=SelectObject (DCMasks,hAndMask);
   (* Maske "aufsetzen" *)
    SelectObject (DCMasks,hAndMask);
    BitBlt (DC,iX,iY,178,74,DCMasks,0,0,SRCAND);
    SelectObject (DCMasks,hXorMask);
    BitBlt (DC,iX,iY,178,74,DCMasks,0,0,SRCInvert);
   (* Text in Bubble einblenden  *)
    hfFat:=CreateFont (8,0,0,0,FW_BOLD,0,0,0,ANSI_CHARSET,
      OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,PROOF_QUALITY,
      VARIABLE_PITCH OR FF_SWISS,'MS SANS SERIF');
    hfOrg:=SelectObject (DC,hfFat);
    clr:=GetTextColor(DC);
    SetTextColor (DC,RGB(255,255,255));
    SetBkMode (DC,TRANSPARENT);
    R.LEFT:=iX+12;             R.TOP:=iY+14;
    R.RIGHT:=R.LEFT+154;       R.BOTTOM:=R.TOP+30;
    DrawText (DC,szHelp,-1,R,DT_LEFT OR DT_WORDBREAK OR DT_NOPREFIX);
    SetTextColor (DC,clr);     SelectObject (DC,hfOrg);
    DeleteObject (hfFat);      hPrevCtrl:=hCtrl;
  End;
  fBubbling:=TRUE
End;

Procedure TDlgBubble.WMTimer (Var Msg:TMessage);
Var P     :TPOINT;
    R     :TRect;
    hCtrl :HWND;
Begin (* nach 800 ms Bubble einblenden *)
  GetCursorPos(p);
  GetWindowRect(hWindow,r);
  If not fBubbling then begin
    hCtrl:=WindowFromPoint(P);
    BubbleOn (hCtrl)
  end
  else if not (PtInRect(r,p)) and (GetActiveWindow=hWindow)
    then BubbleOff
end;

Procedure TDlgBubble.WMSetCursor (Var Msg:TMessage);
Var P     :TPOINT;
    hCtrl :HWND;
Begin
  GetCursorPos (P);       hCtrl:=WindowFromPoint(P);
 (* nur bei neuem Control und Eingabefokus (neu) starten *)
  If (hCtrl <> Bubble.hPrevCtrl) and (GetActiveWindow=hWindow)
    Then BubbleStart;
  TDlgWindow.DefWndProc(Msg)
End;

Procedure TDlgBubble.WMNCActivate (Var Msg:TMessage);
Begin BubbleOff;  TDlgWindow.DefWndProc(Msg) End;

Procedure TDlgBubble.WMCommand (Var Msg:TMessage);
Begin BubbleOff; TDlgWindow.WMCommand(Msg) End;

Function TDlgBubble.GetClassName:pChar;
Begin GetClassName:='BUBBLE' End;

Procedure TAppBubble.InitMainWindow; (* DlgWindow laden *)
Begin MainWindow:=New(pDlgBubble,Init(Nil,'BUBBLE')) End;

Begin
  AppBubble.Init('BUBBLE'); AppBubble.Run; AppBubble.Done
End.
