Program DLL4DPMI;
{ Datei  : DLL4DPMI.PAS
  Autoren: Gemkow, Doering, Woog
  Datum  : 10.09.94              }

{ Dieses Program ist fuer Real-Mode, DPMI und Windows compilierbar!

  Es kopiert die Datei infile.dll in die Datei outfile.dll. Dabei
  wird in der infile.dll jede Referenz auf die WIN87EM.DLL durch
  eine Referenz auf DUMMY87.DLL ersetzt.
  Weil die Zeichenkette "WIN87EM" auch in Funktionsbezeichnern
  enthalten ist, wurden diese Bezeichner analysiert. Sie beginnen
  alle mit "_". Darauf aufbauend wird der Ersetzungsalgorithmus
  fuer alle mit "_" beginnenden Bezeichner blockiert.

  Aufruf:

     DLL4DPMI infile.dll outfile.dll                               }

{$IFDEF Windows}
  {$R dll4dpmi.res}   { enthaelt nur ein spezielles Icon }
  Uses
    WinDos, WinCrt, WinProcs, Objects, Strings;
{$ELSE}
  Uses
    Dos, Crt, Objects, Strings;
{$ENDIF}

Const
  pszSearchFor   = 'WIN87EM';
  pszReplaceWith = 'DUMMY87';  { Wichtig: gleiche Laenge!}
  BufferSize     = 10;

Type
  tBuffer = Array [1..BufferSize] Of Byte;

Var
  iSearch, iX, iY, iPerc : Integer;
  Search, Replace, Buffer: tBuffer;
  stIn, stOut            : tBufStream;
  lBytesPerPercent, lNow : LongInt;
  sInFile, sOutFile      : String;

Begin
{$I-}
  If ParamCount<2
  Then Begin
    WriteLn;
    WriteLn('      DLL4DPMI   Version 1.0 / 03.09.94 ');
    WriteLn;
    WriteLn(' DLL4DPMI.EXE modifiziert eine mit BORLAND-C/C++');
    WriteLn(' geschriebene DLL, die Gleitkommaoperationen');
    WriteLn(' verwendet. Dabei werden alle Verweise auf die');
    WriteLn(' WIN87EM.DLL ersetzt, damit die DLL auch unter');
    WriteLn(' DPMI verwendet werden kann. Unter dieser');
    WriteLn(' Umgebung wird ein  Teil der Funktionalitaet');
    WriteLn(' der  WIN87EM.DLL von der DUMMY87.DLL realisiert.');
    WriteLn(' (Die Rettung der Coprozessorregister bei der');
    WriteLn(' Taskumschaltung ist nicht realisiert. Der');
    WriteLn(' Coprozessor darf nur von einem Task verwendet');
    WriteLn(' werden.)');
    WriteLn(' Die modifizierte C-DLL sollte nur auf PCs mit');
    WriteLn(' Coprozessor eingesetzt werden.');
    WriteLn;
    WriteLn(' Verwendung des Programmes:');
    WriteLn;
    WriteLn('     DLL4DPMI infile.dll outfile.dll');
    WriteLn;
    WriteLn('                     Weiter mit beliebiger Taste');
    ReadKey;
    {$IFDEF Windows}
      DoneWinCrt;
    {$ELSE}
      Halt(0);
    {$ENDIF}
  End;
  sInFile :=ParamStr(1);
  sOutFile:=ParamStr(2);
  WriteLn('Bei jedem Ersetzen wird ein Ton erzeugt.');
  WriteLn('(Abbruch mit ESC; Weiter jede andere Taste)');
  If (ReadKey=#27)
  Then {$IFDEF Windows}
         DoneWinCrt;
       {$ELSE}
         Halt(0);
       {$ENDIF}
  StrCopy(@Search , pszSearchFor);
  StrCopy(@Replace, pszReplaceWith);
  {$IFDEF Windows}
    stIn.Init(@sInFile[1]  , stOpenRead, 8192);
    stOut.Init(@sOutFile[1], stCreate  , 8192);
  {$ELSE}
    stIn.Init(sInFile  , stOpenRead, 8192);
    stOut.Init(sOutFile, stCreate  , 8192);
  {$ENDIF}
  iX:= WhereX;
  iY:= WhereY;
  iSearch:= 1;
  lNow   := 1;
  lBytesPerPercent:= stIn.GetSize Div 100;
  stIn.Read(Buffer[iSearch], 1);
  While (stIn.Status=stOk) And (stOut.Status=stOk) Do
    Begin
      If lNow>=lBytesPerPercent
      Then Begin
             lNow:= 0;
             GoToXY(iX, iY);
             Write(stIn.GetPos*100 Div stIn.GetSize,
                   ' % bearbeitet');
           End
      Else Inc(lNow);
      If (Search[iSearch]=0)
      Then Begin
             stOut.Write(Replace, iSearch-1);
             stOut.Write(Buffer[iSearch], 1);
             iSearch:= 1;
             {$IFDEF Windows}
               MessageBeep(0);
             {$ELSE}
               Sound(2700);
               Delay(50);
               NoSound;
             {$ENDIF}
           End
      Else If (Search[iSearch]=Buffer[iSearch])
           Then Inc(iSearch)
           Else Begin
                  stOut.Write(Buffer, iSearch);
                  iSearch    := 1;
                End;
      stIn.Read(Buffer[iSearch], 1);
      If Buffer[iSearch] = Ord('_')
      Then While (stIn.Status=stOk) And
                 (stOut.Status=stOk) And
                 (Buffer[iSearch]>32) And
                 (Buffer[iSearch]<128) Do
             Begin
               stOut.Write(Buffer[iSearch], 1);
               stIn.Read (Buffer[iSearch], 1);
             End;
    End;
  stOut.Flush;
  stIn.Done;
  stOut.Done;
{$I+}
  GoToXY(iX, iY);
  WriteLn('                ');
  WriteLn('Aktion beendet.');
{$IFDEF Windows}
  ReadKey;
  DoneWinCrt;
{$ENDIF}
End.
