//  Datei "print.c"  Modul zum Drucken
//  von Norbert M. Doerner

#include <Printing.h>
#include "globals.h"
#include "util.h"
#include "win.h"
#include "print.h"

/*  globale Variablen fr das Print-Modul  */
THPrint		gPrintRecord;
TPPrPort	gPrintPort;

#define printMargin	20	/*  Rand beim Drucken in Pixel  */

/*  beim Start aufgerufen, werden hier die Variablen initialisiert  */
void prInit(void)
{
	gPrintRecord = (THPrint) NewHandleClear (sizeof (TPrint));
	if (gPrintRecord == NIL)
		errorHandler (kNotEnoughMemory,true);
	PrOpen ();
	PrintDefault (gPrintRecord);
	PrClose ();
}  /* prInit */

/*  hier kann der Benutzer das Papierformat einstellen  */
void prPageSetup(void)
{
	Boolean		dummy;
	
	PrOpen ();
	dummy = PrStlDialog (gPrintRecord);
	PrClose ();
}  /* prPageSetup */

/*  hier wird das aktive Fenster gedruckt  */
void prPrintWin(void)
{
	WindowPtr	myWindow;
	GrafPtr		oldPort;
	TEHandle	te;
	Rect		oldTEView, oldTEDest;	/*  alte TE-Werte  */
	Rect		zeroRect;
	TPrStatus	printStatus;	/*  enthlt den aktuellen Druckstatus  */
	Rect		pageRect;		/*  die Gre einer Seite  */
	Boolean		pCancel;		/*  hat der Benutzer abgebrochen?    */
	short		pCopies, copyCount;	/*  Anzahl der Kopien  */
	short		pLines, pageHeight;
	short		page, pLineHeight, pFullHeight, pNumPages;
	Str255		docName,strSeite,strSeitenNr;
	
	myWindow = FrontWindow ();		/*  dieses Fenster soll gedruckt werden  */
	if (!winIsOurs (myWindow))		/*  ist es ein Textfenster?  */
		return;						/*  Nein!  */
	GetWTitle (myWindow, docName);	/*  Das ist der Name des Dokumentes  */
	GetIndString (strSeite, kIOStrings, kPageNumber); 
	SetRect (&zeroRect, 0, 0, 0, 0);
	PrOpen ();
	if (PrJobDialog (gPrintRecord))
	{
		GetPort (&oldPort);
		pCopies = (*gPrintRecord)->prJob.iCopies;		/*  so viele Kopien brauchen wir  */
		te = ((documentPeek) myWindow)->docTE;  		/*  das ist der TE-Record  */
		oldTEView = (*te)->viewRect;
		oldTEDest = (*te)->destRect;
		TEDeactivate (te);								/*  damit der Cursor nicht mitgedruckt wird!  */
		gPrintPort = PrOpenDoc (gPrintRecord, NIL, NIL);/*  Druckjob ffnen  */
		
		SetPort ((GrafPtr) gPrintPort);					/*  Druckbereich aktivieren  */
		pageRect = (*gPrintRecord)->prInfo.rPage;		/*  so gro ist eine Seite  */
		InsetRect (&pageRect, printMargin, printMargin);/*  Rand lassen  */
		pageRect.top = pageRect.top + printMargin;		/*  etwas Platz fr die Titelzeile lassen  */
		pageHeight = pageRect.bottom - pageRect.top;	/*  so hoch ist eine Seite  */
		(*te)->inPort = (GrafPtr) gPrintPort;			/*  das ist zum Drucken der GrafPort  */
		(*te)->viewRect = pageRect;						/*  und das fr TE die BegrenzungsRects  */
		(*te)->destRect = pageRect;
		TECalText (te);				/*  Zeilenzahl neu berechnen, da wir die Rects gendert haben  */
		pCancel = false;
		pLines = (*te)->nLines;							/*  Anzahl der Zeilen  */
		pLineHeight = TEGetHeight (1, 1, te);			/*  so hoch ist eine Zeile  */
		pFullHeight = TEGetHeight (pLines, 1, te);		/*  Gesamthhe in Pixel  */
		(*te)->destRect.bottom = (*te)->destRect.top + pFullHeight;	/*  destRect anpassen  */ 
		if (pageHeight % pLineHeight != 0)
			pageHeight = pageHeight - (pageHeight % pLineHeight);
		pNumPages = (pFullHeight / pageHeight) + 1;
		(*te)->viewRect.bottom = (*te)->viewRect.top + pageHeight;
		/*  jetzt knnen die Seiten einzeln aufgebaut werden  */
		for (copyCount = 1; copyCount <= pCopies; copyCount++) 
			for (page = 1; (page <= pNumPages) && (!pCancel); page++)
			{
				PrOpenPage (gPrintPort, NIL);				/*  Seite beginnen  */
				ClipRect (&(*gPrintRecord)->prInfo.rPage);	/*  Clipping ber die ganze Seite  */
				TEUpdate (&(*te)->viewRect, te);			/*  TE soll die Seite zeichnen  */
				MoveTo (pageRect.left, pageRect.top - printMargin);	/*  hier wird die Titelzeile stehen  */
				DrawString (docName);						/*  Titel ist der Name des Dokumentes  */
				DrawString (strSeite);						/*  als Text: "  Seite  "  */
				NumToString (page, strSeitenNr);
				DrawString (strSeitenNr);
				PrClosePage (gPrintPort);					/*  Seite beenden  */
				ClipRect (&zeroRect);						/*  ab hier soll nicht mehr gezeichnet werden  */
				TEScroll (0, -pageHeight, te);
				if (PrError () == iPrAbort)					/*  Benutzer will abbrechen  */
					pCancel = true;			
		}  /*  for  */
		/*  alle Seiten fertig gespoolt  */
		PrCloseDoc (gPrintPort);						/*  Druckjob beendet  */
		if (((*gPrintRecord)->prJob.bJDocLoop == bSpoolLoop) && (PrError () == noErr))
			PrPicFile (gPrintRecord, NIL, NIL, NIL, &printStatus);  /*  hier wird gedruckt  */
		SetPort (oldPort);								/*  alte Werte zurcksetzen  */
		(*te)->inPort = oldPort;
		(*te)->viewRect = oldTEView;
		(*te)->destRect = oldTEDest;
		TEUpdate (&(*te)->viewRect, te);				/*  TE aktualisieren  */
	}  /*  if  */
	PrClose ();
}  /* prPrintWin */