//  Datei "io.c"  Modul fr die Dateiein- und ausgabe
// von Norbert M. Doerner

#include <AppleEvents.h>
#include <Folders.h>
#include "globals.h"
#include "util.h"
#include "win.h"
#include "io.h"
#include "print.h"

/*  prfen, ob ein Fehler aufgetreten ist. Wenn etwas passiert,  wird der  */
/*  Benutzer informiert und das Ergebnis ist "true"	*/
Boolean ioCheckOK (OSErr theError)
{
	Boolean	isNotOK;
	short	i;
	Str255	why;
	
	isNotOK = (theError != noErr);
	if (isNotOK)
	{
		NumToString (theError, why);
		ParamText (why,"\p","\p","\p"); 
		i = StopAlert (kFileErrorAlert, NIL);
	}
	return isNotOK;
}  /*  ioCheckOK  */

/*  ffne die angegebene Textdatei  */
void ioOpenTextFSSpec (FSSpec theFile)
{
	OSErr					err;
	short					textFile;			/*  Nummer der geffneten Textdatei  */
	long						dataSize;			/*  Gre der Datei  */
	Handle					tHandle;			/*  hier wird der Text zunchst landen  */
	WindowPtr				oldFront,newFront;

	if (ioCheckOK (FSpOpenDF (&theFile, fsCurPerm, &textFile)))	/*  Data-fork ffnen  */
		return;	
	err = GetEOF (textFile, &dataSize);		/*  Gre der Datei  */
	if (dataSize > kMaxTELength)	/*  zu gro  */
	{
		errorHandler (kDocumentTooLarge, false);
		err = FSClose (textFile);
		return;
	}  /*  if  */
	tHandle = NewHandleClear (dataSize);	/*  Puffer bereitstellen  */
	if (tHandle == NIL)
	{
		errorHandler (kNotEnoughMemory, false);
		err = FSClose (textFile);
		return;
	}  /*  if  */
	if (ioCheckOK (FSRead (textFile, &dataSize, *tHandle)))		/*  Datei lesen  */
	{
		err = FSClose (textFile);
		return;
	}  /*  if  */
	HLock (tHandle);					/*  im Speicher festsetzen  */
	err = FSClose (textFile);			/*  Datei wieder schlieen  */
	oldFront = FrontWindow ();
	winDoNew ();				/*  neues Fenster erzeugen  */
	newFront = FrontWindow ();	/*  das ist das neue Fenster  */
	if (oldFront != newFront)	/*  hat anscheinend geklappt  */
	{
		SetPort (newFront);
		TESetText (*tHandle, dataSize, ((documentPeek) newFront)->docTE);	/*  Text bergeben  */
		SetWTitle (newFront, theFile.name);		/*  Fenstername = Dateiname  */
		winResizeScrolls (newFront);			/*  Scrollbalken anpassen  */
		winUpdateScrolls (newFront);
		((documentPeek) newFront)->isSaved = true;		/*  wir haben einen Namen  */
		((documentPeek) newFront)->savedFileSpec = theFile;	/*  merken wir uns den Namen  */
	}  /*  if  */
	DisposeHandle (tHandle);	/*  Puffer lschen  */
}  /*  ioOpenTextFSSpec  */

/*  ffne eine Textdatei fr den Benutzer in ein neues Fenster.  */
/*  Da wir nicht wissen, welche es sein soll, mu der Benutzer sie uns zeigen  */
void ioOpenTextFile (void)
{
	SFTypeList				theTypes;
	StandardFileReply			answer;				

	theTypes [0] = 'TEXT';		/*  nur TEXT-Dateien ffnen  */
	StandardGetFile (NIL, 1, theTypes, &answer);		/*  der Benutzer zeigt uns, welche Datei er will  */
	if (answer.sfGood)	/*  Benutzer hat NICHT abgebrochen  */
	{
		ioOpenTextFSSpec (answer.sfFile);
	}  /*  if  */
	
}  /* ioOpenTextFile */

/*  speichere den Inhalt des Textfensters in eine Datei  */
void ioSaveTextFile (WindowPtr theWindow)
{
	documentPeek		doc;
	FSSpec			myFileSpec;
	short			textFile;
	Handle			tHandle;
	long				dataSize;
	OSErr			err;
	
	doc = (documentPeek) theWindow;
	if (!doc->isSaved )		/*  hat noch keinen Namen!  */
		ioSaveAsTextFile (theWindow);
	else
	{
		myFileSpec = doc->savedFileSpec;
		err = FSpOpenDF (&myFileSpec, fsCurPerm, &textFile);	/*  Data-fork ffnen  */
		if (err != noErr)		/*  Fehler!  */
		 {	/*  alte Datei konnte nicht mehr geffnet werden  */
		 	ioSaveAsTextFile (theWindow);		/*  neu sichern  */
		 	return;
		 }  /*  if  */
		tHandle = (Handle) TEGetText (((documentPeek) theWindow)->docTE);
		dataSize = GetHandleSize (tHandle);
		if (ioCheckOK (FSWrite (textFile, &dataSize, *tHandle)))		/*  Datei schreiben  */
		{
			err = FSClose (textFile);	
			return;
		}  /*  if  */
		err = SetEOF (fsFromStart, dataSize);		/*  Lnge der Datei anpassen  */
		err = FSClose (textFile);					/*  kein Dispose (tHandle) ntig !!!  */
		((documentPeek) theWindow)->needSave = false;	/*  wir haben ja gerade gesichert  */
	}  /*  else  */
}  /* ioSaveTextFile */

/*  speichere den Inhalt des Textfensters in eine Datei  */
/*  dabei wird der Benutzer nach dem Namen und dem Speicherort gefragt  */
void ioSaveAsTextFile (WindowPtr theWindow)
{
	StandardFileReply			answer;
	Str255					prompt, name;
	OSErr					err;
	short					textFile;
	Handle					tHandle;
	long						dataSize;
	
	GetIndString(prompt, kIOStrings, kSavePrompt);
	GetWTitle (theWindow, name);		/*  Vorgabe fr den Dateinamen  */
	StandardPutFile(prompt,name,&answer);
	if (answer.sfGood)			/*  Der Benutzer hat auf "Sichern" geklickt  */
	{
		if (answer.sfReplacing)		/*  wir ersetzen  */
			err = FSpDelete (&answer.sfFile);		/*  alte Datei lschen  */
		if (ioCheckOK (FSpCreate(&answer.sfFile,kCreator ,kTextType,answer.sfScript)))
			return;
		if (ioCheckOK (FSpOpenDF (&answer.sfFile, fsCurPerm, &textFile)))	/*  Data-fork ffnen  */
		 	return;	
		tHandle = (Handle) TEGetText (((documentPeek) theWindow)->docTE);
		dataSize = GetHandleSize (tHandle);
		if (ioCheckOK (FSWrite (textFile, &dataSize, *tHandle)))		/*  Datei schreiben  */
		;
		err = FSClose (textFile);			/*  kein Dispose (tHandle) ntig !!!  */
		SetWTitle (theWindow, answer.sfFile.name);	/*  vom Benutzer gewhlten Namen in das Fenster  */
		((documentPeek) theWindow)->needSave = false;	/*  wir haben es ja gerade gesichert  */
		((documentPeek) theWindow)->isSaved = true;		/*  wir haben einen Namen  */
		((documentPeek) theWindow)->savedFileSpec = answer.sfFile;	/*  merken wir uns den Namen  */
	}  /*  if  */
}  /* ioSaveAsTextFile */

/*  hier wird geprft, ob es sich bei der angegebenen Datei um eine Textdatei handelt  */
Boolean ioIsTextFile (FSSpec theFile)
{
	Boolean	result;
	FInfo	fileInfo;
	OSErr	myErr;
	
	result = false;
	myErr = FSpGetFInfo (&theFile, &fileInfo);
	if (myErr == noErr)
		result = (fileInfo.fdType == kTextType);
	return result;
}  /*  ioIsTextFile  */

/*  ffne die Datei(en), die der Finder ber AppleEvents angibt  */
OSErr ioOpenDocs (AppleEvent messageIn)
{
	OSErr		result, myErr;
	AEDescList	docList;
	long		numItems, index;
	Size		actualSize;
	AEKeyword	keywd;
	FSSpec		myFSS;
	DescType	returnedType;
	
	result = noErr;
	myErr = AEGetParamDesc (&messageIn, keyDirectObject, typeAEList, &docList);  /*  hole die Liste der Parameter  */
	if (myErr == noErr)
	{
		myErr = AECountItems (&docList, &numItems);  /*  soviele Elemente hat die Parameterliste  */
		for (index = 1; index <= numItems; index++)
		{			/*  jeden Parameter aus der Liste herausholen  */
			myErr = AEGetNthPtr (&docList, index, typeFSS, &keywd, &returnedType, &myFSS, sizeof (myFSS), &actualSize);
			if ((myErr == noErr) && ioIsTextFile (myFSS))	/*  und, wenn alle geklappt hat, die Datei ffnen  */
				ioOpenTextFSSpec (myFSS);
			else result = myErr;
		}  /*  for  */
		myErr = AEDisposeDesc (&docList);  /*  die Liste wieder lschen  */
	}	/*  if  */
	return result;
}  /*  ioOpenDocs  */

/*  drucke die Datei(en), die der Finder ber AppleEvents angibt  */
OSErr ioPrintDocs (AppleEvent messageIn)
{
	OSErr		result, myErr;
	AEDescList	docList;
	long		numItems, index;
	Size		actualSize;
	AEKeyword	keywd;
	FSSpec		myFSS;
	DescType	returnedType;
	
	result = noErr;
	myErr = AEGetParamDesc (&messageIn, keyDirectObject, typeAEList, &docList);
	if (myErr == noErr)
	{
		myErr = AECountItems (&docList, &numItems);	/*  wieviele Dateien sind in der Liste enthalten?  */
		for (index = 1; index <= numItems; index++)
		{
			myErr = AEGetNthPtr (&docList, index, typeFSS, &keywd, &returnedType, &myFSS, sizeof (myFSS), &actualSize);
			if ((myErr == noErr) && ioIsTextFile (myFSS))
			{
				ioOpenTextFSSpec (myFSS);		/*  die angegebene Datei ffnen...  */
				prPrintWin ();					/*  ...ausdrucken...  */
				winDoClose (FrontWindow ());	/*  ...und wieder schlieen  */
			}  /*  if  */
			else result = myErr;
		}  /*  for  */
		myErr = AEDisposeDesc (&docList);		/*  weg mit der Liste  */
	}	/*  if  */
	return result;
}  /*  ioPrintDocs   */

/*  hier werden die Adressen in eine Datei in dem Preferences-  */
/*  Ordner im Systemordner gespeichert  */
void ioSaveAddresses (addrRecord *theAddrs, short number)
{
	Str255	fileName;
	short	fRefNum;	/*  Reference Number des Volumes  */
	long	fldDirID;			/*  Directory ID des Ordners  */
	short	theFile;		/*  das ist die Datei  */
	OSErr	err;
	long	amount;
	
	GetIndString(fileName, kIOStrings, kAddressFile);  /*  das ist der Dateiname  */
	err = FindFolder (kOnSystemDisk, kPreferencesFolderType, kCreateFolder, &fRefNum, &fldDirID);
	if (err == noErr)
	{
		err = HOpen (fRefNum, fldDirID, fileName, fsRdWrPerm, &theFile);
		if (err == fnfErr)  /*  Datei wurde nicht gefunden, mu also erzeugt werden  */
		{
			if (ioCheckOK (HCreate (fRefNum, fldDirID, fileName, kCreator, kAddrType)))
				return;
			err = HOpen (fRefNum, fldDirID, fileName, fsRdWrPerm, &theFile);
		}  /*  if  */
		amount = sizeof (addrRecord) * number;
		if (ioCheckOK (FSWrite (theFile, &amount, (Ptr) theAddrs)))
		;
		err = SetEOF (theFile, amount);	/*  Gre der Datei anpassen  */
		err = FSClose (theFile);		/*  Datei schlieen  */
		err = FlushVol (nil, fRefNum);	/*  Cache auf die Platte schreiben  */
	}  /*  if  */
}  /*  ioSaveAddresses  */

/*  hier werden die Adressen aus der Adressdatei geladen, falls vorhanden  */
void ioLoadAddresses (addrRecord **theAddrs, short *number, short *addrAlloc)
{
	Str255	fileName;
	short	fRefNum;	/*  Reference Number des Volumes  */
	long	fldDirID;			/*  Directory ID des Ordners  */
	short	theFile;		/*  das ist die Datei  */
	OSErr	err;
	long	amount;
	
	GetIndString(fileName, kIOStrings, kAddressFile);  /*  Dateiname laden  */
	*number = 0;
	err = FindFolder (kOnSystemDisk, kPreferencesFolderType, kCreateFolder, &fRefNum, &fldDirID);
	if (err == noErr)
	{
		err = HOpen (fRefNum, fldDirID, fileName, fsRdWrPerm, &theFile);
		if (err == fnfErr)  /*  Datei wurde nicht gefunden, mu erzeugt werden  */
			return;
		err = GetEOF (theFile, &amount);		/*  so gro ist die Datei  */
		*number = amount / sizeof (addrRecord);	/*  so viele Eintrge haben wir  */
		if (*number > *addrAlloc)				/*  ist schon soviel Platz reserviert?  */
		{
				SetHandleSize ((Handle) theAddrs, (*number + 10) * sizeof (addrRecord));
				if (MemError () != noErr)		/*  Fehler: nicht genug Speicher  */
					errorHandler (kNotEnoughMemory, true);
				*addrAlloc = *number + 10;
		}  /*  if  */
		if (ioCheckOK (FSRead (theFile, &amount, (Ptr) *theAddrs)))
		;
		err = FSClose (theFile);		/*  Datei schlieen  */
	}  /*  if  */
}  /*  ioLoadAddresses  */