// Datei "addr.c"  Modul fr die Adressendatenbank

#include <AppleEvents.h>
#include "globals.h"
#include "util.h"
#include "io.h"
#include "addr.h"

/*  dies sind die Dialogelemente im Adressenfenster  */
#define		kAddrNewItem	1	/*  Neu  */
#define		kAddrEditItem	2	/*  ndern  */
#define		kAddrDeleteItem	3	/*  Lschen  */
#define		kAddrListItem	4	/*  die Liste  */

#define		kAddrSize	sizeof (addrRecord)

/*  Globale Variablen fr die Adressenverwaltung  */
DialogPtr	addrDialog;		/*  Dialog mit der Liste  */
ListHandle	addrList;		/*  die Liste  */
Rect		addrListRect;	/*  Rechteck des Listenfeldes im Dialog  */
RgnHandle	addrListRegion;	/*  Region mit eben diesem Rechteck  */
short		addrAllocated;	/*  so viele Adressen sind im Speicher mglich  */
short		addrUsed;		/*  so viele Adressen sind in Gebrauch  */
addrRecord	**addrBuffer;	/*  hier stehen die Adressen im Speicher  */
Boolean		addrIsActive;	/*  ist das Fenster aktiv oder nicht?  */
UserItemUPP	addrListProc;	/*  das ist die Update-Funktion fr das Listenelement  */

/*  hier wird das Dialogfenster geladen und die Liste vorbereitet  */
void addrInit(void)
{
	Handle	dItem;
	Rect	dataBounds;
	Point	cSize;
	short	dType;
	short	i;
	short	dummy, len;
	Ptr		theData;
	
	addrBuffer =  (addrRecord **) NewHandleClear (5 * kAddrSize);
	if (addrBuffer == nil)
		errorHandler (kNotEnoughMemory, true);  /*  nicht genug Speicher da  */
	HLock ((Handle) addrBuffer);			/*  im Speicher festlegen  */
	addrAllocated = 5;	/*  5 Eintrge reserviert  */
	addrUsed = 0;		/*  keine Eintrge belegt  */
	ioLoadAddresses (addrBuffer, &addrUsed, &addrAllocated);
	setupDialog (kAddressDialog, &addrDialog);	/*  Dialogfeld laden  */
	SetRect (&dataBounds, 0, 0, 1, 0);			/*  Anzahl der Spalten  */
	SetPt (&cSize, 0, 0);
	GetDialogItem (addrDialog, kAddrListItem, &dType, &dItem, &addrListRect);  /*  Daten des Listenelements  */
	addrListProc = NewUserItemProc (addrListUpdate);
	SetDialogItem (addrDialog, kAddrListItem, dType, (Handle) addrListProc, &addrListRect); /*  Update-Prozedur einhngen  */
	addrList = LNew (&addrListRect, &dataBounds, cSize, 0, (WindowPtr) addrDialog, false, false, false, true);
	if (addrList == nil)
		errorHandler (kNotEnoughMemory, true);  /*  nicht genug Speicher da  */
	HLock ((Handle) addrList);
	SetRect (&addrListRect, addrListRect.left -1, addrListRect.top - 1, addrListRect.right +16, addrListRect.bottom +1);
	InvalRect (&addrListRect);		/*  damit dieser Bereich spter neu gezeichnet wird  */
	addrListRegion = NewRgn ();
	if (addrListRegion == nil)		/*  war genug Speicher frei?  */
		errorHandler (kNotEnoughMemory, true);  /*  nein! */
	RectRgn (addrListRegion, &addrListRect);
	(*addrList)->selFlags = lOnlyOne | lNoRect;		/*  immer nur ein Eintrag auswhlbar  */
	for (i=0; i<addrUsed; i++)		/*  alle Eintrge in die Liste bernehmen  */
	{
		dummy = LAddRow (1, i+1, addrList);
		SetPt (&cSize, 0, i);	/*  diese Zelle soll gendert werden  */
		len = (*addrBuffer)[i].aName[0];	/*  Lnge des Namens  */
		theData = (Ptr) &(*addrBuffer)[i].aName[1];	/*  Zeiger auf den Namen  */
		LSetCell (theData, len, cSize, addrList);
	}  /*  for  */
	LDoDraw (true, addrList);
	HUnlock ((Handle) addrBuffer);
	addrIsActive = false;
}  /*   addrInit  */

/*  hier werden die Mens angepat, je nachdem, ob das Fenster vorne ist  */
void addrAdjustMenus (void)
{
	MenuHandle	addrMenu;

	addrMenu = GetMHandle (kAddrMenu);
	if (FrontWindow () == addrDialog)	/*  ist das Adressenfenster vorne?  */
	{
		EnableItem (addrMenu, kAdMNewAddr);
		if (addrListSelected () >= 0)	/*  ist ein Eintrag ausgewhlt?  */
		{
			EnableItem (addrMenu, kAdMEditAddr);
			EnableItem (addrMenu, kAdMDeleteAddr);
			EnableItem (addrMenu, kAdMMerge);
		}  /*  if  */
		else
		{
			DisableItem (addrMenu, kAdMEditAddr);
			DisableItem (addrMenu, kAdMDeleteAddr);
			DisableItem (addrMenu, kAdMMerge);
		}  /*  else  */	
	}  /*  if  */
	else
	{
		DisableItem (addrMenu, kAdMNewAddr);
		DisableItem (addrMenu, kAdMEditAddr);
		DisableItem (addrMenu, kAdMDeleteAddr);
		DisableItem (addrMenu, kAdMMerge);
	}  /*  else  */
}  /*  addrAdjustMenus  */

/*  hier wird eine neue Adresse in die Liste und das Array aufgenommen  */
void addrAdd (addrRecord theAddr)
{
	short	len, i;
	Ptr		theData;
	short	index, dummy;
	Point	cSize;
	
	/*  zuerst die Adresse in die Datenstruktur aufnehmen  */
	if (addrUsed == addrAllocated)  /*  reservierter Speicher ist voll, mehr belegen  */
	{
		SetHandleSize ((Handle) addrBuffer, (addrAllocated + 10) * kAddrSize);
		if (MemError () != noErr)		/*  Fehler: nicht genug Speicher  */
		{
			errorHandler (kNotEnoughMemory, false);
			return;
		}  /*  if  */
		addrAllocated = addrAllocated + 10;
	}  /*  if  */
	HLock ((Handle) addrBuffer);
	/*  jetzt wird der Name in alphabetischer Reihenfolge eingefgt  */
	index = addrUsed;
	for (i=0; i < addrUsed; i++)
		if (IUCompString ((*addrBuffer)[i].aName, theAddr.aName) == 1)
			{
				BlockMoveData (&(*addrBuffer)[i], &(*addrBuffer)[i+1], kAddrSize * (addrUsed - i));
				index = i;			/*  an dieser Stelle fgen wir ein!  */
				i = addrUsed;		/*  zum Verlassen der Schleife  */
			}  /*  if  */
	(*addrBuffer)[index] = theAddr;
	HUnlock ((Handle) addrBuffer);
	addrUsed++;	/*  eine Adresse mehr  */
	/*  jetzt noch die neue Adresse in die Liste einfgen  */
	len = theAddr.aName[0];	/*  Lnge des Namens  */
	theData = (Ptr) &theAddr.aName[1];  /*  Ptr auf den Namen  */
	dummy = LAddRow (1, index, addrList);  /*  Zeile einfgen  */
	SetPt (&cSize, 0, index);
	LSetCell (theData, len, cSize, addrList);  /*  Zeile mit Namen versehen  */	
}  /*  addrAdd  */

/*  hier wird ein Eintrag aus dem Array und der Liste entfernt  */
void addrDelete (short theEntry)
{
	/*  zuerst die Adresse aus der Liste entfernen  */
	LDelRow (1, theEntry, addrList);
	/*  jetzt die Adresse aus dem Speicher entfernen  */
	if (theEntry < addrUsed)	/*  es ist nicht der letzte Eintrag  */
	{
		HLock ((Handle) addrBuffer);	
		BlockMoveData (&(*addrBuffer)[theEntry+1], &(*addrBuffer)[theEntry], (addrUsed - theEntry) * kAddrSize);
		HUnlock ((Handle) addrBuffer);
	}  /*  if  */
	addrUsed--;	/* eine Adresse weniger  */
}  /*  addrDelete  */

/*  hier wird ermittelt, welches Listenelement, wenn berhaupt, angeklickt ist */
/*  liefert die Nummer (ab 0) zurck, -1, wenn nichts gewhlt ist  */
short addrListSelected (void)
{
	short	result;
	Cell	start;
	
	result = -1;
	SetPt (&start, 0, 0);			/*  oben anfangen zu suchen  */
	if (LGetSelect (true, &start, addrList))	/*  ist ein Element ausgewhlt?  */
		result = start.v;
	return result;
}  /* addrListSelected */

/*  wird aufgerufen, wenn ein Men ausgewhlt wurde und in diesem besonderen Fall auch, wenn */
/*  ein Dialogelement angeklickt wurden, weil die Numerierung hier bereinstimmt  */
void addrDoMenu (short theItem)
{
	short		result, entry, len, index;
	addrRecord	temp;
	long		dummy;
	char		scrapData [kAddrSize];
	char		cr = 13;		/*  carriage return  */
	
	switch (theItem)			/*  welches Dialogelement oder welcher Meneintrag wurde gewhlt?  */
	{
		case kAdMNewAddr:		/*  neue Adresse anlegen  */
			temp.aName[0] = 0;		/*  mit leeren Texten vorbelegen  */
			temp.aCity[0] = 0;
			temp.aStreet[0] = 0;
			temp.aPhone[0] = 0;
			result = addrEditAddress (&temp);
			if (result == 1)		/*  Benutzer hat auf OK geklickt  */
				addrAdd (temp);
			break;
		case kAdMEditAddr:		/*  Adresse bearbeiten  */
			entry = addrListSelected ();
			HLock ((Handle) addrBuffer);
			temp = (*addrBuffer)[entry];
			HUnlock ((Handle) addrBuffer);
			result = addrEditAddress (&temp);
			if (result == 1)
			{
				addrDelete (entry);		/*  alten Eintrag lschen  */
				addrAdd (temp);			/*  neuen Eintrag einfgen  */
			}  /*  if  */
			break;
		case kAdMDeleteAddr:	/*  Adresse lschen  */
			entry = addrListSelected ();	/*  welche Adresse ist markiert?  */
			HLock ((Handle) addrBuffer);
			ParamText ((*addrBuffer)[entry].aName,"\p","\p","\p");
			HUnlock ((Handle) addrBuffer);
			result = StopAlert (kDeleteAlert, nil);	/*  Soll sie wirklich gelscht werden?  */
			if (result == 2)		/*  wirklich lschen !  */
				addrDelete (entry);
			break;
		case kAdMMerge:			/*  gesamte Adresse in die Zwischenablage kopieren  */
			entry = addrListSelected ();
			HLock ((Handle) addrBuffer);
			temp = (*addrBuffer)[entry];
			dummy = ZeroScrap ();	/*  Zwischenablage erst mal lschen  */
			index = 0;
			len = temp.aName [0];	/*  den Namen bernehmen  */
			BlockMoveData (&temp.aName[1], &scrapData[index], len);
			index = index + len + 1;
			BlockMoveData (&cr, &scrapData[index - 1], 1);	/*  cr einfgen  */
			len = temp.aStreet [0];	/*  die Strae bernehmen  */
			BlockMoveData (&temp.aStreet[1], &scrapData[index], len);
			index = index + len + 1;
			BlockMoveData (&cr, &scrapData[index - 1], 1);	/*  cr einfgen  */
			len = temp.aCity [0];	/*  die Stadt bernehmen  */
			BlockMoveData (&temp.aCity[1], &scrapData[index], len);
			index = index + len + 1;
			BlockMoveData (&cr, &scrapData[index - 1], 1);	/*  cr einfgen  */
			len = temp.aPhone [0];	/*  die Telefonnummer bernehmen  */
			BlockMoveData (&temp.aPhone[1], &scrapData[index], len);
			index = index + len + 1;
			BlockMoveData (&cr, &scrapData[index - 1], 1);	/*  cr einfgen  */
			PutScrap (index, 'TEXT', scrapData);	/*  ab in die Zwischenablage damit  */
			HUnlock ((Handle) addrBuffer);
			break;
		default:
			break;
	}  /*  switch  */
}  /*  addrDoMenu  */

/*  hier wird ein Textedit-Feld eines Dialoges mit einem Text vorbelegt  */
void addrSetText (DialogPtr theDialog, short item, Str255 theText)
{
	short	iType;
	Rect	itemRect;
	Handle	iHandle;
	
	GetDialogItem (theDialog, item, &iType, &iHandle, &itemRect);
	SetDialogItemText (iHandle, theText);
}  /*  addrSetText  */

/*  hier wird der Text aus einem Textedit-Feld eines Dialoges gelesen  */
void addrGetText (DialogPtr theDialog, short item, Str255 theText)
{
	short	iType;
	Rect	itemRect;
	Handle	iHandle;
	
	GetDialogItem (theDialog, item, &iType, &iHandle, &itemRect);
	GetDialogItemText (iHandle, theText);
}  /*  addrGetText  */

/*  hier wird eine Adresse bearbeitet  */
short addrEditAddress (addrRecord *theAddr)
{
	DialogPtr	editDialog;
	short		itemHit;
	OSErr		myErr;
	
	setupDialog (kEditAddrDialog, &editDialog);
	myErr = SetDialogDefaultItem (editDialog, 1);
	myErr = SetDialogCancelItem (editDialog, 2);
	myErr = SetDialogTracksCursor (editDialog, true);
	addrSetText (editDialog, 4, theAddr->aName);	/*  Textfelder vorbelegen  */
	addrSetText (editDialog, 6, theAddr->aStreet);
	addrSetText (editDialog, 8, theAddr->aCity);
	addrSetText (editDialog, 10, theAddr->aPhone);
	do
	{
		ModalDialog (NIL, &itemHit);
	} while (itemHit > 2);
	if (itemHit == 1)  /*   Benutzer hat OK gedrckt  */
	{
		addrGetText (editDialog, 4, theAddr->aName);
		addrGetText (editDialog, 6, theAddr->aStreet);
		addrGetText (editDialog, 8, theAddr->aCity);
		addrGetText (editDialog, 10, theAddr->aPhone);
	}  /*  if  */
	DisposeDialog (editDialog);
	InitCursor ();
	SetPort (addrDialog);	/*  damit immer ein gltiger Port da ist!  */
	return itemHit;
}  /*  addrEditAddress  */

/*  hier wird die Liste aktualisiert, wenn ein Update-Event eintrifft  */
pascal void addrListUpdate (DialogPtr theDialog, short theItem)
{
	GrafPtr		oldPort;
	
	GetPort (&oldPort);
	SetPort (theDialog);
	InvalRect (&addrListRect);				/*  damit der ganze Bereich neu gezeichnet wird  */
	BeginUpdate (theDialog);				/*  Window Manager Bescheid sagen  */
	FrameRect (&addrListRect);				/*  Rahmen um das Feld malen  */
	LUpdate (addrListRegion, addrList);		/*  List Manager updaten lassen  */
	EndUpdate (theDialog);
	SetPort (oldPort);
}  /* addrListUpdate */

void addrHandleItemHit (short theItem)
{
	addrDoMenu (theItem);		/*  nur, weil die Elemente die gleiche Nummer haben !!!!  */
}  /* addrHandleItemHit */

/*  ein Button des Dialoges wird aktiviert oder deaktiviert, also grau dargestellt  */
void enableDialogItem (DialogPtr theDialog, short theItem, Boolean isActive)
{
	Rect	itemRect;
	Handle	dItem;
	short	dType;
	
	GetDialogItem (theDialog, theItem, &dType, &dItem, &itemRect);
	if (isActive)
		HiliteControl ((ControlHandle) dItem, 0);
	else
		HiliteControl ((ControlHandle) dItem, 255);
}  /*  enableDialogItem  */

void addrEventDispatch (EventRecord *theEvent)
{
	short		theSelected;
	Boolean		dummy, doActivate;
	Point		where;

	if (FrontWindow () == addrDialog)		/*  ist der Dialog vorne?  */
	{
		SetPort (addrDialog);		/*  damit ein gltiger Grafport da ist!  */
		if (theEvent->what == mouseDown)
		{
			where = theEvent->where;		/*  wo war der Klick?  */
			GlobalToLocal (&where);		/*  in lokale Koordinaten umrechnen  */
			dummy = LClick (where, theEvent->modifiers, addrList);  /*  dem List-Manager den Klick geben  */
		}  /*  if  */
		if ((theEvent->what == updateEvt) && ((DialogPtr) theEvent->message == addrDialog))
			addrListUpdate (addrDialog, kAddrListItem);
		theSelected = addrListSelected ();
		enableDialogItem (addrDialog, kAddrEditItem, theSelected >= 0);	/*  ndern   */
		enableDialogItem (addrDialog, kAddrDeleteItem, theSelected >= 0);	/*  Lschen  */
	}  /*  if  */
	doActivate = (isInFront ()) && (FrontWindow () == addrDialog);	/*  mssen wir aktivieren?  */
	if (doActivate != addrIsActive)				/*  ndert sich der Zustand?  */
	{
		LActivate (doActivate, addrList);		/*  erledigt der List-Manager  */
		addrIsActive = doActivate;
	}  /*  if  */
}  /* addrEventDispatch */

void addrClose (void)
{
	DisposeDialog (addrDialog);		/*  Dialogfenster schlieen  */
	HLock ((Handle) addrBuffer);
	ioSaveAddresses (*addrBuffer, addrUsed);  /*  Adressen speichern  */
	HUnlock ((Handle) addrBuffer);
}  /*  addrClose  */