PROGRAM ClrMouse;
{ (c) by Beat Schenk und c't 1/95                         }
{ Betrieb einer seriellen Maus an Notebooks mit Trackball }
{ Turbo Pascal ab 6.0                                     }
USES Crt,Dos;  { Fr SetIntVec }

CONST cIRET = 207;       { Opcode fr Interrupt Return }
      cBIOSSeg = $F800;  { Segmentadresse des ROM-BIOS }
      cMouseInt = $33;   { Interrupt fr Mausabfrage }

VAR comBase: ARRAY [1..4] OF WORD ABSOLUTE $40:$00;
    nCom,code: INTEGER;

FUNCTION MouseConnected (n: BYTE): BOOLEAN;
{ Testet die CTS- und DSR-Pins an der Schnittstelle }
BEGIN
  MouseConnected := port [comBase [n] +6] AND $30 <> 0;
END;

FUNCTION GetIRET: POINTER;
{ Irgendein IRET im ROM-BIOS finden (geht immer) }
VAR n: WORD;
BEGIN
  n := 0;
  WHILE mem [cBIOSSeg:n] <> cIRET DO Inc (n);  
  GetIRET := Ptr (cBIOSSeg,n);
END;

PROCEDURE CheckTaste;
{ Fragt fr 5s ob externe Maus gewnscht }
VAR   ticker:longint absolute $40:$6C;
      altticker,tick:longint;
      ch:char;
CONST tickmax:longint=5*18;
BEGIN
  Write ('Externe Maus aktivieren (J/N)? ');
  tick:=0; ch:='N'; altticker:=ticker;
  REPEAT
    IF KeyPressed THEN BEGIN
      ch:=readkey; tick:=tickmax;
    END;
    IF ticker <> altticker THEN inc (tick);
    altticker:=ticker;
  UNTIL tick>=tickmax;
  IF UpCase(ch)='J' THEN BEGIN
    SetIntVec (cMouseInt,GetIRET);
    WriteLn ('Serielle Maus aktiviert.');
  END;
END;

BEGIN
  WriteLn (#10,#13,'CLRMOUSE (C) by Beat Schenk & c''t 1/95');
  Val (ParamStr (1),nCom,code);
  IF (code = 0) AND (nCom >= 1) AND (nCom <= 4) THEN
    IF MouseConnected (nCom) THEN BEGIN
      { Trackballfunktionen abhngen }
      SetIntVec (cMouseInt,GetIRET);
      WriteLn ('Serielle Maus an COM',nCom,' gefunden:');
      WriteLn ('Der Maustreiber kann geladen werden.');
    END ELSE WriteLn ('Keine Maus an COM',nCom,' gefunden.')
  ELSE CheckTaste;
  WriteLn;
END.
