/* pm_print.c : Hilfsfunktionen zum Drucken ber die GPI           */

#include <malloc.h>
#include <string.h>

#define INCL_PM 
#include <os2.h>

#include "pm_print.h"    



/*****************************************************************************/
/* Liefert den Namen des Standard-Druckers                                   */
/* Der fr den Namen reservierte Speicher mu vom Aufrufer wieder freigesetzt*/
/* werden mit free()                                                         */
/*****************************************************************************/
PSZ QueryDefaultPrinter(VOID)
{
  PSZ pch;
  ULONG ulLength;      
  BOOL  fRet;
  LONG  lRetLen = 0L;
  PSZ   pszPrfStr = NULL;
  PSZ   pszPrtName= NULL;

  /*--------- Gre fr Namensstring erfragen -------------------------------*/
  fRet = PrfQueryProfileSize(HINI_PROFILE,           /* - INI file handle  */
			     "PM_SPOOLER",           /* Application name  */
			     "PRINTER",              /* key name */
			     &ulLength);             /* Rckgabe: Datenlnge*/

  if (fRet && ulLength!=0)
    pszPrfStr = (PSZ) malloc((SHORT)ulLength);

  if (pszPrfStr != NULL)                 /* Name Standarddrucker erfragen */
    lRetLen = PrfQueryProfileString(HINI_PROFILE,
				    "PM_SPOOLER",
				    "PRINTER",
				    "",               /* default String */
				    pszPrfStr,        /*zurckgeg. String*/
				    ulLength);        /* max Lnge */

  if (lRetLen !=0) {
    pch = strchr(pszPrfStr,';');                /* Semikolon als Ende suchen */
    if ((pch != NULL) && (pch != pszPrfStr)) {      /* Name existiert */
      pszPrtName = pszPrfStr;
      *pch = '\0';                              /* Null Terminiert */
    }
  }

  if (pszPrtName==NULL)
    free(pszPrfStr);

  return pszPrtName;
}   /* Ende QueryDefaultPrinter */


/*****************************************************************************/
/* erfragt Drucker-Port, default queue, default driver und device-Namen und  */
/* zustzliche queue, driver und device Namen */
/* Der fr den zurckgegebenen Portnamen pszStr = QueryPrinterInfo(...)      */
/* mu vom Aufrufer mit free() freigegeben werden                            */
/* die Rckgabestrings, auf die nur die Zeiger gesetzt   werden, sind alle   */
/* Teile des Rckgabestrings der Funktion, haben also keinen Speicher        */
/* assoziiert                                                                */
/*****************************************************************************/
PSZ QueryPrinterInfo(PSZ pszPrtName,          /* Druckername */
		     PSZ *pszDefQ,            /* default queue name */
		     PSZ *pszDefDrv,          /* default PrinterDriver */
		     PSZ *pszDefDev,          /* default device name */
		     PSZ *pszAddlQs,
		     PSZ *pszAddDrvDvs)       /* add. driver.device names */
{
  PSZ  pch;
  ULONG  ulLength;
  BOOL   fRet;
  PSZ    pszStart;
  LONG   lRetLen = 0L;
  PSZ    pszPrfStr = NULL;
  PSZ    pszPort   = NULL;
  PSZ    pszDefDrvLc1 = NULL;
  PSZ    pszDefQLc1  = NULL;
  PSZ    pszAddlQsLc1 = NULL;
  PSZ    pszAddDrvDvsLc1 = NULL;
  PSZ    pszDefDevLc1 = NULL;

  /*--------- erfragt die Gre fr user- und system profile Daten ----------*/
  fRet = PrfQueryProfileSize(HINI_PROFILE,
			     "PM_SPOOLER_PRINTER",
			     pszPrtName,
			     &ulLength);
  /*--------- reserviert Speicher dafr  ------------------------------------*/
  if (fRet && ulLength!=0L)
    pszPrfStr = malloc(ulLength);

  /*--------- erfragt den String mit profile-data ---------------------------*/
  if (pszPrfStr != NULL)
    lRetLen = PrfQueryProfileString(HINI_PROFILE,
				    "PM_SPOOLER_PRINTER",
				    pszPrtName,
				    "",
				    pszPrfStr,
				    ulLength);

  /*----------- Die einzelnen Rckgabezeiger werden auf Teile des Strings */
  /* gesetzt, sind also nicht selbst mit Speicher verbunden               */
  /* den String in drei Null-terminierte String aufteilen: */
  /* port name */
  /* driver.device_names (begining with the defaukt driver ) */
  /* queue_names (beginning with default queue */
  if (lRetLen != 0) {
    pszStart = pszPrfStr;
    pch = strchr(pszStart,';');
    if (pch == NULL || pch==pszStart) {
      free (pszPrfStr);
      return NULL;
    }
    pszPort = pszStart;
    *pch = '\0';

    pszStart = ++pch;
    pch = strchr(pszStart, ';');
    if (pch == NULL || pch==pszStart) {
      free (pszPrfStr);
      return NULL;
    }
    *pch = '\0';
    pszDefDrvLc1 = pszStart;

    pszStart = ++pch;
    pch = strchr(pszStart, ';');
    if (pch == NULL || pch==pszStart) {
      free (pszPrfStr);
      return NULL;
    }
    *pch = '\0';
    if (pch != pszStart)
      pszDefQLc1 = pszStart;

    /* Queue names in zwei Strings, den def queue name und die additls. */

    pszStart = pszDefQLc1;
    pch = strchr(pszStart,',');
    if (pch!=NULL) {
      *pch = '\0';
      pszAddlQsLc1 = ++pch;
    }

    /* dito fr driver names */

    pszStart = pszDefQLc1;
    pch = strchr(pszStart,',');
    if (pch!=NULL) {
      *pch = '\0';
      pszAddDrvDvsLc1 = ++pch;
    }

    /* default driver.device String in 2 zerlegen: def driver name */
    /*                                       : dev device name or 0 if none */

    pszStart = pszDefDrvLc1;
    pch = strchr(pszStart,'.');
    if (pch!=NULL) {
      *pch = '\0';
      pszDefDevLc1 = ++pch;
    }
  }
  if (pszDefDrv!=NULL)
    *pszDefDrv = pszDefDrvLc1;
  if (pszDefQ!=NULL)
    *pszDefQ = pszDefQLc1;
  if (pszAddlQs!=NULL)
    *pszAddlQs = pszAddlQsLc1;
  if (pszAddDrvDvs != NULL)
    *pszAddDrvDvs = pszAddDrvDvsLc1;
  if (pszDefDev!=NULL)
    *pszDefDev = pszDefDevLc1;

  return pszPort;
}  /* Ende Printer-Info */



/*****************************************************************************/
/* Liefert die DRIVDATA-Struktur fr angegebenen Treiber, Device und Drucker */
/* benutzt DevPostDeviceModes()                                              */
/* Der Aufrufer mu den Speicher mit free(pdrivDataRet); freigeben           */
/*****************************************************************************/
BOOL PostDeviceModes(HAB hab,                   /* Anchor block handle */
		     PDRIVDATA *pdrivDataRet,   /* Zeiger auf Rckdaten */
		     PSZ pszDriver,             /* Driver name */
		     PSZ pszDevice,             /* Device name */
		     PSZ pszPrinter,            /* Printer name */
		     BOOL UserDialog)           /* Show Dialog or not */
{
  LONG        lLength;
  BOOL        fRet = FALSE;
  PDRIVDATA   pdrivData = NULL;
  ULONG       ulOptions;

  *pdrivDataRet = NULL;                         /* Rckgabezeiger init. */

  if (UserDialog)
    ulOptions = DPDM_CHANGEPROP;
  else
    ulOptions = DPDM_QUERYJOBPROP;
  lLength = DevPostDeviceModes(hab,
			       NULL,            /* DIRVDATA POINTER:frage */
			       pszDriver,
			       pszDevice,
			       pszPrinter,
			       ulOptions);

  if (lLength != DPDM_ERROR && lLength!=DPDM_NONE)
    pdrivData = malloc(lLength);

  if (pdrivData != NULL)
    fRet = DevPostDeviceModes(hab,
			      pdrivData,
			      pszDriver,
			      pszDevice,
			      pszPrinter,
			      ulOptions);

  if (fRet)
    *pdrivDataRet = pdrivData;
  else 
    free(pdrivData);

  return fRet;
}  /* Ende PostDeviceModes() */




/***************************************************************************/
/* ffnet Standarddrucker (hdc), schickt StartDoc-Escapesequenz, so da    */
/* nur noch ein PS erzeugt werden mu */
/* Parameter :   hab      Anchor Block handle                              */
/*             UserDialog: jobeigenschaftsdialog zeigen oder nicht         */
/* Rckgabe  :   hdc      DC-Handle zum Drucker oder DEV_ERROR             */
/***************************************************************************/
HDC OpenDefaultPrinter(HAB hab, BOOL UserDialog)
{
  PSZ  pszPrinter;
  PSZ  pszDefQ;
  PSZ  pszDefDrv;
  PSZ  pszDefDev;
  PDRIVDATA pdrivData;
  DEVOPENSTRUC dopData;
  PSZ  pszPort = NULL;
  HDC hdc = DEV_ERROR;
  BOOL fRet = FALSE;

  pszPrinter = QueryDefaultPrinter(); /* Erfrage Namen des Standarddruckers */

  if (pszPrinter!=NULL)                      /* Queue,TreiberDevicename etc.*/
    pszPort = QueryPrinterInfo(pszPrinter,
			       &pszDefQ,
			       &pszDefDrv,
			       &pszDefDev,
			       NULL,
			       NULL);
  
  if (pszPort != NULL)
    fRet = PostDeviceModes(hab,                 /* DRIVDATA besorgen */
			   &pdrivData,
			   pszDefDrv,
			   pszDefDev,
			   pszPrinter,
			   UserDialog);

  dopData.pszLogAddress = pszDefQ;
  dopData.pszDriverName = pszDefDrv;
  dopData.pdriv = pdrivData;
  dopData.pszDataType = "PM_Q_STD";
  dopData.pszComment = " Standard-Drucken";
  dopData.pszQueueProcName = NULL;
  dopData.pszQueueProcParams = "COL=C XFM=0";
  dopData.pszSpoolerParams = NULL;
  dopData.pszNetworkParams = NULL;

  if (fRet)
    hdc = DevOpenDC(hab,
		    OD_QUEUED,
		    "*",
		    9L,
		    (PDEVOPENDATA)&dopData,
		    NULLHANDLE);

  free(pszPrinter);
  free(pszPort);
  free(pdrivData);

  return hdc;
}  /* Ende OpenDefaultPrinter() */


/****************************************************************************/
/* Schliet den mit OpenDefaultPrinter() geffneten Standarddrucker         */
/****************************************************************************/
BOOL CloseDefaultPrinter(HDC hdc)
{
  BOOL fRet;

  if (hdc != DEV_ERROR)
    fRet = (DevCloseDC(hdc) != DEV_ERROR);

  return fRet;
} /* Ende CloseDefaultPrinter() */



