
/*** pm_cgrs.c **********/
/* Direkte implementation der Systemabhngigen aufrufe von curves.c */
/* fr Presentation-Manager, ein solches File mit allen Funktionen */
/* mu fr alle Devices verfgbar sein */

/* !!! spter soll hier auch die Initialisierung und das Verlassen des */
/* devices fr bestimmte Flle, z.B. TeX, untergrbracht werden */

#include <string.h>

#define INCL_GPILCIDS
#define INCL_GPIPRIMITIVES
#define INCL_GPITRANSFORMS
#include <os2.h>

#include "pm_cgrs.h"

/**** Fr Koordinatensystem, Hintergrund und Vordergrundfarbe werden ****/
/**** ber die Konstanten MCLR_*** ausgewhlt und je nach device     ****/
/**** anders interpretiert                                           ****/
static unsigned PMTransformColor(unsigned color)
{
  unsigned newcolor;

  switch(color) {
  case MCLR_FORGROUND:
    newcolor = (unsigned) CLR_BLACK;
    break;
  case MCLR_BACKGROUND:
    newcolor = (unsigned) CLR_WHITE;
    break;
  default:                 /* Falls unbekannt, Index einfach weiterreichen*/ 
    newcolor = color;
    break;
  }/* switch(color) Ende */
  return newcolor;
}

/*********************************************************************************/
/* Justierte Textausgabe fr den PM, sollte mit allen Fonts arbeiten             */
/*********************************************************************************/
void PMText(long x,long y, char *text, int xadj, int yadj, HPS hps)
{
  POINTL ptl;
  FONTMETRICS fm;

    if (!GpiQueryFontMetrics(hps, (LONG) sizeof(fm), &fm)) {
      ShowErrorMsg("pm_cgrs.h:PMText() GpiError.");
      return;
    }
    ptl.x = x;
    ptl.y = y;
    switch(xadj) {
    case T_LEFT: 
      break;
    case T_CENTER:
      ptl.x -= PMQueryTextLength(text,hps)/2;
      break;
    case T_RIGHT:
      ptl.x -= PMQueryTextLength(text,hps);
      break;
    }  /* Ende switch xadj */

    switch(yadj) {
    case T_LOWER:
      ptl.y +=  fm.lMaxDescender;
      break;
    case T_UPPER:
      ptl.y -=   fm.lMaxAscender ; 
      break;
    case T_MIDDLE:
      ptl.y -= (fm.lLowerCaseAscent/2);
      break;                     
    } /* Ende switch yadj */
    GpiCharStringAt(hps,&ptl,(long) strlen(text),text);

} /* Ende PMText() */


/********************************************************************************/
/* Maximale Texthhe fr aktuellen Zeichensatz erfragen                         */
/********************************************************************************/
int PMQueryMaxCharHeight(HPS hps)
{
  FONTMETRICS fm;

    if (!GpiQueryFontMetrics(hps, (LONG) sizeof(fm), &fm)) {
      ShowErrorMsg("pm_cgrs.c:PMQUeryMaxCharHeight() GpiError.");
      return 0;
    }
    return(fm.lMaxBaselineExt);

} /* Ende PMQueryMaxCharHeight() */

/**********************************************************************************/
/* mittlere Zeichenbreite                                                         */
/**********************************************************************************/
int PMQueryAvCharWidth(HPS hps)
{
  FONTMETRICS fm;

    if (!GpiQueryFontMetrics(hps, (LONG) sizeof(fm), &fm)) {
      ShowErrorMsg("pm_cgrs.c:PMQUeryAvCharWidth() GpiError.");      
      return 0;
    }
    return(fm.lAveCharWidth);

} /* Ende PMQueryAvCharWidth() */

/***********************/
/* Lnge eines Strings */
/************************/
int PMQueryTextLength(char *text, HPS hps)
{
  POINTL aptl[TXTBOX_COUNT];

    if (!GpiQueryTextBox(hps,(long) strlen(text),text,TXTBOX_COUNT,aptl)) {
      ShowErrorMsg("pm_cgrs.c:PMQUeryTextLength() GpiError.");      
      return 0;
    }
    return(aptl[3].x - aptl[1].x);
} /* Ende PMQueryTextLength */




