#include <owl.h>
#include <windows.h>
#include "bms.h"
#include <commdlg.h>
#include <sys\stat.h>
#include <stdio.h>
#include <dir.h>
#include <string.h>


// Copyright (C) 1994, Manfred Rieg, Johannes A. Wohlrab


TBildVerarbeitung::TBildVerarbeitung( LPSTR ATitle, LPSTR MenuName ) : TMDIFrame(ATitle, MenuName)
{
  memset(&szDirName, 0, sizeof(szDirName));
  szDirName[0]='.';
}


void TBildVerarbeitung::SetupWindow()
{
  TMDIFrame::SetupWindow();
};


void TBildVerarbeitung::GetWindowClass( WNDCLASS& WndClass )
{
  TWindow::GetWindowClass(WndClass);
};





void TBildVerarbeitung::CMFileOpen( TMessage& )
{
  OPENFILENAME ofn;

  szFile[0] ='\0';
       
  memset(&ofn, 0, sizeof(OPENFILENAME));
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = HWindow;
  ofn.lpstrFilter = "Bitmap (*.BMP)\0*.bmp\0";
  /* szFilter;*/
  ofn.nFilterIndex = 1;
  ofn.lpstrFile = szFile;
  ofn.nMaxFile = sizeof(szFile);
  ofn.lpstrFileTitle = szFileTitle;
  ofn.nMaxFileTitle = sizeof(szFileTitle);
  ofn.lpstrInitialDir = szDirName;
  ofn.Flags =  OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;

  if (GetOpenFileName(&ofn))
  {
    BITMAPFILEHEADER bfh;
    int DateiHandle = _lopen(ofn.lpstrFile,OF_READ);
    _lread(DateiHandle, &bfh, sizeof(bfh));
    _lclose(DateiHandle);

    if (HIBYTE(bfh.bfType)!='M' && LOBYTE(bfh.bfType)!='B') return;

    char drive[MAXDRIVE];
    char dir[MAXDIR];
    char file[MAXFILE];
    char ext[MAXEXT];
    char Dirnamen[256];

    HANDLE handle =GlobalAlloc(GMEM_MOVEABLE,bfh.bfSize);

    if (handle==NULL)
    {
      MessageBeep(0);
      MessageBox(HWindow,"Nicht gengend Speicher zum ffnen der Bitmap","Hauptfenster",MB_ICONINFORMATION | MB_OK);
      return;
    }
    GlobalFree(handle);
    _splitpath((char far *)ofn.lpstrFile,drive,dir,file,ext);
    strcpy(Dirnamen,drive);
    strcat(Dirnamen,dir);

    for(int i=0;i<sizeof(Dirnamen);i++)
    {
      if (Dirnamen[i]==0x00)
      {
	Dirnamen[i-1]=0x00;
        break;
      }
    }
    strcpy(szDirName ,Dirnamen);

    GetApplication()->MakeWindow(new TBitWindow(this, ofn.lpstrFile,ofn.lpstrFile));
  }
};



void TBildVerarbeitung::Quit( TMessage& )
{
  TMDIFrame:CloseWindow();
};







_CLASSDEF(TApp)
class TApp : public TApplication
{
public :
	TApp (LPSTR AName, HANDLE
		AnInstance, HANDLE APrevInstance, LPSTR 
		ACmdLine, int ACmdShow) : TApplication  ( AName, 
		AnInstance, APrevInstance, ACmdLine, ACmdShow){};
	virtual void InitMainWindow();
};


void TApp::InitMainWindow()
{
  MainWindow = new TBildVerarbeitung ("Bitmap verkleinern","MENU_1");
}

int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance, LPSTR lpCmdLine,
	int nCmdShow)
{
  TApp App("Bitmap verkleinern" ,hInstance ,hPrevInstance, lpCmdLine, nCmdShow);
  App.Run();
  return App.Status; 
}

