// Low-Memory-Monitor via Toolhelp
// ct 11/94, ps

#include <windows.h>
#include "execnick.h"
#include "toolhelp.h"

typedef DWORD (CALLBACK* DWFARPROC)(void);

HANDLE              hInst;
HMODULE             hSystem;
HWND                hWndMain;
LPFNNOTIFYCALLBACK  lpMyNotify= NULL;
DWFARPROC           lpLowMemReport= NULL;

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, 
                    LPSTR lpCmdLine, int nCmdShow)
{   MSG         msg;
    WNDCLASS    wc;
    HMENU       hSysMenu;
    
    // Mu nur einmal laufen ...
    hInst= hInstance;
    if ( hPrevInstance)
    {   MessageBeep( 0);
        return NULL;
    }
    
    // Windows-Vorgeplnkel fr Fenster
    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor( NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject( WHITE_BRUSH);
    wc.lpszMenuName =  NULL;
    wc.lpszClassName = MAINCLASSNAME;
    if (!RegisterClass(&wc))
        return( FALSE);
    
    hWndMain= 
        CreateWindow( MAINCLASSNAME, MAINWINDOWNAME, 
                      WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, 
                      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 
                      HWND_DESKTOP, NULL, hInstance, NULL);
    
    if (!hWndMain)
    {   UnregisterClass( MAINCLASSNAME, hInstance);
        return ( FALSE);
    }
    
    // Dynamisch zum System-"Ersatz" linken (falls vorhanden)
    hSystem= GetModuleHandle( SYSHOOKNAME);
    if ( hSystem)
        lpLowMemReport= 
            (DWFARPROC)GetProcAddress( hSystem, SYSHOOKFUNC);
    
    // "Unwichtiges" aus dem System-Men entfernen
    hSysMenu= GetSystemMenu( hWndMain, FALSE);
    DeleteMenu( hSysMenu, SC_SIZE, MF_BYCOMMAND);
    DeleteMenu( hSysMenu, SC_MAXIMIZE, MF_BYCOMMAND);
    DeleteMenu( hSysMenu, SC_MINIMIZE, MF_BYCOMMAND);
    DeleteMenu( hSysMenu, SC_RESTORE, MF_BYCOMMAND);
        
    // Fenster auf den Schirm bringen ...
    ShowWindow(hWndMain, SW_SHOWMINIMIZED);
    
    // Aufforderung erlassen aktuelle Daten anzuzeigen
    PostMessage( hWndMain, WM_SYSCOMMAND, SM_REFRESH, 0);

    // Nachrichtenschleife aufsetzen
    while ( GetMessage( &msg, NULL, NULL, NULL))
    {   TranslateMessage( &msg);
        DispatchMessage( &msg);
    }
    return ( msg.wParam);
}

// Fensterprozedur bearbeitet Nachrichten 
long FAR PASCAL MainWndProc(HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam)
{   switch (message)
    {   case WM_QUERYOPEN:
    		return NULL;
    	case WM_SYSCOMMAND:
            switch ( wParam)
            {   // verhindert Vergrern des Fensters
                case SC_MAXIMIZE:
                case SC_MINIMIZE:
                case SC_RESTORE:    
                    return NULL;
                case SM_REFRESH:
                    RefreshTitle();
                    return NULL;
            }
            break;
        // Beim Anlegen Toolhelp-Notify registrieren
        case WM_CREATE:
            InstallNotifyProc();
            return NULL;
        // Beim Beenden Notify "abmelden"
        case WM_DESTROY:
            DeInstallNotifyProc();
            PostQuitMessage(0);
            return NULL;
    }
    // den Rest Windows auftragen
    return ( DefWindowProc( hWnd, message, wParam, lParam));
}

// Windows Frei-Liste via Toolhelp abarbeiten
DWORD AvailableLowMem( void)
{   
    GLOBALENTRY ge;
    DWORD       dwFree= 0;
    
    ge. dwSize= sizeof( GLOBALENTRY);
    if ( GlobalFirst( &ge, GLOBAL_ALL))
        do
            // alle freien oder beweglichen Segmente
            // gelten als "frei"
            if ((( ge. wType == GT_FREE) ||
                 ( ge. wcLock == 0)) &&
                ( ge. dwAddress < (DWORD)0xfffff))
                dwFree+= ge. dwBlockSize; 
        while ( GlobalNext( &ge, GLOBAL_ALL));
    return dwFree;
}               
    
// Benachrichtigungs-Callback bei Toolhelp registrieren
void InstallNotifyProc( void)
{   lpMyNotify= (LPFNNOTIFYCALLBACK)
        MakeProcInstance( (FARPROC)&ToolHelpNotify, hInst);
    if ( !lpMyNotify)
        return;
    if ( !NotifyRegister( NULL, lpMyNotify, NF_NORMAL))
        FreeProcInstance( lpMyNotify);
}

// Benachrichtigungs-Callback "abmelden"
void DeInstallNotifyProc( void)
{   if ( lpMyNotify)    
    {   NotifyUnRegister( NULL); 
        FreeProcInstance( (FARPROC)lpMyNotify);
    }
}

// Icon-Text mit dem noch freien Low-Memory fllen
void RefreshTitle( void)
{   char    szTitle [20];

    wsprintf( (LPSTR)&szTitle, "%lu", AvailableLowMem());
    
    // ggf. auch die Gre des Reservoirs des neuen System-
    // Treibers dabei bercksichtigen   
    if ( lpLowMemReport)
        wsprintf( (LPSTR)&szTitle, "%s (%lu)", 
                  (LPSTR)&szTitle, lpLowMemReport());
    SetWindowText( hWndMain, (LPSTR)&szTitle);
}

// Toolhelp Notify-Proc, so da das freie Low-Memory bei jedem
// Applikationsstart und -Ende abgezeigt wird ...
BOOL CALLBACK ToolHelpNotify( WORD wID, DWORD dwData)
{   if (( wID == NFY_STARTTASK) ||
        ( wID == NFY_EXITTASK))
        PostMessage( hWndMain, 
                     WM_SYSCOMMAND, (WPARAM)SM_REFRESH, 0);
    return FALSE;
}