{
+----------------------------------------------------------+
 TOMO.PAS                                                 
 Simulation einer tomographischen Aufnahme                
 :c L. Wenzel u. c't 10/94                                
+----------------------------------------------------------+
}

program TOMO;

uses
  GRAPH,CRT;


const
  LINKS         =     0; {Graphikfenster definieren}
  OBEN          =     0;
  RECHTS        =   639;
  UNTEN         =   479;

  X_OBJEKT      =   180; {Positionen der Bezeichnungen}
  Y_OBJEKT      =   130;
  X_FILM        =   180;
  Y_FILM        =   370;

  RADIUS        =   40;  {Maximum = 100}
  X_MOMENT      =   510;
  Y_MOMENT      =   130;
  X_SUMME       =   510;
  Y_SUMME       =   370;

  X_MITTE       =   380;
  UMLAUF        =   360; {entspricht den 360 Grad eines Umlaufes}
  DELTA         =     3; {Abstand des Sensors}

  O_X_R_1       =   0;
  O_Y_R_1       =   0;   {Relativkoordinaten des 1.Objektes}
  O_RADIUS_1    =   5;

  O_X_R_2       =  -7;
  O_Y_R_2       = -16;   {Relativkoordinaten des 2.Objektes}
  O_RADIUS_2    =   7;

  O_X_R_3       =  23;
  O_Y_R_3       =  -7;   {Relativkoordinaten des 3.Objektes}
  O_RADIUS_3    =   4;

  DICHTE        =   5;   {Farbinformation}
  KREIS         =   3;   {Darstellung der R-Quelle}

  SPRUNG        =   5;   {Winkel zwischen 2 Aufnahmen}
  EPSILON       = 0.0000001; {Vermeidung von Division durch 0}
  SCHRANKE      =   7;       {Schranke fr Bildverbesserung}


type
  Schwaerzung   =  array[-RADIUS..+RADIUS] of real;

var
  Winkel        : integer;
  X_Alt,Y_Alt,
  X_Neu,Y_Neu   : integer;
  Phi           : real;
  Objekt        : array[-RADIUS..+RADIUS,-RADIUS..+RADIUS] of byte;
                      {Dichtezahlen der Objekte}

  Summe         : array[-RADIUS..+RADIUS] of Schwaerzung;


{Initialisierung der Graphik}
procedure graph_init;
var
  Gd, Gm : integer;

begin
  Gd := Detect;
  {passenden Path angeben}
  InitGraph(Gd, Gm, 'e:\turbo\bgi');
  if GraphResult <> grOk then Halt(1);
end;


{Ursprungsbild zeichnen}
procedure aufbau;
var
  I, J, K : integer;

begin
  rectangle(LINKS,OBEN,RECHTS,UNTEN);
  line(X_MITTE,OBEN,X_MITTE,UNTEN);
  outtextxy(X_OBJEKT-RADIUS-30,Y_OBJEKT-RADIUS-40,'Tomographie-Aufnahme');
  circle(X_OBJEKT,Y_OBJEKT,RADIUS);
  outtextxy(X_FILM-RADIUS-30,Y_FILM-RADIUS-20,'Spur auf dem Film');
  circle(X_FILM,Y_FILM,RADIUS+2);
  outtextxy(X_MOMENT-RADIUS-30,Y_MOMENT-RADIUS-40,'Aufsummiertes Bild');
  circle(X_MOMENT,Y_MOMENT,RADIUS+2);
  outtextxy(X_SUMME-RADIUS-30,Y_SUMME-RADIUS-20,'Verbessertes Bild');
  circle(X_SUMME,Y_SUMME,RADIUS+2);
  setcolor(YELLOW);
  setlinestyle(SolidLn,1,3);
  arc(X_OBJEKT,Y_OBJEKT,0,1,RADIUS+DELTA);
  setcolor(WHITE);
  setlinestyle(SolidLn,0,1);
  setcolor(WHITE);
  for I:=1 to 16 do
    for J:=1 to 10 do
      for K:=1 to 5 do
        putpixel(30+J,30+10*I+K,I);
end;


{Schnittpunkte berechnen}
function punkte(X,X1:integer;A,B,O_X,O_Y,O_R:real):real;
var
  W1,W2  : real;

begin
  if (X<>X1) then
  begin
    W1:=(O_R*O_R-O_X*O_X-(B-O_Y)*(B-O_Y))*(1+A*A);
    W1:=W1+(O_X+A*O_Y-A*B)*(O_X+A*O_Y-A*B);
    if (W1<=0) then W2:=0
    else
    W2:=W1;
  end
  else
  begin
    W1:=O_R*O_R-(X1-O_X)*(X1-O_X);
    if (W1<=0) then W2:=0
    else
    W2:=W1;
  end;
  punkte:=W2;
end;


{Lnge der durchstrahlten Materie ermitteln}
function schnitt(X,Y:integer):real;
var
  M,N    : integer;
  X1,Y1  : integer;
  X2,Y2  : integer;
  A,B,C1,C2,C3  : real;
  Alles1,Alles2,
  Alles3         : real;

begin
  X1:=round((RADIUS+DELTA)*cos(2*Pi*Winkel/UMLAUF));
  Y1:=round((RADIUS+DELTA)*sin(2*Pi*Winkel/UMLAUF));

  A:=(Y1-Y)/(X1-X+EPSILON);
  B:=(Y*X1-Y1*X)/(X1-X+EPSILON);

  C1:=punkte(X,X1,A,B,O_X_R_1,O_Y_R_1,O_RADIUS_1);
  if (C1<=0) then Alles1:=0
  else
    Alles1:=2*Sqrt(C1/(1+A*A));

  C2:=punkte(X,X1,A,B,O_X_R_2,O_Y_R_2,O_RADIUS_2);
  if (C2<=0) then Alles2:=0
  else
    Alles2:=2*Sqrt(C2/(1+A*A));

  C3:=punkte(X,X1,A,B,O_X_R_3,O_Y_R_3,O_RADIUS_3);
  if (C3<=0) then Alles3:=0
  else
    Alles3:=2*Sqrt(C3/(1+A*A));

  schnitt:=Alles1+Alles2+Alles3;
end;


{Fehler definieren und zeichnen}
procedure objekte;
var
  I, J : integer;  {Laufvariable}

begin
  for I:=-RADIUS to +RADIUS do
    for J:=-RADIUS to +RADIUS do
      Summe[I][J]:=0;

  for I:=-RADIUS to +RADIUS do
    for J:=-RADIUS to +RADIUS do
    begin
      if ((I-O_X_R_1)*(I-O_X_R_1)+(J-O_Y_R_1)*(J-O_Y_R_1)
          <=O_RADIUS_1*O_RADIUS_1) then
        putpixel(X_OBJEKT+I,Y_OBJEKT+J,DICHTE);
      if ((I-O_X_R_2)*(I-O_X_R_2)+(J-O_Y_R_2)*(J-O_Y_R_2)
          <=O_RADIUS_2*O_RADIUS_2) then
        putpixel(X_OBJEKT+I,Y_OBJEKT+J,DICHTE);
      if ((I-O_X_R_3)*(I-O_X_R_3)+(J-O_Y_R_3)*(J-O_Y_R_3)
          <=O_RADIUS_3*O_RADIUS_3) then
        putpixel(X_OBJEKT+I,Y_OBJEKT+J,DICHTE);

    end;
end;


{Aktuelles Projektionsergebnis zeichnen}
procedure strahlen;
var
  I, J   : integer;
  Wert   : real;
  X1,Y1  : integer;

begin
  for I:=-RADIUS to +RADIUS do
    for J:=-RADIUS to +RADIUS do
    begin
        if (I*I+J*J-1>RADIUS*RADIUS) then
        Wert:=0
        else Wert:=schnitt(I,J);
        if (Wert>0) then
        putpixel(X_FILM+I,Y_FILM+J,round(Wert));
        Summe[I][J]:=Summe[I][J]+Wert;
    end;
end;


{Pixelfarben fr nchste Runde lschen}
procedure loeschen;
var
  I, J : integer;

begin
  for I:=-RADIUS to +RADIUS do
    for J:=-RADIUS to +RADIUS do
    begin
      if (I*I+J*J-1<=RADIUS*RADIUS) then
        putpixel(X_FILM+I,Y_FILM+J,0);
    end;
end;


{Skalierung und Darstellung der momentanen Rekonstruktion}
procedure summierung;
var
  I, J    : integer;
  Maximal : real;
  Wert    : real;

begin
  Maximal:=0;
  for I:=-RADIUS to +RADIUS do
    for J:=-RADIUS to +RADIUS do
    begin
      if Summe[I][J]>Maximal then
        Maximal:=Summe[I][J];
    end;
  for I:=-RADIUS to +RADIUS do
    for J:=-RADIUS to +RADIUS do
    begin
      if (I*I+J*J-1<=RADIUS*RADIUS) then
      begin
        Wert:=15*Summe[I][J]/Maximal;
        if Wert>0 then
          putpixel(X_MOMENT+I,Y_MOMENT+J,round(Wert));
        if (Wert>SCHRANKE) then
          putpixel(X_SUMME+I,Y_SUMME+J,round(Wert))
          else
            if Wert>0 then
              putpixel(X_SUMME+I,Y_SUMME+J,0);
      end;
    end;
end;


{*** HAUPTPROGRAMM ***}
begin
  graph_init;
  setcolor(WHITE);
  objekte;
  aufbau;

  X_ALT:=RADIUS{+O_RADIUS};
  Y_Alt:=0;

  {Winkelpositionen abfahren}
  for Winkel:=1 to UMLAUF do
  begin
    if (Winkel mod SPRUNG=0) then
    begin
      setcolor(WHITE);
      setlinestyle(SolidLn,0,1);
      setcolor(BLACK);
      circle(X_OBJEKT+X_Alt,Y_OBJEKT+Y_Alt,KREIS);
      setcolor(DICHTE);
      Phi:=+2*Pi*Winkel/UMLAUF;
      X_Neu:=round((RADIUS+DELTA+1)*cos(Phi));
      Y_Neu:=round((RADIUS+DELTA+1)*sin(Phi));
      circle(X_OBJEKT+X_Neu,Y_OBJEKT+Y_Neu,KREIS);
      setcolor(WHITE);

      X_Alt:=X_Neu;
      Y_Alt:=Y_Neu;

      {Ergebnisse zeichnen}
      strahlen;
      summierung;
      loeschen;
    end;
  end;
  readln;
end. 
