/*  WCLASSES 
    Thomas Hornschuh, 't 10/93
*/

#ifndef _wclasses_h
#define _wclasses_h

#ifndef __WINDOWS_H
#include <windows.h>
#endif


extern HINSTANCE hInstance;
extern HINSTANCE hPrevInstance;

typedef LONG (FAR _export PASCAL *LPWINPROC)(HWND,UINT,WPARAM,LPARAM);

class AbstractWindow;      // forward
class MetaClass; // forward
class MSGHashTable; // forward

const MAXCLASSES= 16;
const DefaultHashSize=37;


typedef LRESULT (AbstractWindow::*PMSGHandler)(UINT uMsg,WPARAM wParam,
                   LPARAM lParam);


#define DECL_HANDLER(Msg) \
  LRESULT Handle##Msg(UINT,WPARAM,LPARAM)

#define DEF_HANDLER(Class,Msg) \
  LRESULT Class::Handle##Msg(UINT uMsg,WPARAM wParam,LPARAM lParam)

#define MAP_HANDLER(Class,Msg) \
  Message(Msg,PMSGHandler(&Class::Handle##Msg))



/* Neues Macro fuer MakeProcInstance, in aeltere WCLASSES.H einzufuegen */

#if defined(__DLL__) || defined(SMARTCALLBACKS)

#define MakeProcInstance(lpProc,hInstance) (lpProc)
#define FreeProcInstance(lpProc) // nothing
#endif

#define HINSTPARAM HINSTANCE hInstance=NULL



#include "wclsbas.h"



class WindowClass : public MetaClass {
protected:
  HCURSOR hDefaultCursor;
  ATOM ClassName;
  HINSTANCE hOwnerInstance;

  virtual MessageMap *CreateOwnMessageMap();

public:
  WindowClass(char * const pClassName,
         HINSTANCE hInstance,
         HICON hIcon=HICON(-1),
         HCURSOR hCursor=HCURSOR(-1),
         const char * pMenuName=NULL,
         WORD style=CS_DBLCLKS,
         HBRUSH hbrBackground=HBRUSH(COLOR_WINDOW+1),
         WORD cbExtraBytes=0,
         LPWINPROC lpWinProc=NULL);
  ~WindowClass();

  inline BOOL IsRegistered() { return ClassName!=0; }
  char * GetName();
  inline HCURSOR GetCursor() { return hDefaultCursor; }
  inline HCURSOR SetCursor(HCURSOR hCursor);
  inline ATOM GetClassAtom() { return ClassName; }
  inline HANDLE GetOwner() { return hOwnerInstance; }


  static  WindowClass* ClassArray[MAXCLASSES];
  static int Index;

  static WindowClass * FindClass(LPSTR lpClassName);

  virtual MessageMap *GetMap();

};


class Window : public AbstractWindow {
private:
  static WindowClass * lpDefaultClass;
  WindowClass * InitClass();
protected:
  HCURSOR WinCursor;

  void SetThis();
  Window();



/* "Cooked" Message Handlers */

  virtual void Destroy();
  virtual BOOL Paint(HDC hDC,BOOL fErase,LPRECT lprcPaint);
  virtual BOOL QueryClose();
  virtual void Command(UINT idItem,HWND hWndControl,WORD wNotification);



public:

  Window(char * pWindowName,
    DWORD dwStyle,
    int X,int Y,int nWidth,int nHeight,
    HWND hWndParent,HMENU hMenue,
    HINSTANCE hInstance=NULL,
    WindowClass * lpWClass=NULL
   );



  static Window * GetThis(HWND);
  inline HWND GetHandle() { return WinHandle; }
  inline BOOL Show(int nCmdShow) { return ShowWindow(WinHandle,nCmdShow); }
  virtual ~Window();
  virtual void Remove();

  void SetWinCursor(LPSTR lpszCursor);
  inline void SetWinCursor(HCURSOR hCursor) { WinCursor=hCursor; }


/* Message Handlers */


  DECL_HANDLER(WM_PAINT);
  DECL_HANDLER(WM_DESTROY);
  DECL_HANDLER(WM_CLOSE);
  DECL_HANDLER(WM_MOUSEMOVE);
  DECL_HANDLER(WM_COMMAND);

  virtual LRESULT CallDefProc(UINT msg,WPARAM wParam, LPARAM lParam);


  friend LRESULT WINAPI WinProc(HWND hWnd,UINT message,WPARAM,LPARAM);
};


class ToplevelWindow : public Window {
protected:
  virtual void Destroy();
public:
  ToplevelWindow(char *pCaption,WindowClass *pClass,
       HINSTANCE hInstance=NULL,
                 HMENU hMenu=NULL,
                 DWORD dwStyle=NULL,
       int x=CW_USEDEFAULT,int y=CW_USEDEFAULT,int w=CW_USEDEFAULT,
       int h=CW_USEDEFAULT):

       Window(pCaption,dwStyle|WS_OVERLAPPEDWINDOW,
         x,y,w,h,NULL,hMenu,hInstance,pClass)
  {

  }

};




#endif
