#define STRICT

#include "wclsinc.h"
#include "msghash.h"

HINSTANCE  hInstance;
HINSTANCE  hPrevInstance;


/* Implementierung der Klasse Windowclass. WindowClass ist die C++
   Entsprechnung in WClasses.zu einer registrierten Windows-Fensterklasse 
*/

/* Static Members */

int WindowClass::Index = -1;
WindowClass * WindowClass::ClassArray[MAXCLASSES];
WindowClass  * Window::lpDefaultClass=NULL;


/* Der Konstruktor von WindowClass registriert die Fensterklasse und trgt
   das WindowClass Objekt im Array ClassArray ein. Wie man im Headerfile
   sieht, ist fr die meisten Parameter ein Defaultwert vorgesehen.
   Meistens wird man eigene Fensterklassen registrieren um bei einem
   Toplevelwindow ein eigenes Icon anmelden zu knnen.

   Beachtung verdient der Parameter cbExtraBytes: Da WClasses selber
   2 oder 4 Extrabytes verwendet, ist die tatschliche registrierte
   Anzahl an Extrabytes um diesen Betrag grer als der bergebene
   Wert.

*/

WindowClass::WindowClass(char * const pClassName,
          HINSTANCE hInstance,          
          HICON hIcon,
          HCURSOR hCursor,
          const char * pMenuName,
          WORD style,
          HBRUSH hbrBackground,
          WORD cbExtraBytes,
                         LPWINPROC lpWinProc)
{
WNDCLASS wndClass;

  pMap=NULL;

  wndClass.style=style;
  wndClass.lpfnWndProc= (WNDPROC)(lpWinProc?lpWinProc:WinProc);

  wndClass.cbClsExtra=0;
#if defined(__LARGE__) || defined(__DLL__)
  wndClass.cbWndExtra=cbExtraBytes+4;
#else
  wndClass.cbWndExtra=cbExtraBytes+2;
#endif
  wndClass.hInstance=hInstance;
  wndClass.hIcon= (int(hIcon)== -1)?LoadIcon(NULL,IDI_APPLICATION):hIcon;
  wndClass.hCursor= NULL;
  wndClass.hbrBackground=hbrBackground;
  wndClass.lpszMenuName= (LPSTR)pMenuName;
  wndClass.lpszClassName= (LPSTR)pClassName;

  if (RegisterClass(&wndClass)) {
    hDefaultCursor=(int(hCursor)== -1)?LoadCursor(NULL,IDC_ARROW):hCursor;
    hOwnerInstance=hInstance;

    if (Index==MAXCLASSES) {
      UnregisterClass((LPCSTR)pClassName,hInstance);
      ClassName=0;
      return;
    }

    ClassArray[++Index]=this;
    ClassName=AddAtom(pClassName);

  } else
    ClassName=0;
}



/* WClasses verwendet als Standard-Cursor nicht den bei Windows registrierten
   Cursor, sondern einen eigenen, der sich in der Member-Variable
   hDefaultCursor befindet. Den Cursor den man mit WindowClass::SetCursor
   setzt, verwendet WClasses fr alle danach erzeugten Fenster der
   entsprechenden Klasse
*/

HCURSOR WindowClass::SetCursor(HCURSOR hCursor)
{
HCURSOR tmp;

   tmp=hDefaultCursor;
   hDefaultCursor=hCursor;
   return tmp;
}   


/* Gibt einen Pointer auf den Namen der Klasse zurck. Achtung:
   Es handelt sich um einen Pointer auf einen statischen Puffer
*/

char * WindowClass::GetName()
{
static char NameBuff[50];

  GetAtomName(ClassName,NameBuff,50);
  return NameBuff;
}  


WindowClass::~WindowClass()
{
int I;
BOOL found;

  if (ClassName) {
    UnregisterClass(GetName(),hOwnerInstance);
    I=0;
    found=FALSE;
    while (!found && I<=WindowClass::Index) {
      found = ClassArray[I]->GetClassAtom()==ClassName;
      if (!found) I++;
    }
    if (found)  {
      while (I<WindowClass::Index) {
   ClassArray[I]=ClassArray[I+1];
   I++;
      }
      WindowClass::Index--;
    }
    DeleteAtom(ClassName);
  }
}


WindowClass * WindowClass::FindClass(LPSTR lpClassName)
{
int I;
BOOL found;
ATOM aTemp;

    aTemp=FindAtom(lpClassName);
    if (!aTemp) return NULL;
    I=0;
    found=FALSE;
    while (!found && I<=WindowClass::Index) {
      found = WindowClass::ClassArray[I]->GetClassAtom()==aTemp;
      if (!found) I++;
    }
    if (found)
      return WindowClass::ClassArray[I];
    else
      return NULL;
}



/* Die folgende DefaultMessageMap wird von allen WindowClass Instanzen
   gemeinsam benutzt. Dadurch wird fuer WindowClass-Objekte, die keine
   eigenen Messages mappen kein MessageMap Objekt benoetigt. Dieses
   Vorgehen spart etwas Speicher */

/* Hier wird erstmal die Klasse DefaultMessageMap deklariert.
   Sie unterscheidet sich nur in ihrem Konstruktor von der Basisklasse
*/

class DefaultMessageMap : public MessageMap {
public:
  DefaultMessageMap()
  {
  /* Map Default Messages */

  MAP_HANDLER(Window,WM_PAINT);
  MAP_HANDLER(Window,WM_DESTROY);
  MAP_HANDLER(Window,WM_CLOSE);
  MAP_HANDLER(Window,WM_MOUSEMOVE);
  MAP_HANDLER(Window,WM_COMMAND);
  }
};


/* Hier wird das eigentliche Objekt deklariert */

DefaultMessageMap TheDefaultMap;


/* Die folgende virtuelle Methode uebergibt den richtigen MessageMap-Pointer */

MessageMap *WindowClass::GetMap()
{
  if (pMap) // instanzspezifische Map ?
    return pMap; // dann benutzen wir sie auch
  else
    return &TheDefaultMap; // ...sonst wird der Notnagel verwendet
}



MessageMap *WindowClass::CreateOwnMessageMap()
{
  return new DefaultMessageMap();
}


/* Default Constructor, erzeugt keine lauffhige Instanz der Klasse */

Window::Window()
{
  WinCursor=LoadCursor(NULL,IDC_ARROW);
}


/* Der Konstruktor erzeugt ein neues Fenster.
   Falls keine Windowklasse bergeben wurde, wird die Default Windowklasse
   von WClasses verwendet. Falls diese noch nicht registriert wurde,
   wird InitClass aufgerufen.
*/

Window::Window(char * pWindowName, DWORD dwStyle,
          int X,int Y, int nWidth,int nHeight,HWND hWndParent,
          HMENU hMenue,HINSTANCE hInst,WindowClass *lpWClass)

{
  if (!lpWClass && !Window::lpDefaultClass) {
    lpDefaultClass=InitClass();

    if (!Window::lpDefaultClass) {
      MessageBox(NULL,"Defaultwindoklasse konnte nicht registriert werden",NULL,
       MB_ICONEXCLAMATION | MB_OK);
      WinHandle=NULL;
      return;
    }
  }
  pMetaClass=(lpWClass)?lpWClass:lpDefaultClass;
  pMSGHashTable= pMetaClass->GetHashTable();
  WinHandle= CreateWindow(((WindowClass*)pMetaClass)->GetName(),
           pWindowName,dwStyle,
           X,Y,nWidth,nHeight,hWndParent,hMenue,
           (HINSTANCE)(hInst?hInst:lpWClass->GetOwner()), 
           (void FAR *)this);


  if (lpWClass)
    WinCursor=lpWClass->GetCursor();
  else
    WinCursor=LoadCursor(NULL,IDC_ARROW);
}



/* Speichere den This Pointer in den Window extra bytes */

void Window::SetThis()
{
WORD cbExtra=GetClassWord(WinHandle,GCW_CBWNDEXTRA);
#if defined(__LARGE__) || defined(__DLL__)
/* Large Modell Implementation */
  SetWindowLong(WinHandle,cbExtra-4,(LONG)this);
#else
  SetWindowWord(WinHandle,cbExtra-2,(WORD)this);
#endif
}



/* Hole den this Pointer auf das Fenster aus dem Window extra bytes */

Window* Window::GetThis(HWND WinHandle)
{
WORD cbExtra=GetClassWord(WinHandle,GCW_CBWNDEXTRA);
#if defined (__LARGE__) || defined(__DLL__)
  return (Window*)GetWindowLong(WinHandle,cbExtra-4);
#else
  return (Window*)GetWindowWord(WinHandle,cbExtra-2);
#endif
}


/* Erzeugt das Default WindowClass Objekt. Da ja durchaus mehrere
   verschiedene mit WClasses erzeugte Programme im System aktiv sein
   koennen. wird zur Vermeidung von Namenskonflikten der Klassenname
   algorithmisch aus dem Instance Handle der laufenden Instanz
   generiert */

WindowClass * Window::InitClass()
{
char DefaultName[16];
WORD style;

  style=CS_DBLCLKS;

  /* Erzeuge eindeutigen Klassennamen */

  wsprintf(DefaultName,"WClasses%i",hInstance);

  return new WindowClass(DefaultName,hInstance,HICON(-1),NULL,NULL,style);
}



/* Die Methode Remove soll aufgerufen werden, wenn ein Fenster vernichtet
   werden soll. WClasses entfernt automatisch auch das zugehoerige Window
   Objekt. Es sollte immer diese Methode anstatt des Destruktors aufgerufen
   werden, wenn man ein Fenster loswerden will. 
*/    

void Window::Remove()
{
  DestroyWindow(WinHandle);
}


/* Ruft die Default Windowprozedur auf. Wird von speziellen Klassen
   wie Control ueberladen
*/
 
LRESULT Window::CallDefProc(UINT msg,WPARAM wParam,LPARAM lParam)
{
  return DefWindowProc(WinHandle,msg,wParam,lParam);
}
  
   
/* Hier folgt nun die eigentlich Windowprozedur, die das Interface
   zwischen Windows und WClasses darstellt */

LRESULT FAR PASCAL _export WinProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam)
{
Window * w;

  if (message==WM_CREATE) {
#if defined (__LARGE__) || defined(__DLL__)
      w=(Window*)(LPCREATESTRUCT(lParam)->lpCreateParams);
#else
      w=(Window*)LOWORD(LPCREATESTRUCT(lParam)->lpCreateParams);
#endif
      w->WinHandle=hWnd;
      w->SetThis();
  } else
    w=Window::GetThis(hWnd);

  return AbstractWindow::AbstractWndProc(hWnd,w,message,wParam,lParam);

}


/* Message Handlers for Window */

DEF_HANDLER(Window,WM_PAINT)
{
PAINTSTRUCT ps;

    BeginPaint(WinHandle,&ps);
    Paint(ps.hdc,ps.fErase,&ps.rcPaint);
    EndPaint(WinHandle,&ps);
    return 0L;
}

DEF_HANDLER(Window,WM_DESTROY)
{
  Destroy();
  return 0L;
}


DEF_HANDLER(Window,WM_CLOSE)
{
  if (QueryClose()) DestroyWindow(WinHandle);
  return 0L;
}

DEF_HANDLER(Window,WM_MOUSEMOVE)
{
   SetCursor(WinCursor);
   return 0L;
}


DEF_HANDLER(Window,WM_COMMAND)
{
  Command(wParam,HWND(LOWORD(lParam)),HIWORD(lParam));
  return 0L;
}

/* "Cooked" Message Handlers for Window */
void Window::Destroy() {}

BOOL Window::Paint(HDC hDC,BOOL fErase,LPRECT lprcPaint)
{
  return TRUE;
}


BOOL Window::QueryClose()
{
  return TRUE;
}


void Window::Command(UINT idItem,HWND hWndControl,WORD wNotification)
{
}



/* Destructor */

Window::~Window()
{
}


void Window::SetWinCursor(LPSTR lpszCursor)
{
  WinCursor=LoadCursor(hInstance,lpszCursor);
}



void ToplevelWindow::Destroy()
{
  PostQuitMessage(0);
}
