
class MsgEntry {
public:
  UINT Message;
  PMSGHandler pHandler;
  inline void Set(UINT Msg,PMSGHandler pH)
  { Message=Msg; pHandler=pH; }  
};



class Bucket {
public:
  MsgEntry * pContents;
  int nSize;	  // Anzahl der Objekte in diesem Bucket
  Bucket() { nSize=0; pContents=NULL; }

  inline MsgEntry& operator[] (int index)
  { if (index<nSize)
      return pContents[index];
    else
      return Resize(index);
  }

  inline MsgEntry& NextFreeEntry() { return (*this)[nSize]; }

  MsgEntry& Resize(int nIndex);

}; 


class MSGHashTable {
protected:
  int nBuckets; // Groesse der Hashtabelle
  Bucket * pBuckets; // Zeiger auf Array von HashEntries
  MSGHashTable * pParentHashTable;
  PMSGHandler pDefaultHandler;

  inline int HashValue(UINT Message)
  {
    return ((Message >> 4) + (Message & 0x000F)) % nBuckets;
  }
public:
  MSGHashTable(PMSGHandler pDefHandler,int Size=DefaultHashSize);
  void AddMessage(UINT Message,PMSGHandler pHandler);
  PMSGHandler operator[](UINT Message);
  ~MSGHashTable();
};
