#include <windows.h>
#include "wclasses.h"
#include "msghash.h"
#include <memory.h>



MSGHashTable::MSGHashTable(PMSGHandler pDefHandler,int size)
{
  pBuckets= new Bucket[size];
  nBuckets=size;
  pParentHashTable=NULL;
  pDefaultHandler=pDefHandler;
}


MsgEntry& Bucket::Resize(int nIndex)
{
MsgEntry *pNew=new MsgEntry[nIndex+1];

   if (pContents) {
     memcpy(pNew,pContents,sizeof(MsgEntry)*nSize);
     delete pContents;
   }
   pContents=pNew;
   nSize=nIndex+1;
   return pContents[nIndex];
}





void MSGHashTable::AddMessage(UINT Message,PMSGHandler pHandler)
{
int I;

  Bucket &p=pBuckets[HashValue(Message)];
  for(I=0;I<p.nSize;I++)
    if (p[I].Message==Message) { // Dann gibt es bereits einen Eintrag
      p[I].Set(Message,pHandler);
      return;
    }
  /* Wenn wir hierher kommen, gibt es noch keinen */
  p.NextFreeEntry().Set(Message,pHandler);
}



PMSGHandler MSGHashTable::operator[](UINT Message)
{
Bucket &p=pBuckets[HashValue(Message)];
MsgEntry *m;
int I;

  if (p.nSize==0)
    if (pParentHashTable)
      return (*pParentHashTable)[Message];
    else
      return pDefaultHandler;

  /* Aus Peformancegruenden wird hier gemogelt: Anstatt ordentlich
     ueber den Operator [] von Bucket zu iterieren, wird die Struktur
     von Bucket direkt ausgenutzt und nur das erste Element "ordentlich"
     geholt */

  m=&p[0];
  for(I=0;I<p.nSize;I++) {
    if (m->Message==Message) return m->pHandler;
    m++;
  }
  /* Wenn Nachricht nicht gefunden: */
  return pDefaultHandler;
}



MSGHashTable::~MSGHashTable()
{
 delete pBuckets;
}
