Unit dma; { c't/A.S. 9/88 }
Interface

type masktyp=(sperr,frei);
const Cascade_mode      =$C0;
      Block_mode        =$80;
      Single_mode       =$40;
      Demand_mode       =$0;
      AdrDec            =$20;
      AdrInc            =0;
      Auto              =$10;
      Noauto            =0;
      Read_Tr           =8;
      Write_Tr          =4;
      Verify_Tr         =0;
      Mem_Mem           =1;
      Mem_IO            =0;
      DMA_page: array[0..15] of Byte =
       ($87,$83,$81,$82,$8B,$89,$8A,$8F,
        $83,$83,$83,$83,$83,$83,$83,$8F);
var
      Akt_DMA_Adr:      byte;
      Akt_DMA_word:     byte;
      Akt_DMA_Kanal:    byte;
      Akt_DMA_Page:     byte;
      DMA_Command,
      DMA_Status ,
      DMA_Request,
      DMA_Single_Mask,
      DMA_Mode,
      DMA_ff,
      DMA_Master_Clear,
      DMA_read_Temp,
      DMA_Clear_Mask,
      DMA_all_mask:     byte;

Procedure Next_page (max:word);
Procedure Select_DMA_Kanal (Kanal:byte);
Procedure Set_DMA_Adr (adresse:pointer);
Procedure Set_DMA_word (wort:word);
Function  Current_DMA_Adr :word;
Function  Current_DMA_word :word;
Procedure Set_DMA_mode(Modebyte:byte);
Procedure Set_DMA_mask (maske:masktyp);
Procedure Set_DMA_Command (Command:byte);
Procedure Set_DMA_Request (maske:masktyp);
Function  DMA_EOP :boolean;
Procedure refresh (ref:byte);

Implementation
type feldtyp=array[0..$FFF0] of Byte;
var DMA_Array:array[0..9] of Byte absolute DMA_Command;

Procedure Next_page (max:word);
var adresse, grenze :longint;
    skip            :^Feldtyp;
begin
  adresse:=seg (heapPtr^) * 16 + ofs(heapPtr^);
  grenze:=$10000+(adresse shr 16) shl 16;
  if memavail < grenze-adresse + max then
    begin
    write ('Fehler, Speicherplatz zu klein');
    exit;
    end;
   getmem (skip, word (grenze-adresse));
end;

Procedure Select_DMA_Kanal (Kanal:byte);
const DMA_0: array [0..9] of Byte =
             (8,8,9,$A,$B,$C,$D,$D,$E,$F);
var i:integer;
begin
Akt_DMA_kanal:=kanal;
Akt_DMA_adr :=2* (Akt_DMA_Kanal and 3);
Akt_DMA_word:=Akt_DMA_adr +1;
for I:=0 to 9 do DMA_array[I]:=DMA_0[I];
If Akt_DMA_Kanal > 3 then
  begin
  For I:= 0 to 9 do
  DMA_array[i] :=2*DMA_0[i]+$C0;
  Akt_DMA_adr  :=2*Akt_DMA_Adr+$C0;
  Akt_DMA_word :=2*Akt_DMA_word+$C0;
  end;
end;

procedure set_DMA_Adr (adresse:pointer);
var page,adr:word;
begin
 page:=seg(adresse^) shr 12;
 adr:=(seg(adresse^) and ($0FFF)) shl 4 + ofs(adresse^);
 if adr < ofs(adresse^) then inc (page);
 akt_DMA_page:=page;
 port [dma_page[akt_DMA_kanal]]:=page;
 port [dma_ff]:=0;
 port [akt_DMA_adr]:= lo(adr);
 port [akt_DMA_adr]:= hi(adr);
end;

Procedure set_DMA_word (wort:word);
begin
 port [DMA_ff]:=0;
 port [akt_DMA_word]:= lo(wort);
 port [akt_DMA_word]:= hi(wort);
end;

Function Current_DMA_Adr :word;
var hib,lob:word;
begin
 port [DMA_ff]:=0;
 lob:=port[akt_DMA_Adr]; hib:=port[akt_DMA_Adr];
 current_DMA_adr:=hib shl 8 + lob;
end;

Function Current_DMA_word :word;
var hib,lob:word;
begin
 port [DMA_ff]:=0;
 lob:=port[akt_DMA_word]; hib:=port[akt_DMA_word];
 current_DMA_word:=hib shl 8 + lob;
end;

Procedure set_dma_mode(Modebyte:byte);
begin
 port[DMA_mode]:=Modebyte + Akt_DMA_Kanal and 3
end;

Procedure Set_DMA_mask (maske:masktyp);
begin
if maske = sperr then
   port[dma_single_mask]:=akt_DMA_kanal and 3 +4;
if maske = frei then
   port[dma_single_mask]:=akt_DMA_kanal and 3;
end;

Procedure Set_DMA_Command (Command:byte);
begin
Port [DMA_Command]:=Command
end;

Procedure Set_DMA_Request (maske:masktyp);
begin
if maske=frei then
   Port[DMA_Request]:=4+(Akt_DMA_Kanal and 3);
if maske=sperr then
   Port[DMA_Request]:=(Akt_DMA_Kanal and 3)
end;

Function  DMA_EOP :boolean;
begin
DMA_EOP:=odd(Port[DMA_status] shr (Akt_DMA_Kanal and 3));
end;

Procedure refresh (ref:byte);
begin
if ref= 0 then port[$43]:=$74
else
  begin
  select_DMA_Kanal (0);
  set_DMA_Mask (sperr);
  set_dma_mode(Single_mode+AdrInc+auto+Read_Tr);
  set_dma_word($FFFF);
  set_dma_command(MEM_IO);
  set_DMA_Mask (frei);
  port[$43]:=$54;
  port[$41]:=ref;
  end;
end;
end.unit utility;
Interface { Hex-Umwandlung u. }

Procedure NOP; inline ($90);
Procedure CLI; inline ($FA);
Function Hexbyte (zahl:Byte):string;
Function hexword (zahl : INTEGER) : string;
Function AT:boolean;

Implementation

Function Hexbyte;
var i,j:byte;
Begin
i:=zahl mod 16 + $30; if i>$39 then i:=i+7;
j:=zahl div 16 + $30; if j>$39 then j:=j+7;
hexbyte:=chr(j)+chr(i);
end;

Function Hexword;
BEGIN
hexword:=hexbyte(hi(Zahl))+hexbyte(lo(Zahl));
END;

Function AT:boolean;
begin
AT:=Mem[$F000:$FFFE] = $FC
end;

End. { Utility }
Program dmatest;
{ c't/A.S. 9/88  nur PC oder AT, nicht PS/2!!! }
uses utility, DMA;
const timeout=$C000; { Bei Parity-Error timout erhhen }
type Feldtyp=array[0..$FF00] of Byte;
var  ziel,quelle :^Feldtyp;
     i:integer;
     timerwert:word;
     x,xu,xo:word;
     tn,t0:word;
     error:boolean;

Function mess
   (Modus:byte; len:word; kanal:byte; hard,soft:masktyp):word;
begin
cli;
refresh (0);  { kein Refresh beim Transfer }
if modus = Mem_Mem then
  begin
  select_DMA_Kanal(1);
  set_DMA_mask (sperr);
  set_DMA_Mode (Block_Mode+AdrInc+Noauto+Write_Tr);
  set_DMA_adr (ziel);
  set_DMA_word (len-1);
  set_DMA_mask(frei);
  kanal:=0;
  end;
Select_DMA_Kanal (kanal);
set_DMA_mask (sperr);
set_Dma_Request(sperr);
set_DMA_adr (quelle);
set_DMA_word (len-1);
set_DMA_Mode (Block_Mode+AdrInc+Noauto+Read_Tr);
set_dma_command (Modus);
port[$41]:=$FF;        { Start Refresh Counter }
port[$41]:=$FF;
set_dma_mask(hard);
set_DMA_Request(soft); { Maske bleibt gesperrt }
                        { nur Software-DMA }
repeat
port[$43]:=$44;        { Stopp Refresh Counter }
xu:=port [$41]; xo:=port [$41];
timerwert:=xu + 256* xo;
until (port [dma_status] and $F >0) or (timerwert < timeout);
refresh (18);          { Standard-Refresh-Rate }
mess:= timerwert;
end;

Procedure check_Kanal (kanal:byte; hard,soft:masktyp);

begin
t0:=mess(MEM_IO,$100,Kanal,hard,soft);
tn:=mess(MEM_IO,x,Kanal,hard,soft);
Write ('Kanal ',Kanal,' : ');
if (t0 >timeout) and (tn > timeout) then
     writeln ((0.832*integer(t0-tn)/(x-$100)):6:2,' Mikrosek')
else writeln (' luft nicht');
end;

{************************** Hauptprogramm******************}

const maxfeld=$800;
begin
next_page (2*maxfeld);
getmem (quelle,maxfeld);
getmem (ziel,maxfeld);
for i:=0 to maxfeld-1 do quelle^[i]:=lo(i);
for i:=0 to maxfeld-1 do ziel^[i]:=$AA;
x:=maxfeld;
Writeln ('DMA-Test');
Writeln ('Messung: DMA Speicher/Port-Transfer ');
Writeln (' - zunchst per Software-DREQ');
For i:=0 to 3 do check_kanal (i,sperr,frei);
If AT then For i:=5 to 7 do check_kanal(i,sperr,frei);
Writeln (' - und per DREQ falls offen oder dauernd High ');
For i:=0 to 3 do check_kanal (i,frei,sperr);
If AT then For i:=5 to 7 do check_kanal(i,frei,sperr);
writeln; Writeln ('Messung: DMA Speicher/Speicher-Transfer');
t0:=mess(MEM_MEM,$100,0,sperr,frei);
tn:=mess(MEM_MEM,x,0,sperr,frei);
if (t0> timeout) and (tn > timeout) then
  Write ('in ':10,
  (0.8381*integer(t0-tn)/(x-$100)):6:2,' Mikrosek')
else write (' luft nicht');
error:=false;
for i:=0 to maxfeld-1 do if lo(i) <> ziel^[i]
         then error:=true;
if error then writeln (', Transfer nicht erfolgreich')
         else writeln (', Transfer erfolgreich durchgefhrt');
end.




{$R-,S-,I+,D+,T-,F-,V+,B-,N-,L+ }
{$M 16384,0,655360 }
{ c't/A.S. 9/88 }
program disk_dma;
uses dos, utility; {Unit folgt am Ende des Artikels}
type feldtyp=array[0..$FFF0] of Byte;
var reg         :registers;
    adresse     :longint;
    grenze      :longint;
    skip        :^Feldtyp;
    segment     :^Feldtyp;
    Diskpuffer  :^Feldtyp;
    Diskpuffer2 :^Feldtyp;
    i           :integer;
    error       :boolean;
    status      :byte;
    seks        :byte;
    inch        :char;
    Intr_nr     :byte;
    carry       :boolean;

procedure Reset_disk;
begin
reg.ax:=0;
reg.dx:=0;
intr($13,reg);
end;

procedure read_disk (intr_nr:byte;segx,ofsx:word;
                     var status,seks:byte;var carry:boolean);
 begin
 with reg do
   begin

   AX:=$201;            {Lies einen Sektor}
   CX:=$101;            {Track 1, Sektor 1}
   DX:=0;               {von Drive A:     }
   BX:=ofsx;            {nach segx:ofsx}
   ES:=segx;
   if Intr_nr = $40 then intr ($40,reg);
   if Intr_nr = $13 then intr ($13,reg);
   status:=ah;
   seks:=al;
   carry:=odd (flags);
   end;
end;

procedure check (Intr_nr:byte; overofs:word);
begin
if Intr_nr=$13 then
  writeln  (',Transfer => ',
  hexword(seg(diskpuffer^)),':',hexword(ofs(diskpuffer^)));
   repeat
   Fillchar(Diskpuffer^,$400,$77);
   Fillchar(segment^,$3000,$77);
   read_disk (Intr_nr,seg(segment^),$1000, status,seks,Carry);
   if status <> 0 then
      begin
      if status <> 6 then begin
                          writeln ('Disk-Fehler, ist Diskette auf A:?');
                          write ('A)bbruch oder R)etry ');
                          readln (inch);
                          if upcase (inch) = 'A' then exit;
                          end;
      reset_disk
      end;
   until status = 0;
  read_disk (Intr_nr,seg(diskpuffer^),ofs(diskpuffer^),status,seks,Carry);
    write ('INT ',hexbyte(Intr_nr));
  if ofs (diskpuffer^) >=$FE00 then
     diskpuffer:=ptr(seg(diskpuffer^)+$FE0,
                     ofs(diskpuffer^)-$FE00);
  Writeln ('  Disk-Status:',status,' Carry=',Carry,
            '  gelesene Sektoren: ',seks);
  case status of
    0: begin
       error:=false;
       for I:=0 to $1FF do
          if diskpuffer^[i] <> segment^[$1000+i] then error:=true;
       if error then write (' Overflow-Fehler, nicht gemeldet, ')
                else Write (' Overflow-Fehler automatisch korrigiert, ');
       error:=false;
       for I:=0 to $1FF do
         if segment^[i+overofs] <> $77 then error:=true;
         if error then
           writeln (' !!!!! falscher berlauf !!!!!!')
         else writeln (' kein falscher berlauf');
       end;

 9: begin
    write (' meldet DMA-Overflow, ');
      error:=false;
      for I:=0 to $1FF do
        if segment^[i+overofs] <> $77 then error:=true;
      if error then
        writeln ('!!!!!! dennoch falscher berlauf !!!!!!')
      else writeln ('kein falscher berlauf');
      end;
   end;
   writeln;
end;

begin
  adresse:=seg (heapPtr^) * 16 + ofs(heapPtr^);
  grenze:=$10000+(adresse shr 16) shl 16;
  if memavail < grenze-adresse + $11000 then
    begin
    write ('Fehler, Speicherplatz zu klein');
    exit;
    end;
   getmem (skip, word (grenze-adresse));
   getmem (segment,$FF00);
   getmem (Diskpuffer,$200);
   getmem (Diskpuffer2,$200);
   Write ('Test auf DMA-Overflow ');
   check ($13,0);
   check ($40,0);
   Write ('Test auf Segment-Overflow ');
   diskpuffer:=ptr(seg(segment^)+$20,$FF00);
   check ($13,$200);
   check ($40,$200);
   Write ('DMA und Segment-Overflow ');
   diskpuffer:=ptr(seg(segment^),$FF00);
   check ($13,0);
   check ($40,0);

end.

