PROGRAM DGL;
  uses
  Graph, crt, koordina;

VAR
  cc : Char;

  PROCEDURE DGL_sys(x, y : Real; VAR dx, dy : Real);
  BEGIN
    dx := 0.2*x-0.001*y*x;
    dy := -0.1*y+0.0005*y*x;
  END;

  PROCEDURE Zeichne_Richtung(x, y : Real);
  VAR sx, sy, dx_dy, dy_dx, lx, ly : Integer;
    dx, dy, laenge : Real;

  BEGIN
    lx := maxX DIV 100;
    ly := maxY DIV 70;
    sx := sxkoor(x);
    sy := sykoor(y);
    DGL_sys(x, y, dx, dy);
    IF (Abs(dx) < 1e-7) THEN
      BEGIN
        IF Abs(dy) > 1e-5 THEN
          BEGIN
            Line(sx, sy-ly, sx, sy+ly);
            IF dy > 0 THEN Circle(sx, sy-ly, 2) ELSE Circle(sx, 
              sy+ly, 2);
          END
        ELSE Circle(sx, sy, 2)
      END
    ELSE
      BEGIN
        laenge := Sqrt(dx*dx+dy*dy);
        dx_dy := Round(dx/laenge*lx);
        dy_dx := Round(ly*dy/laenge);
        Line(sx-dx_dy, sy+dy_dx, sx+dx_dy, sy-dy_dx);
        Circle(sx+dx_dy, sy-dy_dx, 2);
      END;
  END;

  PROCEDURE Richtungsfeld;
  VAR
    x, y, dx, dy, x_von, x_bis, y_von, y_bis, delta_t : Real;
    cc : Char;
  BEGIN
    WriteLn('x von, bis '); ReadLn(x_von, x_bis);
    WriteLn('y von, bis '); ReadLn(y_von, y_bis);
    K_System(x_von, x_bis, y_von, y_bis);
    x := x_von;
    REPEAT
      y := y_von;
      REPEAT
        Zeichne_Richtung(x, y);
        y := y+(y_bis-y_von)/20;
      UNTIL y > y_bis;
      x := x+(x_bis-x_von)/32
    UNTIL x > x_bis;
    cc := Readkey;
    CloseGraph;
  END;

  PROCEDURE x_y_Diagramm;
  VAR
    x, y, dx, dy, x_von, x_bis, y_von, y_bis, delta_t : Real;
    cc : Char;
  BEGIN
    WriteLn('x von, bis '); ReadLn(x_von, x_bis);
    WriteLn('y von, bis '); ReadLn(y_von, y_bis);
    WriteLn('x , y ,dt ?');
    ReadLn(x, y, delta_t);
    K_System(x_von, x_bis, y_von, y_bis);
    REPEAT
      setviewport(0, 0, maxX, maxY, True);
      REPEAT
        Zeichne(x, y);
        DGL_sys(x, y, dx, dy);
        y := y+dy*delta_t;
        x := x+dx*delta_t;
      UNTIL KeyPressed;
      cc := Readkey;
      cc := Readkey;
    UNTIL cc = 'x';
    CloseGraph;
  END;

  PROCEDURE t_Diagramm;
  VAR
    x, y, dx, dy, y_von, y_bis, t_von, t_bis, t, delta_t : Real;
    cc : Char;
  BEGIN
    WriteLn('x/y von, bis '); ReadLn(y_von, y_bis);
    WriteLn('t von, bis '); ReadLn(t_von, t_bis);
    WriteLn('x , y ,dt ?');
    ReadLn(x, y, delta_t);
    K_System(t_von, t_bis, y_von, y_bis);
    REPEAT
      setviewport(0, 0, maxX, maxY, True);
      t:=t_von;
      REPEAT
        Zeichne(t, x);
        Zeichne(t, y);
        DGL_sys(x, y, dx, dy);
        y := y+dy*delta_t;
        x := x+dx*delta_t;
        t := t+delta_t;
      UNTIL KeyPressed;
      cc := Readkey;
      cc := Readkey;
    UNTIL cc = 'x';
    CloseGraph;
  END;

BEGIN
  REPEAT
    ClrScr;
    WriteLn('(R)ichtungsfeld, (x)-y-Diagramm, (t)-Diagramm ?');
    cc := UpCase(Readkey);
    CASE cc OF
      'R' : Richtungsfeld;
      'X' : x_y_Diagramm;
      'T' : t_Diagramm;
    END;
  UNTIL cc = ' ';
END.
