Program Debug_Assembler;

Type    S4=       String[4];
        S20=      String[20];
        S255=     String[255];

{--------------------------------}
{       Symboltabellen:          }
{--------------------------------}

{ Tabelle der "Symbole" }

RefSet=Record
       Symbol:  S20;
       Line:    Integer;
       SymStart:Integer;
end;

{ Tabelle der "Marken" }

LocSet=Record
       Symbol:S20;
       Line:  Integer;
       Value: S4;
end;

{ "Label-Reference-Set" }

LabRefSet=Record
          Line:    Integer;
          Position:Integer;
          Value:   S4;
end;

Const   E_ErrMark:   String[7]='^ Error';
        G_ErrMark:   String[7]='^ Fehler'; {Fr deutsche DEBUGs}

        LabelMark:   Char     ='/';
        MaxErrors:   Integer  =10;
        PageFeed:    Char     =#12;
        ListDefault: Integer  =60;
        DEMO:        Boolean  =False;

Var     Pass:        Char;
        DateCTL:     Text;
        AsmFile:     Text;
        WorkFile:    Text;
        InFile:      Text;
        OutFile:     Text;
        ApproxFile:  Text;
        ErrorFile:   Text;
        CrefList:    Text;
        Pass1File:   Text;
        PhaseCheck:  Text;
        DDLabelCheck:Text;                 {--- DEMO ---}
        SymbolRefs: File of RefSet;        SR:Text;
        SymbolLocs: File of LocSet;        SL:Text;
        LabelRefs:  File of LabRefSet;     LR:Text;
                                           {--- DEMO ---}
        LRS:        LabRefSet;
        Loc:        LocSet;
        Ref:        RefSet;

        SymbolValue,First_Approx,LastOffs:S4;
        Symbol:                           S20;
        AsmLine,PrevLine:                 S255;
        Pass1Line,Pass2Line:              S255;
        MayBeErrorLine,Dummy:             S255;

        Errors,Symbols,LineNumber:Integer;
        AsmErr,WrkErr:            Integer;

        ErrPos,NoErrPos,SemiPos:  Byte;
        SymStart,SymEnd:          Byte;
        I,MsgLine:                Byte;
        SubstPos,EquPos:          Byte;

        ErrFlag,SymFound,PhaseError,CodeLine:Boolean;
        FileName:S20;

        Switch:String[2];

{---------------------------------------------------}
{      Hilfsprozeduren und -Funktionen              }
{---------------------------------------------------}

{--------------------------------------------------------------------)
     Fehlermelde-Routine:

   - Erstellt die "Notbremse" DEBASS.ERR
   - Gibt bis zu "MaxErrors" Fehlertexte mit markierter Stelle aus
   - Zhlt "Fatal Errors"
(--------------------------------------------------------------------}

Procedure Error(ErrLin:Integer;ErrLine:S255;Message:S255);
Begin
   Assign (ErrorFile,'DEBASS.ERR');
   rewrite (ErrorFile);
   Close (ErrorFile);
   If Errors<MaxErrors then
   begin
      GotoXY (1,MsgLine+3+Errors);
      If ErrLin=0 then Write ('Error: ',Message)
      else
      begin
         Write ('Error in Line ',ErrLin+Symbols:5,': ',Message,'   ');
         If ErrPos>Length(ErrLine) then ErrPos:=Length(ErrLine);
         If ErrPos=0 then Write (Copy(ErrLine,11,255))
         else
         begin
            Write (Copy(ErrLine,11,ErrPos-11));
            TextColor (5);
            Write (ErrLine[ErrPos]);
            NormVideo;
            WriteLn (Copy(ErrLine,ErrPos+1,255));
         end;
      end;
   end;
   Errors:=Succ(Errors);
   If Pass='2' then
   begin
      GotoXY (1,MsgLine+1);
      Writeln (Errors:5);
   end;
end;

Procedure InternalError;
begin
   Assign (ErrorFile,'DEBASS.ERR');
   rewrite (ErrorFile);
   Close (ErrorFile);
end;

{--------------------------------------------------------------------)
   Zeile aus Quelltext bzw. Zwischendateien lesen und Kommentarzeilen
   entfernen. Als umgeleitete Ausgabe des DEBUG-Assemblers knnen sich
   Leerzeilen dazwischen befinden, die sowohl die Zeilenzhlung
   beeinflussen knnen als auch als neue Eingabedatei den A- Befehl
   vorzeitig abbrechen wrden.
(--------------------------------------------------------------------}

Procedure GetLine (var Source:Text;var Line:S255);
begin
   repeat
      If not Eof(Source) then
      begin
         {$I-}
         Readln(Source,Line);
         {$I+}
         If IOResult<>0 then
            Error (LineNumber,Line,'File Access Error');
      end;
      SemiPos:=Pos(';',Line);
      Case SemiPos of
          0:   SemiPos:=Length(Line)+1;
          1:   Line:='';
          else Line:=Copy(Line,1,SemiPos-1);
      end;
   until (Length(Line)>0) or (Eof(Source));
end;

{--------------------------------------------------------------------)
   Entnimmt das durch "LabelMark" gekennzeichnete Symbol der
   Pass1Line und zhlt Marken
(--------------------------------------------------------------------}

Procedure Extract_Symbol;
begin
   Pass1Line[SymStart]:=' ';
   SymEnd:=Pos(LabelMark,Pass1Line);
   If SymEnd=0 then
   begin
      SymEnd:=Maxint;
      ErrPos:=SymStart;
      Pass1Line[SymStart]:=LabelMark;
      Error(LineNumber,Pass1Line,'Bad Label');
   end;
   Symbol:=Copy(Pass1Line,SymStart+1,SymEnd-SymStart-1);
   If SymStart=11 then
   begin
      Symbols:=Succ(Symbols);
      GotoXY(1,MsgLine+2);
      Writeln (Symbols:5);
   end;
end;

{***************************************************************}
{      Die fnf Teilprozeduren (ursprnglich Einzelprogramme),  }
{      die zwischen den DEBUG-Sitzungen auszufhren sind:       }
{***************************************************************}

{--------------------------------------------------------------------)
   Teil-Prozedur 1 = Vorbehandlung des .ASM-Files.

   - Entfernt TABs und Leerzeilen.
   - Setzt A-Befehl vor den .WRK-File
   - Setzt Q-Befehl hinter den .WRK-File.
(--------------------------------------------------------------------}

Procedure ConvertToWorkFile;
Begin
   LineNumber:=1;
   ClrScr;
   Assign (DateCTL,'Date.CTL');
   Rewrite (DateCTL);
   Writeln (DateCTL);
   Close (DateCTL);
   Assign (AsmFile, FileName+'.ASM');
   Assign (WorkFile,FileName+'.WRK');
   {$I-};
   Reset (AsmFile);
   AsmErr:=IOResult;
   Rewrite (WorkFile);
   WrkErr:=IOResult;
   {$I+}
   If AsmErr<>0 then
   begin
      Error (0,'','Bad or missing sourcefile');
      writeln;
   end;
   If WrkErr<>0 then Error (0,'','Disk write error');
   If AsmErr+WrkErr <> 0 then Exit;
   Writeln (WorkFile,'A');
   Writeln;
   Write ('Reading ',FileName+'.ASM':13,' Line ');
   Repeat
      GetLine(AsmFile,AsmLine);
      GotoXY(28,WhereY);
      Write (LineNumber:5);
      LineNumber:=Succ(LineNumber);

      { TAB's durch Leerzeichen ersetzen: }
      For i:=1 to Length(AsmLine) do
         If AsmLine[I]=Chr(9) Then AsmLine[I]:=' ';

      { Ist dadurch eine Leerzeile entstanden ? }
      CodeLine:=False;
      For i:=1 to Length(AsmLine) do
         If AsmLine[I]>'  ' then CodeLine:=True;
      If CodeLine then Writeln (WorkFile,AsmLine);

   Until Eof(AsmFile);
   Writeln (WorkFile);
   Writeln (WorkFile,'Q');
   Close (AsmFile);
   Close (WorkFile);
   Writeln;
End;

{--------------------------------------------------------------------)
   Teil-Prozedur 2 = Assembler-Pass 1.

 - Erstellt die vorlufige Symbol-Tabelle in den Dateien
   SymbolLocs : Zeilen, in denen die Labels als Marken dienen.
   SymbolRefs : Zeilen, in denen sich auf diese Marken bezogen wird.

 - Prft auf Fehlermeldungen des DEBUGs, die  n i c h t  durch
   Verwendung der Labels erzeugt wurden.

 - Ersetzt zur spteren Adressbestimmung alle Labels durch geeignete
   Nherungswerte (=Offset-Adresse der Zeile)
(--------------------------------------------------------------------}

Procedure DEBUG_Assembler_Pass_1;
Begin
   MsgLine:=WhereY;
   GotoXY (1,MsgLine+0);Writeln (0:5,' Lines');
   GotoXY (1,MsgLine+1);Writeln (0:5,' Fatal error(s)  ');
   GotoXY (1,MsgLine+2);Writeln (0:5,' Symbol(s) ');

   Assign (InFile,      FileName+'.P1');
   Assign (SymbolRefs,  FileName+'.REF');
   Assign (SymbolLocs,  FileName+'.LOC');
   Assign (OutFile,     FileName+'.WRK');
   Assign (DDLabelcheck,FileName+'.DDL');
   Rewrite (DDLabelCheck);
   Reset   (InFile);
   Rewrite (SymbolRefs);
   Rewrite (SymbolLocs);
   Rewrite (OutFile);

   If DEMO then begin
      Assign (SR,'\TEXTE\DEMO.SR'); Rewrite (SR);
      Assign (SL,'\TEXTE\DEMO.SL'); Rewrite (SL);
   end;

   Writeln (OutFile,'A');

   GetLine (InFile,Dummy);   { berlesen der "-A"-Zeile }


   While not Eof(InFile) do
   begin
      Repeat
         GetLine (InFile,Pass1Line);
         SymStart:=Pos(LabelMark,Pass1Line);
         If SymStart=11 then  { ... ist eine "Marke" in der Zeile! }
         begin
            Extract_Symbol;
            Loc.Symbol:=Symbol;
            EquPos:=Pos('=',Pass1Line);
            If EquPos=0 then  { ... ist ihr Wert = der Zeilenadresse }
            begin
               Loc.Line:=LineNumber;
               Loc.Value:='0000';
            end
            else { ... ist sie per "=" unmittelbar definiert! }
            begin
               Loc.Line:=0;
               Loc.Value:=Copy(Pass1Line,EquPos+1,255);
            end;
            Write (SymbolLocs,Loc);
            Writeln (DDLabelCheck,Symbol);
            If DEMO then
               Writeln (SL,Loc.Symbol:20,Loc.Line:6,Loc.Value:6);
            GetLine (InFile,Dummy); { Fehlermeldezeile berlesen! }
         end;
      Until SymStart<>11; { ... dann ist's keine Marke mehr! }

      ErrPos:=Pos(G_ErrMark,Pass1Line)+Pos(E_ErrMark,Pass1Line);
      If ErrPos>10 then Error (LineNumber-1,PrevLine,'Bad Syntax')

      { Es war gar keine Code-erzeugende Zeile, sonder die Fehler-
        meldungszeile. => Fehler in vorhergehender Zeile! }

      else { ... knnte es jetzt ein "Symbol" sein: }
      begin
         ErrFlag:=False;
         Repeat  { ... Zeile nach "Symbols" abtasten, ... }
            SymStart:=Pos(LabelMark,Pass1Line);

            If SymStart>11 then  { ... haben wir eins! }
            begin
               { 1.) Label in the Table! }
               Extract_Symbol;
               Ref.Symbol   :=Symbol;
               Ref.Line     :=LineNumber;
               Ref.SymStart :=SymStart;
               Write (SymbolRefs,Ref);
               If DEMO then
                  Writeln (SR,Ref.Symbol:20,Ref.Line:6,
                              Ref.SymStart:6);

               { 2.) Nherung einsetzen: }
               Delete (Pass1Line,SymStart,Length(Symbol)+2);
               Insert (Copy(Pass1Line,6,4),Pass1Line,SymStart);

               { 3.) Fehlermeldezeile folgt! }
               ErrFlag:=True;
            end;
         Until SymStart<12; { ... bis keins mehr drin! };
         If ErrFlag then GetLine (InFile,Dummy);
         If (Pass1Line[5]=':') then
         { ... Code-erzeugende Zeile 'rausschreiben und mitzhlen! }
         begin
            writeln (OutFile,Copy(Pass1Line,11,255));
            LineNumber:=Succ(LineNumber);
            GotoXY(1,MsgLine);
            Writeln (LineNumber:5);
         end;
         PrevLine:=Pass1Line;
         Pass1Line:='';
      end;
   end;
   Close (InFile);
   Writeln (OutFile,'Q');
   Close (OutFile);
   Close (SymbolRefs);
   Close (SymbolLocs);
   Close (DDLabelCheck);
   MsgLine:=MsgLine+4;
   If Errors>MaxErrors then Errors:=MaxErrors;
   GotoXY (1,MsgLine+Errors);
   If Errors>0 then Writeln ('Fatal errors detected, aborted!');
   If Symbols=0 then
   begin
      Erase (DDLabelCheck);
      Writeln ('No second pass due to missing symbols!');
   end;
   Writeln;
End;

{--------------------------------------------------------------------)
 Teil-Prozedur 3

   - Prft die inzwischen auf DOS-Ebene SORTierte Datei %1.DDL auf
     mehrfach vorhandene Marken.
   - Durchsucht die nach Pass1 dem DEBUG bergebene 1.Quellversion
     nach Fehlern, die durch den vorlufigen Ersatz aller Labels durch
     den Offset der Zeile entstanden sein knnten.
(--------------------------------------------------------------------}

Procedure Detect_Substitution_Errors_and_check_for_DDLabels;
Var LastSymbol,ThisSymbol:S20;

Begin
   Reset (DDLabelCheck);
   LastSymbol:='';
   Repeat
      Readln (DDLabelCheck,ThisSymbol);
      If ThisSymbol=LastSymbol then
      begin
         ErrPos:=0;
         Error (0,'','Double defined label "'+LastSymbol+'"');
      end;
      LastSymbol:=ThisSymbol;
   until Eof(DDLabelCheck);
   Close (DDLabelCheck);
   Assign (InFile, FileName+'.P2');
   Assign (ApproxFile,FileName+'.P1');
   Assign (OutFile,FileName+'.WRK');

   Reset   (InFile);
   Reset   (ApproxFile);
   Rewrite (OutFile);
   Write   (OutFile,'A');

   Repeat
      ErrPos:=0;
      GetLine (InFile,Pass2Line);
      Repeat
         GetLine (ApproxFile,Pass1Line)
      until ((Pass1Line[5]=':') and not (Pass1Line[11]=LabelMark))
             or Eof(ApproxFile);
      Repeat
         GetLine(InFile,MayBeErrorLine);
         { ist's  vielleicht Fehlerzeile? }
         ErrPos := Pos(G_ErrMark,MayBeErrorLine)
                  +Pos(E_ErrMark,MayBeErrorLine);
         If ErrPos=0 then  { nicht! }
         begin
            Writeln (OutFile,Copy(Pass2Line,11,255));
            Pass2Line:=MayBeErrorLine;
            Repeat
               GetLine (ApproxFile,Pass1Line)
            until ((Pass1Line[5]=':')
                   and not (Pass1Line[11]=LabelMark))
                   or Eof(ApproxFile);
         end;
         Until (ErrPos>11) or Eof(InFile);
         If Not Eof(InFile) then
         begin
            {Erste Allgemeine Nherung - sprich: Offset der Adresse
             dem Pass1 entnehmen:}

            First_Approx:=Copy(Pass1Line,6,4);
            Pass2Line:=Copy(Pass2Line,11,255);

            {Sorgt "FirstApprox" fr Fehler?
             Falls ja, durch 00-Byte-Nherung ersetzen:}

            SubstPos:=Pos(First_Approx,Pass2Line);
            While SubstPos>0 do
            begin
               Delete (Pass2Line,SubstPos,4);
               Insert ('00  ',Pass2Line,SubstPos);
               SubstPos:=Pos(First_Approx,Pass2Line);
            end;
            Writeln (OutFile,Pass2Line);
         end;
      until Eof(Infile);
   Close (InFile);
   Close (ApproxFile);
   Writeln (OutFile,'Q');
   Close (OutFile);
End;

{--------------------------------------------------------------------)
     Teil-Prozedur 4 = Assembler-Pass 2

   - Erstellt aus SymbolRefs und SymbolLocs den LRS
     (=Label-Reference-Set). Dieser zustzliche Durchlauf wird ntig,
     da allein aus Ref's und Loc's nur Adressen von Rckwrtsbezgen
     bestimmbar wren!

   - Ersetzt mit Hilfe der Daten aus dem LRS alle Symbole durch ihren
     tatschlichen Wert.

   - Erzeugt einen .CRF-File mit:
     Wert der Marke,
     Name der Marke,
     Zeile, in der auf diese Marke Bezug genommen wurde.
(--------------------------------------------------------------------}

Procedure DEBUG_Assembler_Pass_2;
Begin
   Assign (CrefList,  FileName+'.CRF');
   Assign (InFile,    FileName+'.P2');
   Assign (OutFile,   FileName+'.WRK');
   Assign (SymbolLocs,FileName+'.LOC');
   Assign (SymbolRefs,FileName+'.REF');
   Assign (LabelRefs, FileName+'.LRS');
   If DEMO then
   begin
      Assign (LR,'\TEXTE\DEMO.LR');
      Rewrite (LR);
   end;
   Rewrite (CrefList);
   Rewrite (LabelRefs);
   Reset   (SymbolRefs);
   Reset   (InFile);

{ 1. Hlfte: Aufbau des Label-Reference-Sets }

   begin
      While not Eof(SymbolRefs) do
      begin
         { Marke aus .REF-Datei in .LOC-Datei suchen: }
         Read (SymbolRefs,Ref);
         SymFound:=False;
         Reset (SymbolLocs);
         Repeat
            Read (SymbolLocs,Loc);
            If Ref.Symbol=Loc.Symbol then SymFound:=True;
         until (Eof(SymbolLocs)) or SymFound;

         If SymFound then
         begin
            { Marke steht korrekterweise in LOC und REF }
            LineNumber:=0;
            If Loc.Line>0 then
            begin
               { Symbol steht als Marke vor einer Zeile =>
                 Adresse dieser in Pass1 suchen: }
               Reset (InFile);
               GetLine(InFile,Dummy);
               Repeat
                  GetLine (InFile,Pass1Line);
                  If (Length(Pass1Line)>4) and (Pass1Line[5]=':')
                  then LineNumber:=Succ(LineNumber)
               Until LineNumber=Loc.Line;
               SymbolValue:=Copy(Pass1Line,6,4);
               Write (CrefList,SymbolValue,' ');
            end
            else
            begin
               { Marke ist per "=" definiert =>
                 Wert ist direkt der .LOC-Datei entnehmbar: }
               SymbolValue:=Loc.Value;
               Write (CrefList,SymbolValue,'=');
            end;

            WriteLn (CrefList,Loc.Symbol,
                     Ref.Line:40-Length(Loc.Symbol));
            LRS.Line:=Ref.Line;
            LRS.Position:=Ref.SymStart;
            LRS.Value:=SymbolValue;
            Write (LabelRefs,LRS);
            If DEMO then
               Writeln (LR,LRS.Line:6,LRS.Position:6,LRS.Value:6);
         end
         else
         begin
            { Symbol steht nur in .REF-Datei =>
              Bezug auf nicht definierte Marke! }
            LineNumber:=0;
            Assign  (Pass1File,FileName+'.P1');
            Reset   (Pass1File);
            GetLine (Pass1File,Dummy);
            Repeat
               GetLine (Pass1File,Pass1Line);
            Until (Pos(Ref.Symbol,Pass1Line)>0) or Eof(Pass1File);
            Close(Pass1File);
            ErrPos:=Pos(LabelMark,Pass1Line)+1;
            Error (Ref.Line,Pass1Line,'Symbol not found');
         end;
      end;
      Close (SymbolLocs);
      Close (SymbolRefs);
      Close (CrefList);

{ 2. Hlfte: Auswertung des Label-Reference-Sets }

      Rewrite (OutFile);
      Reset   (InFile);
      GetLine (InFile,Dummy);
      Writeln (OutFile,'A');    { bergabe der A-Zeile }
      GetLine (InFile,Pass1Line);
      LineNumber:=1;

      Reset (LabelRefs);
      LRS.Line:=0;
      Repeat { Zeile aus LRS lesen: }
         If Not Eof(LabelRefs)
         then Read (LabelRefs,LRS)
         else LRS.Line:=0;

         { Solange kein Bezug auf diese Zeile, diese
           - falls code-erzeugend - unverndert bernehmen: }
         While (LineNumber<>LRS.Line) and (not Eof(InFile)) do
         begin
            If Pass1Line[5]=':' then
            begin
               Writeln (OutFile,Copy(Pass1Line,11,255));
               LineNumber:=Succ(LineNumber);
            end;
            GetLine (InFile,Pass1Line);
         end;
         { Zeile mit Symbol aus LRS gefunden =>
           Nherung durch Wert des Symbols ersetzen: }
         Delete (Pass1Line,LRS.Position,4);
         Insert (LRS.Value,Pass1Line,LRS.Position);
      Until Eof(InFile);
      Writeln (OutFile);
      Writeln (OutFile,'Q');
      Close (OutFile);
      Close (LabelRefs);
   end;
End;

{--------------------------------------------------------------------)
 Teil-Prozedur 5

   - Testet auf Phase-Errors durch Vergleich der vor und nach Pass2
     erzeugten Adressen.

   - Erzeugt eine Steuerdatei, die durch letztmaligen Aufruf des
     DEBUGs diesen die .COM-Datei erstellen lt.
(--------------------------------------------------------------------}

Procedure DEBUG_Assembler_Pass_3;
Var PCR:Boolean;
Begin
  Assign  (PhaseCheck,FileName+'.P2');
  Assign  (InFile,    FileName+'.P3');
  Assign  (OutFile,   FileName+'.CTL');
  Rewrite (OutFile);
  Reset   (InFile);
  {$I-}
  Reset   (PhaseCheck);
  {$I+}
  PCR:=(IOResult=0);
  If PCR then GetLine (PhaseCheck,Pass1Line);
  GetLine (InFile,    Pass2Line);

  LineNumber:=0;
  Errors    :=0;
  PrevLine  :='';
  ErrFlag   :=False;
  PhaseError:=False;

  Writeln (OutFile,'A');
  Repeat
     If PCR then GetLine (PhaseCheck,Pass1Line);
     GetLine (InFile,    Pass2Line);

     { Zeile, falls code-erzeugend, unverndert
       bernehmen: }
     If Pass2Line[5]=':' then
     begin
        Writeln (OutFile,Copy(Pass2Line,11,255));
        LineNumber:=Succ(LineNumber);
     end;

     { Fehler durch falsche Labelwerte entstanden ? }
     ErrPos:=Pos(G_ErrMark,Pass2Line)+Pos(E_ErrMark,Pass2Line);
     If ErrPos>0 then
     begin
        Error (LineNumber,PrevLine,'Illegal Size for Item:');
        ErrFlag:=True;
     end;

     { Fehler durch Adressverschiebung ? }
     If PCR then If Copy (Pass1Line,1,9)<>Copy(Pass2Line,1,9) then
     if not ErrFlag then
     begin
        ErrPos:=0;
        Error (LineNumber,PrevLine,'Phase Error');
        ErrFlag:=True;
        PhaseError:=True;
     end;
     PrevLine:=Pass2Line;
  Until (Eof(InFile))             { unerwartetes Datei-Ende }
         or (Length(Pass2Line)=10) { letzte Assembler-Adressvorgabe }
         or (PhaseError);         { Abbruch durch Adressverschiebung }

  Close (InFile);

  { Code ist fehlerfrei, darf nun als .COM-Datei geschrieben werden: }
  If Not (ErrFlag) then
  begin
     Writeln (OutFile);
     Writeln (OutFile,'U100,',Copy(Pass2Line,6,4));

     { Dateilnge = 100 Byte weniger als
       letzter erzeugter Offset: }
     LastOffs:=Copy(Pass2Line,6,4);
     If LastOffs[2]='0' then
     begin
        LastOffs[2]:='F';
        LastOffs[1]:=Pred(LastOffs[1]);
     end
     else LastOffs[2]:=Pred(LastOffs[2]);
     Writeln (OutFile,'RCX');
     Writeln (OutFile,LastOffs);
     Writeln (OutFile,'N',FileName,'.COM');
     Writeln (OutFile,'W');
     Writeln (OutFile,'Q');
  end;
  Close (OutFile);
  Writeln (Errors:5,' error(s) detected.');
  If Not ErrFlag then Writeln ('Writing ',FileName,'.COM');
End;

{------------------------------------)
  Zusatzoption /L : List-File erzeugen
(------------------------------------}

Procedure BuildListFile;
var UnAss,Ass,ListFile:Text;
    ULine,ALine,Date:S255;
    CListEntry,NextClistEntry,OldCListEntry:S255;
    Symbol:S255;
    Done,SymbolPage,WrongAddr:Boolean;
    Page,ListLines:Integer;

Procedure ListPageHeader;
var PageNumber:String[5];
Begin
   ListLines:=Succ(ListLines);
   If ListLines>=ListDefault then
   begin
      ListLines:=0;
      Page:=Succ(Page);
      Str(Page,PageNumber);
      If SymbolPage then PageNumber:='S'+PageNumber;
      Writeln (ListFile,PageFeed);
      Write   (ListFile,'DEBUG''s-Symbolic-Assembler Rel 1.0    ');
      Write   (ListFile,'File:',Filename+'.ASM':10);
      Writeln (ListFile,Date+' Page '+PageNumber:50);
      Writeln (ListFile);
   end;
end;

begin
   { Systemdatum bernehmen }
   Reset (DateCTL);
   Readln (DateCTL,Date);
   Close (DateCTL);
   Date:=Copy(Date,Length(Date)-14,15);

   Gotoxy (1,MsgLine+4);
   Writeln ('Building ',FileName,'.LST');

   Page:=0;
   ListLines:=ListDefault;
   SymbolPage:=False;
   Assign  (ListFile,FileName+'.LST');
   Rewrite (ListFile);

   { Zur bernahme des Quelltextes in den .LST-File: }
   Assign  (AsmFile,FileName+'.P1');
   Reset   (AsmFile);
   GetLine (AsmFile,Dummy);  { "-A"-Zeile berlesen }

   { Zur bernahme der Marken in den .LST-File: }
   Assign (CrefList,FileName+'.CRF');
   Reset  (CrefList);
   If not Eof(CrefList) then GetLine (CrefList,CListEntry);

   { Zur bernahme des erzeugten Codes in den .LST-File: }
   Assign (UnAss,FileName+'.P5');
   Reset  (UnAss);
   Repeat
      GetLine (UnAss,Dummy);
   Until (Copy(Dummy,1,2)='-U') or Eof(UnAss);

   { Zur bernahme der erzeugten Adressen in den .LST-File: }
   Assign  (Ass,FileName+'.P5');
   Reset   (Ass);
   GetLine (Ass,Dummy);

   Done:=False;
   While (not Done) and not EoF(Ass) do
   begin
      WrongAddr:=False;
      ListPageHeader;
      GetLine (Ass,ALine);
      If Length (ALine)>10 then
      begin
         { Aus letztem "-A"ssembler-Durchgang die zugehrige
           "-U"nassemblierte Zeile suchen, um den erzeugten
           Code zu erhalten: }
         Repeat
            GetLine (UnAss,ULine);
         Until Eof(UnAss) or (Copy(ULine,1,9)>=Copy(ALine,1,9));
         { Deren Adresse kann - falls zuvor DB's disassembliert
           wurden - flschlicherweise auch hher liegen: }
         If Copy(Uline,1,9)>Copy(ALine,1,9) then WrongAddr:=True;

         { Aus Quelltext die zugehrige Quellzeile suchen: }
         Repeat
            GetLine (AsmFile,Pass1Line);
         Until Eof(AsmFile)
               or (Pass1Line[5]=':') and (Pass1Line[11]<>LabelMark);

         { Aus CRF-Datei eventuelle Marke holen: }
         If Copy(CListEntry,1,4)<=Copy(ULine,6,4) then
         begin
            Repeat
               GetLine (CrefList,NextCListEntry);
            Until (Copy(CListEntry,1,4) <> Copy (NextCListEntry,1,4))
                   or Eof(CrefList);
            Symbol:=Copy(CListEntry,5,20);
            CListEntry:=NextCListEntry;
         end
         else Symbol:='';

         { Ergab sich eine falsche Adresse durch Disassemblierung
           vorhergender DB's, dann die Adressangabe statt aus dem
           "-U"nassembler-Durchgang dem "-A"ssembler-Durchgang
           entnehmen. Der erzeugte Code ist dann allerdings
           unbekannt: }
         If WrongAddr then
            Write (ListFile,Copy(Aline,1,9),' ??            ')
         else Write (ListFile,Copy(Uline,1,24));
         Writeln (ListFile,Symbol:22,Copy(Pass1Line,11,255));
      end
      else Done:=True;
   end;

   { Zur Erzeugung der Symbol-Page: }
   Reset (CrefList);
   SymbolPage:=True;
   Page:=0;
   ListLines:=ListDefault;
   ListPageHeader;
   Writeln (ListFile,'Symbols:');
   OldCListEntry:='';
   While not Eof(CrefList) do
   begin
      GetLine (CrefList,CListEntry);
      If (Copy(CListEntry,6,20) <> Copy (OldCListEntry,6,20)) then
      begin
         Writeln (ListFile,Copy(ClistEntry,1,26));
         OldClistEntry:=ClistEntry;
      end;
   end;
   Close (AsmFile);
   Close (Unass);
   Close (Ass);
   Close (ListFile);
   Close (CrefList);
end;

{------------------------------------)
       H A U P T P R O G R A M M
(------------------------------------}

Begin
   ErrorPtr:=Ofs(InternalError);
   LineNumber:=1;
   PrevLine:='0000:0000';
   Pass1Line:='';
   SymStart:=0;
   NoErrPos:=0;
   ErrPos:=0;
   Errors:=0;
   Symbols:=0;
   If ParamCount in [2,3] then
   begin
      FileName:=ParamStr(1);
      Pass:=ParamStr(2);

      Case Pass of
         '1':ConvertToWorkFile;
         '2':DEBUG_Assembler_Pass_1;
         '3':Detect_Substitution_Errors_and_check_for_DDLabels;
         '4':DEBUG_Assembler_Pass_2;
         '5':DEBUG_Assembler_Pass_3;
         'L':BuildListFile;
      end;
      If DEMO then
      begin
         Close (SL);
         Close (SR);
         Close (LR);
      end
   end
   else Error(0,'','Missing filename');
End.


******************************************************************


echo off
:
:  Eventuell vorhandene "Notbremse" lschen:
:
if exist DEBASS.ERR del DEBASS.ERR
:
:  Die Teilprozedur 1 des DEBASS liest die Datei %1.ASM ein,
:  setzt den "A"-Befehl vor die Daten, entfernt TABs und
:  Kommentare, schliet mit dem "Q"-Befehl ab und schreibt
:  dieses Ergebnis in die Datei "%1.WRK":
:
DEBASS %1 1
if exist DEBASS.ERR goto Exit
echo Processing Pass 1:
:
:  Die so erstellte .WRK-Datei wird zur Feststellung grober
:  Fehler dem DEBUG bergeben, dessen Antworten die Datei
:  %1.P1 erstellen:
:
DEBUG <%1.WRK >%1.P1
:
:  Die Teilprozedur 2 des DEBASS wertet die Datei %1.P1 aus,
:  ersetzt zunchst alle Label-Referenzen mit der Zeilen-Adresse
:  und erstellt folgende Dateien:
:
:   %1.LOC      = Namen und Zeilen der Marken
:   %1.REF      = Namen, Zeilen und Spalten der Symbole
:   %1.DDL      = Liste der Marken
:   %1.WRK      = Neue DEBUG-Eingabedatei mit Nherungsadressen
:   DEBASS.ERR  = Notbremse, falls Fehler erkannt wurden
:
DEBASS %1 2
if exist DEBASS.ERR goto Exit
:
:  Falls keine Datei %1.DDL erstellt wurde, so hatte DEBASS
:  keine Marken gefunden! Folgende Durchgnge zum Einsatz und
:  zur Prfung der Adressen werden dann berflssig:
:
if not exist %1.DDL goto Pass5
:
:  Die Liste der Marken wird nun sortiert, DEBASS kann anschlieend
:  so leicht doppelt definierte Marken erkennen, da deren Namen dann
:  unmittelbar aufeinanderfolgen:
:
sort <%1.DDL >%1.DDL
:
:  Den Quelltext mit den so vorlufig ersetzten Labels %1.WRK
:  berprft DEBUG nochmals, ob durch diesen Ersatz nicht
:  eventuell fr Byte-Operanden zu groe Nherungswerte
:  eingesetzt wurden:
:
echo Processing Pass 2:
DEBUG <%1.WRK >%1.P2
:
:  DEBUG hat die Nherungswerte enthaltende Date %1.WRK erneut
:  assembliert und das Ergebnis einschlielich eventueller
:  Fehlermeldungen in die Datei %1.P2 geschrieben.
:  DEBASS's Teilprozedur 3 sucht diese Fehlermeldungen und
:  ersetzt die ungeeigneten Nherungen durch 00-Bytes:
:
DEBASS %1 3
if exist DEBASS.ERR goto Exit
:
:  Bis auf die Tatsache, da %1.WRK noch immer Nherungswerte
:  fr die Symbole enthlt, drfte %1.WRK nun fehlerfrei sein.
:  Die Adressen der Marken knnen nun bestimmt werden:
:
DEBUG <%1.WRK >%1.P2
:
:  %1.P2 enthlt nun das Assemblerlisting, dem DEBASS in der
:  Teilprozedur 4 die Adressen der Marken entnehmen kann.
:  Aus %1.LOC und %1.REF entsteht nun mit diesen Informationen
:  die Datei %1.LRS sowie im gleichen Durchgang wiederum aus
:  diesen Daten %1.WRK als letzte DEBUG-Eingabedatei mit 
:  korrekt ermittelten Adressen:
:
DEBASS %1 4
if exist DEBASS.ERR goto Exit
:
:  Nachdem nun alle Symbole ersetzt wurden, wird das Ergebnis
:  aus Pass2 nochmals DEBUG bergeben, um
:
:    a) zu prfen, ob durch das - diesmal korrrekte - Ersetzen
:       keine falschen Adressen entstanden sind,
:
:    b) die .COM-Datei zu schreiben.
:
:Pass5
:
DEBUG <%1.WRK >%1.P3
:
:  DEBASS's Teilprozedur 5 wertet diese letzte Ergebnis nochmals 
:  aus, ob - zum Beispiel - nun relative Sprnge nicht zu weit
:  geraten sind und erzeugt folgende Dateien:
:
:    %1.CTL    =    Eingabedatei fr DEBUG zum assemblieren
:                   und Erzeugen der %1.COM-Datei
:    %1.CRF    =    Cross-Reference-File, sowohl zur 
:                   Information als auch als Symboltabelle
:                   fr den %1.LST-File.
:    DATE.CTL  =    Eingabedatei fr den DATE-Befehl
:    DEBASS.ERR=    Notbremse, falls Fehler erkannt wurden
:
DEBASS %1 5
if exist DEBASS.ERR goto Exit
:
:  Falls Marken gefunden wurden, hatte DEBASS 5 eine %1.CRF-Datei
:  erzeugt. Diese sortieren:
:
if not exist %1.crf goto NoCRF
sort<%1.crf >%1.crf
:NoCRF
:
:   DEBUG erstellt nun die %1.COM-Datei und liefert mit %1.P5
:   die Ausgangsdaten fr einen eventuellen *.LST-File:
:
DEBUG <%1.CTL >%1.P5
:
:   Aktuelles Datum fr %1.LST-Kopfzeile bernehmen
:   und - falls gewnscht - %1.LST-File erzeugen:
:
date < DATE.CTL > DATE.CTL
if %2X==/LX DEBASS %1 L
if %2X==/lX DEBASS %1 L
:
:   Erzeugte und nun nicht mehr bentigte 
:   Zwischendateien lschen:
:
if exist %1.REF del %1.REF
if exist %1.LOC del %1.LOC
if exist %1.LRS del %1.LRS
if exist %1.WRK del %1.WRK
if exist %1.P? del %1.P?
if exist %1.CTL del %1.CTL
if exist %1.DDL del %1.DDL
:
:  %1.CRF alfabetisch nach Symbolnamen sortieren:
:
sort/+5 < %1.CRF > %1.CRF
:
:  Ende!
:  Eventuell erzeugte Notbremse lschen:
:
:Exit
if exist DEBASS.ERR del DEBASS.ERR


******************************************************************


;===================================================
;   DEMO.ASM
;   INT-17 Routine als Demonstration der DEBASS-
;   Mglichkeiten.
;===================================================

JMP NEAR /INIT/  ; Umspringen der Initialisierungsroutine, diese
                 ; braucht spter nicht resident zu sein!

;Platz fr Offset und Segment des ursprnglichen INT 17:

/OLDVEK_OFFSET/
dw 0
/OLDVEK_SEGMENT/
dw 0

;Neuer Druckertreiber (INT 17)

/DRIVER/
OR      AH,AH       ; Zeichenausgabe?
JNZ     /NOPRINT/   ; Nein, unverndert an "alten Treiber" weiter.
PUSH    BX          ; einzig verwendetes Register retten
MOV     BX,/TABLE/  ; Zeiger auf Code-bersetzungstabelle setzen
CS:                 ; Wirkt wie
XLAT                ; MOV AH,0 / ADD AX,BX / MOV AL,[AX]
POP     BX          ; Register wie gehabt!

/NOPRINT/           ; und
CS:                 ; ab an den "alten" Treiber!
JMP FAR [/OLDVEK_OFFSET/]

;bersetzungstabelle "Deutsches"-ASCII ==> "IBM"-ASCII

/TABLE/
DB 00,01,02,03,04,05,06,07,08,09,0A,0B,0C,0D,0E,0F
DB 10,11,12,13,14,40,16,17,18,19,1A,1B,1C,1D,1E,1F
DB 20,21,22,23,24,25,26,27,28,29,2A,2B,2C,2D,2E,2F
DB 30,31,32,33,34,35,36,37,38,39,3A,3B,3C,3D,3E,3F
DB 40,41,42,43,44,45,46,47,48,49,4A,4B,4C,4D,4E,4F
DB 50,51,52,53,54,55,56,57,58,59,5A,3C,EF,3E,5E,5F
DB 60,61,62,63,64,65,66,67,68,69,6A,6B,6C,6D,6E,6F
DB 70,71,72,73,74,75,76,77,78,79,7A,D9,F2,DA,7E,7F
DB 80,7D,82,83,7B,85,86,87,88,89,8A,8B,8C,8D,5B,8F
DB 90,91,92,93,7C,95,96,97,98,5C,5D,9B,9C,9D,9E,9F
DB A0,A1,A2,A3,A4,A5,A6,A7,A8,98,99,CD,CE,AD,AE,AF
DB B0,B1,B2,96,92,92,92,99,99,92,96,99,9B,9B,9B,99
DB 9A,90,91,93,95,8F,93,93,9A,98,90,91,93,95,8F,90
DB 90,91,91,9A,9A,98,98,8F,8F,9B,98,8E,84,8B,DE,A0
DB A0,7E,E2,B9,BA,B1,AB,A2,CA,A7,BC,A3,CB,ED,A4,EF
DB F0,C4,C6,C7,F4,F5,F6,C8,CF,C9,C9,BE,FC,D1,BF,FF
;Bis hier wird Programm resident; s.u.!

/INIT/

;ITOH-Drucker auf Mathematisch/Griechischen Zeichensatz
;schalten, sonst bekommen wir Hiragana!

MOV     AX,001B
INT     17
MOV     AX,0026
INT     17

;Treiber (in)-Aktiv-Text ausgeben:

MOV     DX,/TEXT1/
MOV     AH,09
INT     21

;Y(es) oder N(o) gegeben?

MOV     AL,[0082]            ; Ersten Parameter lesen
AND     AL,5F                ; Kleinschrift maskieren.
CMP     AL,4E                ; 4EH = 'Y'
JNZ     /YES/

; bei N(o): Original INT17-Vektor restaurieren.
; Bitte nicht aus OLDVEK... , da sptestens beim
; zweiten DEMO-Aufruf der Original-Vektor "jwd" wre!

MOV     BX,0000
MOV     ES,BX
ES:
MOV     WORD PTR [005C],EFD2 ; EFD2:F000 ist vorher (!) aus der
ES:                          ; Interrupt-Tabelle ab 005C ff. notiert
MOV     WORD PTR [005E],F000 ; worden.

; In-Aktiv-Text ausgeben:

MOV     DX,/TEXT3/
MOV     AH,09
INT     21

; DEMO verlassen:

/EXIT/
MOV     AH,4C
INT     21

; bei Y(es) Aktiv-Text ausgeben ....

/YES/
MOV     DX,/TEXT2/
MOV     AH,09
INT     21

; ... und prfen, ob DEMO bereits im INT 17 eingeklinkt:

MOV     BX,0000
MOV     ES,BX
ES:
MOV     BX,[005C]
CMP     BX,/DRIVER/
JZ      /EXIT/

; Alten INT 17-Vektor retten:

MOV     [/OLDVEK_OFFSET/],BX
ES:
MOV     BX,[005E]
MOV     [/OLDVEK_SEGMENT/],BX

; INT 17-Vektor verbiegen:

MOV     BX,/DRIVER/
ES:
MOV     [005C],BX
ES:
MOV     [005E],CS

; DEMO bis ausschlielich /INIT/ (s.o.) resident machen:

MOV     DX,/INIT/
INT     27

/TEXT1/
DB "ITOH-Driver is $"
/TEXT2/
DB "active !",0d,"$"
/TEXT3/
DB "inactive !",0d,"$"


