; Universal Keyboard-Driver Gerdes/c't
; assembles with MASM 4.0 or 5.0 only!
; Use: Masm k3,k3;
;      Link k3,k3;
;      Exe2bin k3.exe k3.com
;
; be sure int 15h is predefined
;
rtn    MACRO
DB      0C3H
ENDM
;
jmps   macro to
jmp short to
endm
;
RESTART         MACRO
DB      0EAH,0F0H,0ffh,0,0F0H   ; JMP FAR F000:FFF0 (RESET)
ENDM
;
apox    equ     1         ; apostrophe translate 1 = on
kxlate  equ     0         ; 1 = translate keys (my keyboard)
forceMF equ     0         ; force MF decode w/o read-id
doint16 equ     1         ; include int16 routine
capbeep equ     1         ; beep on caps lock change
atcoding equ    1         ; if 0 support pc-coding
                          ; of a AT keyboard. Normally 1
int15df equ     1         ; 1 if int 15 defined (default)

LF      EQU     0AH
CR      EQU     0DH
shiftR  EQU     01H
shiftL  EQU     02H
SHIFT   EQU     03H
CTRL    EQU     04H
ALT     EQU     08H
SCRLOCK EQU     10H
NUMLOCK EQU     20H
CAPLOCK EQU     40H
INSERT  EQU     80H

system  EQU     04H
suspend EQU     08H

E0Flag  EQU     02H
E1Flag  EQU     01H

; (be very careful with that !!!)
;-------------------------------
; the int 9 routine is entered via SAVE
; which stores processor registers on stack.
; BP register points to the saved register set.
; Via the following equates the stored register
; set is directly changed.
; Any modifications in SAVE and RESTORE will
; require adaptations here !!!

SavedF          equ     byte ptr [bp+18h]   ; flags on stack
SavedAX         equ     word ptr [bp+10h]   ; AX on stack

ZeroFlag        equ     040h
CarryFlag       equ     1

Vectors         segment at 0h
                org     024h
Vec9o           dw      ?
Vec9s           dw      ?
                org     058h
Vec16o          dw      ?
Vec16s          dw      ?
Vectors         ends

BIOS            segment at 040h
                org     017h
KbFlags         label   word
KbFlag          db      ?
KbFlag1         db      ?
AltInp          db      ?
Buffer_Head     dw      ?
Buffer_Tail     dw      ?

                org     080h
Buffer_Start    dw      ?
Buffer_End      dw      ?

                org     096h
KbFlag3         db      ?
KbFlag2         db      ?

BIOS            ends
;--------------------------
Code    SEGMENT
        ASSUME DS:BIOS,cs:code

        ORG     0100H
Start:  jmp     install
titl:   db      10,13,'*** german keyboard driver'
        db      " by -mat/c't 11-july-88 ***",10,13,'$'

INCLUDE K3TAB.ASM

Do_9:   STI
        CALL    Save            ; save registers
        Call    DS40            ; set data segment
        CLD
        IN      AL,60h          ; read in char
;-------------------------------------

if int15df
        mov     ah,4fh          ; allow system to process
        stc                     ; scancode
        int     15h
        jnc     exit99          ; if no clear, system did
                                ; keycode processing
endif                           ; int15df
;-------------------------------------
do1:     mov     dx,061h        ; support PC
         PUSH    AX             ; save char
         IN      AL,DX          ; get control port
         MOV     AH,AL          ; save value
         OR      AL,80H         ; reset bit for keyboard
         OUT     DX,AL
         XCHG    AH,AL
         OUT     DX,AL
         POP     AX             ; get back scancode
         MOV     ah,al          ; in ah also
         MOV     dx,KbFlags     ; get main flags

;-------------------------------------
;-- check commands to the system -----
;-------------------------------------
chkres: cmp    ah,0feh         ; re-send ?
        jnz    chkack
        or     kbflag2,20h     ; flag re-send
        jmps   exit99
chkack: cmp     ah,0fah         ; acknowledge ?
        jnz     chkid           ; no, check id command
        or      kbflag2,10h     ; flag acknowledge
        jmps    exit99
chkid:  test    kbflag3,80h     ; doing rd-id?
        jz      cmderr          ; no, bad command
        test    cs:id1,0ffh     ; 1. byte received?
        jnz     rdid2
rdid1:  mov     cs:id1,ah        ; save 1.id byte
        jmps    exit99
rdid2:  mov     cs:id2,ah        ; save 2. id byte
        and     kbflag3,7fh      ; clear rd-id flag
        jmps    exit99
cmderr: CMP     ah,0d8h         ; over $d8 ?
        jbe     nxt
        cmp     ah,0e0h         ; modifier ?
        jnz     chk0e1
        or      kbflag3,E0Flag  ; flag 0e0h
        jmp     exit2
chk0e1: cmp     ah,0e1h         ; special for pause
        jnz     cmderr2
        or      kbflag3,E1Flag  ; flag 0e1h
        jmp     exit2
cmderr2:call    errbeep
exit99: jmps    exit88          ;  error beep

;--- end of command byte processing --

nxt:     sti
         and    ax,807fh    ; mask high bit (LEAVE INTACT!)

;-------------------------------------
; change scancodes 52 INS <-> 47 HOME
;                  53 DEL <-> 4F END
; in shift status  to simulate MF layout
; change y <-> z also as scancodes
;-------------------------------------
         cmp    al,15h          ; 'Y'
         jnz    nx0
         mov    al,2ch
         jmps   nxex
nx0:     cmp    al,2ch          ; 'Z'
         jnz    nx01
         mov    al,15h
         jmps   nxex

; a translation routine for a very special keyboard.
; cursor block keys (giving shifted scancodes) were
; laid out different from MF keyboard.
; the routine as is is useful only for that keyboard.
; I left it in to demonstrate how to reprogram certain
; keys on keyboard driver level

nx01:
if kxlate
         test   kbflag3,010h    ; MF-Keyboard ?
         jz     nxex            ; skip for MF keyboard
         TEST   DL,3            ; shifted ??
         JZ     nxex            ; no skip
         cmp    al,47h
         jnz    nx1
         mov    al,52h
         jmps   nxex
nx1:     cmp    al,52h
         jnz    nx2
         mov    al,47h
         jmps   nxex
nx2:     cmp    al,4fh
         jnz    nx3
         mov    al,53h
         jmps   nxex
nx3:     cmp    al,53h
         jnz    nxex
         mov    al,4fh
endif                           ; kxlate
nxex:    add    ah,al
;-------------------------------------
; key processing is done separately for
; pressed keys and released keys

nxt1:   TEST    ah,80H          ; key released?
        JZ      MakeKey         ; no, make key

;-------------------------------------
;- Proceed keys released
;-------------------------------------
BreakKey:
        CALL    ChkShift        ; special key ???
        JZ      brk10           ; no, exit!

;-- proceed shift and alt and control keys

        TEST    BL,(shift+ctrl+alt) ; check state
        not     bl              ; invert mask
        JNZ     any             ; any of them

;-------------------------------------
;- Proceed toggles (Insert Capslock Numlock Scrollock)
;-------------------------------------
        AND     DH,BL           ; reset bit
exit88: jmp     exit

;-------------------------------------
;-- proceed non toggles (shift and alt and control keys)
;-------------------------------------
any:    AND     DL,BL           ; special bit -> DL
        shr     BL,1
        shr     BL,1            ; shift alt & ctrl bits
        or      bl,0c0h         ; set high bits
        and     dh,bl           ; reset bit
        CMP     Ah,38H          ; ALT ??
        JNZ     exit88          ; no, exit !!
        XOR     ah,ah           ; ax := 0
        MOV     Al,AltInp       ; AltInput (via keypad...)
        test    cs:AltFlg,0ffh
        JZ      exit88          ; exit w. ah = 0 al = code
        MOV     AltInp,ah       ; reset AltInput
        mov     cs:AltFlg,ah
        JMP     ValidKey        ; output byte

;-------------------------------------
;-- release sys req
;-------------------------------------
brk10:  cmp     ah,84
        jnz     exit88         ; no action for other keys
        and     dh,not(system) ; flag system key released
        call    S18endint      ; reset interrupt controller

if int15df
        mov     ax,8501h       ; sys req
        int     15h
endif                          ; int15df
        jmp     exit3

;-------------------------------------
;- Proceed keys pressed
;-------------------------------------
MakeKey:
        MOV     CH,DL          ; shift status -> CH
        AND     CH,(ctrl+alt)  ; mask control and alt
        SUB     CH,(ctrl+alt)
        jz      mk1
        jmp     make1          ; no , different one
mk1:
;-------------------------------------
;-  Alt and Ctrl are pressed ---------
;-  often these are special functions-
;-------------------------------------

;-------------------------------------
;-- call old vector ------------------
;-------------------------------------
call_old:
        cmp     ah,59          ; F1 ?
        jnz     co1            ; no, skip
        mov     cs:oldv,byte ptr 0ffh  ; use old vector
        jmps    co3
co1:    cmp     ah,60          ; F2 ?
        jnz     co2            ; no, skip
        mov     cs:oldv,byte ptr 0h   ; use current vector
        jmps    co3
co2:    test    cs:oldv,byte ptr 0ffh ; use old vector ??
        jz      co3            ; no, skip
        jmp     make1          ; use old vector
co3:
;-------------------------------------
;-- de-install -----------------------
;-------------------------------------
deinstall:
        cmp     al,55          ; ALT CTRL PrtSC is DeInstall
        jnz     di1
        assume  ds:vectors
        CLI
        xor     ax,ax
        mov     ds,ax
        mov     bx,cs:oldvec      ; restore old vector
        mov     es,cs:oldvec+2
        mov     vec9o,bx
        mov     vec9s,es
if doint16
        mov     bx,cs:oldv16      ; restore old vector
        mov     es,cs:oldv16+2
        mov     vec16o,bx
        mov     vec16s,es
endif                             ; doint16
        call    errbeep
        call    errbeep
        call    ds40              ; reload BIOS Segment
        jmp     exit
di1:    assume  ds:bios

;-------------------------------------
;- ALT CTRL BREAK
;- modification : ALT CTRL BREAK breaks
;- directly w/o break interrupt
;-------------------------------------
altbrk: CMP     AL,70      ; check special make code
        jnz     ab1
        call    errbeep
        call    endint
        sti
        mov     ax,4cffh   ; force MS-DOS terminate
        int     21h
ab1:
;-------------------------------------
;- Force Reset for Ctrl Alt Del
;-------------------------------------
reset:  CMP     AH,83          ; Delete
        JNZ     re1
        test    kbflag3,08h    ; AltGr ?
        JNZ     re1            ; no reset for AltGr-Del!

        MOV     WORD PTR DS:72H,1234H ; Flag warm start
        RESTART
re1:
;-------------------------------------
;- graphic charset selection
;-------------------------------------
gchar:  cmp     ah,64           ; F6 .. F10
        jb      gc1
        cmp     ah,68
        ja      gc1
        sub     ah,64           ; reduce to 0..4
        mov     cs:gselect,ah
        jmp     exit            ; char is made invalid
gc1:
;-------------------------------------
;- special CTRL ALT done, translate rest
;- use table to translate ------------
;-------------------------------------
altgr:  xor     bh,bh
        mov     bl,cs:gselect  ; get selection
        shl     bx,1           ; double value as index
        MOV     SI,[bx+AltgrTbls]    ; get table value
altgr1: CMP     AH,CS:[SI]     ; find value
        JZ      altgr2         ; found !!
        cmp     byte ptr cs:[si],-1  ; end marker ??
        jz      altgr4
        ADD     SI,2           ; next entry
        jmps    altgr1
altgr2: INC     SI             ; get value
        MOV     AL,CS:[SI]     ; get byte as valid key input
        JMP     ValidKey
altgr4:
;---
make1:  test    cs:oldv,byte ptr 0ffh ; use old vector ??
        jz      make111        ; no, skip
        call    restore        ; restore registers
        jmp     dword ptr cs:oldvec  ; call saved old vector
make111:
;-------------------------------------
;- special keys ----------------------
;-------------------------------------

;- system required -------------------

syskey: cmp     ah,84
        jnz     k841
key84:  or      dh,system      ; flag system key depressed
        call    S18endint
if int15df
        mov     ax,8500h       ; sys req
        int     15h
endif                          ; int15df
        jmp     exit3
k841:

;- break -----------------------------

brkkey: cmp     al,70
        jnz     bk1
brk1:   test    dl,ctrl
        jz      bk1            ; no break !!
        MOV     BYTE PTR DS:71H,80H     ; Break_hit
        INT     1BH
        XOR     AX,AX          ; AX := 0;
        MOV     SI,Buffer_Head
        MOV     Buffer_Tail,SI
        and     DH,not(suspend); reset suspend state
        jmps    validkey
bk1:

;-- Pause key -------------------------

pausekey:
        CMP     AL,69
        jnz     pk1
Pause:  test    dl,ctrl
        jz      pk1            ; no pause !!
        or      dh,suspend     ; set suspend state
        CALL    S18EndInt      ; enable further interrupts
        sti
dowait: TEST    KbFlag1,suspend  ; still waiting ??
        JNZ     dowait
        JMPs    exit1
pk1:
;-------------------------------------
;-- check alt/ctrl/shift -------------
;-------------------------------------
        CALL    ChkShift       ; special key ??
        JZ      anykey         ; no
;---
        TEST    BL,(shift+ctrl+alt)
        jz      maketoggl      ; none of them
        or      DL,BL          ; set the bit
        shr     bl,1
        shr     bl,1
        or      dh,bl          ; set kbflag1
        JMPs    exit           ; and terminate

;--------------- exit : validkey ------
;--------------- exit : exit ----------
ValidKey:
if apox
        CALL    ChkApo         ; manage apostrophes
        jnc     exit
endif                          ; apox
        call    PutInBuffer    ; out char
exit:   mov     KbFlags,DX     ; save flags
exit1:  and     kbflag3,0fch   ; reset e0/e1 flags
exit2:  
        CALL    endint
if not forceMF
        call    leds
endif                          ; forceMF
exit3:  CALL    restore
        IRET

;-------------------------------------
;-- Release suspend state ------------
;-------------------------------------

;-- any key entered -----------

anykey: TEST    DH,suspend     ; waiting ??
        jz      makenormal     ; no, skip
        and     DH,not(suspend) ; reset suspend state
        jmps    exit

;-------------------------------------
;-- proceed toggles ------------------
;-------------------------------------
maketoggl:
        test    dl,ctrl        ; control state ??
        jnz     makenormal     ; skip on yes
noin:   TEST    DH,BL          ; is depressed ??
        JNZ     exit           ; yes, skip
        XOR     DL,BL          ; toggle that bit in kbflag
        OR      DH,BL          ; add it into kbflag1
        test    bl,insert      ; is it insert key ?
        jz      exit
        jmp     np000

;-------------------------------------
;-- no control -----------------------
;-------------------------------------
makenormal:
        CMP     AH,59          ; normal keys
        jb      ChkAlt
        cmp     ah,86
        jz      ChkA1
        jmp     fkeys
ChkA1:  mov     al,58          ; key 86 is table entry 58

;-------------------------------------
;-- proceed alt keys -----------------
;-------------------------------------
ChkAlt: TEST    DL,alt         ; alt ??
        JZ      ChkCtrl        ; no chk ctrl

; is alt. check keypad enter and keypad /

        test    kbflag3,E0Flag ;  0e0h?
        jz      alt01
        cmp     ah,28          ; alt keypad enter
        jnz     altm1
        mov     ax,0a600h
        jmps    validkey
altm1:  cmp     ah,53          ; alt keypad /
        jnz     alt01
        mov     ax,0a400h
        jmps    validkey
alt01:  MOV     SI,OFFSET AltTbl
alt1:   CMP     AH,CS:[SI]     ; find value
        JZ      alt2           ; found !!
        cmp     byte ptr cs:[si],-1  ; end ??
        jz      alt4
        ADD     SI,3           ; next entry
        jmps    alt1
alt2:   INC     SI             ; get value
        TEST    DL,3           ; shifted ??
        JZ      alt3           ; no skip
        INC     SI             ; get next value
alt3:   CMP     BYTE PTR CS:[SI],-1  ; dummy value ??
        JZ      alt4           ; yes
        MOV     AL,CS:[SI]     ; get byte as valid key input
        JMPs    altvk

; not found in table

alt4:   MOV     AltInp,0       ; clear alt input
        mov     cs:AltFlg,0
        cmp     ah,15          ; tab
        jnz     alt40
        mov     ah,165
        jmps    alt6
alt40:  CMP     AH,13          ; top row ??
        JA      alt6
        CMP     AH,1
        JBE     alt6
; is top row
        ADD     AH,118         ; alt 1 : 120
alt6:   XOR     AL,AL          ; reset scancode
altvk:  JMP     ValidKey

;-- check control --------------------

ChkCtrl:TEST    DL,ctrl
        JNZ     Do_ctrl

;-- check shifted keys ---------------

ChkSh:  test    kbflag3,E0Flag  ;  0e0h?
        jz      cs1
        cmp     ah,53          ; keypad /
        jnz     cs1
        mov     al,'/'
        jmps    altvk
cs1:    TEST    DL,3
        jz      notsh

;-------------------------------------
;-- proceed shifted keys -------------
;-------------------------------------
        CMP     AH,55          ; shift 55 is PrintScreen
        jz      print
        jmps    issh

;-------------------------------------
;-- proceed non shifted keys ---------
;-------------------------------------
notsh:  CALL    DoCaps
        JNZ     xlate
        TEST    DL,caplock
        JNZ     xlate
        INC     CH             ; do shift
        JMPs    xlate
issh:   CALL    DoCaps
        JNZ     invsh
        TEST    DL,caplock
        JZ      xlate
invsh:  XOR     CH,1

;---- translate scancodes into ASCII

xlate:  DEC     AL             ; dec scancode
        SHL     AL,1           ; * 2
        ADD     AL,CH          ; add shift mode !!!
        mov     bx,offset GerTbl
        XLAT    CS:GerTbl
        jmp     ValidKey

;-------------------------------------
;-- Print Screen  --------------------
;-------------------------------------
Print:  CALL    EndInt
        INT     5h
        JMP     exit2

;-------------------------------------
;- Proceed control keys
;-------------------------------------
Do_CTRL: cmp     ah,55          ; print screen
         jnz     dc1
         mov     ax,07200h
         jmps    ctrlvk
dc1:     test    kbflag3,E0Flag ;  0e0h?
         jz      dc2
         cmp     ah,53          ; keypad /
         jnz     dc2
         mov     ax,09500h
         jmps    ctrlvk
dc2:     CMP     AH,57          ; table length
         JA      ctrlex         ; skip
         DEC     Al
         MOV     BX,OFFSET CtrlTBL ;control table
         XLAT    CS:CtrlTBL
ctrl2:   cmp     al,-1          ; valid ??
         jnz     ctrlvk
         cmp     ah,15          ; TAB?
         jnz     ctrlex
         mov     ax,09400h
ctrlvk:  jmp     validkey
ctrlex:  jmp     exit

;-------------------------------------
;-- Function Keys --------------------
;-- entry: al >= 59
;-------------------------------------
FKeys:  CMP     AH,69
        jb      Fk010          ; 59..68
        CMP     AH,87
        Jb      numpad         ; drop to f11/12
FK1112: ADD     AH,46          ; F11 and F12  (87/88)
Fk010:  XOR     AL,AL          ; reset scancode
        MOV     AltInp,AL      ; reset alt input
        mov     cs:AltFlg,al
        TEST    DL,(shift+ctrl+alt)
        JZ      fkv            ; no alt, ctrl, shift
        TEST    DL,alt
        JZ      Fkey1
FkeyAlt:Or      ah,ah          ; f11-f12
        Js      fs1
        ADD     AH,39
fs1:    ADD     AH,6
        JMPs    fkv
Fkey1:  TEST    DL,ctrl
        JZ      FkeySh
FkeyC:  or      ah,ah
        Js      fs2
        ADD     AH,31
fs2:    ADD     AH,4
        jmps    fkv
FkeySh: or      ah,ah
        js      fs3
        add     ah,23
fs3:    add     ah,2
fkv:    jmp     validkey

;-------------------------------------
;-- Proceed NumPad -------------------
;-- entry scc 69..87 -----------------
;-------------------------------------
NumPad: CMP     AH,83
        Jbe     np000
        jmps    xit
np000:  SUB     AL,71          ; adjust scancode
np001:  TEST    DL,alt
        JZ      np1

; alt input

altnp:  CALL    KPShift        ; for keypad
        JNC     altnp1         ; jump on upper
        MOV     BX,OFFSET npad ; "numbers" for alt-input
        XLAT    CS:npad
        CMP     AL,-1          ; invalid ??
        JZ      altnp01
np00:   MOV     CL,AL          ; multiply alt input with 10
        MOV     AH,10
        MOV     AL,AltInp      ; get value
        MUL     AH             ; mul al*ah
        ADD     AL,CL          ; add in new digit
        MOV     AltInp,AL      ; store result
        MOV     cs:AltFlg,0ffh
        JMPs    xit            ; exit

;-- proceed alt numpad w/o shift -----

altnp01:mov     al,ah
        sub     al,71
altnp1: MOV     BX,OFFSET AltNPad
        XLAT    CS:AltNPad
        MOV     AH,AL
        XOR     AL,AL
        cmp     ah,-1          ; if $FF
        jz      xit
        jmps    npvk
np1:    TEST    DL,ctrl
        JNZ     np2            ; jump on control

; normal and shifted

minus:  CMP     AL,3           ; '-'
        JNZ     plus
        MOV     AL,2DH
        JMPs    npvk
plus:   CMP     AL,7
        JNZ     period
        MOV     AL,2BH         ; '+'
        JMPs    npvk
period: CALL    KPShift        ; for keypad
        JC      pe1            ; jump on lower
        cmp     al,5           ; is it "5" ?
        jnz     pe0            ; keypad 5 is '/'
        mov     al,'\'         ; for grell
        jmps    npvk
pe0:    XOR     AL,AL          ; upper is "DEL"
        JMPs    npvk
pe1:    CMP     AL,12          ; scancode 83 ??
        JNZ     npother
        MOV     AL,2EH         ; '.'
        JMPs    npvk
xit:    jmp     exit
;------
npother:MOV     BX,OFFSET npad ; xlate numpad
        XLAT    CS:npad
        cmp     AL,-1          ; to be sure
        jz      xit
        ADD     AL,30H         ; add '0'
        JMPs    npvk

;- control numpad ------------------------

np2:    MOV     BX,OFFSET CtrlNPad
        XLAT    CS:CtrlNPad
        MOV     AH,AL
        XOR     AL,AL
        cmp     ah,-1          ; if $FF
        jz      xit
npvk:   jmp     validkey

;-------------------------------------
;-- valid only for keypad  -----------
;-- returns c=0 if no shift ----------
;-------------------------------------
KPShift: CLC                    ; reset carry
         OR      dl,dl          ; on dl = 0 exit
         JZ      iss3
         test    kbflag3,E0Flag ; 0e0h?
         jnz     iss3
         test    dl,020H        ; num lock ??
         jz      iss2           ; jump on no num lock
         test    dl,3           ; shift ??
         jnz     iss3           ; yes, skip
         jz      iss21          ; no. set carry
iss2:    test    dl,3           ; shift ??
         jz      iss3           ; no, skip
iss21:   stc
iss3:    rtn

;-------------------------------------
;-- check shift status ---------------
;-- for downshift returns ch = 1 else ch = 0
;-------------------------------------
DoCAPS: XOR     CH,CH          ; ch := 0
        CMP     AL,15          ; 0..15  ch := 1
        JBE     down
        CMP     AL,26          ; .. 26  ch := 1
        JBE     upsh
        Cmp     al,29
        jbe     down
        cmp     al,40
        jbe     upsh
        cmp     al,43
        jbe     down
        cmp     al,50
        jbe     upsh
down:   INC     CH
upsh:   or      ch,ch
        rtn

;-------------------------------------
;-- end of interrupt to controller ---
;-------------------------------------
S18EndInt:
        mov     KbFlag1,dh     ; save KbFlag1
EndInt: cli
        MOV     AL,20H         ; announce end of interrupt
        OUT     20H,AL         ; to interrupt control port
        rtn

;-------------------------------------
; find special key  BL gives the bit if found
;-------------------------------------
ChkShift:
        MOV     BL,1
        MOV     SI,OFFSET Special
        MOV     CX,8
sp1:    CMP     AL,CS:[SI]
        JZ      sp2
        SHL     BL,1
        INC     SI
        LOOP    sp1
sp2:    test    bl,insert      ; is it insert key ??
        jz      sp3            ; no, skip
        call    KPShift        ; check shift status
        jc      sp21           ; is not shifted
        test    dl,alt         ; skip on alt
        jz      sp3
sp21:   xor     bl,insert      ; reset that bit,
                               ; no insert toggle
sp3:    test    bl,ctrl        ; control?
        jz      sp4
        test    kbflag3,E0Flag ; 0e0h?
        jz      sp4
        or      ah,ah          ; make key ?
        js      sp301
        or      kbflag3,4      ; set flag
        jmps    sp31
sp301:  and     kbflag3,not 4  ; reset flag
sp31:
; by using the following section AltGr
; works like Alt and Ctrl together

sp4:    test    bl,alt         ; alt + modified is altgr.
        jz      sp41           ; no skip
        test    kbflag3,E0Flag ; 0e0h?
        jz      sp41
        or      bl,ctrl        ; add ctrl state
        or      ah,ah          ; make key ?
        js      sp401
        or      kbflag3,8h     ; set flag
        jmps    sp41
sp401:  and     kbflag3,not 8h ; reset flag
sp41:
if capbeep
        test    bl,caplock
        jz      sp5
        or      ah,ah          ; make key ?
        js      sp5
        call    errbeep        ; beep for caps lock press
sp5:
endif                          ; capbeep
        and     ah,7fh         ; reset release bit
        or      bl,bl
        rtn
if Apox
;-------------------------------------
;-- check apostrophes
;-- ret C = 1 if output ready
;-------------------------------------
ChkApo: cmp     ax,cs:apo      ; is same char ??
        jz      apoout         ; output single char
; search if current char is an apo
        mov     si,offset apotbl ; start of table
; no 255 allowed
apo1:   cmp     byte ptr cs:[si], -1  ; end of table ??
        jz      pending
        cmp     AL,CS:[SI]     ; al = apostrophe ??
        jz      apofound       ; yes, is one
apo11:  inc     si             ; si := si + 1
        cmp     byte ptr cs:[si], -1  ; end of local list ?
        jnz     apo11
        inc     si             ; skip end marker
        jmps    apo1
apofound:
        cmp     ah,43          ; key 43: apo is single char
at2     label   word
        jz      apoout
        mov     cs:apo,ax      ; save apostrophe
        inc     si
        mov     cs:apoptr,si   ; points to first entry
        clc                    ; flag no output
        rtn
pending:cmp     word ptr cs:apo,0 ; apo pending?
        jz      apoout         ; no, char out
        cmp     al,020h        ; is current char a space ??
        jnz     pend1
        mov     ax,CS:apo      ; get apostrophe
        jmps    apoout         ; gobble space, output apo

; apo is pending
pend1:  mov     si,cs:apoptr   ; start of local table
apo2:   cmp     AL,CS:[SI]     ; can char be modified ??
        jz      apo21          ; yes, match
        inc     si             ; si := si + 2
        inc     si
        cmp     byte ptr cs:[si], -1  ; end of local list ?
        jnz     apo2           ; no do next
;----
        push    ax             ; save current char
        mov     ax,CS:apo      ; get apostrophe
        CALL    PutInBuffer    ; output in buffer
        pop     ax             ; get back current char
        jmps    apoout
apo21:  inc     si
        mov     al,cs:[si]     ; get modified char
apoout: mov     word ptr cs:apo,0 ; reset pending apo
        STC                    ; flag output ready char AX
        rtn

;-------------------------------------
;--end of apostroph ------------------
;-------------------------------------
endif                          ; apox

if doint16
Do_16:  call    save
        sti
        call    ds40
        mov     di,offset do_end   ; push a return address
        push    di            ; to use subroutines
        cmp     ah,0          ; fct 0 and 10
        jz      getfrombuffer
        cmp     ah,10h
        jz      getfrombuffer
        cmp     ah,1          ; fct 1 and 11
        jz      chkbuffer
        cmp     ah,11h
        jz      chkbuffer
        cmp     ah,2          ; fct 2 and 11
        jz      getshift
        cmp     ah,12h
        jz      getshift

if not forceMF
        cmp     ah,3          ; fct 3
        jz      setrep
endif                         ; forceMF
        cmp     ah,5          ; fct 5
        jz      puttobuffer
        mov     ah,0ffh       ; flag bad command
        pop     di            ; drop return address
do_end: mov     SavedAX,ax    ; store AX
        call    restore
        iret

;-------------------------------------
; for IBM functions 0 and 1
; "new" scancodes are invalid
;-------------------------------------
;-- function 0/10:
;-- get char from buffer,
;-- waits for key press if no char waiting
;-- on exit: ax contains code.
;-------------------------------------
getb0:
if int15df
        mov     ax,9002h       ; multitasking hook
        int     15h
endif                          ; int15df
GetFromBuffer:
        cli
        mov     di,buffer_head
        cmp     di,buffer_tail ; any key ??
        sti
        jz      getb0
getb1:  mov     ax,[di]        ; get char into ax
        call    set_di
        mov     buffer_head,di
        rtn

;-------------------------------------
;-- function 1/11:
;-- checks if any char waiting
;-- if char available returns z=0, char in ax
;-- char remains in buffer
;-- if no char, returns z=1
;-------------------------------------
ChkBuffer:
        cli
        and     savedF,not zeroflag  ; reset zero flag
        mov     di,buffer_head
        cmp     di,buffer_tail  ; any key ??
        mov     ax,[di]         ; get char into ax
        jnz     chkb1
        or      savedF,zeroflag ; set zero flag on stack
chkb1:  sti
        rtn

;-------------------------------------
; old IBM functions 2 is marked
;-------------------------------------
;-- function 2/12: get shift status
;-- standard f 2 only returns kbflag in al
;-- extended f 12 returns kbflag in
;-- al and a combined flag byte in ah
;---
;---  7   system request pressed and held
;---  6   caps lock pressed
;---  5   num lock pressed
;---  4   scroll lock pressed
;---  3   right alt down
;---  2   right ctrl down
;---  1   left alt down
;---  0   left ctrl down
;-------------------------------------
getshift:
        xor     ah,ah          ; reset output
        mov     bh,kbflag3     ; get extended (wow!) status
        mov     bl,kbflag1
        test    bl,4           ; system key?
        jz      gsh1           ; no, skip
        or      ah,080h        ; set status bit
gsh1:   and     bl,01110011b   ; mask flags
        or      ah,bl          ; merg e status bits
        and     bh,00001100b   ; mask bits
        or      ah,bh          ; add them in
old_fct2:
        mov     al,kbflag      ; get shift status
        rtn

;-------------------------------------
;-- function 5
;-- place scancode/ascii in buffer
;-- on entry:  ch scancode, cl ascii code
;-- exit:      al = 0: o.k., al = 1: buffer was full
;--            carry set on error
;-------------------------------------
PutTobuffer:
        and     savedF,not carryflag  ; reset carry flag
        mov     ax,cx
        call    putinbuffer
        mov     al,0           ; NOT !!! xor al,al
        jnc     ptb0           ; no carry -> ok
        inc     al             ; ah=1
        or      savedF,carryflag      ; flag error
ptb0:   mov     ah,5           ; restore
        rtn

;-------------------------------------
;-- function 3  set repeat delay and rate (AT only)
;-- on entry:  al 05h
;--            bl typematic rate
;--               00  30.0 char/sec
;--         ...   1f   2.0 char/sec
;--            bh typematic delay
;--               00  250 msec   01  500 msec
;--               02  750 msec   03 1000 msec
;-------------------------------------
if not forceMF
setrep: cmp     al,5
        jnz     srex
        cmp     bh,3           ; chk bounds
        ja      srex
        cmp     bl,01fh
        ja      srex
        mov     al,0f3h        ; command
        call    outdta
        mov     cl,5
        mov     al,bh          ; delay
        shl     al,cl
        or      al,bl          ; or rate
        call    outdta
srex:   rtn
endif                          ; forceMF
endif                          ; doint16
;------------------------------------
;-- miscellaneous routines
;------------------------------------
if not forceMF

leds:   test    kbflag2,040h   ; update ?
        jnz     ledout
leds1:  push    ax
        mov     al,kbflag      ; get led status
        mov     ah,kbflag2
        and     ax,0770h
        mov     cx,04h
        shr     al,cl
        cmp     al,ah          ; status changed ?
        jz      ledou1         ; no change
        mov     ah,al          ; save new status in ah
        or      al,040h        ; update in progress
        and     kbflag2,not 7  ; mask led flags
        or      kbflag2,al     ; update flags
        mov     al,0edh
        call    outdta
        mov     al,ah
        call    outdta
        mov     al,0f4h
        call    outdta
        and     kbflag2,3fh    ; update done
ledou1: pop     ax
ledout: rtn
outdta: push    ax
        push    bx
        push    cx
        mov     bh,al
        mov     bl,3
odta0:  cli
        and     kbflag2,0cfh
        xor     cx,cx
odta1:  in      al,64h
        and     al,2
        loopnz  odta1
        mov     al,bh
        out     60h,al
        sti
        mov     cx,02000h
odta2:  test    kbflag2,30h
        jnz     odta4
        loop    odta2
odta3:  dec     bl
        jnz     odta0
        or      kbflag2,80h
        jmps    odta5
odta4:  test    kbflag2,10h  ; wait for acknowledge
        jz      odta3
odta5:  pop     cx
        pop     bx
        pop     ax
        rtn
endif                        ; forceMF
;-------------------------------------
;--error beep ------------------------
;-------------------------------------
ErrBeep:PUSH    CX       ; save
        PUSH    BX
        PUSH    AX
        mov     bl,3
        mov     ah,040h
        IN      AL,61H
        MOV     BH,AL
        OR      AL,3
        OUT     61H,AL
loop2:  MOV     CH,AH
loop1:  LOOP    loop1
        DEC     BL         ;BL
        JNZ     loop2
        MOV     AL,BH
        OUT     61H,AL
        POP     AX
        POP     BX
        POP     CX
        rtn

;-------------------------------------
;-- Put into buffer
;-------------------------------------
PutInBuffer:
        push    di
        MOV     DI,Buffer_Tail ; space in buffer ?
        call    set_di         ; advance pointer
        CMP     DI,Buffer_Head ; end of buffer ?
        jz      pib0           ; yes, error
        MOV     DI,Buffer_Tail ; get buffer ptr again
        MOV     [DI],AX        ; save char in buffer
        CALL    SET_DI         ; advance pointer
        MOV     Buffer_Tail,DI ; save buffer pointer
        clc
        pop     di
        rtn
pib0:   call errbeep
        stc
        pop     di
        rtn

;-------------------------------------
;--adjust buffer pointer -------------
;-------------------------------------
SET_DI: add     di,2
        CMP     di,[buffer_end]
        jnz     sdi1
        MOV     di,[buffer_start]
sdi1:   rtn

;-------------------------------------
; Set DS to $00400 (BIOS parameters)
;-------------------------------------
DS40:   push    ax
        mov     ax,40H
        mov     ds,ax
        pop     ax
        rtn

;-------------------------------------
;--save register set -----------------
;-------------------------------------
Save:   push    ax
        PUSH    BX
        PUSH    CX
        PUSH    DX
        PUSH    DI
        PUSH    SI
        PUSH    BP
        PUSH    DS
        PUSH    ES
        MOV     bp,sp
        jmp     [bp+12H]       ; return address !!

;-------------------------------------
;-- restore register set -------------
;-------------------------------------
Restore:POP     SI             ; get return address
        MOV     [bp+12H],SI    ; save on stack
        POP     ES
        POP     DS
        POP     BP
        POP     SI
        POP     DI
        POP     DX
        POP     CX
        POP     BX
        pop     ax
        rtn
;-------------------------------------
Install: assume  ds:vectors
         xor     ax,ax             ; set DS := 0
         mov     ds,ax
         CLI
         mov     es,Vec9s       ; get old vector
         mov     ax,Vec9o
         mov     cs:oldvec+2,es ; save it
         mov     cs:oldvec,ax
         MOV     ax,OFFSET Do_9 ; set int 9 entry point
         MOV     Vec9s,CS
         MOV     Vec9o,ax
if doint16
         mov     es,Vec16s      ; get old vector
         mov     ax,Vec16o
         mov     cs:oldv16+2,es ; save it
         mov     cs:oldv16,ax
         MOV     ax,OFFSET Do_16; set int 16 entry point
         MOV     Vec16s,CS
         MOV     Vec16o,ax
endif                           ; doint16
         sti
         assume  ds:code
         MOV     dx,offset titl    ; title
         push    cs
         pop     ds
         mov     ah,9
         int     21h
         assume  ds:bios
         call    ds40
if not forceMF
         mov     al,0f2h        ; read ID
         or      kbflag3,80h    ; doing rd-id
         out     60h,al
         xor     cx,cx
id6:     nop
         loop    id6
         mov     ax,id          ; get ID
         cmp     ax,041abh      ; marker for MF keyboard
         jz      IsMfk
         test    kbflag2,10h    ; acknowledge ?
         jz      pck            ; no reaction from keyboard

; is an AT - Keyboard

         assume  ds:code
         push    cs
         pop     ds
if atcoding
         mov     ax,03c3eh      ; patch table
         mov     mf1,ax
         mov     ax,0235eh
         mov     mf2,ax
         mov     al,41          ; patch key 43 to 41
         mov     mf3,al
         mov     mf4,al
         mov     al,43
         mov     at1,al
endif                           ; atcoding
if apox
         mov     ax,09090h      ; disable MF feature
         mov     at2,ax         ; nop, nop
endif                           ; apox
         mov     al,0f3h        ; set repeat rate / delay
         call    outdta
         mov     al,48h         ; 15 chars/s  250ms
         call    outdta
         mov     dx,offset MsgAT
         jmps    EndIns
endif                           ; forceMF

IsMfK:   assume  ds:bios
         or      kbflag3,010h   ; indicate MF-Keyboard
         assume  ds:code
         push    cs
         pop     ds
         mov     ax,05ef8h      ; patch table
         mov     mf1,ax
         mov     ax,02327h
         mov     mf2,ax
         mov     al,86             ; patch key 43 to 86
         mov     mf3,al
         mov     mf4,al
         assume  ds:bios
         call    ds40
         or      kbflag,byte ptr numlock ; set numlock
         MOV     dx,offset msgmfk
         jmps    EndIns
If not forceMF

PCK:     MOV     dx,offset MsgPC
if kxlate
         assume  ds:code
         push    cs
         pop     ds
         mov     ah,9
         int     21h
         mov     dx,offset XlateIt
endif                           ; kxlate
endif                           ; forceMF
EndIns:  assume  ds:code
         push    cs
         pop     ds
         mov     ah,9
         int     21h
if not forceMF
         assume  ds:bios
         call    ds40
         call    leds1
         and     kbflag3,7fh    ; reset rd-id
         assume  ds:code
         push    cs
         pop     ds
endif                           ; forceMF
         MOV     dx,offset NewLine
         mov     ah,9
         int     21h
if doint16
         MOV     dx,offset msgi16
         mov     ah,9
         int     21h
endif                              ; doint16
         MOV     DX,OFFSET Install ; length of prog
         INT     27H               ; leave - stay resident.

MsgMfk   db      'MF$'
if not forceMF
MsgPC    db      'PC$'
MsgAt    db      'AT$'
NewLine  db      ' keyboard attached.',10,13,'$'
else
NewLine  db      ' keyboard forced.',10,13,'$'
endif
if kxlate
XlateIt  db      ' xlate to MF ',10,13,'$'
endif
if doint16
msgi16  db       'Int 16 routine installed.',13,10,'$'
endif
code    ENDS
;
END     Start
