program heapreplace(input,output);


const bufsize = 254;  (* GERADZAHLIG !!! *)


type { Mac     integer_4 = longint;      {}
     { Atari } integer_4 = long_integer; {}
     string255  = string[255];
     bufpointer = ^bufmem;
     bufmem     = record
                    buf : string[bufsize];    (* Textfragment  *)
                    vor, nach: bufpointer;    (* Listenpointer *)
                  end;


var bufbegin,                    (* Listenanker Anfang         *)
    bufend,                      (* Listenanker Ende           *)
    bufwork  : bufpointer;       (* Arbeitspointer             *)
    text_len : integer_4;        (* akt. Zeichenanzahl im Text *)
    bufpos   : integer_4;        (* akt. Zeichenposit. im Text *)
    workver  : integer;          (* Position im akt. Fragment  *)


(* Variabeln nur fr das Testprogramm : *)

var  c  : char;
     fc : integer_4;
     pr : integer;

{public}
procedure init_heap;
begin
  if odd(bufsize)
    then begin
           writeln(chr(7),'nur geradzahlige Bufferlngen !');
           readln;
           halt;
         end;
  bufbegin := nil;                (* Grundzustand einer leeren *)
  bufend   := nil;                (* Liste initialisieren...   *)
  bufwork  := nil;
  text_len := 0;
end;


{intern}
procedure fetch_neu(var n : bufpointer);
(* neues Textfragment in der Liste einfgen *)
var hold : bufpointer;
begin
  new(n);
   if bufwork^.nach=nil
     then begin                     (* am Ende      --------|  *)
            hold      := bufend;    (* Listenende merken       *)
            bufend    := n;         (* neues El. wird Listende *)
            hold^.nach:= n;         (* an vorletztes anhngen  *)
            n^.vor    := hold;      (* auf Vorgnger zeigen    *)
            n^.nach   := nil;       (* kein Nachfolger         *)
          end
    else  begin                     (* in der Mitte ---|-----  *)
            (* Auftrennen der Liste hinter bufwork und neues   *)
            (* Element einhngen                               *)
            hold          := bufwork^.nach;
            bufwork^.nach := n;
            hold^.vor     := n;
            n^.vor        := bufwork;
            n^.nach       := hold;
         end;
  n^.buf:='';
end;


{intern}
procedure del_buf(var point : bufpointer);
(* Nicht mehr bentigtes Element freigeben und aus der         *)
(* Liste entfernen                                             *)
var c   : char;
    v,n : bufpointer;
begin
  c:='B';                                   (* in der Mitte    *)
  if point  = bufbegin then c:='A';         (* am Anfang       *)
  if point  = bufend   then c:='C';         (* am Ende         *)
  if bufend = bufbegin then c:='D';         (* letztes Element *)

  case c of
    'A' : begin
            bufbegin     := point^.nach; (* Listenanfang auf   *)
                                         (* zweites Element    *)
            bufbegin^.vor:= nil;         (* Vorgnger abhngen *)
            dispose(point);              (* Speicher freigeben *)
            point   := bufbegin;
            workver := 0;
          end;

    'B' : begin
            (* Element in der Mitte lschen und freigeben *)
            v      := point^.vor;
            n      := point^.nach;
            v^.nach:= point^.nach;
            n^.vor := point^.vor;
            dispose(point);
            point  := n;
            workver := 0;
         end;

    'C' : begin
            (* Listenende auf vorletztes Element,         *)
            (* dessen Nachfolger wird abgehngt und frei- *)
            (* gegeben                                    *)
            bufend   := point^.vor;
            bufend^.nach := nil;
            dispose(point);
            point   := bufend;
            bufpos  := bufpos-1;
            workver := length(point^.buf)-1;
          end;

    'D' : begin
            (* allerletztes Listenelement wird entfernt   *)
            bufbegin := nil;
            bufend   := nil;
            dispose(point);
            point    := nil;
            workver  := 0;
          end;
   end;
end;

{intern}
procedure checkbuf(p : integer_4);
(* sucht das Fragment, in dem das p-te Zeichen gespei-    *)
(* chert ist und setzt die Variablen workver und bufpos   *)
(* entsprechend                                           *)
var neu : bufpointer;
begin
  if (p>text_len+1) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in CHECKBUF');
      readln;
      halt;
    end;
  if p<>bufpos then
    begin
      if p<bufpos
        then begin                            (* p<bufpos *)
               if p<bufpos-workver
                 then begin
                        bufpos  := bufpos-workver;
                        workver := 0;
                        repeat
                          bufwork:=bufwork^.vor;
                          bufpos :=bufpos-length(bufwork^.buf);
                        until p>=bufpos;
                      end
                else  begin
                        bufpos:=bufpos-workver;
                      end;
             end
        else begin                            (* p>bufpos *)
               if p>bufpos-workver+length(bufwork^.buf)
                 then begin
                        bufpos  := bufpos-workver+
                                   length(bufwork^.buf)-1;
                        workver := 0;
                        repeat
                          bufwork := bufwork^.nach;
                          bufpos  := bufpos+length(bufwork^.buf);
                        until (p<=bufpos) or (bufwork^.nach=nil);
                        bufpos:=bufpos-length(bufwork^.buf)+1;
                      end
                 else begin
                        bufpos:=bufpos-workver;
                      end;
             end;
    workver := p-bufpos;
    bufpos  := p;
  end;
end;


{public}
procedure in_char(c : char; p : integer_4);
(* neues Zeichen c an Position p einfgen *)
var neu,hold,q : bufpointer;
    s          : string[1];
    w          : char;


  procedure put_in_next;
  (* kein Platz mehr im aktuellen Element, *)
  (* daher neues anlegen                   *)
  begin
  fetch_neu(neu);
  if workver<>bufsize
    then begin
           (* Z.pos. mitten im Frg. --> splitten *)
           neu^.buf := copy(bufwork^.buf,workver+1,
                                         bufsize-workver);
           delete(bufwork^.buf,workver+1,bufsize-workver);
           bufwork^.buf := concat(bufwork^.buf,c);
         end
    else begin                 (* Z.pos. direkt nach akt. Frg. *)
           neu^.buf:=s;        (* --> Zeichen in neues Element *)
           workver:=0;
           bufwork:=neu;
         end;
  end;

begin
  if (p>text_len+1) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in IN_CHAR');
      readln;
      halt;
    end;
  s:=' '; s[1]:=c;
  if bufwork=nil
    then begin  (* erstes Zeichen in eine leere Liste einfgen *)
           new(neu);
           bufend    := neu;
           bufbegin  := neu;
           bufwork   := neu;
           neu^.buf  := s;
           neu^.nach := nil;
           neu^.vor  := nil;
           bufpos    := 1;
           workver   := 0;
         end

    else begin
           checkbuf(p);                 (* aktuelle Position setzen *)
           if workver = bufsize
             then begin           (* Einf.pos. direkt nach akt. El. *)
                    if bufwork^.nach=nil
                      then begin  (* Listenende -->                 *)
                                  (* neues Element anfgen          *)
                             fetch_neu(neu);
                             bufwork:=neu;
                           end
                      else begin  (* auf nchstes positionieren     *)
                             bufwork:=bufwork^.nach;
                           end;
                    workver:=0;
                  end;

           if length(bufwork^.buf)<bufsize
             then begin                       (* Element nicht voll *)
                    if workver+1>length(bufwork^.buf)
                      then bufwork^.buf := concat(bufwork^.buf,c)
                      else insert(s,bufwork^.buf,workver+1);
                  end
             else begin                         (* Element ist voll *)
                    if bufwork^.nach=nil
                      then put_in_next          (* an Listenende    *)
                      else begin
                             (* Platz im nchsten Element?                *)
                             if length(bufwork^.nach^.buf)=bufsize
                               then put_in_next      (* Nein --> splitten *)
                             else begin              (* Ja   --> also ... *)
                                    w:=bufwork^.buf[bufsize];
                                    delete(bufwork^.buf,bufsize,1);
                                    insert(w,bufwork^.nach^.buf,1);
                                    if workver=length(bufwork^.buf)
                                      then bufwork^.buf:=concat(bufwork^.buf,c)
                                      else insert(c,bufwork^.buf,workver+1);
                                  end;
                           end;
                  end;
         end;
  text_len:=text_len+1; (* Gesamttext wurde um ein Zch. lnger *)
end;


{intern}
procedure split_element(p : integer_4);
(* sicherstellen, da an Textpos.p ein neues Fragment beginnt *)
var neu : bufpointer;
begin
  if (p>text_len) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in SPLIT_ELEMENT');
      readln;
      halt;
    end;
  checkbuf(p);
  if workver=bufsize then
    begin                                     (* splitten *)
      bufwork:=bufwork^.nach;                 (* unntig  *)
      workver:=0;
    end;
  if (workver>0) and (workver<>length(bufwork^.buf)) then
    begin                                   (* splitten ! *)
      fetch_neu(neu);
      neu^.buf:=copy(bufwork^.buf,workver+1,
                    length(bufwork^.buf)-workver);
      delete(bufwork^.buf,workver+1,length(bufwork^.buf)-workver);
      bufwork:=bufwork^.nach;
      workver:=0;
    end;
end;


{public}
function get_char(p : integer_4) : char;
(* liefert das Zeichen an der Position p im Text *)
begin
  if (p>text_len) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in GET_CHAR');
      readln;
      halt;
    end;
  checkbuf(p);
  if workver=length(bufwork^.buf) then
    begin
      bufwork:=bufwork^.nach;
      workver:=0;
    end;
  get_char:=bufwork^.buf[workver+1]; (* Zeichen aus akt. Frg. holen *)
end;


{public}
function find_for(p : integer_4; such : string255) : integer_4;
(* Suchen des Strings such ab Position p im Text vorwrts *)
var i,l   : integer;
    lim   : integer_4;
    found : boolean;
begin
  if (p>text_len) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in FIND_FOR');
      readln;
      halt;
    end;
  found:=false;
  l:=length(such);
  lim:=text_len-l+1;
  if (p<=lim) and (l<>0) then
    begin
      i:=1;
      repeat
        if get_char(p+i-1)=such[i]
          then begin
                 if i=l then found:=true
                        else i:=i+1;
               end
          else begin
                 p:=p+1;
                 i:=1;
               end;
      until (found) or (p>lim);
    end;
  if found then find_for:=p
           else find_for:=0;
end;


{public}
function find_back(p : integer_4; such : string255) : integer_4;
(* Suchen des Strings such ab Position p im Text rckwrts *)
var i,l   : integer;
    lim   : integer_4;
    found : boolean;
begin
  if (p>text_len) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in FIND_BACK');
      readln;
      halt;
    end;
  found:=false;
  l:=length(such);
  lim:=p-l+1;
  p:=lim;
  if (p>=1) and (l<>0) then
    begin
      i:=1;
      repeat
        if get_char(p+i-1)=such[i]
          then begin
                 if i=l  then found:=true
                         else i:=i+1;
               end
          else begin
                 p:=p-1;
                 i:=1;
               end;
      until (found) or (p<1);
    end;
  if found then find_back:=p
           else find_back:=0;
end;



{public}
procedure ride_char(c : char; p : integer_4);
(* berschreiben des Zch. an Position p mit c *)
begin
  if (p>text_len) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in RIDE_CHAR');
      readln;
      halt;
    end;
  checkbuf(p);
  if workver=length(bufwork^.buf) then
    begin
      bufwork:=bufwork^.nach;
      workver:=0;
    end;
  bufwork^.buf[workver+1]:=c;   (* Zeichen im Frg. ersetzen *)
end;


{intern}
procedure put_together(b : bufpointer);
(* Es wird geprft, ob zwei benachbarte Fragmente zu einem  *)
(* zusammengefat werden knnen und ggf. eines freigegeben. *)
(* Wenn es sich nicht um das 1. Fragment handelt, wird      *)
(* geprft, ob der Text des Vorgnger-Frg. sich noch im     *)
(* aktuellen Fragment unterbringen lt                     *)
var h  : bufpointer;
    wv : integer;
begin
  h:=b^.vor;
  if h<>nil then
    begin
      if length(h^.buf)+length(b^.buf) <= bufsize then
        begin
          b^.buf:=concat(h^.buf,b^.buf);    (* Text des Vorgngers  *)
                                            (* ins aktuelle Element *)
          wv:=workver+length(h^.buf);       (* workver erhhen      *)
          del_buf(h);                (* nicht gebrauchtes freigeben *)
          workver:=wv;
        end;
    end;
end;



{public}
procedure del_char(p : integer_4);
(* Lschen des Zeichens an Pos. p aus dem Text *)
begin
  if (p>text_len) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in DEL_CHAR');
      readln;
      halt;
    end;
  checkbuf(p);

  if length(bufwork^.buf)=workver then
    begin
      bufwork:=bufwork^.nach;
      workver:=0;
    end;

  if length(bufwork^.buf)>1
    then begin                    (* es bleiben Zeichen im Fragment *)
           delete(bufwork^.buf,workver+1,1);
           if workver=length(bufwork^.buf)
             then begin
                    if bufwork=bufend      (* neupos. der Variablen *)
                      then begin
                             bufpos:=bufpos-1;
                             workver:=workver-1;
                           end
                      else begin
                             workver:=0;
                             bufwork:=bufwork^.nach;
                           end;
                  end;

           put_together(bufwork);   (* ggf. zusammenfassen *)
         end
    else begin                      (* Fragment wird leer  *)
           del_buf(bufwork);        (* Fragment entfernen  *)
         end;
  text_len:=text_len-1;   (* Text wurde um ein Zch. krzer *)
end;



{public}
procedure del_text(a,e : integer_4);
(* Lschen aller Zeichen des Textes von a - e  *)
var hold : bufpointer;
    l    : integer;
    an   : integer_4;
begin
 if (a>e) or (a<1) or (e>text_len) then
   begin
     writeln('Pointer ausserhalb Text in DEL_TEXT');
     readln;
     halt;
   end;
  e:=e+1;                             (* hinter e splitten     *)
  an:=e-a;
  if e<=text_len then split_element(e);
  checkbuf(a);
  split_element(a);                   (* vor a splitten        *)

  repeat                              (* Alle Frg. zwischen    *)
    hold:=bufwork;                    (* a und e werden frei-  *)
    l:=length(bufwork^.buf);          (* gegeben. Diese Meth.  *)
    an:=an-l;                         (* ist wesentlich        *)
    text_len:=text_len-l;             (* schneller als freig.  *)
    bufwork:=bufwork^.nach;           (* einzelner Zeichen mit *)
    del_buf(hold);                    (* del_char.             *)
  until an=0;
  if bufwork=nil
    then begin
           bufwork:=bufbegin;
           bufpos:=1;
           workver:=0;
         end
    else put_together(bufwork);    (* ggf. Teilfrg. vereinigen *)
end;

{public}
procedure disk_write(a,e : integer_4; name : string255);
var datei : text;
    an    : integer_4;              (* Schreiben aller Zeichen *)
    l     : integer;                (* des Textes von a - e    *)
                                    (* in das File name        *)
begin
  if (a>e) or (a<1) or (e>text_len+1) then
    begin
      writeln('Pointer ausserhalb Text in DISK_WRITE');
      readln;
      halt;
    end;
  rewrite(datei,name);
  e:=e+1;
  an:=e-a;
  if e<=text_len then split_element(e);
  checkbuf(a);
  split_element(a);
  repeat                                   (* siehe del_text ! *)
    write(datei,bufwork^.buf);
    l:=length(bufwork^.buf);
    bufpos:=bufpos+l;
    an:=an-l;
    bufwork:=bufwork^.nach;
  until an=0;
  close(datei);

  if bufwork=nil then
    begin
      bufwork:=bufbegin;
      bufpos:=1;
      workver:=0;
    end;
end;

{public}
procedure disk_read(p : integer_4; name : string255);
(* fgt das File name an p in den Text ein *)
var datei    : text;
    c        : char;
    eol_flag : boolean;
begin
  if (p>text_len+1) or (p<1) then
    begin
      writeln('Pointer ausserhalb Text in DISK_READ');
      readln;
      halt;
    end;
  reset(datei,name);
  eol_flag:=false;
  while not eof(datei) do
    begin
      eol_flag:=eoln(datei);
      read(datei,c);
{ Mac ------------------------------
      if eol_flag then c:=chr(13);
      in_char(c,p);  p:=p+1;               { Macintosh }
{ Atari ----------------------------  }
      if not eof(datei) then
        begin
          if eol_flag then
            begin
              in_char(chr(13),p);  p:=p+1;
              c:=chr(10);
            end;
          in_char(c,p);  p:=p+1;
        end;                               { Atari      }
    end;

  close(datei);
end;


{-------------------- A p p l i k a t i o n -------------------}

procedure load_file;
var name:string255;
begin
  writeln('Eingabedatei : ');
  readln(name);
  writeln('reading...');
  if text_len<>0 then del_text(1,text_len);
  disk_read(1,name);
end;

procedure save_file;
var name:string255;
begin
  writeln('Ausgabedatei : ');
  readln(name);
  writeln('writing...');
  disk_write(1,text_len,name);
end;

procedure display_text(mode:boolean);
const txt=false;
      ctr=true;
var von,nach,i : integer_4;
    ch         : char;
begin
  if text_len<>0 then
    begin
      write('Ausgabe von Zeichen : ');
      readln(von);
      write('bis Zeichen         : ');
      readln(nach);
      if von <1        then von:=1;
      if nach>text_len then nach:=text_len;
      i:=von;
      repeat
        ch:=get_char(i);

        if (ch>chr(31)) and (ch<chr(128))
          then write(ch)
          else begin
                 if mode<>txt then write('<',ord(ch):1,'>');
                 if ch=chr(13) then writeln;
               end;
        i:=i+1;
      until i>nach;
      writeln;
    end;
end;

procedure read_ctrl_str(var s : string255);
var p,w : integer;
begin
  readln(s);

  p:=pos('#',s);
  while p>0 do
    begin
      w:=100*(ord(s[p+1])-48) + 10*(ord(s[p+2])-48)
                              + (ord(s[p+3])-48);
      if (w>=0) and (w<=255) then
        begin
          delete(s,p,3);
          s[p]:=chr(w);
          p:=pos('#',s);
        end;
    end;
end;

procedure exc_text(p:integer_4;ls:integer;var repl:string255);
var j:integer;
begin
  del_text(p,p+ls-1);
  for j:=1 to length(repl) do in_char (repl[j],p+j-1);
end;

procedure replace_text;
var von,nach,p,i : integer_4;
    c,ch         : char;
    repl,such    : string255;

  procedure disp_context(p:integer_4;l:integer;such:string255);
  var von,nach,i : integer_4;
      ch         : char;
  begin
    von:=p-l; nach:=p+length(such)+l;
    if von <1        then von:=1;
    if nach>text_len then nach:=text_len;
    i:=von;
    repeat
      ch:=get_char(i);
      if (ch>chr(31)) and (ch<chr(128))
        then write(ch) else write('.');
      i:=i+1;
    until i>nach;
    writeln;
    i:=von;
    repeat
      if (i>=p) and (i<p+length(such))
        then write('^')
        else write(' ');
      i:=i+1;
    until i>nach;
    writeln;
  end;

begin
  if text_len<>0 then
    begin
      write('Suchstring (ASCII-Codes auch als #123) : ');
      read_ctrl_str(such);
      write('Ersetzen durch                         : ');
      read_ctrl_str(repl);
      c:='F';
      p:=1;
      repeat
        if p<=text_len then p:=find_for(p,such) else p:=0;
        if p=0 then c:='X'
          else begin
                 if not (c in ['a','A'])
                   then
                     begin
                       disp_context(p,20,such);
                       write('Austauschen?  N)ein j)a a)lle q)uit: ');
                       readln(c);
                       if c=' '     then c:='N';  {  z.B. Atari     }
                    {  if c=chr(13) then c:='N';     z.B. Macintosh }
                     end;

                 case c of
                   'N','n' : p:=p+length(such);
                   'J','j' : begin
                               exc_text(p,length(such),repl);
                               p:=p+length(repl);
                             end;
                   'A','a' : begin
                               exc_text(p,length(such),repl);
                               p:=p+length(repl);
                               write('.');
                             end;
                   'Q','q' : c:='X';
                 end; { case }

               end;
      until c='X';
    end;
end;

procedure get_frag_stat(var f : integer_4; var n : integer);
var bufloop: bufpointer;
begin
  bufloop:=bufbegin;
  f:=0;
  while bufloop<>nil do
    begin
      f:=f+1;
      bufloop:=bufloop^.nach;
    end;
  if f<>0 then n:=round(text_len / (f*bufsize) *100)
          else n:=100;
end;

begin
 (*****************************)
 (*       Hauptprogramm       *)
 (*****************************)
  init_heap;

  repeat
    get_frag_stat(fc,pr);
    writeln;
    writeln('L)oad S)ave D)isp C)ontr R)epl Q)uit    ',
            text_len:1,' Byte in ',fc:1,' Frag. = ',pr:1,' %');
    readln(c);

    case c of
      'L','l' : load_file;
      'S','s' : save_file;
      'D','d' : display_text(false);
      'C','c' : display_text(true);
      'R','r' : replace_text;
     { Mac     otherwise   writeln('?'); {}
     { Atari } otherwise : writeln('?'); {}
    end; { case }

  until c in ['q','Q'];

  if text_len<>0 then del_text(1,text_len);
end.
