#ifndef __IDEA_HPP_OGM
#define __IDEA_HPP_OGM

#include <stdexcept>
#include <time.h>

// Anzahl der Runden und resultierende Schlssellnge
#define IDEAROUNDS 8
#define IDEAKEYLEN (6*IDEAROUNDS+4)

class IDEACipher;

// Klasse IDEAKey - Kapselung von IDEA-Schlsseln
class IDEAKey
{
	public:
		IDEAKey();
		IDEAKey(unsigned char *userkey);
		~IDEAKey();

		const unsigned short *getEncryptionKey();
		const unsigned short *getDecryptionKey();

		void generateKey_start();
		bool generateKey_action();
		void generateKey_end();
		
		void setkey(const unsigned char aUserKey[16]);

	protected:
		unsigned char UserKey[16];
		unsigned short EncryptionKey[IDEAKEYLEN], 
		               DecryptionKey[IDEAKEYLEN];
		time_t time1, time2;
		unsigned byte_pos, bit_pos;

		void generatePartKeys();
		unsigned short mulInv(unsigned short x);
};

inline const unsigned short *IDEAKey::getEncryptionKey()
{
	return EncryptionKey;
}

inline const unsigned short *IDEAKey::getDecryptionKey()
{
	return DecryptionKey;
}

// Klasse XNoIDEAKey - Exception wenn kein Schlssel spezifiziert ist
class XNoIDEAKey : public std::exception
{
	public:
		virtual const char* what () const throw();
};

// Klasse IDEA - Kapselung von IDEA
class IDEA
{
	public:
		IDEA();
		IDEA(IDEAKey *aKey);

		void setkey(IDEAKey *aKey);
		void encrypt(const unsigned char *inbuf, IDEACipher& outObj, 
		             unsigned size);
		void decrypt(const IDEACipher& inObj, unsigned char *&outbuf);

	protected:
		IDEAKey *key;

		void cipher(unsigned char const inbuf[8], unsigned char outbuf[8],                    unsigned short const *key);
		void mul(unsigned short& x, unsigned short y);
};

inline void IDEA::setkey(IDEAKey *aKey)
{
	key = aKey;
}

inline void IDEA::mul(unsigned short& x, unsigned short y)
{
	unsigned short t16;
	unsigned int t32;

	if ((t16 = y) != 0)
		if (x != 0) {
		    // x = (unsigned short)(((unsigned int)x * y ) % 65537)
			t32 = (unsigned int)x * t16;
			x = t32;
			t16 = t32 >> 16;
			x = (x - t16) + (x < t16);
		}
		else
			x = 1 - t16;
	else
		x = 1 - x;
}

// Klasse IDEACipher - Kapselung von IDEA-Chiffraten
class IDEACipher
{
	public:
    	IDEACipher();
    	~IDEACipher();

        const unsigned char operator[](unsigned index);
        unsigned getSize();

    protected:
    	friend void IDEA::encrypt(const unsigned char *inbuf, 
    	                          IDEACipher& outObj, unsigned size);
        friend void IDEA::decrypt(const IDEACipher& inObj, 
                                  unsigned char *&outbuf);

    	unsigned size;
        unsigned char *buffer;

        void setBufferSize(unsigned aSize);
};

inline unsigned IDEACipher::getSize()
{
	return size;
}

inline const unsigned char IDEACipher::operator[](unsigned index)
{
	if(index < size)
		return buffer[index];
	else
		return '\0';
}

#endif
