' VERSIONEN.VBS
' listet alle DLLs im Systemordner mit
' ihrer internen Versionsnummer auf
' (C) Tobias Weltner, c't 21/99

set wshshell = CreateObject("WScript.Shell")
set fs = CreateObject("Scripting.FileSystemObject")

' Diese Liste nimmt Versionsinfos auf:
redim liste(3000,1)
counter=0

wshshell.Popup "Prfe DLL-Versionen. Bitte Geduld!", 1

' Windows-Ordner ermitteln:
windir = wshshell.ExpandEnvironmentStrings("%WINDIR%")

' Protokolldatei ffnen:
logbuchname = "C:\DLL.HTM"
set logbuch = fs.CreateTextFile(logbuchname, true)
logbuch.WriteLine "<html><style>td {font:10pt Arial;" _
		& " background:""#CCCCCC""}</style><body><table>"
logbuch.WriteLine "<tr><td><b>DLL-Name</b></td>"_
		& "<td><b>Version</b></td></tr>"
' Systemordner ffnen:
set system = fs.GetFolder(windir & "\system")

' alle Dateien darin kontrollieren
for each file in system.files
	ext = lcase(fs.GetExtensionName(file.name))
	if ext="dll" then
		' es ist eine DLL, also Version bestimmen:
		ver = GetVer(file.path)
		' notieren:
		liste(counter,0) = lcase(file.name)
		liste(counter,1) = ver
		counter = counter + 1
	end if
next

SortResult 0
WriteResult

' Protokoll schlieen und anzeigen:
logbuch.WriteLine "</table></body></html>"
logbuch.Close
wshshell.run logbuchname

function GetVer(pfad)
	on error resume next
	GetVer = CStr(fs.getFileVersion(pfad))
	if not err.Number=0 then
		GetVer = "??"
		err.clear
	end if
end function

sub WriteResult
	for x=0 to counter-1
		logbuch.WriteLine "<tr><td>" _
		& liste(x,0) & "</td><td>" _
		& liste(x,1) & "</td></tr>"
	next
end sub

sub sortresult(modus)
	if modus<0 or modus>1 then
		MsgBox "Sortiermodus mu 0 oder 1 sein!"
		exit sub
	end if
	for x=0 to counter-1
		for y=x+1 to counter-1
			if liste(x,modus)>liste(y,modus) then
				temp1 = liste(x,0)
				temp2 = liste(x,1)
				liste(x,0) = liste(y,0)
				liste(x,1) = liste(y,1)
				liste(y,0) = temp1
				liste(y,1) = temp2
			end if
		next
	next
end sub