#!/usr/bin/perl
# Convert HTML to Text to PilotDoc format.
# Rainer Schleevoigt / ju

# Falls ntig: hier Proxy eintragen
BEGIN {
  $ENV{http_proxy}="http://www_proxy.heise.de:8080/";
}

use LWP::Simple;              # Datei aus Web holen 
use CGI qw(:all);             # CGI-Paket   
use HTML::Entities;           # HTML-Wandlungen


$TEMP_IN   = "/tmp/u$$.plt";     # Win: start filename with letter 
$TEMP_OUT  = "/tmp/u$$.prc";
$CONVERT   = "/usr/local/bin/txt2pdbdoc \"TITEL\" $TEMP_IN $TEMP_OUT";
#$CONVERT   = "/bin/makedoc6.exe $TEMP_IN $TEMP_OUT \"TITEL\"";
$LOG       = "/tmp/url2doc.log"; 


$HR         = "\n" ."\x97" x 22 . "\n";   # horizontal ruler
$BM         = "\x9e";

my ($url,$titel,$name);

################################################
sub err_exit($) {
    my ($msg) = @_;
    print "Content-type: text/html\r\n\r\n";
    print "<HTML><BODY><H3><FONT COLOR=red>";
    print "$msg";
    print "</H3></FONT></BODY></HTML>";
    exit 1;
}


######################################################
sub writelog($$) {
  my ($url,$titel) = @_;
  open (SESAM,">> $LOG") or err_exit("Kann Log-File nicht ffnen");
  print(SESAM $url . " :: " . $titel . "\n");
  close SESAM;
}


################################################
# Vorbereitung auf die grosse Wandlung:
################################################
sub stripHTML($) {
    my ($txt) = @_;
    # Leerzeichen bereinigen:
    $txt =~ s/[\n\r\t ]+/ /g;
  
    # wenn es das Tag BODY gibt, dann nur Text dazwischen:
    if (($txt =~ m|<BODY .*?>(.*)<\/BODY>|is) && $1) {
	$txt = $1;
    }

    # Text im Header weg
    $txt =~ s/<HEAD>.*<\/HEAD>//i;
    $txt =~ s/<SCRIPT .*?>.*?<\/SCRIPT>//ig;   # Javascript raus
    $txt =~ s/<APPLET .*?>.*?<\/APPLET>//ig;   # Java
    $txt =~ s/<OBJECT .*?>.*?<\/OBJECT>//ig;
    $txt =~ s/<AREA .*?>.*?<\/AREA>//ig;
    $txt =~ s/<EMBED .*?>.*?<\/EMBED>//ig;
    $txt =~ s/<BR.*?>/\n/ig;                    # Newline
    $txt =~ s/<P.*?>/\n \n/ig;
    $txt =~ s/<LI.*?>/\n/ig;
    $txt =~ s/<\/TD>/ /ig;                      # Ende Tabellenfeld
    $txt =~ s/<\/TR>/\n/ig;                     # Ende Tabellenspalte
    $txt =~ s/<HR>/$HR/ig;                      # Linien
    $txt =~ s/\n+/\n/g;                         # mehrfache Newlines
    $txt =~ s:<H\d.*?>:\n\n:ig;                 # Ueberschriften
    $txt =~ s:<\/H\d>:\n:ig;                    
    $txt =~ s/<A NAME=.*?>/$BM/ig;              # Lesezeichen markieren
    $txt =~ s/<.*?ALT=\"(.*?)\".*?>/[$1]/ig;    # ALT-Texte von Bildern
    $txt =~ s/<.*?>//g;                         # alle HTML-Tags entfernen
    $txt =~ s/\x0D/\x0A/gi;                     # CR -> LF
    # ersetze HTML-Umlaute durch ISO -> libwww
    $txt  = decode_entities($txt);              # HTML-Entities zu ISO
    return $txt;
}


#####################################################################
sub Start_Form($$) {
    my ($url,$titel) = @_;
    print "Content-Type: text/html\r\n\r\n";
    print <<HTML_FINISH;
<HTML><BODY>
<H2>Umwandlung einer Web-Seite in das Pilot-Format</H2>

<FORM ACTION="/cgi-bin/url2doc.pl">
  <P><B>URL der Web-Seite</b><br>
  <input name=url SIZE=30 VALUE=$url><br>
  <font size=-1> 
    (z.B.: <CODE>http://www.heise.de/</CODE>)</font>
   	    
  <P><B>Titel</B><br>
  <INPUT VALUE=\"$titel\" SIZE=40 name=titel><br>
  <font size=-1>
   Ist das Feld leer, wird der Titel des Dokumentes verwendet</font>
  <P>

  <P><input type=submit value="Wandle ins Doc-Format ! ">  
</FORM>
</BODY></HTML>
HTML_FINISH
}

	     
#################################################################
# Main
#################################################################
$| = 1;    # ungepufferte I/O

unless (param('url')) {
    Start_Form($url,$titel);
    exit;
}

$url   = param('url');
$titel = param('titel');
if ( $url eq 'referer') {          # spezielle Behandlung: referer
    $url = $ENV{'HTTP_REFERER'};
}

    
# Seite holen:
unless ($page=get($url)) {
    err_exit ("URL $url nicht erreichbar.");
}
    
# Titel aus HTML-Titel, falls Parameter leer:
unless ($titel) {
    if (($page =~ m|<title>\s*(.*)<\/title>|is) && $1) {
	$titel = $1;
    }
}
    
writelog($url,$titel);

$page = stripHTML($page);

# Rohdatei schreiben:
open(OUT, "> $TEMP_IN") or err_exit("Kann TMP-Datei nicht schreiben");
print(OUT $page);
# <$BM> am Ende definiert das Lesezeichen
print(OUT "\n--\nby url2doc (c) 1999 c't magazin, ju\n<$BM>");
close(OUT);

# Kommando vollenden und ausfuehren:
$CONVERT =~ s/TITEL/$titel/gs;
$res = `$CONVERT`;
unlink($TEMP_IN);  

# Ergebnis (DOC-Datei) einlesen:
open(IN, $TEMP_OUT) or err_exit("Kann $TEMP_OUT nicht lesen");
my $buff=join("",<IN>);
close(IN);
unlink ($TEMP_OUT);  # Ergebnis im /tmp wieder loeschen   

# eindeutiger Dateiname:
$name= substr($titel,0,16);
$name =~ s/\s//gs;           # Leerzeichen weg
$name = $$ unless $name;
print "Content-length: ". length($buff) . "\r\n";
print "Content-type: application/x-pilot\r\n";
print "Content-Disposition: inline; filename=$name.prc\r\n\r\n";
print $buff;

# das war's
