' Aufpasser.vbs  von Tobias Weltner / c't
' Videoberwachung im Eigenbau

set wshshell = CreateObject("Wscript.Shell")
set tob = CreateObject("tobtools.scan")

' -- Variablen ggf. anpassen -----------------------------------------
schwellenwert = 500            ' 1..765
filterbreite = 3               ' 1...15, ungerade Zahlen
ordner = "c:\bilder"           ' Bilderordner
schablone = "pic"              ' Dateinamenschablone
zielordner = "c:\alarmbilder"  ' Einbrecherbilder
compare = "icompare.exe"       ' Vergleichsprogramm, ggf. mit Pfad
intervall = 5                  ' Prfintervall (Sekunden)
' --------------------------------------------------------------------

frage = "Nchste berwachung in " & intervall & " Sekunden." & vbCr
frage = frage & "Klicken Sie auf Abbrechen, um zu beenden."

tob.Init ordner, schablone
tob.ShowSelection
tob.ShowDialog=false

' Der folgende Aufruf von LosJetzt.vbs kann entfallen, wenn das
' Twain-Modul sich wie eigentlich eingestellt den Dialog verkneift
wshshell.run "wscript.exe LosJetzt.vbs" 
tob.ScanPic

do
    Ueberwachung
    antwort = Ask(frage)
loop until antwort=vbCancel
    
sub Ueberwachung
    ' vergleicht die beiden jngsten Bilder und ruft bei Unterschieden
    ' doAlarm(bildname) auf. Lscht ansonsten das ltere Bild.
    
    wshshell.run "wscript.exe LosJetzt.vbs" ' entfllt evtl. (s. oben)
    tob.ScanPic
    if tob.GetTwoPics(ordner, pic1, pic2) > 1 then
        ergebnis = Bildvergleich(pic1, pic2)
        if ergebnis>schwellenwert then
            doAlarm(pic1)
        end if
        if ergebnis<0 then
            Say "Fehler beim Bildvergleich: " & ergebnis
        else
            if not tob.KillPic(pic2) then
                Say "Konnte Bild " & pic2 & " nicht lschen!"
            end if
        end if
    else
        Say "Keine Bilder zum Vergleichen vorhanden!"
    end if
end sub

sub doAlarm(pic)
    ' wird aufgerufen, wenn zwei Bilder unterschiedlich sind.
    ' Speichert das Bild in einem speziellen Ordner

    meldung = "Achtung! Bewegung erkannt! Speichere Bild..."
    dateiname = "\ALARM" & hour(now) & "h" & minute(now) 
    dateiname = dateiname & "m" & second(now) & "s"
    dateiname = dateiname & ".bmp"
    if not tob.SavePic(pic, dateiname, zielordner) then
        meldung = meldung & vbCr & "Ordner " & zielordner 
        meldung = meldung & " existiert nicht!"
    end if
    Say meldung
end sub

sub Say(text)
    ' Hilfsfunktion: gibt Text fr intervall Sekunden aus:
    WSHShell.Popup text, intervall, , vbInformation
end sub

function Ask(text)
    ' Hilfsfunktion: stellt eine Frage fr intervall Sekunden:
    Ask = WSHShell.Popup(text, intervall, , vbOKCancel + vbQuestion)
end function

function Bildvergleich(bild1, bild2)
    ' Hilfsfunktion: bastelt die korrekte Befehlszeile fr 
    ' ICOMPARE.EXE und ruft das Programm dann auf. Dabei
    ' versteckt es das DOS-Fenster und liefert den Rckgabewert
    ' von ICOMPARE.EXE zurck:
    command = """" & compare & """ -m:1 -b:" & filterbreite 
    command = command & " -1:""" & bild1 & """ -2:""" & bild2 & """"
    Bildvergleich = wshshell.Run(command, 0, vbTrue)
end function
