#!/usr/bin/perl
#
# Programm zum Spiegeln von Verzeichnissen via FTP
#
# Copyright: c't, Heise Verlag
# Autor: Erich Kramer, 1999



use strict "vars"; # alle Variablen mssen deklariert werden!
use strict "subs";
no strict "refs";


require 'ftp.pl'; # Einbinden der ftp-Routinen:

package main;

my $version = "0.4";
my $stand = "17.08.99";

my %config = ();    # Inhalt der Konfigurationsdatei
my %sr = ();        # zu ersetzende Zeichenketten

# ToDo-Listen:
my @mirror = ();            # Liste der zu bertragenden Dateien
my @mirror_ver = ();        # Liste der zu neuen Verzeichnisse
my @unlink = ();            # Liste der zu lschenden Dateien
my @unlink_ver = ();        # Liste der zu lschenden Verzeichnisse
my @error_mirror = ();      # Fehlerliste der zu bertragenden Dateien
my @error_mirror_ver = ();  # Fehlerliste neue Verzeichnisse
my @error_unlink = ();      # Fehlerliste zu lschenden Dateien
my @error_unlink_ver = ();  # Fehlerliste zu lschende Verzeichnisse

# Dateinamen:
my $configdatei = "mirror.cfg";   # Konfigurationsdatei
my $srDatei = "sr.cfg";           # zu ersetzende Zeichenketten
my $tempdatei = "tmp.tmp";	  # temporre Konvertierungsdatei
my $mirrordat = "mirror.dat";     # Sicherung, Zustaende der Dateien
my $mirrortmp = "mirror.tmp";     # Neuerstellung der mirrordat
my $logdatei = "mirror.log";	  # bertragungs-Logdatei

# ftp-Variablen:
my $ftp_port = 21;
my $retry_call = 1;
my $attempts = 2;
my $text_mode;

# Daten aus der mirrordat:
my %laenge = ();      # Lnge der Dateien
my %datum = ();       # Datum der Dateien

# Extensions:
my @ReplaceIn = ();
my @exclude = ();

#******
# Main:
#******
print "Homepage-Upload $version von Erich Kramer\n";
print "Stand: $stand\n";

#**********************************
# Einlesen der Konfigurationsdatei:
#**********************************
open(CONFIG, "< $configdatei") 
  || die ("\nkann Konfigurationsdatei $configdatei nicht oeffnen");
while(<CONFIG>) {
  my ($bezeichner,$wert);
  next if (substr($_,0,1) eq "#");	 # Kommentare auslassen
  ($bezeichner,$wert) = split (/=/, $_);
  $wert =~ s/\n//;             		 
  $config{$bezeichner} = $wert;
}
close (CONFIG);
		
# Extension-Liste definieren:
@ReplaceIn = split (/,/, $config{'ReplaceIn'});
@exclude = split (/,/, $config{'exclude'});

# Ersetzungs-Strings laden:
open(SR, "< $srDatei") 
  || die "\nkann Konfigurationsdatei $srDatei nicht oeffnen";
while(<SR>) {
  my ($bezeichner,$wert);
  ($bezeichner,$wert) = split (/\|/, $_);
  $wert =~ s/\n//;             	
  $sr{$bezeichner} = $wert;
}
close (SR);


# lschen der temporren Verzeichnisstruktur mirror.tmp
unlink ($mirrortmp);

#*********************************
# Einlesen der Originaldateidaten:
#*********************************
open(MIRRORDAT, "< $mirrordat") 
  || die "\nkann $mirrordat nicht oeffnen";
while(<MIRRORDAT>) {
  my ($Datei,$Laenge,$Datum);
  ($Datei,$Laenge,$Datum) = split (/\|/, $_);
  $Datum =~ s/\n//;           # das Return (\n) am Ende lschen
  $laenge{$Datei} = $Laenge;
  $datum {$Datei} = $Datum;
}
close(MIRRORDAT);

# ToDo-Listen erstellen:
&ToDo_Liste($config{'LocalDir'});
&Unlink_Liste;

# Spiegel starten
while (! &mirror ) {}

print "\n\nSpiegelvorgang erfolgreich abgeschlossen.\n";

# Wenn der Spiegelvorgang erfogreich war, temporre lokale 
# Verzeichnisstruktur mirror.tmp in mirror.dat bernehmen
unlink ($mirrordat);
rename ($mirrortmp,$mirrordat);

# ToDo-Liste generieren
sub ToDo_Liste(@_)
  {
  my ($dir) = @_;
  my $dir_eintrag;
  my @dir_eintraege;  #das gesammte Verzeichnis

  opendir (DIR, $dir) || die ("\nVerzeichnis $dir nicht gefunden");
  @dir_eintraege = readdir(DIR);
  closedir (DIR);

 NAECHSTER_EINTRAG:
  foreach $dir_eintrag (@dir_eintraege)
    {
    next if $dir_eintrag eq ".";
    next if $dir_eintrag eq "..";
    # Ausgeschlossene Dateien auslassen:
    for (@exclude) {
	my $eintrag = $dir_eintrag;
	# Dateien mit Dateierweiterungen, die in der mirror.cfg unter
	# exclude angegeben sind, werden nicht beachtet.
	# Die Verzeichniseintrge und die Ausschlu-Dateierweiterungen
	# werden beide klein geschrieben
	tr/A-Z/a-z/;
	$eintrag =~ tr/A-Z/a-z/;
	next NAECHSTER_EINTRAG 
	  if ( rightstr($eintrag,length($_) + 1) eq ".$_");
      }
		
    my $eintrag = "$dir$config{'slash'}$dir_eintrag";
    my ($size,$mtime) = (stat($eintrag))[7,9];

    if ((-f _) && ( ($laenge{$eintrag} ne $size) 
		    || ($datum{$eintrag} != $mtime) )) {
      push (@mirror, "$eintrag");
    }
    if (-d _) {
      if ($laenge{$eintrag} ne "V") {
	push (@mirror_ver, "$eintrag");
      }
      ToDo_Liste("$eintrag");
    }
  }

  #******************************************************************
  # aktuelle Verzeichnisstruktur in die Datei mirror.tmp bernehmen *
  #******************************************************************
  open (MIRRORTMP, ">> $mirrortmp") 
    || die ("\nkann $mirrortmp nicht oeffnen!");
 NAECHSTER_EINTRAG2:
  foreach $dir_eintrag (@dir_eintraege) {
    next if $dir_eintrag eq ".";
    next if $dir_eintrag eq "..";
    # Ausgeschlossene Dateien auslassen:
    for (@exclude)
      {
	my $eintrag = $dir_eintrag;
	tr/A-Z/a-z/;
	$eintrag =~ tr/A-Z/a-z/;
	next NAECHSTER_EINTRAG2 
	  if ( rightstr($eintrag,length($_) + 1) eq ".$_");
      }
    my ($size,$mtime) = 
      (stat("$dir$config{'slash'}$dir_eintrag"))[7,9];
    print MIRRORTMP 
      "$dir$config{'slash'}$dir_eintrag|$size|$mtime\n"  if (-f _);
    print MIRRORTMP 
      "$dir$config{'slash'}$dir_eintrag|V|$mtime\n"  if (-d _);
    }
  close(MIRRORTMP);
}

#*******************************************************
# Liste der gelschten Dateien/Verzeichnisse erstellen *
#*******************************************************
sub Unlink_Liste {
  my $eintrag;
  foreach $eintrag (reverse sort keys(%laenge)) {
    if ( !(-e $eintrag) ) { # existiert Datei/Verzeichnis nicht?
      if ($laenge{$eintrag} eq "V") {
        push (@unlink_ver, "$eintrag");
      } else {
        push (@unlink, "$eintrag");
      }
    }
  }
}


#**********************************
# Dateien bertragen bzw. Lschen *
#**********************************
sub mirror {
  @error_mirror = ();
  @error_mirror_ver = ();
  @error_unlink = ();
  @error_unlink_ver = ();

  # Log-Datei ffnen:
  open(LOG, ">> $logdatei") 
    || die "\nkann Logdatei $logdatei nicht oeffnen";

  # beim ftp-Server anmelden:
  print "\nkontaktiere $config{'RemoteServer'} ...";
  if( &ftp::open( $config{'RemoteServer'}, 
		  $ftp_port, $retry_call, $attempts ) != 1 ) {
    print "\nkann $config{'RemoteServer'} nicht erreichen";
    return 0;
  }
  print "\nuser login...";
  if( ! &ftp::login( $config{'UserID'}, $config{'Passwd'} ) ) {
    print "\nLogin fehlgeschlagen";
    return 0;
  }

  # alte Dateien vom Server lschen:
  if (@unlink) {
    print "\n\nloesche alte Dateien...";
    for (@unlink) {
      my ($verzeichnis,$name,$rem_file);

      $verzeichnis = $config{'RemoteDir'} . Verzeichnis($_);
      $name = Name($_);
      # Namen unter DOS klein schreiben, 
      # da sie sonst komplett in Grobuchstaben bertragen werden
      $name =~ tr/A-Z/a-z/  if ($config{'slash'} eq "\\");     
      $rem_file = "$verzeichnis/$name";
      print "\n$rem_file";
      
      if( ! &ftp::delete( $rem_file ) ) {
	print " - kann Datei nicht loeschen";
	push (@error_unlink, $_);
      } else {
      	print LOG "unlink $config{'RemoteServer'}$rem_file\n";
      }
    }
  } else {
    print "\n\nkeine alten Dateien zu loeschen";
  }

  # alte Verzeichnisse auf dem Server lschen:
  if (@unlink_ver) {
    print "\n\nloesche alte Verzeichnisse...";
    for (@unlink_ver) {
      my ($verzeichnis,$name,$rem_dir);
      $verzeichnis = $config{'RemoteDir'} . Verzeichnis($_);
      $name = Name($_);
      $rem_dir = "$verzeichnis/$name";
      print "\n$rem_dir";

      if( ! &ftp::deldir( $rem_dir ) ) {
	print " - kann Verzeichnis nicht loeschen";
	push (@error_unlink_ver, $_);
      } else {
      	print LOG "rmdir $config{'RemoteServer'}$rem_dir\n";
      }
    }
  } else {
    print "\n\nkeine alten Verzeichnisse zu loeschen";
  }

  # neue Verzeichnisse auf dem Server erstellen:
  if (@mirror_ver) {
    print "\n\nerstelle neue Verzeichnisse...";
    for (@mirror_ver) {
      my ($verzeichnis,$name,$rem_dir);
      $verzeichnis = $config{'RemoteDir'} . Verzeichnis($_);
      $name = Name($_);
      $rem_dir = "$verzeichnis/$name";
      print "\n$rem_dir";
      
      if( ! &ftp::mkdir( $rem_dir ) ) {
	print " - kann Verzeichnis nicht erstellen";
	push (@error_mirror_ver, $_);
      } else {
      	print LOG "mkdir $config{'RemoteServer'}$rem_dir\n";
      }
    }
  } else {
    print "\n\nkeine neuen Verzeichnisse zu erstellen";
  }

  # Dateien zum Server bertragen:
  if (@mirror) {
    print "\n\nuebertrage Dateien...";
    for (@mirror) {
      my ($verzeichnis,$name,$rem_file,$local_file,$put_file);
      my $replace = 0;
      
      $verzeichnis = $config{'RemoteDir'} . Verzeichnis($_);
      $name = Name($_);
      # Namen unter DOS klein schreiben
      $name =~ tr/A-Z/a-z/  if ($config{'slash'} eq "\\");     
      
      $rem_file = "$verzeichnis/$name";
      $local_file = $_;

      print "\n$local_file";
      
      # mu eine Ersetzung vorgenommen werden?
      for (@ReplaceIn) {
	my $file = $local_file;
	# In Dateien mit Erweiterungen, die in der mirror.cfg unter
	# ReplaceIn angegeben sind, werden Ausdrcke ersetzt.
	# Die Dateinamen und die Erweiterungen werden beide klein 
	# geschrieben, damit ein gro-kleinschreibungs-unabhngiger
	# Vergleich mglich wird.
	tr/A-Z/a-z/;
	$file=~ tr/A-Z/a-z/;
	$replace = 1  if ( rightstr($file,length($_) + 1) eq ".$_");
      }

      if ($replace == 1) {
	&s_r($local_file);
	$put_file = $tempdatei;
	$text_mode = 1;	           # Dateien, in denen ersetzt wird, 
      }				   # werden in Textmodus bertragen.
      else {
	$put_file = $local_file;
	$text_mode = 0;
      }
      
      &ftp::type( $text_mode ? 'A' : 'I' );
      if( ! &ftp::put( $put_file, $rem_file ) ) {
	print " - kann Datei nicht uebertragen";
	push (@error_mirror, $_);
      } else {
      	# Logdatei ergnzen:
      	print LOG "put ";
      	print LOG "with search&replace " if ($replace == 1);
      	print LOG "$local_file -> $config{'RemoteServer'}$rem_file";
      	# Rechte setzen, falls es ein CGI-Script war:
      	if ( substr(Verzeichnis($local_file),0,
		    length($config{'cgi-bin'})) eq $config{'cgi-bin'})
	  {
	    print "\nsetze Zugriffsrechte fuer $rem_file...";
	    if( ! &ftp::chmod( $rem_file, 457 ) ) {	# chmod 711
	      print " - Zugriffsrechte konnten nicht gesetzt werden";
	      print LOG " - konnte Zugriffsrechte nicht setzten";
	      push (@error_mirror, $_);
	    } else {
	      print LOG " - Zugriffsrecht auf Ausfuehrbar gesetzt";
	      print " - o.k.";
	    }
	  }
      	print LOG "\n";
      }
    }
  } else {
    print "\n\nkeine Dateien zu uebertragen";
  }

  &ftp::close();
  close (LOG);
  if (($#error_mirror != -1) 
      || ($#error_mirror_ver != -1) 
      || ($#error_unlink != -1) 
      || ($#error_unlink_ver != -1) ) {
    print "\nEs sind bei der Uebertragung Fehler aufgetreten!";
    @mirror     = @error_mirror;
    @mirror_ver = @error_mirror_ver;
    @unlink     = @error_unlink;
    @unlink_ver = @error_unlink_ver;
    return (0);
  } else {
    return (1);
  }
}


#***************************************************
# Suchen und erstzen in der zu bertragenden Datei *
#***************************************************
sub s_r(@_) {
  my ($quelldatei) = @_;
	
  open (QUELLE, "< $quelldatei") 
    || die "kann $quelldatei nicht oeffnen";
  open (ZIEL, "> $tempdatei") 
    || die "kann $tempdatei nicht ueberschreiben";;
	
  my $zeile;
  while ($zeile = <QUELLE>) {
    for (keys %sr) {
      $zeile =~ s/$_/$sr{$_}/g;
    }
    print ZIEL "$zeile";
  }

  close (QUELLE);
  close (ZIEL);
}


#*******************************************
# Dateinamen aus lokalem Pfad herausnehmen *
#*******************************************
sub Verzeichnis_Lokal(@_) {
  my ($pfad) = @_;

  $pfad = substr($pfad,0,rindex($pfad,$config{'slash'}));
  return $pfad;
}


#******************************************
# (DOS-) Pfad in relativen Pfad umwandeln *
#******************************************
sub Verzeichnis(@_) {
  my ($pfad) = @_;

  my ($localdir);

  $localdir = $config{'LocalDir'};
  $localdir =~ s#\\#/#g;        # bs -> sl
  $pfad     =~ s#\\#/#g;        # bs -> sl
  $pfad     =~ s#$localdir##g;  # lokalen Start-Pfad raus
  $pfad = substr($pfad,0,rindex($pfad,"/"));
  return $pfad;
}


#************************************************
# (DOS-) Pfad in relativen Pfad+Datei umwandeln *
#************************************************
sub Verzeichnis_Dat(@_) {
  my ($pfad) = @_;

  my ($localdir);

  $localdir = $config{'LocalDir'};
  $localdir =~ s#\\#/#g;        # bs -> sl
  $pfad     =~ s#\\#/#g;        # bs -> sl
  $pfad     =~ s#$localdir##g;  # lokalen Start-Pfad raus
  return $pfad;
}


#***************************************
# Datei aus relativen Pfad extrahieren *
#***************************************
sub Name(@_) {
  my ($verzeichnis) = @_;
  my ($name);

  $verzeichnis =~ s#\\#/#g;        # bs -> sl
  $name = substr($verzeichnis,rindex($verzeichnis,"/")+1,
		 length($verzeichnis));
  return $name;
}


#**************************************
# rechten Teil eines Strings ausgeben *
#**************************************
sub rightstr(@_) {
  my ($string,$anzahl_zeichen) = @_;

  $string = substr($string,length($string)-$anzahl_zeichen,
		   length($string));
  return $string;
}

