unit IForce2;
{ * Header for IForce2.DLL (force feedback FX)
  *
  * Original: IForce2.h, Copyright (c) 1997 Immersion Corporation
  *
  * Delphi adaptation by Arne Schpers, comments mostly unchanged
  *
  * Last modification: 22-MAR-99
  *
  * Requires: IForce2.DLL from Immersion Corp; download latest version
  * from www.immersion.com or www.force-feedback.com
  *
  * NOTE: The device *must* be unacquired before calling CreateEffects. Otherwise
  * this function will fail (i.e. return PIEffects = nil) at random -- at least
  * in combination with SideWinder FF Pro and Logitech WingMan
}

interface
uses Windows, DInput;  // DI headers converted by Erik Unger/Arne Schpers


const
  { RT_IFORCE - Resource type for IFORCE projects stored as resources.
    This is the resource type looked for by IFLoadProjectResource(). }
  RT_IFORCE = 'IFORCE';


type
{ HIFORCEPROJECT - used to identify a loaded project as a whole.
  individual objects within a project are uniquely referenced by name.
  Created by the IFLoadProject* functions and released by IFReleaseProject. }

  HIFORCEPROJECT = Pointer;

{ TIForceEffect - contains the information needed to create a DI effect
  using IDirectInputEffect::CreateEffect. An array of pointers to these
  structures is allocated and returned by IFCreateEffectStructs. }

  IForceEffect = record
    guid: TGUID;
    lpDIEffect: PDIEffect;
  end;

// Delphi specific declarations
  TIForceEffectArray = Array[0..99] of ^IForceEffect;
  PIForceEffectArray = ^TIForceEffectArray;  // pointer to array with a pointers

  PIDirectInputEffect = ^IDirectInputEffect;


{ IFLoadProjectResource - Load a project from a resource.
    hRsrcModule - handle of the module containing the project definition resource.
    pRsrcName - name or MAKEINTRESOURCE(id) identifier of resource to load.
    pDevice - device for which the project is being loaded. If nil,
      effects will be created generically, and IFCreateEffects will fail.
  Returns an identifier for the loaded project, or nil if unsuccessful. }
function IFLoadProjectResource(hRsrcModule: HModule; pRsrcName: PChar;
  PDevice: IDirectInputDevice2): HIFORCEPROJECT; stdcall;

{ IFLoadProjectPointer - Load a project from a pointer, i.e. from main memory.
    pProject - points to a project definition.
    pDevice - device for which the project is being loaded. If nil,
      effects will be created generically, and IFCreateEffects will fail.
  Returns an identifier for the loaded project, or nil if unsuccessful. }
function IFLoadProjectPointer(pProject: Pointer;
  pDevice: IDirectInputDevice2): HIFORCEPROJECT; stdcall;

{ IFLoadProjectFile - Load a project from a file.
    pProjectFileName - points to a project file name.
    pDevice - device for which the project is being loaded. If nil,
      effects will be created generically, and IFCreateEffects() will fail.
   Returns an identifier for the loaded project, or nil if unsuccessful. }
function IFLoadProjectFile(const pProjectFileName: PChar;
  pDevice: IDirectInputDevice2): HIFORCEPROJECT; stdcall;

{ IFLoadProjectObjectPointer - Load a project from a pointer to a single
  object definition (usually used only by the editor).
    pObject - points to an object definition.
    pDevice - device for which the project is being loaded. If nil,
       effects will be created generically, and IFCreateEffects() will fail.
  Returns an identifier for the loaded project, or nil if unsuccessful. }
function IFLoadProjectObjectPointer(pObject: Pointer;
  pDevice: IDirectInputDevice2): HIFORCEPROJECT; stdcall;

{ IFReleaseProject - Release a loaded project.
    hProject - identifies the project to be released.
  Returns TRUE if the project is released, FALSE if it is an invalid project. }
function IFReleaseProject(hProject: HIFORCEPROJECT): BOOL; stdcall;

{ IFCreateEffectStructs - Create IForceEffects for a named effect.
    hProject - identifies the project containing the object.
    pObjectName - name of the object for which to create structures.
    pNumEffects - if not nil will be set to a count of the IForceEffect
      structures in the array (not including the terminating nil pointer.)
  Returns a pointer to the allocated array of pointers to IForceEffect
  structures. The array is terminated with a nil pointer. If the
  function fails, a nil pointer is returned. }
function IFCreateEffectStructs(hProject: HIFORCEPROJECT;
   const pObjectName: PChar; var NumEffects: Cardinal): PIForceEffectArray; stdcall;

{ IFReleaseEffectStructs - Release an array of IForceEffects.
    hProject - identifies the project for which the effects were created.
    pEffects - points to the array of IForceEffect pointers to be released.
  Returns TRUE if the array is released, FALSE if it is an invalid array. }
function IFReleaseEffectStructs(hProject:HIFORCEPROJECT;
   pEffects: PIForceEffectArray): BOOL; stdcall;

{ IFCreateEffects - Creates the DirectInput effects using
  IDirectInput::CreateEffect.
    hProject - identifies the project containing the object.
    pObjectName - name of the object for which to create effects.
    pNumEffects - if not nil will be set to a count of the IDirectInputEffect
      pointers in the array (not including the terminating nil pointer.)
  Returns a pointer to the allocated array of pointers to IDirectInputEffects.
  The array is terminated with a nil pointer. If the function fails,
  a nil pointer is returned.
}
function IFCreateEffects(hProject: HIFORCEPROJECT; const pObjectName: PChar;
  var NumEffects: Cardinal): PIDirectInputEffect; stdcall;

{ IFReleaseEffects - Releases an array of IDirectInputEffect structures.
    hProject - identifies the project for which the effects were created.
    pEffects - points to the array if IDirectInputEffect pointers to be released.
  Returns TRUE if the array is released, FALSE if it is an invalid array.
}
function IFReleaseEffects(hProject: HIFORCEPROJECT;
  pEffects: PIDirectInputEffect): BOOL; stdcall;

implementation

// in case somebody really wants to use this with C++ Builder...
{$IFNDEF VER100} // i.e. not Delphi 3
{$EXTERNALSYM IFLoadProjectResource}
{$EXTERNALSYM IFLoadProjectPointer}
{$EXTERNALSYM IFLoadProjectFile}
{$EXTERNALSYM IFLoadProjectObjectPointer}
{$EXTERNALSYM IFReleaseProject}
{$EXTERNALSYM IFCreateEffectStructs}
{$EXTERNALSYM IFReleaseEffectStructs}
{$EXTERNALSYM IFCreateEffects}
{$EXTERNALSYM IFReleaseEffects}
{$ENDIF}
const IForceDLL = 'iforce2.dll';

function IFLoadProjectResource; external IForceDLL index 6;
function IFLoadProjectPointer; external IForceDLL index 5;
function IFLoadProjectFile; external IForceDLL index 3;
function IFLoadProjectObjectPointer; external IForceDLL index 4;
function IFReleaseProject; external IForceDLL index 9;
function IFCreateEffectStructs; external IForceDLL index 1
function IFReleaseEffectStructs; external IForceDLL index 7;
function IFCreateEffects; external IForceDLL index 2;
function IFReleaseEffects; external IForceDLL index 8;
// IForceDLLMain index 10;

end.
