unit FXIFRDemoU;  // 30-JUN-99 as (Arne Schpers)
// Force Feedback-Effekte aus IFR-Dateien
// Vorausgesetzt: DirectX5, IForce2.DLL von Immersion
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, DInput, DXInputAS, IForceEffects, DXTimer,
  StdCtrls, IForce2, Menus, ExtCtrls;

type
  TIFRDemoForm = class(TForm)
    lJoyPosition: TLabel;
    ListBox1: TListBox;
    rDirection: TRadioGroup;
    lCurEffect: TLabel;
    MainMenu1: TMainMenu;
    mFile: TMenuItem;
    mFileOpen: TMenuItem;
    N1: TMenuItem;
    mFileQuit: TMenuItem;
    OpenDialog1: TOpenDialog;
    mControl: TMenuItem;
    Label1: TLabel;
    lCompounds: TLabel;
    barGain: TScrollBar;
    lGain: TLabel;
    procedure FormDestroy(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure mFileOpenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rDirectionClick(Sender: TObject);
    procedure barGainScroll(Sender: TObject;
      ScrollCode: TScrollCode; var ScrollPos: Integer);
    procedure barGainChange(Sender: TObject);
  protected
    ProgTitle, FXFileName: String;
    FXFile: TDIFFEffectFile;
    procedure JoystickEnumDone(Sender: TObject);
    procedure LoadEffects;
  protected  // Joystick-Auswahl
    mControlJoy1, mControlJoy2: TMenuItem;
    procedure mControlItemsClick(Sender: TObject);
  protected
    DIJoy: TDIJoy;  // aktuelles FF-Gert
    CurEffect: TDIFFEffect;
    DXTimer: TDXTimer;
    procedure OnDXTimer(Sender: TObject);
  end;

var IFRDemoForm: TIFRDemoForm;

implementation
{$R *.DFM}

procedure TIFRDemoForm.FormCreate(Sender: TObject);
begin
  ProgTitle := Caption; FXFileName := '';
  lCurEffect.Caption := ''; lCompounds.Caption := '';
  lJoyPosition.Caption := '';
  rDirection.Enabled := False;
  barGain.Enabled := False; barGain.Position := 100;

  // Joystick-Abzhlung starten
  TDIJoyEnumerator.Create(JoystickEnumDone);
  DXTimer := TDXTimer.Create(Self);
  with DXTimer do
  begin
    Interval := 20; OnTimer := OnDXTimer; Enabled := True;
  end;
end;

procedure TIFRDemoForm.FormDestroy(Sender: TObject);
begin
  FXFile.Free;
end;

// einziger & einmaliger Rckruf von TDIJoyEnumerator; bis
// auf die Rckmeldungen dasselbe wie in PongDI
procedure TIFRDemoForm.JoystickEnumDone(Sender: TObject);

  procedure InitJoystick(DIJoy: TDIJoy; var NewMenu: TMenuItem);
  begin
    if DIJoy = nil then Exit;
    // Wahlpunkt fr den Joystick
    NewMenu := TMenuItem.Create(Self);
    with NewMenu do
    begin
      OnClick := mControlItemsClick; Tag := Integer(DIJoy);
      Caption := DIJoy.ProductName; RadioItem := True;
    end;
    mControl.Add(NewMenu);
    with DIJoy do
    begin   // Initialisierung des Joysticks
      CooperativeLevel := DISCL_FOREGROUND or DISCL_EXCLUSIVE;
      SetRangeProperty(DIPROP_RANGE,-1000,1000,-1);  // Achsen
      SetDWordProperty(DIPROP_DEADZONE,0*100,-1);  // Nullzone
      // Nur fr Lenkrder empfehlenswert: Maximalwert nach 30%
      // SetDWordProperty(DIPROP_SATURATION,30*100,-1);
      // automatische Zentrierung aus (FF-spezifisch)
      CheckDIRes(SetDWordProperty(DIPROP_AUTOCENTER,0,-1),
        'Autocenter off');
    end;
  end;

begin
  InitJoystick(DIJoy1, mControlJoy1);
  // fr ungewhnliche Systeme (wie meins im Moment)
  InitJoystick(DIJoy2, mControlJoy2);
  if DIJoy1 = nil then
  begin
    ShowMessage('No FFX devices detected, terminating.');
    Close;
  end  // sonst 1. Joystick als Standardvorgabe
    else mControlItemsClick(mControlJoy1);
end;

// Umschaltung zwischen mehreren Joysticks
procedure TIFRDemoForm.mControlItemsClick(Sender: TObject);
begin
  with TMenuItem(Sender) do
  begin
    if Checked then Exit;  // keine nderung
    mControlJoy1.Checked := Sender = mControlJoy1;
    if mControlJoy2 <> nil
      then mControlJoy2.Checked := Sender = mControlJoy2;
    DIJoy := TDIJoy(Tag);  // neuer aktiver Joystick
  end;
  // mu spezifisch fr das jeweilige Gert angelegt werden
  FXFile.Free;
  FXFile := TDIFFEffectFile.Create(DIJoy.DIObject);
  LoadEffects;
  CurEffect := nil; barGain.Enabled := False;
  rDirection.Enabled := False;
end;

// Auswahl einer IFR-Datei
procedure TIFRDemoForm.mFileOpenClick(Sender: TObject);
begin
  with OpenDialog1 do
  begin
    if FileName <> '' then InitialDir := ExtractFilePath(FileName)
      else InitialDir := ExtractFilePath(ParamStr(0));
    FileName := '*.IFR';
    if Execute then
    begin
      FXFileName := FileName; LoadEffects;
    end;
  end;
end;

// Laden einer IFR-Datei. XRefs: mFileOpen, mControlItems
procedure TIFRDemoForm.LoadEffects;
begin
  if FXFileName = '' then Exit;
  FXFile.LoadFromFile(FXFileName);
  Caption := ProgTitle + ' - ' + ExtractFileName(FXFileName);
  ListBox1.Items.Assign(FXFile.EffectNames);
  CurEffect := nil;
end;

procedure TIFRDemoForm.OnDXTimer(Sender: TObject);
begin
  if DIJoy <> nil then
  with DIJoy do
  begin
    Poll;  // sorgt gleichzeitig fr das Acquire
    lJoyPosition.Caption := Format('Position X: %.04d, Y: %.04d',
      [Data.lX,Data.lY]);
  end;
end;

// ------- Auswahl, Parametrierung, Abspielen -------------
procedure TIFRDemoForm.ListBox1DblClick(Sender: TObject);
var x: Integer; CompNames: String;
begin
  // eventuell laufenden Effekt wieder rauswerfen
  if CurEffect <> nil then FXFile.UnloadEffect(CurEffect.FXName);
  with Listbox1 do CurEffect := FXFile.LoadEffect(Items[ItemIndex]);
  CheckDIRes(CurEffect.Start(DIES_SOLO),'Start');
  // Parametrierung ist bei Verbundeffekten leider nicht
  rDirection.Enabled := CurEffect is TDIFFSingleEffect;
  barGain.Position := 100;
  barGain.Enabled := CurEffect is TDIFFSingleEffect;

  // nur zur Anzeige
  lCurEffect.Caption := 'Effect: '+CurEffect.FXName;
  CompNames := '';
  if CurEffect is TDIFFCompoundEffect then
    with CurEffect as TDIFFCompoundEffect do
       for x := 0 to CompoundCount-1 do
         CompNames := CompNames + Compounds[x].FXName + #13#10;
  lCompounds.Caption := CompNames;
end;

// Parametrierung, hier nur fr Richtung und Strke
procedure TIFRDemoForm.rDirectionClick(Sender: TObject);
begin
  with CurEffect as TDIFFSingleEffect do
  begin
    Direction := rDirection.ItemIndex * 90;
    CheckDIRes(Start(DIES_SOLO),'Start');
  end;
end;

procedure TIFRDemoForm.barGainScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
begin
  if ScrollCode = scEndScroll then
  with CurEffect as TDIFFSingleEffect do
  begin  // tut beim SideWinder Wheel nichts?
    Gain := ScrollPos;
    CheckDIRes(Start(DIES_SOLO),'Start');
  end;
end;

procedure TIFRDemoForm.barGainChange(Sender: TObject);
begin
  lGain.Caption := 'Gain: '+IntToStr(barGain.Position);
end;

end.
